/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_COLLAPSEMATERIALIZEOPSPASS
#define GEN_PASS_DECL_COMPOSESETOPSPASS
#define GEN_PASS_DECL_FUSIONPASS
#define GEN_PASS_DECL_GMLSTTOGPUPASS
#define GEN_PASS_DECL_GMLSTTOSCF
#define GEN_PASS_DECL_TILEDLOOPBUFFERIZEPASS
#define GEN_PASS_DECL_TILINGCWISEPASS
#define GEN_PASS_DECL_TILINGPASS
#define GEN_PASS_DECL_TILINGREDUCTIONPASS
#define GEN_PASS_DECL_TILINGSOFTMAXPASS
#define GEN_PASS_DECL_VECTORIZEGMLSTLOOPSPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// CollapseMaterializeOpsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_COLLAPSEMATERIALIZEOPSPASS
struct CollapseMaterializeOpsPassOptions {
  bool reverse_ = false;
};
#undef GEN_PASS_DECL_COLLAPSEMATERIALIZEOPSPASS
#endif // GEN_PASS_DECL_COLLAPSEMATERIALIZEOPSPASS
#ifdef GEN_PASS_DEF_COLLAPSEMATERIALIZEOPSPASS
namespace impl {

template <typename DerivedT>
class CollapseMaterializeOpsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = CollapseMaterializeOpsPassBase;

  CollapseMaterializeOpsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CollapseMaterializeOpsPassBase(const CollapseMaterializeOpsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-collapse-materialize-ops");
  }
  ::llvm::StringRef getArgument() const override { return "gml-collapse-materialize-ops"; }

  ::llvm::StringRef getDescription() const override { return "Collapse (or uncollapse) materialize operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CollapseMaterializeOpsPass");
  }
  ::llvm::StringRef getName() const override { return "CollapseMaterializeOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CollapseMaterializeOpsPassBase<DerivedT>)

  CollapseMaterializeOpsPassBase(const CollapseMaterializeOpsPassOptions &options) : CollapseMaterializeOpsPassBase() {
    reverse_ = options.reverse_;
  }
protected:
  ::mlir::Pass::Option<bool> reverse_{*this, "reverse", ::llvm::cl::desc("Whether to revert collapsing of materialize operations."), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_COLLAPSEMATERIALIZEOPSPASS
#endif // GEN_PASS_DEF_COLLAPSEMATERIALIZEOPSPASS

//===----------------------------------------------------------------------===//
// ComposeSetOpsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_COMPOSESETOPSPASS
#undef GEN_PASS_DECL_COMPOSESETOPSPASS
#endif // GEN_PASS_DECL_COMPOSESETOPSPASS
#ifdef GEN_PASS_DEF_COMPOSESETOPSPASS
namespace impl {

template <typename DerivedT>
class ComposeSetOpsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ComposeSetOpsPassBase;

  ComposeSetOpsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ComposeSetOpsPassBase(const ComposeSetOpsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-compose-set-ops");
  }
  ::llvm::StringRef getArgument() const override { return "gml-compose-set-ops"; }

  ::llvm::StringRef getDescription() const override { return "Compose set operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ComposeSetOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ComposeSetOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ComposeSetOpsPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_COMPOSESETOPSPASS
#endif // GEN_PASS_DEF_COMPOSESETOPSPASS

//===----------------------------------------------------------------------===//
// FusionPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_FUSIONPASS
struct FusionPassOptions {
  std::string producerLabel;
  std::string consumerLabel;
};
#undef GEN_PASS_DECL_FUSIONPASS
#endif // GEN_PASS_DECL_FUSIONPASS
#ifdef GEN_PASS_DEF_FUSIONPASS
namespace impl {

template <typename DerivedT>
class FusionPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = FusionPassBase;

  FusionPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  FusionPassBase(const FusionPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-fusion");
  }
  ::llvm::StringRef getArgument() const override { return "gml-fusion"; }

  ::llvm::StringRef getDescription() const override { return "Fuse producers in into `gml_st.materialize` operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FusionPass");
  }
  ::llvm::StringRef getName() const override { return "FusionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FusionPassBase<DerivedT>)

  FusionPassBase(const FusionPassOptions &options) : FusionPassBase() {
    producerLabel = options.producerLabel;
    consumerLabel = options.consumerLabel;
  }
protected:
  ::mlir::Pass::Option<std::string> producerLabel{*this, "producer-label", ::llvm::cl::desc("Producer label.")};
  ::mlir::Pass::Option<std::string> consumerLabel{*this, "consumer-label", ::llvm::cl::desc("Consumer label.")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_FUSIONPASS
#endif // GEN_PASS_DEF_FUSIONPASS

//===----------------------------------------------------------------------===//
// GmlStToGpuPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_GMLSTTOGPUPASS
std::unique_ptr<::mlir::Pass> createGmlStToGpuPass();
#undef GEN_PASS_DECL_GMLSTTOGPUPASS
#endif // GEN_PASS_DECL_GMLSTTOGPUPASS
#ifdef GEN_PASS_DEF_GMLSTTOGPUPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createGmlStToGpuPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class GmlStToGpuPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = GmlStToGpuPassBase;

  GmlStToGpuPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GmlStToGpuPassBase(const GmlStToGpuPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-st-to-gpu");
  }
  ::llvm::StringRef getArgument() const override { return "gml-st-to-gpu"; }

  ::llvm::StringRef getDescription() const override { return "Lower nested `gml_st.parallel` to `gpu.launch`"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GmlStToGpuPass");
  }
  ::llvm::StringRef getName() const override { return "GmlStToGpuPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::AffineDialect>();

  registry.insert<::mlir::arith::ArithDialect>();

  registry.insert<::mlir::gpu::GPUDialect>();

  registry.insert<::mlir::scf::SCFDialect>();

  registry.insert<::mlir::vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GmlStToGpuPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createGmlStToGpuPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createGmlStToGpuPass() {
  return impl::createGmlStToGpuPass();
}
#undef GEN_PASS_DEF_GMLSTTOGPUPASS
#endif // GEN_PASS_DEF_GMLSTTOGPUPASS

//===----------------------------------------------------------------------===//
// GmlStToScf
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_GMLSTTOSCF
#undef GEN_PASS_DECL_GMLSTTOSCF
#endif // GEN_PASS_DECL_GMLSTTOSCF
#ifdef GEN_PASS_DEF_GMLSTTOSCF
namespace impl {

template <typename DerivedT>
class GmlStToScfBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = GmlStToScfBase;

  GmlStToScfBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GmlStToScfBase(const GmlStToScfBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-st-to-scf");
  }
  ::llvm::StringRef getArgument() const override { return "gml-st-to-scf"; }

  ::llvm::StringRef getDescription() const override { return "Lower `gml_st.loop` to SCF loops and parallel loops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GmlStToScf");
  }
  ::llvm::StringRef getName() const override { return "GmlStToScf"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::scf::SCFDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GmlStToScfBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_GMLSTTOSCF
#endif // GEN_PASS_DEF_GMLSTTOSCF

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TILEDLOOPBUFFERIZEPASS
#undef GEN_PASS_DECL_TILEDLOOPBUFFERIZEPASS
#endif // GEN_PASS_DECL_TILEDLOOPBUFFERIZEPASS
#ifdef GEN_PASS_DEF_TILEDLOOPBUFFERIZEPASS
namespace impl {

template <typename DerivedT>
class TiledLoopBufferizePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TiledLoopBufferizePassBase;

  TiledLoopBufferizePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TiledLoopBufferizePassBase(const TiledLoopBufferizePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiled-loop-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiled-loop-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to bufferize linalg.tiled_loop with the ops inside it."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TiledLoopBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "TiledLoopBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TiledLoopBufferizePassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_TILEDLOOPBUFFERIZEPASS
#endif // GEN_PASS_DEF_TILEDLOOPBUFFERIZEPASS

//===----------------------------------------------------------------------===//
// TilingCwisePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TILINGCWISEPASS
struct TilingCwisePassOptions {
  bool distribute_ = true;
  ::llvm::ArrayRef<int64_t> tileSizes_;
  std::string distributionLabel_;
};
#undef GEN_PASS_DECL_TILINGCWISEPASS
#endif // GEN_PASS_DECL_TILINGCWISEPASS
#ifdef GEN_PASS_DEF_TILINGCWISEPASS
namespace impl {

template <typename DerivedT>
class TilingCwisePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingCwisePassBase;

  TilingCwisePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingCwisePassBase(const TilingCwisePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-cwise");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-cwise"; }

  ::llvm::StringRef getDescription() const override { return "Tile and fuse all cwise ops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingCwisePass");
  }
  ::llvm::StringRef getName() const override { return "TilingCwisePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingCwisePassBase<DerivedT>)

  TilingCwisePassBase(const TilingCwisePassOptions &options) : TilingCwisePassBase() {
    distribute_ = options.distribute_;
    tileSizes_ = options.tileSizes_;
    distributionLabel_ = options.distributionLabel_;
  }
protected:
  ::mlir::Pass::Option<bool> distribute_{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes_{*this, "tile-sizes", ::llvm::cl::desc("Right-aligned tile sizes. Do not tile possible remaining dimensions"), llvm::cl::ZeroOrMore};
  ::mlir::Pass::Option<std::string> distributionLabel_{*this, "distribution-label", ::llvm::cl::desc("Distribution label for generated gml_st.parallel")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_TILINGCWISEPASS
#endif // GEN_PASS_DEF_TILINGCWISEPASS

//===----------------------------------------------------------------------===//
// TilingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TILINGPASS
struct TilingPassOptions {
  std::string opName;
  std::string opLabel;
  bool distribute = true;
  ::llvm::ArrayRef<int64_t> tileSizes;
};
#undef GEN_PASS_DECL_TILINGPASS
#endif // GEN_PASS_DECL_TILINGPASS
#ifdef GEN_PASS_DEF_TILINGPASS
namespace impl {

template <typename DerivedT>
class TilingPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingPassBase;

  TilingPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingPassBase(const TilingPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling"; }

  ::llvm::StringRef getDescription() const override { return "Tile operations using TilingInterface to produce gml_st.for"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingPass");
  }
  ::llvm::StringRef getName() const override { return "TilingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingPassBase<DerivedT>)

  TilingPassBase(const TilingPassOptions &options) : TilingPassBase() {
    opName = options.opName;
    opLabel = options.opLabel;
    distribute = options.distribute;
    tileSizes = options.tileSizes;
  }
protected:
  ::mlir::Pass::Option<std::string> opName{*this, "op-name", ::llvm::cl::desc("Operation with this name is the anchor to latch on.")};
  ::mlir::Pass::Option<std::string> opLabel{*this, "op-label", ::llvm::cl::desc("Operation with this label is the anchor to latch on.")};
  ::mlir::Pass::Option<bool> distribute{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "tile-sizes", ::llvm::cl::desc("Tile sizes"), llvm::cl::ZeroOrMore};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_TILINGPASS
#endif // GEN_PASS_DEF_TILINGPASS

//===----------------------------------------------------------------------===//
// TilingReductionPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TILINGREDUCTIONPASS
#undef GEN_PASS_DECL_TILINGREDUCTIONPASS
#endif // GEN_PASS_DECL_TILINGREDUCTIONPASS
#ifdef GEN_PASS_DEF_TILINGREDUCTIONPASS
namespace impl {

template <typename DerivedT>
class TilingReductionPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingReductionPassBase;

  TilingReductionPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingReductionPassBase(const TilingReductionPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-reduction");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-reduction"; }

  ::llvm::StringRef getDescription() const override { return "Tile linalg.generic reductions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingReductionPass");
  }
  ::llvm::StringRef getName() const override { return "TilingReductionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::gml_st::GmlStDialect>();

  registry.insert<::mlir::arith::ArithDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingReductionPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_TILINGREDUCTIONPASS
#endif // GEN_PASS_DEF_TILINGREDUCTIONPASS

//===----------------------------------------------------------------------===//
// TilingSoftmaxPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TILINGSOFTMAXPASS
struct TilingSoftmaxPassOptions {
  bool distribute = true;
  ::llvm::ArrayRef<int64_t> tileSizes;
};
#undef GEN_PASS_DECL_TILINGSOFTMAXPASS
#endif // GEN_PASS_DECL_TILINGSOFTMAXPASS
#ifdef GEN_PASS_DEF_TILINGSOFTMAXPASS
namespace impl {

template <typename DerivedT>
class TilingSoftmaxPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingSoftmaxPassBase;

  TilingSoftmaxPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingSoftmaxPassBase(const TilingSoftmaxPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-softmax");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-softmax"; }

  ::llvm::StringRef getDescription() const override { return "Match, tile, and fuse softmax implementations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingSoftmaxPass");
  }
  ::llvm::StringRef getName() const override { return "TilingSoftmaxPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingSoftmaxPassBase<DerivedT>)

  TilingSoftmaxPassBase(const TilingSoftmaxPassOptions &options) : TilingSoftmaxPassBase() {
    distribute = options.distribute;
    tileSizes = options.tileSizes;
  }
protected:
  ::mlir::Pass::Option<bool> distribute{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "tile-sizes", ::llvm::cl::desc("Right-aligned tile sizes. Do not tile possible remaining dimensions"), llvm::cl::ZeroOrMore};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_TILINGSOFTMAXPASS
#endif // GEN_PASS_DEF_TILINGSOFTMAXPASS

//===----------------------------------------------------------------------===//
// VectorizeGmlStLoopsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_VECTORIZEGMLSTLOOPSPASS
struct VectorizeGmlStLoopsPassOptions {
  bool vectorizeGmlStOps = false;
};
#undef GEN_PASS_DECL_VECTORIZEGMLSTLOOPSPASS
#endif // GEN_PASS_DECL_VECTORIZEGMLSTLOOPSPASS
#ifdef GEN_PASS_DEF_VECTORIZEGMLSTLOOPSPASS
namespace impl {

template <typename DerivedT>
class VectorizeGmlStLoopsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = VectorizeGmlStLoopsPassBase;

  VectorizeGmlStLoopsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  VectorizeGmlStLoopsPassBase(const VectorizeGmlStLoopsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("vectorize-gml-st-loops");
  }
  ::llvm::StringRef getArgument() const override { return "vectorize-gml-st-loops"; }

  ::llvm::StringRef getDescription() const override { return "Pass to vectorize linalg.generic ops tiled to gml_st.parallel and gml_st.for loops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorizeGmlStLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "VectorizeGmlStLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(VectorizeGmlStLoopsPassBase<DerivedT>)

  VectorizeGmlStLoopsPassBase(const VectorizeGmlStLoopsPassOptions &options) : VectorizeGmlStLoopsPassBase() {
    vectorizeGmlStOps = options.vectorizeGmlStOps;
  }
protected:
  ::mlir::Pass::Option<bool> vectorizeGmlStOps{*this, "vectorize-gml-st-ops", ::llvm::cl::desc("If true, vectorizes GmlSt ops in addition to linalg ops"), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_VECTORIZEGMLSTLOOPSPASS
#endif // GEN_PASS_DEF_VECTORIZEGMLSTLOOPSPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// CollapseMaterializeOpsPass Registration
//===----------------------------------------------------------------------===//

inline void registerCollapseMaterializeOpsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createCollapseMaterializeOpsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerCollapseMaterializeOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createCollapseMaterializeOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// ComposeSetOpsPass Registration
//===----------------------------------------------------------------------===//

inline void registerComposeSetOpsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createComposeSetOpsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerComposeSetOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createComposeSetOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// FusionPass Registration
//===----------------------------------------------------------------------===//

inline void registerFusionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createFusionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerFusionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createFusionPass();
  });
}

//===----------------------------------------------------------------------===//
// GmlStToGpuPass Registration
//===----------------------------------------------------------------------===//

inline void registerGmlStToGpuPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createGmlStToGpuPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerGmlStToGpuPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createGmlStToGpuPass();
  });
}

//===----------------------------------------------------------------------===//
// GmlStToScf Registration
//===----------------------------------------------------------------------===//

inline void registerGmlStToScf() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createGmlStToScfPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerGmlStToScfPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createGmlStToScfPass();
  });
}

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerTiledLoopBufferizePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::CreateTiledLoopBufferizePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTiledLoopBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::CreateTiledLoopBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// TilingCwisePass Registration
//===----------------------------------------------------------------------===//

inline void registerTilingCwisePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingCwisePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTilingCwisePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingCwisePass();
  });
}

//===----------------------------------------------------------------------===//
// TilingPass Registration
//===----------------------------------------------------------------------===//

inline void registerTilingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTilingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingPass();
  });
}

//===----------------------------------------------------------------------===//
// TilingReductionPass Registration
//===----------------------------------------------------------------------===//

inline void registerTilingReductionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingReductionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTilingReductionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingReductionPass();
  });
}

//===----------------------------------------------------------------------===//
// TilingSoftmaxPass Registration
//===----------------------------------------------------------------------===//

inline void registerTilingSoftmaxPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingSoftmaxPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTilingSoftmaxPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingSoftmaxPass();
  });
}

//===----------------------------------------------------------------------===//
// VectorizeGmlStLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerVectorizeGmlStLoopsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createVectorizeGmlStLoopsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerVectorizeGmlStLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createVectorizeGmlStLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// GmlSt Registration
//===----------------------------------------------------------------------===//

inline void registerGmlStPasses() {
  registerCollapseMaterializeOpsPass();
  registerComposeSetOpsPass();
  registerFusionPass();
  registerGmlStToGpuPass();
  registerGmlStToScf();
  registerTiledLoopBufferizePass();
  registerTilingCwisePass();
  registerTilingPass();
  registerTilingReductionPass();
  registerTilingSoftmaxPass();
  registerVectorizeGmlStLoopsPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class CollapseMaterializeOpsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = CollapseMaterializeOpsPassBase;

  CollapseMaterializeOpsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CollapseMaterializeOpsPassBase(const CollapseMaterializeOpsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-collapse-materialize-ops");
  }
  ::llvm::StringRef getArgument() const override { return "gml-collapse-materialize-ops"; }

  ::llvm::StringRef getDescription() const override { return "Collapse (or uncollapse) materialize operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CollapseMaterializeOpsPass");
  }
  ::llvm::StringRef getName() const override { return "CollapseMaterializeOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CollapseMaterializeOpsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> reverse_{*this, "reverse", ::llvm::cl::desc("Whether to revert collapsing of materialize operations."), ::llvm::cl::init(false)};
};

template <typename DerivedT>
class ComposeSetOpsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ComposeSetOpsPassBase;

  ComposeSetOpsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ComposeSetOpsPassBase(const ComposeSetOpsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-compose-set-ops");
  }
  ::llvm::StringRef getArgument() const override { return "gml-compose-set-ops"; }

  ::llvm::StringRef getDescription() const override { return "Compose set operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ComposeSetOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ComposeSetOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ComposeSetOpsPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class FusionPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = FusionPassBase;

  FusionPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  FusionPassBase(const FusionPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-fusion");
  }
  ::llvm::StringRef getArgument() const override { return "gml-fusion"; }

  ::llvm::StringRef getDescription() const override { return "Fuse producers in into `gml_st.materialize` operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FusionPass");
  }
  ::llvm::StringRef getName() const override { return "FusionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FusionPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> producerLabel{*this, "producer-label", ::llvm::cl::desc("Producer label.")};
  ::mlir::Pass::Option<std::string> consumerLabel{*this, "consumer-label", ::llvm::cl::desc("Consumer label.")};
};

template <typename DerivedT>
class GmlStToGpuPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = GmlStToGpuPassBase;

  GmlStToGpuPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GmlStToGpuPassBase(const GmlStToGpuPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-st-to-gpu");
  }
  ::llvm::StringRef getArgument() const override { return "gml-st-to-gpu"; }

  ::llvm::StringRef getDescription() const override { return "Lower nested `gml_st.parallel` to `gpu.launch`"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GmlStToGpuPass");
  }
  ::llvm::StringRef getName() const override { return "GmlStToGpuPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::AffineDialect>();

  registry.insert<::mlir::arith::ArithDialect>();

  registry.insert<::mlir::gpu::GPUDialect>();

  registry.insert<::mlir::scf::SCFDialect>();

  registry.insert<::mlir::vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GmlStToGpuPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class GmlStToScfBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = GmlStToScfBase;

  GmlStToScfBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GmlStToScfBase(const GmlStToScfBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-st-to-scf");
  }
  ::llvm::StringRef getArgument() const override { return "gml-st-to-scf"; }

  ::llvm::StringRef getDescription() const override { return "Lower `gml_st.loop` to SCF loops and parallel loops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GmlStToScf");
  }
  ::llvm::StringRef getName() const override { return "GmlStToScf"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::scf::SCFDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GmlStToScfBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TiledLoopBufferizePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TiledLoopBufferizePassBase;

  TiledLoopBufferizePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TiledLoopBufferizePassBase(const TiledLoopBufferizePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiled-loop-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiled-loop-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to bufferize linalg.tiled_loop with the ops inside it."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TiledLoopBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "TiledLoopBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TiledLoopBufferizePassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TilingCwisePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingCwisePassBase;

  TilingCwisePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingCwisePassBase(const TilingCwisePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-cwise");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-cwise"; }

  ::llvm::StringRef getDescription() const override { return "Tile and fuse all cwise ops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingCwisePass");
  }
  ::llvm::StringRef getName() const override { return "TilingCwisePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingCwisePassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> distribute_{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes_{*this, "tile-sizes", ::llvm::cl::desc("Right-aligned tile sizes. Do not tile possible remaining dimensions"), llvm::cl::ZeroOrMore};
  ::mlir::Pass::Option<std::string> distributionLabel_{*this, "distribution-label", ::llvm::cl::desc("Distribution label for generated gml_st.parallel")};
};

template <typename DerivedT>
class TilingPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingPassBase;

  TilingPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingPassBase(const TilingPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling"; }

  ::llvm::StringRef getDescription() const override { return "Tile operations using TilingInterface to produce gml_st.for"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingPass");
  }
  ::llvm::StringRef getName() const override { return "TilingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> opName{*this, "op-name", ::llvm::cl::desc("Operation with this name is the anchor to latch on.")};
  ::mlir::Pass::Option<std::string> opLabel{*this, "op-label", ::llvm::cl::desc("Operation with this label is the anchor to latch on.")};
  ::mlir::Pass::Option<bool> distribute{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "tile-sizes", ::llvm::cl::desc("Tile sizes"), llvm::cl::ZeroOrMore};
};

template <typename DerivedT>
class TilingReductionPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingReductionPassBase;

  TilingReductionPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingReductionPassBase(const TilingReductionPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-reduction");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-reduction"; }

  ::llvm::StringRef getDescription() const override { return "Tile linalg.generic reductions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingReductionPass");
  }
  ::llvm::StringRef getName() const override { return "TilingReductionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::gml_st::GmlStDialect>();

  registry.insert<::mlir::arith::ArithDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingReductionPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class TilingSoftmaxPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingSoftmaxPassBase;

  TilingSoftmaxPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingSoftmaxPassBase(const TilingSoftmaxPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling-softmax");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling-softmax"; }

  ::llvm::StringRef getDescription() const override { return "Match, tile, and fuse softmax implementations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingSoftmaxPass");
  }
  ::llvm::StringRef getName() const override { return "TilingSoftmaxPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingSoftmaxPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> distribute{*this, "distribute", ::llvm::cl::desc("Generate gml_st.parallel or gml_st.for"), ::llvm::cl::init(true)};
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "tile-sizes", ::llvm::cl::desc("Right-aligned tile sizes. Do not tile possible remaining dimensions"), llvm::cl::ZeroOrMore};
};

template <typename DerivedT>
class VectorizeGmlStLoopsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = VectorizeGmlStLoopsPassBase;

  VectorizeGmlStLoopsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  VectorizeGmlStLoopsPassBase(const VectorizeGmlStLoopsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("vectorize-gml-st-loops");
  }
  ::llvm::StringRef getArgument() const override { return "vectorize-gml-st-loops"; }

  ::llvm::StringRef getDescription() const override { return "Pass to vectorize linalg.generic ops tiled to gml_st.parallel and gml_st.for loops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorizeGmlStLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "VectorizeGmlStLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(VectorizeGmlStLoopsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> vectorizeGmlStOps{*this, "vectorize-gml-st-ops", ::llvm::cl::desc("If true, vectorizes GmlSt ops in addition to linalg ops"), ::llvm::cl::init(false)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
