#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtHelp, except for defaults which are replaced by "...".
"""

# Module PySide2.QtHelp
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtHelp


class QCompressedHelpInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QCompressedHelpInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def component(self) -> str: ...
    @staticmethod
    def fromCompressedHelpFile(documentationFileName: str) -> PySide2.QtHelp.QCompressedHelpInfo: ...
    def isNull(self) -> bool: ...
    def namespaceName(self) -> str: ...
    def swap(self, other: PySide2.QtHelp.QCompressedHelpInfo) -> None: ...
    def version(self) -> PySide2.QtCore.QVersionNumber: ...


class QHelpContentItem(Shiboken.Object):
    @staticmethod
    def __copy__() -> None: ...
    def child(self, row: int) -> PySide2.QtHelp.QHelpContentItem: ...
    def childCount(self) -> int: ...
    def childPosition(self, child: PySide2.QtHelp.QHelpContentItem) -> int: ...
    def parent(self) -> PySide2.QtHelp.QHelpContentItem: ...
    def row(self) -> int: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QHelpContentModel(PySide2.QtCore.QAbstractItemModel):
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def contentItemAt(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtHelp.QHelpContentItem: ...
    def createContents(self, customFilterName: str) -> None: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isCreatingContents(self) -> bool: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...


class QHelpContentWidget(PySide2.QtWidgets.QTreeView):
    def indexOf(self, link: PySide2.QtCore.QUrl) -> PySide2.QtCore.QModelIndex: ...


class QHelpEngine(PySide2.QtHelp.QHelpEngineCore):

    def __init__(self, collectionFile: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def contentModel(self) -> PySide2.QtHelp.QHelpContentModel: ...
    def contentWidget(self) -> PySide2.QtHelp.QHelpContentWidget: ...
    def indexModel(self) -> PySide2.QtHelp.QHelpIndexModel: ...
    def indexWidget(self) -> PySide2.QtHelp.QHelpIndexWidget: ...
    def searchEngine(self) -> PySide2.QtHelp.QHelpSearchEngine: ...


class QHelpEngineCore(PySide2.QtCore.QObject):

    def __init__(self, collectionFile: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def addCustomFilter(self, filterName: str, attributes: typing.Sequence[str]) -> bool: ...
    def autoSaveFilter(self) -> bool: ...
    def collectionFile(self) -> str: ...
    def copyCollectionFile(self, fileName: str) -> bool: ...
    def currentFilter(self) -> str: ...
    def customFilters(self) -> typing.List[str]: ...
    def customValue(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def documentationFileName(self, namespaceName: str) -> str: ...
    @typing.overload
    def documentsForIdentifier(self, id: str) -> typing.List[PySide2.QtHelp.QHelpLink]: ...
    @typing.overload
    def documentsForIdentifier(self, id: str, filterName: str) -> typing.List[PySide2.QtHelp.QHelpLink]: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str) -> typing.List[PySide2.QtHelp.QHelpLink]: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str, filterName: str) -> typing.List[PySide2.QtHelp.QHelpLink]: ...
    def error(self) -> str: ...
    def fileData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def files(self, namespaceName: str, filterAttributes: typing.Sequence[str], extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    @typing.overload
    def files(self, namespaceName: str, filterName: str, extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    def filterAttributeSets(self, namespaceName: str) -> typing.List[typing.List[str]]: ...
    @typing.overload
    def filterAttributes(self) -> typing.List[str]: ...
    @typing.overload
    def filterAttributes(self, filterName: str) -> typing.List[str]: ...
    def filterEngine(self) -> PySide2.QtHelp.QHelpFilterEngine: ...
    def findFile(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def linksForIdentifier(self, id: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...
    @staticmethod
    def metaData(documentationFileName: str, name: str) -> typing.Any: ...
    @staticmethod
    def namespaceName(documentationFileName: str) -> str: ...
    def registerDocumentation(self, documentationFileName: str) -> bool: ...
    def registeredDocumentations(self) -> typing.List[str]: ...
    def removeCustomFilter(self, filterName: str) -> bool: ...
    def removeCustomValue(self, key: str) -> bool: ...
    def setAutoSaveFilter(self, save: bool) -> None: ...
    def setCollectionFile(self, fileName: str) -> None: ...
    def setCurrentFilter(self, filterName: str) -> None: ...
    def setCustomValue(self, key: str, value: typing.Any) -> bool: ...
    def setUsesFilterEngine(self, uses: bool) -> None: ...
    def setupData(self) -> bool: ...
    def unregisterDocumentation(self, namespaceName: str) -> bool: ...
    def usesFilterEngine(self) -> bool: ...


class QHelpFilterData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QHelpFilterData) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def components(self) -> typing.List[str]: ...
    def setComponents(self, components: typing.Sequence[str]) -> None: ...
    def setVersions(self, versions: typing.Sequence[PySide2.QtCore.QVersionNumber]) -> None: ...
    def swap(self, other: PySide2.QtHelp.QHelpFilterData) -> None: ...
    def versions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...


class QHelpFilterEngine(PySide2.QtCore.QObject):

    def __init__(self, helpEngine: PySide2.QtHelp.QHelpEngineCore) -> None: ...

    def activeFilter(self) -> str: ...
    def availableComponents(self) -> typing.List[str]: ...
    def availableVersions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...
    def filterData(self, filterName: str) -> PySide2.QtHelp.QHelpFilterData: ...
    def filters(self) -> typing.List[str]: ...
    @typing.overload
    def indices(self) -> typing.List[str]: ...
    @typing.overload
    def indices(self, filterName: str) -> typing.List[str]: ...
    def namespaceToComponent(self) -> typing.Dict[str, str]: ...
    def namespaceToVersion(self) -> typing.Dict[str, PySide2.QtCore.QVersionNumber]: ...
    def namespacesForFilter(self, filterName: str) -> typing.List[str]: ...
    def removeFilter(self, filterName: str) -> bool: ...
    def setActiveFilter(self, filterName: str) -> bool: ...
    def setFilterData(self, filterName: str, filterData: PySide2.QtHelp.QHelpFilterData) -> bool: ...


class QHelpFilterSettingsWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def applySettings(self, filterEngine: PySide2.QtHelp.QHelpFilterEngine) -> bool: ...
    def readSettings(self, filterEngine: PySide2.QtHelp.QHelpFilterEngine) -> None: ...
    def setAvailableComponents(self, components: typing.Sequence[str]) -> None: ...
    def setAvailableVersions(self, versions: typing.Sequence[PySide2.QtCore.QVersionNumber]) -> None: ...


class QHelpIndexModel(PySide2.QtCore.QStringListModel):
    @typing.overload
    def createIndex(self, customFilterName: str) -> None: ...
    @typing.overload
    def createIndex(self, row: int, column: int, id: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row: int, column: int, ptr: object) -> PySide2.QtCore.QModelIndex: ...
    def filter(self, filter: str, wildcard: str = ...) -> PySide2.QtCore.QModelIndex: ...
    def helpEngine(self) -> PySide2.QtHelp.QHelpEngineCore: ...
    def isCreatingIndex(self) -> bool: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str, PySide2.QtCore.QUrl]: ...


class QHelpIndexWidget(PySide2.QtWidgets.QListView):
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter: str, wildcard: str = ...) -> None: ...


class QHelpLink(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpLink: PySide2.QtHelp.QHelpLink) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QHelpSearchEngine(PySide2.QtCore.QObject):

    def __init__(self, helpEngine: PySide2.QtHelp.QHelpEngineCore, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def cancelIndexing(self) -> None: ...
    def cancelSearching(self) -> None: ...
    def hitCount(self) -> int: ...
    def hitsCount(self) -> int: ...
    def query(self) -> typing.List[PySide2.QtHelp.QHelpSearchQuery]: ...
    def queryWidget(self) -> PySide2.QtHelp.QHelpSearchQueryWidget: ...
    def reindexDocumentation(self) -> None: ...
    def resultWidget(self) -> PySide2.QtHelp.QHelpSearchResultWidget: ...
    def scheduleIndexDocumentation(self) -> None: ...
    @typing.overload
    def search(self, queryList: typing.Sequence[PySide2.QtHelp.QHelpSearchQuery]) -> None: ...
    @typing.overload
    def search(self, searchInput: str) -> None: ...
    def searchInput(self) -> str: ...
    def searchResultCount(self) -> int: ...
    def searchResults(self, start: int, end: int) -> typing.List[PySide2.QtHelp.QHelpSearchResult]: ...


class QHelpSearchQuery(Shiboken.Object):
    DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
    FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
    WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
    PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
    ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
    ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    class FieldName(Shiboken.Enum):
        DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
        FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
        WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
        PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
        ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
        ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpSearchQuery: PySide2.QtHelp.QHelpSearchQuery) -> None: ...
    @typing.overload
    def __init__(self, field: PySide2.QtHelp.QHelpSearchQuery.FieldName, wordList_: typing.Sequence[str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QHelpSearchQueryWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...
    def focusInEvent(self, focusEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def isCompactMode(self) -> bool: ...
    def query(self) -> typing.List[PySide2.QtHelp.QHelpSearchQuery]: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool) -> None: ...
    def setQuery(self, queryList: typing.Sequence[PySide2.QtHelp.QHelpSearchQuery]) -> None: ...
    def setSearchInput(self, searchInput: str) -> None: ...


class QHelpSearchResult(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QHelpSearchResult) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, title: str, snippet: str) -> None: ...

    def snippet(self) -> str: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QHelpSearchResultWidget(PySide2.QtWidgets.QWidget):
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def linkAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QUrl: ...

# eof
