"""
Autogenerated Enums for VASP RunType, TaskType, and CalcType.

Do not edit this by hand to add or remove enums.
Instead, edit
    dev_scripts/generate_enums.py
and/or
    emmet/core/vasp/calc_types/calc_types.yaml
"""

from emmet.core.utils import ValueEnum, IgnoreCaseEnum


class RunType(IgnoreCaseEnum):
    """VASP calculation run types."""

    AM05 = "AM05"
    AM05_U = "AM05+U"
    B3LYP = "B3LYP"
    B3LYP_U = "B3LYP+U"
    G0W0 = "G0W0"
    G0W0_U = "G0W0+U"
    GGA = "GGA"
    GGA_U = "GGA+U"
    HF = "HF"
    HFCus = "HFCus"
    HFCus_U = "HFCus+U"
    HF_U = "HF+U"
    HSE03 = "HSE03"
    HSE03_U = "HSE03+U"
    HSE06 = "HSE06"
    HSE06_U = "HSE06+U"
    LDA = "LDA"
    LDA_U = "LDA+U"
    M06L = "M06L"
    M06L_U = "M06L+U"
    MBJL = "MBJL"
    MBJL_U = "MBJL+U"
    MS0 = "MS0"
    MS0_U = "MS0+U"
    MS1 = "MS1"
    MS1_U = "MS1+U"
    MS2 = "MS2"
    MS2_U = "MS2+U"
    PBE = "PBE"
    PBE0 = "PBE0"
    PBE0_U = "PBE0+U"
    PBE_U = "PBE+U"
    PBEsol = "PBEsol"
    PBEsol_U = "PBEsol+U"
    RTPSS = "RTPSS"
    RTPSS_U = "RTPSS+U"
    SCAN = "SCAN"
    SCAN_U = "SCAN+U"
    SCAN_rVV10 = "SCAN-rVV10"
    SCAN_rVV10_U = "SCAN-rVV10+U"
    TPSS = "TPSS"
    TPSS_U = "TPSS+U"
    optB86b = "optB86b"
    optB86b_U = "optB86b+U"
    optB86b_vdW = "optB86b-vdW"
    optB86b_vdW_U = "optB86b-vdW+U"
    optB88 = "optB88"
    optB88_U = "optB88+U"
    optB88_vdW = "optB88-vdW"
    optB88_vdW_U = "optB88-vdW+U"
    optPBE = "optPBE"
    optPBE_U = "optPBE+U"
    optPBE_vdW = "optPBE-vdW"
    optPBE_vdW_U = "optPBE-vdW+U"
    r2SCAN = "r2SCAN"
    r2SCAN_U = "r2SCAN+U"
    r2SCAN_rVV10 = "r2SCAN-rVV10"
    r2SCAN_rVV10_U = "r2SCAN-rVV10+U"
    revPBE = "revPBE"
    revPBE_PADE = "revPBE+PADE"
    revPBE_PADE_U = "revPBE+PADE+U"
    revPBE_U = "revPBE+U"
    revPBE_vdW = "revPBE-vdW"
    revPBE_vdW_U = "revPBE-vdW+U"
    rev_vdW_DF2 = "rev-vdW-DF2"
    rev_vdW_DF2_U = "rev-vdW-DF2+U"
    vdW_DF2 = "vdW-DF2"
    vdW_DF2_U = "vdW-DF2+U"


class TaskType(ValueEnum):
    """VASP calculation task types."""

    DFPT = "DFPT"
    DFPT_Dielectric = "DFPT Dielectric"
    Deformation = "Deformation"
    Dielectric = "Dielectric"
    Molecular_Dynamics = "Molecular Dynamics"
    NMR_Electric_Field_Gradient = "NMR Electric Field Gradient"
    NMR_Nuclear_Shielding = "NMR Nuclear Shielding"
    NSCF_Line = "NSCF Line"
    NSCF_Uniform = "NSCF Uniform"
    Optic = "Optic"
    Static = "Static"
    Structure_Optimization = "Structure Optimization"
    Unrecognized = "Unrecognized"


class CalcType(IgnoreCaseEnum):
    """VASP calculation types."""

    AM05_DFPT = "AM05 DFPT"
    AM05_DFPT_Dielectric = "AM05 DFPT Dielectric"
    AM05_Deformation = "AM05 Deformation"
    AM05_Dielectric = "AM05 Dielectric"
    AM05_Molecular_Dynamics = "AM05 Molecular Dynamics"
    AM05_NMR_Electric_Field_Gradient = "AM05 NMR Electric Field Gradient"
    AM05_NMR_Nuclear_Shielding = "AM05 NMR Nuclear Shielding"
    AM05_NSCF_Line = "AM05 NSCF Line"
    AM05_NSCF_Uniform = "AM05 NSCF Uniform"
    AM05_Optic = "AM05 Optic"
    AM05_Static = "AM05 Static"
    AM05_Structure_Optimization = "AM05 Structure Optimization"
    AM05_U_DFPT = "AM05+U DFPT"
    AM05_U_DFPT_Dielectric = "AM05+U DFPT Dielectric"
    AM05_U_Deformation = "AM05+U Deformation"
    AM05_U_Dielectric = "AM05+U Dielectric"
    AM05_U_Molecular_Dynamics = "AM05+U Molecular Dynamics"
    AM05_U_NMR_Electric_Field_Gradient = "AM05+U NMR Electric Field Gradient"
    AM05_U_NMR_Nuclear_Shielding = "AM05+U NMR Nuclear Shielding"
    AM05_U_NSCF_Line = "AM05+U NSCF Line"
    AM05_U_NSCF_Uniform = "AM05+U NSCF Uniform"
    AM05_U_Optic = "AM05+U Optic"
    AM05_U_Static = "AM05+U Static"
    AM05_U_Structure_Optimization = "AM05+U Structure Optimization"
    AM05_U_Unrecognized = "AM05+U Unrecognized"
    AM05_Unrecognized = "AM05 Unrecognized"
    B3LYP_DFPT = "B3LYP DFPT"
    B3LYP_DFPT_Dielectric = "B3LYP DFPT Dielectric"
    B3LYP_Deformation = "B3LYP Deformation"
    B3LYP_Dielectric = "B3LYP Dielectric"
    B3LYP_Molecular_Dynamics = "B3LYP Molecular Dynamics"
    B3LYP_NMR_Electric_Field_Gradient = "B3LYP NMR Electric Field Gradient"
    B3LYP_NMR_Nuclear_Shielding = "B3LYP NMR Nuclear Shielding"
    B3LYP_NSCF_Line = "B3LYP NSCF Line"
    B3LYP_NSCF_Uniform = "B3LYP NSCF Uniform"
    B3LYP_Optic = "B3LYP Optic"
    B3LYP_Static = "B3LYP Static"
    B3LYP_Structure_Optimization = "B3LYP Structure Optimization"
    B3LYP_U_DFPT = "B3LYP+U DFPT"
    B3LYP_U_DFPT_Dielectric = "B3LYP+U DFPT Dielectric"
    B3LYP_U_Deformation = "B3LYP+U Deformation"
    B3LYP_U_Dielectric = "B3LYP+U Dielectric"
    B3LYP_U_Molecular_Dynamics = "B3LYP+U Molecular Dynamics"
    B3LYP_U_NMR_Electric_Field_Gradient = "B3LYP+U NMR Electric Field Gradient"
    B3LYP_U_NMR_Nuclear_Shielding = "B3LYP+U NMR Nuclear Shielding"
    B3LYP_U_NSCF_Line = "B3LYP+U NSCF Line"
    B3LYP_U_NSCF_Uniform = "B3LYP+U NSCF Uniform"
    B3LYP_U_Optic = "B3LYP+U Optic"
    B3LYP_U_Static = "B3LYP+U Static"
    B3LYP_U_Structure_Optimization = "B3LYP+U Structure Optimization"
    B3LYP_U_Unrecognized = "B3LYP+U Unrecognized"
    B3LYP_Unrecognized = "B3LYP Unrecognized"
    G0W0_DFPT = "G0W0 DFPT"
    G0W0_DFPT_Dielectric = "G0W0 DFPT Dielectric"
    G0W0_Deformation = "G0W0 Deformation"
    G0W0_Dielectric = "G0W0 Dielectric"
    G0W0_Molecular_Dynamics = "G0W0 Molecular Dynamics"
    G0W0_NMR_Electric_Field_Gradient = "G0W0 NMR Electric Field Gradient"
    G0W0_NMR_Nuclear_Shielding = "G0W0 NMR Nuclear Shielding"
    G0W0_NSCF_Line = "G0W0 NSCF Line"
    G0W0_NSCF_Uniform = "G0W0 NSCF Uniform"
    G0W0_Optic = "G0W0 Optic"
    G0W0_Static = "G0W0 Static"
    G0W0_Structure_Optimization = "G0W0 Structure Optimization"
    G0W0_U_DFPT = "G0W0+U DFPT"
    G0W0_U_DFPT_Dielectric = "G0W0+U DFPT Dielectric"
    G0W0_U_Deformation = "G0W0+U Deformation"
    G0W0_U_Dielectric = "G0W0+U Dielectric"
    G0W0_U_Molecular_Dynamics = "G0W0+U Molecular Dynamics"
    G0W0_U_NMR_Electric_Field_Gradient = "G0W0+U NMR Electric Field Gradient"
    G0W0_U_NMR_Nuclear_Shielding = "G0W0+U NMR Nuclear Shielding"
    G0W0_U_NSCF_Line = "G0W0+U NSCF Line"
    G0W0_U_NSCF_Uniform = "G0W0+U NSCF Uniform"
    G0W0_U_Optic = "G0W0+U Optic"
    G0W0_U_Static = "G0W0+U Static"
    G0W0_U_Structure_Optimization = "G0W0+U Structure Optimization"
    G0W0_U_Unrecognized = "G0W0+U Unrecognized"
    G0W0_Unrecognized = "G0W0 Unrecognized"
    GGA_DFPT = "GGA DFPT"
    GGA_DFPT_Dielectric = "GGA DFPT Dielectric"
    GGA_Deformation = "GGA Deformation"
    GGA_Dielectric = "GGA Dielectric"
    GGA_Molecular_Dynamics = "GGA Molecular Dynamics"
    GGA_NMR_Electric_Field_Gradient = "GGA NMR Electric Field Gradient"
    GGA_NMR_Nuclear_Shielding = "GGA NMR Nuclear Shielding"
    GGA_NSCF_Line = "GGA NSCF Line"
    GGA_NSCF_Uniform = "GGA NSCF Uniform"
    GGA_Optic = "GGA Optic"
    GGA_Static = "GGA Static"
    GGA_Structure_Optimization = "GGA Structure Optimization"
    GGA_U_DFPT = "GGA+U DFPT"
    GGA_U_DFPT_Dielectric = "GGA+U DFPT Dielectric"
    GGA_U_Deformation = "GGA+U Deformation"
    GGA_U_Dielectric = "GGA+U Dielectric"
    GGA_U_Molecular_Dynamics = "GGA+U Molecular Dynamics"
    GGA_U_NMR_Electric_Field_Gradient = "GGA+U NMR Electric Field Gradient"
    GGA_U_NMR_Nuclear_Shielding = "GGA+U NMR Nuclear Shielding"
    GGA_U_NSCF_Line = "GGA+U NSCF Line"
    GGA_U_NSCF_Uniform = "GGA+U NSCF Uniform"
    GGA_U_Optic = "GGA+U Optic"
    GGA_U_Static = "GGA+U Static"
    GGA_U_Structure_Optimization = "GGA+U Structure Optimization"
    GGA_U_Unrecognized = "GGA+U Unrecognized"
    GGA_Unrecognized = "GGA Unrecognized"
    HFCus_DFPT = "HFCus DFPT"
    HFCus_DFPT_Dielectric = "HFCus DFPT Dielectric"
    HFCus_Deformation = "HFCus Deformation"
    HFCus_Dielectric = "HFCus Dielectric"
    HFCus_Molecular_Dynamics = "HFCus Molecular Dynamics"
    HFCus_NMR_Electric_Field_Gradient = "HFCus NMR Electric Field Gradient"
    HFCus_NMR_Nuclear_Shielding = "HFCus NMR Nuclear Shielding"
    HFCus_NSCF_Line = "HFCus NSCF Line"
    HFCus_NSCF_Uniform = "HFCus NSCF Uniform"
    HFCus_Optic = "HFCus Optic"
    HFCus_Static = "HFCus Static"
    HFCus_Structure_Optimization = "HFCus Structure Optimization"
    HFCus_U_DFPT = "HFCus+U DFPT"
    HFCus_U_DFPT_Dielectric = "HFCus+U DFPT Dielectric"
    HFCus_U_Deformation = "HFCus+U Deformation"
    HFCus_U_Dielectric = "HFCus+U Dielectric"
    HFCus_U_Molecular_Dynamics = "HFCus+U Molecular Dynamics"
    HFCus_U_NMR_Electric_Field_Gradient = "HFCus+U NMR Electric Field Gradient"
    HFCus_U_NMR_Nuclear_Shielding = "HFCus+U NMR Nuclear Shielding"
    HFCus_U_NSCF_Line = "HFCus+U NSCF Line"
    HFCus_U_NSCF_Uniform = "HFCus+U NSCF Uniform"
    HFCus_U_Optic = "HFCus+U Optic"
    HFCus_U_Static = "HFCus+U Static"
    HFCus_U_Structure_Optimization = "HFCus+U Structure Optimization"
    HFCus_U_Unrecognized = "HFCus+U Unrecognized"
    HFCus_Unrecognized = "HFCus Unrecognized"
    HF_DFPT = "HF DFPT"
    HF_DFPT_Dielectric = "HF DFPT Dielectric"
    HF_Deformation = "HF Deformation"
    HF_Dielectric = "HF Dielectric"
    HF_Molecular_Dynamics = "HF Molecular Dynamics"
    HF_NMR_Electric_Field_Gradient = "HF NMR Electric Field Gradient"
    HF_NMR_Nuclear_Shielding = "HF NMR Nuclear Shielding"
    HF_NSCF_Line = "HF NSCF Line"
    HF_NSCF_Uniform = "HF NSCF Uniform"
    HF_Optic = "HF Optic"
    HF_Static = "HF Static"
    HF_Structure_Optimization = "HF Structure Optimization"
    HF_U_DFPT = "HF+U DFPT"
    HF_U_DFPT_Dielectric = "HF+U DFPT Dielectric"
    HF_U_Deformation = "HF+U Deformation"
    HF_U_Dielectric = "HF+U Dielectric"
    HF_U_Molecular_Dynamics = "HF+U Molecular Dynamics"
    HF_U_NMR_Electric_Field_Gradient = "HF+U NMR Electric Field Gradient"
    HF_U_NMR_Nuclear_Shielding = "HF+U NMR Nuclear Shielding"
    HF_U_NSCF_Line = "HF+U NSCF Line"
    HF_U_NSCF_Uniform = "HF+U NSCF Uniform"
    HF_U_Optic = "HF+U Optic"
    HF_U_Static = "HF+U Static"
    HF_U_Structure_Optimization = "HF+U Structure Optimization"
    HF_U_Unrecognized = "HF+U Unrecognized"
    HF_Unrecognized = "HF Unrecognized"
    HSE03_DFPT = "HSE03 DFPT"
    HSE03_DFPT_Dielectric = "HSE03 DFPT Dielectric"
    HSE03_Deformation = "HSE03 Deformation"
    HSE03_Dielectric = "HSE03 Dielectric"
    HSE03_Molecular_Dynamics = "HSE03 Molecular Dynamics"
    HSE03_NMR_Electric_Field_Gradient = "HSE03 NMR Electric Field Gradient"
    HSE03_NMR_Nuclear_Shielding = "HSE03 NMR Nuclear Shielding"
    HSE03_NSCF_Line = "HSE03 NSCF Line"
    HSE03_NSCF_Uniform = "HSE03 NSCF Uniform"
    HSE03_Optic = "HSE03 Optic"
    HSE03_Static = "HSE03 Static"
    HSE03_Structure_Optimization = "HSE03 Structure Optimization"
    HSE03_U_DFPT = "HSE03+U DFPT"
    HSE03_U_DFPT_Dielectric = "HSE03+U DFPT Dielectric"
    HSE03_U_Deformation = "HSE03+U Deformation"
    HSE03_U_Dielectric = "HSE03+U Dielectric"
    HSE03_U_Molecular_Dynamics = "HSE03+U Molecular Dynamics"
    HSE03_U_NMR_Electric_Field_Gradient = "HSE03+U NMR Electric Field Gradient"
    HSE03_U_NMR_Nuclear_Shielding = "HSE03+U NMR Nuclear Shielding"
    HSE03_U_NSCF_Line = "HSE03+U NSCF Line"
    HSE03_U_NSCF_Uniform = "HSE03+U NSCF Uniform"
    HSE03_U_Optic = "HSE03+U Optic"
    HSE03_U_Static = "HSE03+U Static"
    HSE03_U_Structure_Optimization = "HSE03+U Structure Optimization"
    HSE03_U_Unrecognized = "HSE03+U Unrecognized"
    HSE03_Unrecognized = "HSE03 Unrecognized"
    HSE06_DFPT = "HSE06 DFPT"
    HSE06_DFPT_Dielectric = "HSE06 DFPT Dielectric"
    HSE06_Deformation = "HSE06 Deformation"
    HSE06_Dielectric = "HSE06 Dielectric"
    HSE06_Molecular_Dynamics = "HSE06 Molecular Dynamics"
    HSE06_NMR_Electric_Field_Gradient = "HSE06 NMR Electric Field Gradient"
    HSE06_NMR_Nuclear_Shielding = "HSE06 NMR Nuclear Shielding"
    HSE06_NSCF_Line = "HSE06 NSCF Line"
    HSE06_NSCF_Uniform = "HSE06 NSCF Uniform"
    HSE06_Optic = "HSE06 Optic"
    HSE06_Static = "HSE06 Static"
    HSE06_Structure_Optimization = "HSE06 Structure Optimization"
    HSE06_U_DFPT = "HSE06+U DFPT"
    HSE06_U_DFPT_Dielectric = "HSE06+U DFPT Dielectric"
    HSE06_U_Deformation = "HSE06+U Deformation"
    HSE06_U_Dielectric = "HSE06+U Dielectric"
    HSE06_U_Molecular_Dynamics = "HSE06+U Molecular Dynamics"
    HSE06_U_NMR_Electric_Field_Gradient = "HSE06+U NMR Electric Field Gradient"
    HSE06_U_NMR_Nuclear_Shielding = "HSE06+U NMR Nuclear Shielding"
    HSE06_U_NSCF_Line = "HSE06+U NSCF Line"
    HSE06_U_NSCF_Uniform = "HSE06+U NSCF Uniform"
    HSE06_U_Optic = "HSE06+U Optic"
    HSE06_U_Static = "HSE06+U Static"
    HSE06_U_Structure_Optimization = "HSE06+U Structure Optimization"
    HSE06_U_Unrecognized = "HSE06+U Unrecognized"
    HSE06_Unrecognized = "HSE06 Unrecognized"
    LDA_DFPT = "LDA DFPT"
    LDA_DFPT_Dielectric = "LDA DFPT Dielectric"
    LDA_Deformation = "LDA Deformation"
    LDA_Dielectric = "LDA Dielectric"
    LDA_Molecular_Dynamics = "LDA Molecular Dynamics"
    LDA_NMR_Electric_Field_Gradient = "LDA NMR Electric Field Gradient"
    LDA_NMR_Nuclear_Shielding = "LDA NMR Nuclear Shielding"
    LDA_NSCF_Line = "LDA NSCF Line"
    LDA_NSCF_Uniform = "LDA NSCF Uniform"
    LDA_Optic = "LDA Optic"
    LDA_Static = "LDA Static"
    LDA_Structure_Optimization = "LDA Structure Optimization"
    LDA_U_DFPT = "LDA+U DFPT"
    LDA_U_DFPT_Dielectric = "LDA+U DFPT Dielectric"
    LDA_U_Deformation = "LDA+U Deformation"
    LDA_U_Dielectric = "LDA+U Dielectric"
    LDA_U_Molecular_Dynamics = "LDA+U Molecular Dynamics"
    LDA_U_NMR_Electric_Field_Gradient = "LDA+U NMR Electric Field Gradient"
    LDA_U_NMR_Nuclear_Shielding = "LDA+U NMR Nuclear Shielding"
    LDA_U_NSCF_Line = "LDA+U NSCF Line"
    LDA_U_NSCF_Uniform = "LDA+U NSCF Uniform"
    LDA_U_Optic = "LDA+U Optic"
    LDA_U_Static = "LDA+U Static"
    LDA_U_Structure_Optimization = "LDA+U Structure Optimization"
    LDA_U_Unrecognized = "LDA+U Unrecognized"
    LDA_Unrecognized = "LDA Unrecognized"
    M06L_DFPT = "M06L DFPT"
    M06L_DFPT_Dielectric = "M06L DFPT Dielectric"
    M06L_Deformation = "M06L Deformation"
    M06L_Dielectric = "M06L Dielectric"
    M06L_Molecular_Dynamics = "M06L Molecular Dynamics"
    M06L_NMR_Electric_Field_Gradient = "M06L NMR Electric Field Gradient"
    M06L_NMR_Nuclear_Shielding = "M06L NMR Nuclear Shielding"
    M06L_NSCF_Line = "M06L NSCF Line"
    M06L_NSCF_Uniform = "M06L NSCF Uniform"
    M06L_Optic = "M06L Optic"
    M06L_Static = "M06L Static"
    M06L_Structure_Optimization = "M06L Structure Optimization"
    M06L_U_DFPT = "M06L+U DFPT"
    M06L_U_DFPT_Dielectric = "M06L+U DFPT Dielectric"
    M06L_U_Deformation = "M06L+U Deformation"
    M06L_U_Dielectric = "M06L+U Dielectric"
    M06L_U_Molecular_Dynamics = "M06L+U Molecular Dynamics"
    M06L_U_NMR_Electric_Field_Gradient = "M06L+U NMR Electric Field Gradient"
    M06L_U_NMR_Nuclear_Shielding = "M06L+U NMR Nuclear Shielding"
    M06L_U_NSCF_Line = "M06L+U NSCF Line"
    M06L_U_NSCF_Uniform = "M06L+U NSCF Uniform"
    M06L_U_Optic = "M06L+U Optic"
    M06L_U_Static = "M06L+U Static"
    M06L_U_Structure_Optimization = "M06L+U Structure Optimization"
    M06L_U_Unrecognized = "M06L+U Unrecognized"
    M06L_Unrecognized = "M06L Unrecognized"
    MBJL_DFPT = "MBJL DFPT"
    MBJL_DFPT_Dielectric = "MBJL DFPT Dielectric"
    MBJL_Deformation = "MBJL Deformation"
    MBJL_Dielectric = "MBJL Dielectric"
    MBJL_Molecular_Dynamics = "MBJL Molecular Dynamics"
    MBJL_NMR_Electric_Field_Gradient = "MBJL NMR Electric Field Gradient"
    MBJL_NMR_Nuclear_Shielding = "MBJL NMR Nuclear Shielding"
    MBJL_NSCF_Line = "MBJL NSCF Line"
    MBJL_NSCF_Uniform = "MBJL NSCF Uniform"
    MBJL_Optic = "MBJL Optic"
    MBJL_Static = "MBJL Static"
    MBJL_Structure_Optimization = "MBJL Structure Optimization"
    MBJL_U_DFPT = "MBJL+U DFPT"
    MBJL_U_DFPT_Dielectric = "MBJL+U DFPT Dielectric"
    MBJL_U_Deformation = "MBJL+U Deformation"
    MBJL_U_Dielectric = "MBJL+U Dielectric"
    MBJL_U_Molecular_Dynamics = "MBJL+U Molecular Dynamics"
    MBJL_U_NMR_Electric_Field_Gradient = "MBJL+U NMR Electric Field Gradient"
    MBJL_U_NMR_Nuclear_Shielding = "MBJL+U NMR Nuclear Shielding"
    MBJL_U_NSCF_Line = "MBJL+U NSCF Line"
    MBJL_U_NSCF_Uniform = "MBJL+U NSCF Uniform"
    MBJL_U_Optic = "MBJL+U Optic"
    MBJL_U_Static = "MBJL+U Static"
    MBJL_U_Structure_Optimization = "MBJL+U Structure Optimization"
    MBJL_U_Unrecognized = "MBJL+U Unrecognized"
    MBJL_Unrecognized = "MBJL Unrecognized"
    MS0_DFPT = "MS0 DFPT"
    MS0_DFPT_Dielectric = "MS0 DFPT Dielectric"
    MS0_Deformation = "MS0 Deformation"
    MS0_Dielectric = "MS0 Dielectric"
    MS0_Molecular_Dynamics = "MS0 Molecular Dynamics"
    MS0_NMR_Electric_Field_Gradient = "MS0 NMR Electric Field Gradient"
    MS0_NMR_Nuclear_Shielding = "MS0 NMR Nuclear Shielding"
    MS0_NSCF_Line = "MS0 NSCF Line"
    MS0_NSCF_Uniform = "MS0 NSCF Uniform"
    MS0_Optic = "MS0 Optic"
    MS0_Static = "MS0 Static"
    MS0_Structure_Optimization = "MS0 Structure Optimization"
    MS0_U_DFPT = "MS0+U DFPT"
    MS0_U_DFPT_Dielectric = "MS0+U DFPT Dielectric"
    MS0_U_Deformation = "MS0+U Deformation"
    MS0_U_Dielectric = "MS0+U Dielectric"
    MS0_U_Molecular_Dynamics = "MS0+U Molecular Dynamics"
    MS0_U_NMR_Electric_Field_Gradient = "MS0+U NMR Electric Field Gradient"
    MS0_U_NMR_Nuclear_Shielding = "MS0+U NMR Nuclear Shielding"
    MS0_U_NSCF_Line = "MS0+U NSCF Line"
    MS0_U_NSCF_Uniform = "MS0+U NSCF Uniform"
    MS0_U_Optic = "MS0+U Optic"
    MS0_U_Static = "MS0+U Static"
    MS0_U_Structure_Optimization = "MS0+U Structure Optimization"
    MS0_U_Unrecognized = "MS0+U Unrecognized"
    MS0_Unrecognized = "MS0 Unrecognized"
    MS1_DFPT = "MS1 DFPT"
    MS1_DFPT_Dielectric = "MS1 DFPT Dielectric"
    MS1_Deformation = "MS1 Deformation"
    MS1_Dielectric = "MS1 Dielectric"
    MS1_Molecular_Dynamics = "MS1 Molecular Dynamics"
    MS1_NMR_Electric_Field_Gradient = "MS1 NMR Electric Field Gradient"
    MS1_NMR_Nuclear_Shielding = "MS1 NMR Nuclear Shielding"
    MS1_NSCF_Line = "MS1 NSCF Line"
    MS1_NSCF_Uniform = "MS1 NSCF Uniform"
    MS1_Optic = "MS1 Optic"
    MS1_Static = "MS1 Static"
    MS1_Structure_Optimization = "MS1 Structure Optimization"
    MS1_U_DFPT = "MS1+U DFPT"
    MS1_U_DFPT_Dielectric = "MS1+U DFPT Dielectric"
    MS1_U_Deformation = "MS1+U Deformation"
    MS1_U_Dielectric = "MS1+U Dielectric"
    MS1_U_Molecular_Dynamics = "MS1+U Molecular Dynamics"
    MS1_U_NMR_Electric_Field_Gradient = "MS1+U NMR Electric Field Gradient"
    MS1_U_NMR_Nuclear_Shielding = "MS1+U NMR Nuclear Shielding"
    MS1_U_NSCF_Line = "MS1+U NSCF Line"
    MS1_U_NSCF_Uniform = "MS1+U NSCF Uniform"
    MS1_U_Optic = "MS1+U Optic"
    MS1_U_Static = "MS1+U Static"
    MS1_U_Structure_Optimization = "MS1+U Structure Optimization"
    MS1_U_Unrecognized = "MS1+U Unrecognized"
    MS1_Unrecognized = "MS1 Unrecognized"
    MS2_DFPT = "MS2 DFPT"
    MS2_DFPT_Dielectric = "MS2 DFPT Dielectric"
    MS2_Deformation = "MS2 Deformation"
    MS2_Dielectric = "MS2 Dielectric"
    MS2_Molecular_Dynamics = "MS2 Molecular Dynamics"
    MS2_NMR_Electric_Field_Gradient = "MS2 NMR Electric Field Gradient"
    MS2_NMR_Nuclear_Shielding = "MS2 NMR Nuclear Shielding"
    MS2_NSCF_Line = "MS2 NSCF Line"
    MS2_NSCF_Uniform = "MS2 NSCF Uniform"
    MS2_Optic = "MS2 Optic"
    MS2_Static = "MS2 Static"
    MS2_Structure_Optimization = "MS2 Structure Optimization"
    MS2_U_DFPT = "MS2+U DFPT"
    MS2_U_DFPT_Dielectric = "MS2+U DFPT Dielectric"
    MS2_U_Deformation = "MS2+U Deformation"
    MS2_U_Dielectric = "MS2+U Dielectric"
    MS2_U_Molecular_Dynamics = "MS2+U Molecular Dynamics"
    MS2_U_NMR_Electric_Field_Gradient = "MS2+U NMR Electric Field Gradient"
    MS2_U_NMR_Nuclear_Shielding = "MS2+U NMR Nuclear Shielding"
    MS2_U_NSCF_Line = "MS2+U NSCF Line"
    MS2_U_NSCF_Uniform = "MS2+U NSCF Uniform"
    MS2_U_Optic = "MS2+U Optic"
    MS2_U_Static = "MS2+U Static"
    MS2_U_Structure_Optimization = "MS2+U Structure Optimization"
    MS2_U_Unrecognized = "MS2+U Unrecognized"
    MS2_Unrecognized = "MS2 Unrecognized"
    PBE0_DFPT = "PBE0 DFPT"
    PBE0_DFPT_Dielectric = "PBE0 DFPT Dielectric"
    PBE0_Deformation = "PBE0 Deformation"
    PBE0_Dielectric = "PBE0 Dielectric"
    PBE0_Molecular_Dynamics = "PBE0 Molecular Dynamics"
    PBE0_NMR_Electric_Field_Gradient = "PBE0 NMR Electric Field Gradient"
    PBE0_NMR_Nuclear_Shielding = "PBE0 NMR Nuclear Shielding"
    PBE0_NSCF_Line = "PBE0 NSCF Line"
    PBE0_NSCF_Uniform = "PBE0 NSCF Uniform"
    PBE0_Optic = "PBE0 Optic"
    PBE0_Static = "PBE0 Static"
    PBE0_Structure_Optimization = "PBE0 Structure Optimization"
    PBE0_U_DFPT = "PBE0+U DFPT"
    PBE0_U_DFPT_Dielectric = "PBE0+U DFPT Dielectric"
    PBE0_U_Deformation = "PBE0+U Deformation"
    PBE0_U_Dielectric = "PBE0+U Dielectric"
    PBE0_U_Molecular_Dynamics = "PBE0+U Molecular Dynamics"
    PBE0_U_NMR_Electric_Field_Gradient = "PBE0+U NMR Electric Field Gradient"
    PBE0_U_NMR_Nuclear_Shielding = "PBE0+U NMR Nuclear Shielding"
    PBE0_U_NSCF_Line = "PBE0+U NSCF Line"
    PBE0_U_NSCF_Uniform = "PBE0+U NSCF Uniform"
    PBE0_U_Optic = "PBE0+U Optic"
    PBE0_U_Static = "PBE0+U Static"
    PBE0_U_Structure_Optimization = "PBE0+U Structure Optimization"
    PBE0_U_Unrecognized = "PBE0+U Unrecognized"
    PBE0_Unrecognized = "PBE0 Unrecognized"
    PBE_DFPT = "PBE DFPT"
    PBE_DFPT_Dielectric = "PBE DFPT Dielectric"
    PBE_Deformation = "PBE Deformation"
    PBE_Dielectric = "PBE Dielectric"
    PBE_Molecular_Dynamics = "PBE Molecular Dynamics"
    PBE_NMR_Electric_Field_Gradient = "PBE NMR Electric Field Gradient"
    PBE_NMR_Nuclear_Shielding = "PBE NMR Nuclear Shielding"
    PBE_NSCF_Line = "PBE NSCF Line"
    PBE_NSCF_Uniform = "PBE NSCF Uniform"
    PBE_Optic = "PBE Optic"
    PBE_Static = "PBE Static"
    PBE_Structure_Optimization = "PBE Structure Optimization"
    PBE_U_DFPT = "PBE+U DFPT"
    PBE_U_DFPT_Dielectric = "PBE+U DFPT Dielectric"
    PBE_U_Deformation = "PBE+U Deformation"
    PBE_U_Dielectric = "PBE+U Dielectric"
    PBE_U_Molecular_Dynamics = "PBE+U Molecular Dynamics"
    PBE_U_NMR_Electric_Field_Gradient = "PBE+U NMR Electric Field Gradient"
    PBE_U_NMR_Nuclear_Shielding = "PBE+U NMR Nuclear Shielding"
    PBE_U_NSCF_Line = "PBE+U NSCF Line"
    PBE_U_NSCF_Uniform = "PBE+U NSCF Uniform"
    PBE_U_Optic = "PBE+U Optic"
    PBE_U_Static = "PBE+U Static"
    PBE_U_Structure_Optimization = "PBE+U Structure Optimization"
    PBE_U_Unrecognized = "PBE+U Unrecognized"
    PBE_Unrecognized = "PBE Unrecognized"
    PBEsol_DFPT = "PBEsol DFPT"
    PBEsol_DFPT_Dielectric = "PBEsol DFPT Dielectric"
    PBEsol_Deformation = "PBEsol Deformation"
    PBEsol_Dielectric = "PBEsol Dielectric"
    PBEsol_Molecular_Dynamics = "PBEsol Molecular Dynamics"
    PBEsol_NMR_Electric_Field_Gradient = "PBEsol NMR Electric Field Gradient"
    PBEsol_NMR_Nuclear_Shielding = "PBEsol NMR Nuclear Shielding"
    PBEsol_NSCF_Line = "PBEsol NSCF Line"
    PBEsol_NSCF_Uniform = "PBEsol NSCF Uniform"
    PBEsol_Optic = "PBEsol Optic"
    PBEsol_Static = "PBEsol Static"
    PBEsol_Structure_Optimization = "PBEsol Structure Optimization"
    PBEsol_U_DFPT = "PBEsol+U DFPT"
    PBEsol_U_DFPT_Dielectric = "PBEsol+U DFPT Dielectric"
    PBEsol_U_Deformation = "PBEsol+U Deformation"
    PBEsol_U_Dielectric = "PBEsol+U Dielectric"
    PBEsol_U_Molecular_Dynamics = "PBEsol+U Molecular Dynamics"
    PBEsol_U_NMR_Electric_Field_Gradient = "PBEsol+U NMR Electric Field Gradient"
    PBEsol_U_NMR_Nuclear_Shielding = "PBEsol+U NMR Nuclear Shielding"
    PBEsol_U_NSCF_Line = "PBEsol+U NSCF Line"
    PBEsol_U_NSCF_Uniform = "PBEsol+U NSCF Uniform"
    PBEsol_U_Optic = "PBEsol+U Optic"
    PBEsol_U_Static = "PBEsol+U Static"
    PBEsol_U_Structure_Optimization = "PBEsol+U Structure Optimization"
    PBEsol_U_Unrecognized = "PBEsol+U Unrecognized"
    PBEsol_Unrecognized = "PBEsol Unrecognized"
    RTPSS_DFPT = "RTPSS DFPT"
    RTPSS_DFPT_Dielectric = "RTPSS DFPT Dielectric"
    RTPSS_Deformation = "RTPSS Deformation"
    RTPSS_Dielectric = "RTPSS Dielectric"
    RTPSS_Molecular_Dynamics = "RTPSS Molecular Dynamics"
    RTPSS_NMR_Electric_Field_Gradient = "RTPSS NMR Electric Field Gradient"
    RTPSS_NMR_Nuclear_Shielding = "RTPSS NMR Nuclear Shielding"
    RTPSS_NSCF_Line = "RTPSS NSCF Line"
    RTPSS_NSCF_Uniform = "RTPSS NSCF Uniform"
    RTPSS_Optic = "RTPSS Optic"
    RTPSS_Static = "RTPSS Static"
    RTPSS_Structure_Optimization = "RTPSS Structure Optimization"
    RTPSS_U_DFPT = "RTPSS+U DFPT"
    RTPSS_U_DFPT_Dielectric = "RTPSS+U DFPT Dielectric"
    RTPSS_U_Deformation = "RTPSS+U Deformation"
    RTPSS_U_Dielectric = "RTPSS+U Dielectric"
    RTPSS_U_Molecular_Dynamics = "RTPSS+U Molecular Dynamics"
    RTPSS_U_NMR_Electric_Field_Gradient = "RTPSS+U NMR Electric Field Gradient"
    RTPSS_U_NMR_Nuclear_Shielding = "RTPSS+U NMR Nuclear Shielding"
    RTPSS_U_NSCF_Line = "RTPSS+U NSCF Line"
    RTPSS_U_NSCF_Uniform = "RTPSS+U NSCF Uniform"
    RTPSS_U_Optic = "RTPSS+U Optic"
    RTPSS_U_Static = "RTPSS+U Static"
    RTPSS_U_Structure_Optimization = "RTPSS+U Structure Optimization"
    RTPSS_U_Unrecognized = "RTPSS+U Unrecognized"
    RTPSS_Unrecognized = "RTPSS Unrecognized"
    SCAN_DFPT = "SCAN DFPT"
    SCAN_DFPT_Dielectric = "SCAN DFPT Dielectric"
    SCAN_Deformation = "SCAN Deformation"
    SCAN_Dielectric = "SCAN Dielectric"
    SCAN_Molecular_Dynamics = "SCAN Molecular Dynamics"
    SCAN_NMR_Electric_Field_Gradient = "SCAN NMR Electric Field Gradient"
    SCAN_NMR_Nuclear_Shielding = "SCAN NMR Nuclear Shielding"
    SCAN_NSCF_Line = "SCAN NSCF Line"
    SCAN_NSCF_Uniform = "SCAN NSCF Uniform"
    SCAN_Optic = "SCAN Optic"
    SCAN_Static = "SCAN Static"
    SCAN_Structure_Optimization = "SCAN Structure Optimization"
    SCAN_U_DFPT = "SCAN+U DFPT"
    SCAN_U_DFPT_Dielectric = "SCAN+U DFPT Dielectric"
    SCAN_U_Deformation = "SCAN+U Deformation"
    SCAN_U_Dielectric = "SCAN+U Dielectric"
    SCAN_U_Molecular_Dynamics = "SCAN+U Molecular Dynamics"
    SCAN_U_NMR_Electric_Field_Gradient = "SCAN+U NMR Electric Field Gradient"
    SCAN_U_NMR_Nuclear_Shielding = "SCAN+U NMR Nuclear Shielding"
    SCAN_U_NSCF_Line = "SCAN+U NSCF Line"
    SCAN_U_NSCF_Uniform = "SCAN+U NSCF Uniform"
    SCAN_U_Optic = "SCAN+U Optic"
    SCAN_U_Static = "SCAN+U Static"
    SCAN_U_Structure_Optimization = "SCAN+U Structure Optimization"
    SCAN_U_Unrecognized = "SCAN+U Unrecognized"
    SCAN_Unrecognized = "SCAN Unrecognized"
    SCAN_rVV10_DFPT = "SCAN-rVV10 DFPT"
    SCAN_rVV10_DFPT_Dielectric = "SCAN-rVV10 DFPT Dielectric"
    SCAN_rVV10_Deformation = "SCAN-rVV10 Deformation"
    SCAN_rVV10_Dielectric = "SCAN-rVV10 Dielectric"
    SCAN_rVV10_Molecular_Dynamics = "SCAN-rVV10 Molecular Dynamics"
    SCAN_rVV10_NMR_Electric_Field_Gradient = "SCAN-rVV10 NMR Electric Field Gradient"
    SCAN_rVV10_NMR_Nuclear_Shielding = "SCAN-rVV10 NMR Nuclear Shielding"
    SCAN_rVV10_NSCF_Line = "SCAN-rVV10 NSCF Line"
    SCAN_rVV10_NSCF_Uniform = "SCAN-rVV10 NSCF Uniform"
    SCAN_rVV10_Optic = "SCAN-rVV10 Optic"
    SCAN_rVV10_Static = "SCAN-rVV10 Static"
    SCAN_rVV10_Structure_Optimization = "SCAN-rVV10 Structure Optimization"
    SCAN_rVV10_U_DFPT = "SCAN-rVV10+U DFPT"
    SCAN_rVV10_U_DFPT_Dielectric = "SCAN-rVV10+U DFPT Dielectric"
    SCAN_rVV10_U_Deformation = "SCAN-rVV10+U Deformation"
    SCAN_rVV10_U_Dielectric = "SCAN-rVV10+U Dielectric"
    SCAN_rVV10_U_Molecular_Dynamics = "SCAN-rVV10+U Molecular Dynamics"
    SCAN_rVV10_U_NMR_Electric_Field_Gradient = (
        "SCAN-rVV10+U NMR Electric Field Gradient"
    )
    SCAN_rVV10_U_NMR_Nuclear_Shielding = "SCAN-rVV10+U NMR Nuclear Shielding"
    SCAN_rVV10_U_NSCF_Line = "SCAN-rVV10+U NSCF Line"
    SCAN_rVV10_U_NSCF_Uniform = "SCAN-rVV10+U NSCF Uniform"
    SCAN_rVV10_U_Optic = "SCAN-rVV10+U Optic"
    SCAN_rVV10_U_Static = "SCAN-rVV10+U Static"
    SCAN_rVV10_U_Structure_Optimization = "SCAN-rVV10+U Structure Optimization"
    SCAN_rVV10_U_Unrecognized = "SCAN-rVV10+U Unrecognized"
    SCAN_rVV10_Unrecognized = "SCAN-rVV10 Unrecognized"
    TPSS_DFPT = "TPSS DFPT"
    TPSS_DFPT_Dielectric = "TPSS DFPT Dielectric"
    TPSS_Deformation = "TPSS Deformation"
    TPSS_Dielectric = "TPSS Dielectric"
    TPSS_Molecular_Dynamics = "TPSS Molecular Dynamics"
    TPSS_NMR_Electric_Field_Gradient = "TPSS NMR Electric Field Gradient"
    TPSS_NMR_Nuclear_Shielding = "TPSS NMR Nuclear Shielding"
    TPSS_NSCF_Line = "TPSS NSCF Line"
    TPSS_NSCF_Uniform = "TPSS NSCF Uniform"
    TPSS_Optic = "TPSS Optic"
    TPSS_Static = "TPSS Static"
    TPSS_Structure_Optimization = "TPSS Structure Optimization"
    TPSS_U_DFPT = "TPSS+U DFPT"
    TPSS_U_DFPT_Dielectric = "TPSS+U DFPT Dielectric"
    TPSS_U_Deformation = "TPSS+U Deformation"
    TPSS_U_Dielectric = "TPSS+U Dielectric"
    TPSS_U_Molecular_Dynamics = "TPSS+U Molecular Dynamics"
    TPSS_U_NMR_Electric_Field_Gradient = "TPSS+U NMR Electric Field Gradient"
    TPSS_U_NMR_Nuclear_Shielding = "TPSS+U NMR Nuclear Shielding"
    TPSS_U_NSCF_Line = "TPSS+U NSCF Line"
    TPSS_U_NSCF_Uniform = "TPSS+U NSCF Uniform"
    TPSS_U_Optic = "TPSS+U Optic"
    TPSS_U_Static = "TPSS+U Static"
    TPSS_U_Structure_Optimization = "TPSS+U Structure Optimization"
    TPSS_U_Unrecognized = "TPSS+U Unrecognized"
    TPSS_Unrecognized = "TPSS Unrecognized"
    optB86b_DFPT = "optB86b DFPT"
    optB86b_DFPT_Dielectric = "optB86b DFPT Dielectric"
    optB86b_Deformation = "optB86b Deformation"
    optB86b_Dielectric = "optB86b Dielectric"
    optB86b_Molecular_Dynamics = "optB86b Molecular Dynamics"
    optB86b_NMR_Electric_Field_Gradient = "optB86b NMR Electric Field Gradient"
    optB86b_NMR_Nuclear_Shielding = "optB86b NMR Nuclear Shielding"
    optB86b_NSCF_Line = "optB86b NSCF Line"
    optB86b_NSCF_Uniform = "optB86b NSCF Uniform"
    optB86b_Optic = "optB86b Optic"
    optB86b_Static = "optB86b Static"
    optB86b_Structure_Optimization = "optB86b Structure Optimization"
    optB86b_U_DFPT = "optB86b+U DFPT"
    optB86b_U_DFPT_Dielectric = "optB86b+U DFPT Dielectric"
    optB86b_U_Deformation = "optB86b+U Deformation"
    optB86b_U_Dielectric = "optB86b+U Dielectric"
    optB86b_U_Molecular_Dynamics = "optB86b+U Molecular Dynamics"
    optB86b_U_NMR_Electric_Field_Gradient = "optB86b+U NMR Electric Field Gradient"
    optB86b_U_NMR_Nuclear_Shielding = "optB86b+U NMR Nuclear Shielding"
    optB86b_U_NSCF_Line = "optB86b+U NSCF Line"
    optB86b_U_NSCF_Uniform = "optB86b+U NSCF Uniform"
    optB86b_U_Optic = "optB86b+U Optic"
    optB86b_U_Static = "optB86b+U Static"
    optB86b_U_Structure_Optimization = "optB86b+U Structure Optimization"
    optB86b_U_Unrecognized = "optB86b+U Unrecognized"
    optB86b_Unrecognized = "optB86b Unrecognized"
    optB86b_vdW_DFPT = "optB86b-vdW DFPT"
    optB86b_vdW_DFPT_Dielectric = "optB86b-vdW DFPT Dielectric"
    optB86b_vdW_Deformation = "optB86b-vdW Deformation"
    optB86b_vdW_Dielectric = "optB86b-vdW Dielectric"
    optB86b_vdW_Molecular_Dynamics = "optB86b-vdW Molecular Dynamics"
    optB86b_vdW_NMR_Electric_Field_Gradient = "optB86b-vdW NMR Electric Field Gradient"
    optB86b_vdW_NMR_Nuclear_Shielding = "optB86b-vdW NMR Nuclear Shielding"
    optB86b_vdW_NSCF_Line = "optB86b-vdW NSCF Line"
    optB86b_vdW_NSCF_Uniform = "optB86b-vdW NSCF Uniform"
    optB86b_vdW_Optic = "optB86b-vdW Optic"
    optB86b_vdW_Static = "optB86b-vdW Static"
    optB86b_vdW_Structure_Optimization = "optB86b-vdW Structure Optimization"
    optB86b_vdW_U_DFPT = "optB86b-vdW+U DFPT"
    optB86b_vdW_U_DFPT_Dielectric = "optB86b-vdW+U DFPT Dielectric"
    optB86b_vdW_U_Deformation = "optB86b-vdW+U Deformation"
    optB86b_vdW_U_Dielectric = "optB86b-vdW+U Dielectric"
    optB86b_vdW_U_Molecular_Dynamics = "optB86b-vdW+U Molecular Dynamics"
    optB86b_vdW_U_NMR_Electric_Field_Gradient = (
        "optB86b-vdW+U NMR Electric Field Gradient"
    )
    optB86b_vdW_U_NMR_Nuclear_Shielding = "optB86b-vdW+U NMR Nuclear Shielding"
    optB86b_vdW_U_NSCF_Line = "optB86b-vdW+U NSCF Line"
    optB86b_vdW_U_NSCF_Uniform = "optB86b-vdW+U NSCF Uniform"
    optB86b_vdW_U_Optic = "optB86b-vdW+U Optic"
    optB86b_vdW_U_Static = "optB86b-vdW+U Static"
    optB86b_vdW_U_Structure_Optimization = "optB86b-vdW+U Structure Optimization"
    optB86b_vdW_U_Unrecognized = "optB86b-vdW+U Unrecognized"
    optB86b_vdW_Unrecognized = "optB86b-vdW Unrecognized"
    optB88_DFPT = "optB88 DFPT"
    optB88_DFPT_Dielectric = "optB88 DFPT Dielectric"
    optB88_Deformation = "optB88 Deformation"
    optB88_Dielectric = "optB88 Dielectric"
    optB88_Molecular_Dynamics = "optB88 Molecular Dynamics"
    optB88_NMR_Electric_Field_Gradient = "optB88 NMR Electric Field Gradient"
    optB88_NMR_Nuclear_Shielding = "optB88 NMR Nuclear Shielding"
    optB88_NSCF_Line = "optB88 NSCF Line"
    optB88_NSCF_Uniform = "optB88 NSCF Uniform"
    optB88_Optic = "optB88 Optic"
    optB88_Static = "optB88 Static"
    optB88_Structure_Optimization = "optB88 Structure Optimization"
    optB88_U_DFPT = "optB88+U DFPT"
    optB88_U_DFPT_Dielectric = "optB88+U DFPT Dielectric"
    optB88_U_Deformation = "optB88+U Deformation"
    optB88_U_Dielectric = "optB88+U Dielectric"
    optB88_U_Molecular_Dynamics = "optB88+U Molecular Dynamics"
    optB88_U_NMR_Electric_Field_Gradient = "optB88+U NMR Electric Field Gradient"
    optB88_U_NMR_Nuclear_Shielding = "optB88+U NMR Nuclear Shielding"
    optB88_U_NSCF_Line = "optB88+U NSCF Line"
    optB88_U_NSCF_Uniform = "optB88+U NSCF Uniform"
    optB88_U_Optic = "optB88+U Optic"
    optB88_U_Static = "optB88+U Static"
    optB88_U_Structure_Optimization = "optB88+U Structure Optimization"
    optB88_U_Unrecognized = "optB88+U Unrecognized"
    optB88_Unrecognized = "optB88 Unrecognized"
    optB88_vdW_DFPT = "optB88-vdW DFPT"
    optB88_vdW_DFPT_Dielectric = "optB88-vdW DFPT Dielectric"
    optB88_vdW_Deformation = "optB88-vdW Deformation"
    optB88_vdW_Dielectric = "optB88-vdW Dielectric"
    optB88_vdW_Molecular_Dynamics = "optB88-vdW Molecular Dynamics"
    optB88_vdW_NMR_Electric_Field_Gradient = "optB88-vdW NMR Electric Field Gradient"
    optB88_vdW_NMR_Nuclear_Shielding = "optB88-vdW NMR Nuclear Shielding"
    optB88_vdW_NSCF_Line = "optB88-vdW NSCF Line"
    optB88_vdW_NSCF_Uniform = "optB88-vdW NSCF Uniform"
    optB88_vdW_Optic = "optB88-vdW Optic"
    optB88_vdW_Static = "optB88-vdW Static"
    optB88_vdW_Structure_Optimization = "optB88-vdW Structure Optimization"
    optB88_vdW_U_DFPT = "optB88-vdW+U DFPT"
    optB88_vdW_U_DFPT_Dielectric = "optB88-vdW+U DFPT Dielectric"
    optB88_vdW_U_Deformation = "optB88-vdW+U Deformation"
    optB88_vdW_U_Dielectric = "optB88-vdW+U Dielectric"
    optB88_vdW_U_Molecular_Dynamics = "optB88-vdW+U Molecular Dynamics"
    optB88_vdW_U_NMR_Electric_Field_Gradient = (
        "optB88-vdW+U NMR Electric Field Gradient"
    )
    optB88_vdW_U_NMR_Nuclear_Shielding = "optB88-vdW+U NMR Nuclear Shielding"
    optB88_vdW_U_NSCF_Line = "optB88-vdW+U NSCF Line"
    optB88_vdW_U_NSCF_Uniform = "optB88-vdW+U NSCF Uniform"
    optB88_vdW_U_Optic = "optB88-vdW+U Optic"
    optB88_vdW_U_Static = "optB88-vdW+U Static"
    optB88_vdW_U_Structure_Optimization = "optB88-vdW+U Structure Optimization"
    optB88_vdW_U_Unrecognized = "optB88-vdW+U Unrecognized"
    optB88_vdW_Unrecognized = "optB88-vdW Unrecognized"
    optPBE_DFPT = "optPBE DFPT"
    optPBE_DFPT_Dielectric = "optPBE DFPT Dielectric"
    optPBE_Deformation = "optPBE Deformation"
    optPBE_Dielectric = "optPBE Dielectric"
    optPBE_Molecular_Dynamics = "optPBE Molecular Dynamics"
    optPBE_NMR_Electric_Field_Gradient = "optPBE NMR Electric Field Gradient"
    optPBE_NMR_Nuclear_Shielding = "optPBE NMR Nuclear Shielding"
    optPBE_NSCF_Line = "optPBE NSCF Line"
    optPBE_NSCF_Uniform = "optPBE NSCF Uniform"
    optPBE_Optic = "optPBE Optic"
    optPBE_Static = "optPBE Static"
    optPBE_Structure_Optimization = "optPBE Structure Optimization"
    optPBE_U_DFPT = "optPBE+U DFPT"
    optPBE_U_DFPT_Dielectric = "optPBE+U DFPT Dielectric"
    optPBE_U_Deformation = "optPBE+U Deformation"
    optPBE_U_Dielectric = "optPBE+U Dielectric"
    optPBE_U_Molecular_Dynamics = "optPBE+U Molecular Dynamics"
    optPBE_U_NMR_Electric_Field_Gradient = "optPBE+U NMR Electric Field Gradient"
    optPBE_U_NMR_Nuclear_Shielding = "optPBE+U NMR Nuclear Shielding"
    optPBE_U_NSCF_Line = "optPBE+U NSCF Line"
    optPBE_U_NSCF_Uniform = "optPBE+U NSCF Uniform"
    optPBE_U_Optic = "optPBE+U Optic"
    optPBE_U_Static = "optPBE+U Static"
    optPBE_U_Structure_Optimization = "optPBE+U Structure Optimization"
    optPBE_U_Unrecognized = "optPBE+U Unrecognized"
    optPBE_Unrecognized = "optPBE Unrecognized"
    optPBE_vdW_DFPT = "optPBE-vdW DFPT"
    optPBE_vdW_DFPT_Dielectric = "optPBE-vdW DFPT Dielectric"
    optPBE_vdW_Deformation = "optPBE-vdW Deformation"
    optPBE_vdW_Dielectric = "optPBE-vdW Dielectric"
    optPBE_vdW_Molecular_Dynamics = "optPBE-vdW Molecular Dynamics"
    optPBE_vdW_NMR_Electric_Field_Gradient = "optPBE-vdW NMR Electric Field Gradient"
    optPBE_vdW_NMR_Nuclear_Shielding = "optPBE-vdW NMR Nuclear Shielding"
    optPBE_vdW_NSCF_Line = "optPBE-vdW NSCF Line"
    optPBE_vdW_NSCF_Uniform = "optPBE-vdW NSCF Uniform"
    optPBE_vdW_Optic = "optPBE-vdW Optic"
    optPBE_vdW_Static = "optPBE-vdW Static"
    optPBE_vdW_Structure_Optimization = "optPBE-vdW Structure Optimization"
    optPBE_vdW_U_DFPT = "optPBE-vdW+U DFPT"
    optPBE_vdW_U_DFPT_Dielectric = "optPBE-vdW+U DFPT Dielectric"
    optPBE_vdW_U_Deformation = "optPBE-vdW+U Deformation"
    optPBE_vdW_U_Dielectric = "optPBE-vdW+U Dielectric"
    optPBE_vdW_U_Molecular_Dynamics = "optPBE-vdW+U Molecular Dynamics"
    optPBE_vdW_U_NMR_Electric_Field_Gradient = (
        "optPBE-vdW+U NMR Electric Field Gradient"
    )
    optPBE_vdW_U_NMR_Nuclear_Shielding = "optPBE-vdW+U NMR Nuclear Shielding"
    optPBE_vdW_U_NSCF_Line = "optPBE-vdW+U NSCF Line"
    optPBE_vdW_U_NSCF_Uniform = "optPBE-vdW+U NSCF Uniform"
    optPBE_vdW_U_Optic = "optPBE-vdW+U Optic"
    optPBE_vdW_U_Static = "optPBE-vdW+U Static"
    optPBE_vdW_U_Structure_Optimization = "optPBE-vdW+U Structure Optimization"
    optPBE_vdW_U_Unrecognized = "optPBE-vdW+U Unrecognized"
    optPBE_vdW_Unrecognized = "optPBE-vdW Unrecognized"
    r2SCAN_DFPT = "r2SCAN DFPT"
    r2SCAN_DFPT_Dielectric = "r2SCAN DFPT Dielectric"
    r2SCAN_Deformation = "r2SCAN Deformation"
    r2SCAN_Dielectric = "r2SCAN Dielectric"
    r2SCAN_Molecular_Dynamics = "r2SCAN Molecular Dynamics"
    r2SCAN_NMR_Electric_Field_Gradient = "r2SCAN NMR Electric Field Gradient"
    r2SCAN_NMR_Nuclear_Shielding = "r2SCAN NMR Nuclear Shielding"
    r2SCAN_NSCF_Line = "r2SCAN NSCF Line"
    r2SCAN_NSCF_Uniform = "r2SCAN NSCF Uniform"
    r2SCAN_Optic = "r2SCAN Optic"
    r2SCAN_Static = "r2SCAN Static"
    r2SCAN_Structure_Optimization = "r2SCAN Structure Optimization"
    r2SCAN_U_DFPT = "r2SCAN+U DFPT"
    r2SCAN_U_DFPT_Dielectric = "r2SCAN+U DFPT Dielectric"
    r2SCAN_U_Deformation = "r2SCAN+U Deformation"
    r2SCAN_U_Dielectric = "r2SCAN+U Dielectric"
    r2SCAN_U_Molecular_Dynamics = "r2SCAN+U Molecular Dynamics"
    r2SCAN_U_NMR_Electric_Field_Gradient = "r2SCAN+U NMR Electric Field Gradient"
    r2SCAN_U_NMR_Nuclear_Shielding = "r2SCAN+U NMR Nuclear Shielding"
    r2SCAN_U_NSCF_Line = "r2SCAN+U NSCF Line"
    r2SCAN_U_NSCF_Uniform = "r2SCAN+U NSCF Uniform"
    r2SCAN_U_Optic = "r2SCAN+U Optic"
    r2SCAN_U_Static = "r2SCAN+U Static"
    r2SCAN_U_Structure_Optimization = "r2SCAN+U Structure Optimization"
    r2SCAN_U_Unrecognized = "r2SCAN+U Unrecognized"
    r2SCAN_Unrecognized = "r2SCAN Unrecognized"
    r2SCAN_rVV10_DFPT = "r2SCAN-rVV10 DFPT"
    r2SCAN_rVV10_DFPT_Dielectric = "r2SCAN-rVV10 DFPT Dielectric"
    r2SCAN_rVV10_Deformation = "r2SCAN-rVV10 Deformation"
    r2SCAN_rVV10_Dielectric = "r2SCAN-rVV10 Dielectric"
    r2SCAN_rVV10_Molecular_Dynamics = "r2SCAN-rVV10 Molecular Dynamics"
    r2SCAN_rVV10_NMR_Electric_Field_Gradient = (
        "r2SCAN-rVV10 NMR Electric Field Gradient"
    )
    r2SCAN_rVV10_NMR_Nuclear_Shielding = "r2SCAN-rVV10 NMR Nuclear Shielding"
    r2SCAN_rVV10_NSCF_Line = "r2SCAN-rVV10 NSCF Line"
    r2SCAN_rVV10_NSCF_Uniform = "r2SCAN-rVV10 NSCF Uniform"
    r2SCAN_rVV10_Optic = "r2SCAN-rVV10 Optic"
    r2SCAN_rVV10_Static = "r2SCAN-rVV10 Static"
    r2SCAN_rVV10_Structure_Optimization = "r2SCAN-rVV10 Structure Optimization"
    r2SCAN_rVV10_U_DFPT = "r2SCAN-rVV10+U DFPT"
    r2SCAN_rVV10_U_DFPT_Dielectric = "r2SCAN-rVV10+U DFPT Dielectric"
    r2SCAN_rVV10_U_Deformation = "r2SCAN-rVV10+U Deformation"
    r2SCAN_rVV10_U_Dielectric = "r2SCAN-rVV10+U Dielectric"
    r2SCAN_rVV10_U_Molecular_Dynamics = "r2SCAN-rVV10+U Molecular Dynamics"
    r2SCAN_rVV10_U_NMR_Electric_Field_Gradient = (
        "r2SCAN-rVV10+U NMR Electric Field Gradient"
    )
    r2SCAN_rVV10_U_NMR_Nuclear_Shielding = "r2SCAN-rVV10+U NMR Nuclear Shielding"
    r2SCAN_rVV10_U_NSCF_Line = "r2SCAN-rVV10+U NSCF Line"
    r2SCAN_rVV10_U_NSCF_Uniform = "r2SCAN-rVV10+U NSCF Uniform"
    r2SCAN_rVV10_U_Optic = "r2SCAN-rVV10+U Optic"
    r2SCAN_rVV10_U_Static = "r2SCAN-rVV10+U Static"
    r2SCAN_rVV10_U_Structure_Optimization = "r2SCAN-rVV10+U Structure Optimization"
    r2SCAN_rVV10_U_Unrecognized = "r2SCAN-rVV10+U Unrecognized"
    r2SCAN_rVV10_Unrecognized = "r2SCAN-rVV10 Unrecognized"
    revPBE_DFPT = "revPBE DFPT"
    revPBE_DFPT_Dielectric = "revPBE DFPT Dielectric"
    revPBE_Deformation = "revPBE Deformation"
    revPBE_Dielectric = "revPBE Dielectric"
    revPBE_Molecular_Dynamics = "revPBE Molecular Dynamics"
    revPBE_NMR_Electric_Field_Gradient = "revPBE NMR Electric Field Gradient"
    revPBE_NMR_Nuclear_Shielding = "revPBE NMR Nuclear Shielding"
    revPBE_NSCF_Line = "revPBE NSCF Line"
    revPBE_NSCF_Uniform = "revPBE NSCF Uniform"
    revPBE_Optic = "revPBE Optic"
    revPBE_PADE_DFPT = "revPBE+PADE DFPT"
    revPBE_PADE_DFPT_Dielectric = "revPBE+PADE DFPT Dielectric"
    revPBE_PADE_Deformation = "revPBE+PADE Deformation"
    revPBE_PADE_Dielectric = "revPBE+PADE Dielectric"
    revPBE_PADE_Molecular_Dynamics = "revPBE+PADE Molecular Dynamics"
    revPBE_PADE_NMR_Electric_Field_Gradient = "revPBE+PADE NMR Electric Field Gradient"
    revPBE_PADE_NMR_Nuclear_Shielding = "revPBE+PADE NMR Nuclear Shielding"
    revPBE_PADE_NSCF_Line = "revPBE+PADE NSCF Line"
    revPBE_PADE_NSCF_Uniform = "revPBE+PADE NSCF Uniform"
    revPBE_PADE_Optic = "revPBE+PADE Optic"
    revPBE_PADE_Static = "revPBE+PADE Static"
    revPBE_PADE_Structure_Optimization = "revPBE+PADE Structure Optimization"
    revPBE_PADE_U_DFPT = "revPBE+PADE+U DFPT"
    revPBE_PADE_U_DFPT_Dielectric = "revPBE+PADE+U DFPT Dielectric"
    revPBE_PADE_U_Deformation = "revPBE+PADE+U Deformation"
    revPBE_PADE_U_Dielectric = "revPBE+PADE+U Dielectric"
    revPBE_PADE_U_Molecular_Dynamics = "revPBE+PADE+U Molecular Dynamics"
    revPBE_PADE_U_NMR_Electric_Field_Gradient = (
        "revPBE+PADE+U NMR Electric Field Gradient"
    )
    revPBE_PADE_U_NMR_Nuclear_Shielding = "revPBE+PADE+U NMR Nuclear Shielding"
    revPBE_PADE_U_NSCF_Line = "revPBE+PADE+U NSCF Line"
    revPBE_PADE_U_NSCF_Uniform = "revPBE+PADE+U NSCF Uniform"
    revPBE_PADE_U_Optic = "revPBE+PADE+U Optic"
    revPBE_PADE_U_Static = "revPBE+PADE+U Static"
    revPBE_PADE_U_Structure_Optimization = "revPBE+PADE+U Structure Optimization"
    revPBE_PADE_U_Unrecognized = "revPBE+PADE+U Unrecognized"
    revPBE_PADE_Unrecognized = "revPBE+PADE Unrecognized"
    revPBE_Static = "revPBE Static"
    revPBE_Structure_Optimization = "revPBE Structure Optimization"
    revPBE_U_DFPT = "revPBE+U DFPT"
    revPBE_U_DFPT_Dielectric = "revPBE+U DFPT Dielectric"
    revPBE_U_Deformation = "revPBE+U Deformation"
    revPBE_U_Dielectric = "revPBE+U Dielectric"
    revPBE_U_Molecular_Dynamics = "revPBE+U Molecular Dynamics"
    revPBE_U_NMR_Electric_Field_Gradient = "revPBE+U NMR Electric Field Gradient"
    revPBE_U_NMR_Nuclear_Shielding = "revPBE+U NMR Nuclear Shielding"
    revPBE_U_NSCF_Line = "revPBE+U NSCF Line"
    revPBE_U_NSCF_Uniform = "revPBE+U NSCF Uniform"
    revPBE_U_Optic = "revPBE+U Optic"
    revPBE_U_Static = "revPBE+U Static"
    revPBE_U_Structure_Optimization = "revPBE+U Structure Optimization"
    revPBE_U_Unrecognized = "revPBE+U Unrecognized"
    revPBE_Unrecognized = "revPBE Unrecognized"
    revPBE_vdW_DFPT = "revPBE-vdW DFPT"
    revPBE_vdW_DFPT_Dielectric = "revPBE-vdW DFPT Dielectric"
    revPBE_vdW_Deformation = "revPBE-vdW Deformation"
    revPBE_vdW_Dielectric = "revPBE-vdW Dielectric"
    revPBE_vdW_Molecular_Dynamics = "revPBE-vdW Molecular Dynamics"
    revPBE_vdW_NMR_Electric_Field_Gradient = "revPBE-vdW NMR Electric Field Gradient"
    revPBE_vdW_NMR_Nuclear_Shielding = "revPBE-vdW NMR Nuclear Shielding"
    revPBE_vdW_NSCF_Line = "revPBE-vdW NSCF Line"
    revPBE_vdW_NSCF_Uniform = "revPBE-vdW NSCF Uniform"
    revPBE_vdW_Optic = "revPBE-vdW Optic"
    revPBE_vdW_Static = "revPBE-vdW Static"
    revPBE_vdW_Structure_Optimization = "revPBE-vdW Structure Optimization"
    revPBE_vdW_U_DFPT = "revPBE-vdW+U DFPT"
    revPBE_vdW_U_DFPT_Dielectric = "revPBE-vdW+U DFPT Dielectric"
    revPBE_vdW_U_Deformation = "revPBE-vdW+U Deformation"
    revPBE_vdW_U_Dielectric = "revPBE-vdW+U Dielectric"
    revPBE_vdW_U_Molecular_Dynamics = "revPBE-vdW+U Molecular Dynamics"
    revPBE_vdW_U_NMR_Electric_Field_Gradient = (
        "revPBE-vdW+U NMR Electric Field Gradient"
    )
    revPBE_vdW_U_NMR_Nuclear_Shielding = "revPBE-vdW+U NMR Nuclear Shielding"
    revPBE_vdW_U_NSCF_Line = "revPBE-vdW+U NSCF Line"
    revPBE_vdW_U_NSCF_Uniform = "revPBE-vdW+U NSCF Uniform"
    revPBE_vdW_U_Optic = "revPBE-vdW+U Optic"
    revPBE_vdW_U_Static = "revPBE-vdW+U Static"
    revPBE_vdW_U_Structure_Optimization = "revPBE-vdW+U Structure Optimization"
    revPBE_vdW_U_Unrecognized = "revPBE-vdW+U Unrecognized"
    revPBE_vdW_Unrecognized = "revPBE-vdW Unrecognized"
    rev_vdW_DF2_DFPT = "rev-vdW-DF2 DFPT"
    rev_vdW_DF2_DFPT_Dielectric = "rev-vdW-DF2 DFPT Dielectric"
    rev_vdW_DF2_Deformation = "rev-vdW-DF2 Deformation"
    rev_vdW_DF2_Dielectric = "rev-vdW-DF2 Dielectric"
    rev_vdW_DF2_Molecular_Dynamics = "rev-vdW-DF2 Molecular Dynamics"
    rev_vdW_DF2_NMR_Electric_Field_Gradient = "rev-vdW-DF2 NMR Electric Field Gradient"
    rev_vdW_DF2_NMR_Nuclear_Shielding = "rev-vdW-DF2 NMR Nuclear Shielding"
    rev_vdW_DF2_NSCF_Line = "rev-vdW-DF2 NSCF Line"
    rev_vdW_DF2_NSCF_Uniform = "rev-vdW-DF2 NSCF Uniform"
    rev_vdW_DF2_Optic = "rev-vdW-DF2 Optic"
    rev_vdW_DF2_Static = "rev-vdW-DF2 Static"
    rev_vdW_DF2_Structure_Optimization = "rev-vdW-DF2 Structure Optimization"
    rev_vdW_DF2_U_DFPT = "rev-vdW-DF2+U DFPT"
    rev_vdW_DF2_U_DFPT_Dielectric = "rev-vdW-DF2+U DFPT Dielectric"
    rev_vdW_DF2_U_Deformation = "rev-vdW-DF2+U Deformation"
    rev_vdW_DF2_U_Dielectric = "rev-vdW-DF2+U Dielectric"
    rev_vdW_DF2_U_Molecular_Dynamics = "rev-vdW-DF2+U Molecular Dynamics"
    rev_vdW_DF2_U_NMR_Electric_Field_Gradient = (
        "rev-vdW-DF2+U NMR Electric Field Gradient"
    )
    rev_vdW_DF2_U_NMR_Nuclear_Shielding = "rev-vdW-DF2+U NMR Nuclear Shielding"
    rev_vdW_DF2_U_NSCF_Line = "rev-vdW-DF2+U NSCF Line"
    rev_vdW_DF2_U_NSCF_Uniform = "rev-vdW-DF2+U NSCF Uniform"
    rev_vdW_DF2_U_Optic = "rev-vdW-DF2+U Optic"
    rev_vdW_DF2_U_Static = "rev-vdW-DF2+U Static"
    rev_vdW_DF2_U_Structure_Optimization = "rev-vdW-DF2+U Structure Optimization"
    rev_vdW_DF2_U_Unrecognized = "rev-vdW-DF2+U Unrecognized"
    rev_vdW_DF2_Unrecognized = "rev-vdW-DF2 Unrecognized"
    vdW_DF2_DFPT = "vdW-DF2 DFPT"
    vdW_DF2_DFPT_Dielectric = "vdW-DF2 DFPT Dielectric"
    vdW_DF2_Deformation = "vdW-DF2 Deformation"
    vdW_DF2_Dielectric = "vdW-DF2 Dielectric"
    vdW_DF2_Molecular_Dynamics = "vdW-DF2 Molecular Dynamics"
    vdW_DF2_NMR_Electric_Field_Gradient = "vdW-DF2 NMR Electric Field Gradient"
    vdW_DF2_NMR_Nuclear_Shielding = "vdW-DF2 NMR Nuclear Shielding"
    vdW_DF2_NSCF_Line = "vdW-DF2 NSCF Line"
    vdW_DF2_NSCF_Uniform = "vdW-DF2 NSCF Uniform"
    vdW_DF2_Optic = "vdW-DF2 Optic"
    vdW_DF2_Static = "vdW-DF2 Static"
    vdW_DF2_Structure_Optimization = "vdW-DF2 Structure Optimization"
    vdW_DF2_U_DFPT = "vdW-DF2+U DFPT"
    vdW_DF2_U_DFPT_Dielectric = "vdW-DF2+U DFPT Dielectric"
    vdW_DF2_U_Deformation = "vdW-DF2+U Deformation"
    vdW_DF2_U_Dielectric = "vdW-DF2+U Dielectric"
    vdW_DF2_U_Molecular_Dynamics = "vdW-DF2+U Molecular Dynamics"
    vdW_DF2_U_NMR_Electric_Field_Gradient = "vdW-DF2+U NMR Electric Field Gradient"
    vdW_DF2_U_NMR_Nuclear_Shielding = "vdW-DF2+U NMR Nuclear Shielding"
    vdW_DF2_U_NSCF_Line = "vdW-DF2+U NSCF Line"
    vdW_DF2_U_NSCF_Uniform = "vdW-DF2+U NSCF Uniform"
    vdW_DF2_U_Optic = "vdW-DF2+U Optic"
    vdW_DF2_U_Static = "vdW-DF2+U Static"
    vdW_DF2_U_Structure_Optimization = "vdW-DF2+U Structure Optimization"
    vdW_DF2_U_Unrecognized = "vdW-DF2+U Unrecognized"
    vdW_DF2_Unrecognized = "vdW-DF2 Unrecognized"
