/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.internal.html.page;

import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.core.analysis.ISourceFileCoverage;
import build.please.vendored.org.jacoco.report.ISourceFileLocator;
import build.please.vendored.org.jacoco.report.internal.ReportOutputFolder;
import build.please.vendored.org.jacoco.report.internal.html.HTMLElement;
import build.please.vendored.org.jacoco.report.internal.html.IHTMLReportContext;
import build.please.vendored.org.jacoco.report.internal.html.ILinkable;
import build.please.vendored.org.jacoco.report.internal.html.page.ReportPage;
import build.please.vendored.org.jacoco.report.internal.html.page.SourceFileItem;
import build.please.vendored.org.jacoco.report.internal.html.page.SourceFilePage;
import build.please.vendored.org.jacoco.report.internal.html.page.TablePage;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageSourcePage
extends TablePage<IPackageCoverage> {
    private final ISourceFileLocator locator;
    private final Map<String, ILinkable> sourceFilePages;
    private final ILinkable packagePage;

    public PackageSourcePage(IPackageCoverage node, ReportPage parent, ISourceFileLocator locator, ReportOutputFolder folder, IHTMLReportContext context, ILinkable packagePage) {
        super(node, parent, folder, context);
        this.locator = locator;
        this.packagePage = packagePage;
        this.sourceFilePages = new HashMap<String, ILinkable>();
    }

    @Override
    public void render() throws IOException {
        this.renderSourceFilePages();
        super.render();
    }

    ILinkable getSourceFilePage(String name) {
        return this.sourceFilePages.get(name);
    }

    private final void renderSourceFilePages() throws IOException {
        String packagename = ((IPackageCoverage)this.getNode()).getName();
        for (ISourceFileCoverage s : ((IPackageCoverage)this.getNode()).getSourceFiles()) {
            if (!s.containsCode()) continue;
            String sourcename = s.getName();
            Reader reader = this.locator.getSourceFile(packagename, sourcename);
            if (reader == null) {
                this.addItem(new SourceFileItem(s));
                continue;
            }
            SourceFilePage sourcePage = new SourceFilePage(s, reader, this.locator.getTabWidth(), this, this.folder, this.context);
            sourcePage.render();
            this.sourceFilePages.put(sourcename, sourcePage);
            this.addItem(sourcePage);
        }
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    @Override
    protected String getFileName() {
        return "index.source.html";
    }

    @Override
    public String getLinkLabel() {
        return this.context.getLanguageNames().getPackageName(((IPackageCoverage)this.getNode()).getName());
    }

    @Override
    protected void infoLinks(HTMLElement span) throws IOException {
        String link = this.packagePage.getLink(this.folder);
        span.a(link, "el_class").text("Classes");
        super.infoLinks(span);
    }
}

