/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.internal.html.page;

import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.report.ISourceFileLocator;
import build.please.vendored.org.jacoco.report.internal.ReportOutputFolder;
import build.please.vendored.org.jacoco.report.internal.html.HTMLElement;
import build.please.vendored.org.jacoco.report.internal.html.IHTMLReportContext;
import build.please.vendored.org.jacoco.report.internal.html.ILinkable;
import build.please.vendored.org.jacoco.report.internal.html.page.ClassPage;
import build.please.vendored.org.jacoco.report.internal.html.page.PackageSourcePage;
import build.please.vendored.org.jacoco.report.internal.html.page.ReportPage;
import build.please.vendored.org.jacoco.report.internal.html.page.TablePage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagePage
extends TablePage<IPackageCoverage> {
    private final PackageSourcePage packageSourcePage;
    private final boolean sourceCoverageExists;

    public PackagePage(IPackageCoverage node, ReportPage parent, ISourceFileLocator locator, ReportOutputFolder folder, IHTMLReportContext context) {
        super(node, parent, folder, context);
        this.packageSourcePage = new PackageSourcePage(node, parent, locator, folder, context, this);
        this.sourceCoverageExists = !node.getSourceFiles().isEmpty();
    }

    @Override
    public void render() throws IOException {
        if (this.sourceCoverageExists) {
            this.packageSourcePage.render();
        }
        this.renderClasses();
        super.render();
    }

    private void renderClasses() throws IOException {
        for (IClassCoverage c : ((IPackageCoverage)this.getNode()).getClasses()) {
            if (!c.containsCode()) continue;
            ILinkable sourceFilePage = this.packageSourcePage.getSourceFilePage(c.getSourceFileName());
            ClassPage page = new ClassPage(c, this, sourceFilePage, this.folder, this.context);
            page.render();
            this.addItem(page);
        }
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    @Override
    protected String getFileName() {
        return "index.html";
    }

    @Override
    public String getLinkLabel() {
        return this.context.getLanguageNames().getPackageName(((IPackageCoverage)this.getNode()).getName());
    }

    @Override
    protected void infoLinks(HTMLElement span) throws IOException {
        if (this.sourceCoverageExists) {
            String link = this.packageSourcePage.getLink(this.folder);
            span.a(link, "el_source").text("Source Files");
        }
        super.infoLinks(span);
    }
}

