/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.csv;

import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.report.IReportGroupVisitor;
import build.please.vendored.org.jacoco.report.ISourceFileLocator;
import build.please.vendored.org.jacoco.report.csv.ClassRowWriter;
import java.io.IOException;

class CSVGroupHandler
implements IReportGroupVisitor {
    private final ClassRowWriter writer;
    private final String groupName;

    public CSVGroupHandler(ClassRowWriter writer) {
        this(writer, null);
    }

    private CSVGroupHandler(ClassRowWriter writer, String groupName) {
        this.writer = writer;
        this.groupName = groupName;
    }

    public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
        String name = this.appendName(bundle.getName());
        for (IPackageCoverage p : bundle.getPackages()) {
            String packageName = p.getName();
            for (IClassCoverage c : p.getClasses()) {
                if (!c.containsCode()) continue;
                this.writer.writeRow(name, packageName, c);
            }
        }
    }

    public IReportGroupVisitor visitGroup(String name) throws IOException {
        return new CSVGroupHandler(this.writer, this.appendName(name));
    }

    private String appendName(String name) {
        return this.groupName == null ? name : this.groupName + "/" + name;
    }
}

