/*
 * Decompiled with CFR 0.152.
 */
package build.please.test.runner;

import build.please.test.result.ErrorCaseResult;
import build.please.test.result.FailureCaseResult;
import build.please.test.result.SkippedCaseResult;
import build.please.test.result.SuccessCaseResult;
import build.please.test.result.TestCaseResult;
import build.please.test.result.TestSuiteResult;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class TestListener
extends RunListener {
    private TestSuiteResult result;
    private Long currentTestStart;
    private TestCaseResult currentState = null;
    private PrintStream originalOut;
    private PrintStream originalErr;
    private PrintStream stdOutStream;
    private PrintStream stdErrStream;
    private ByteArrayOutputStream rawStdOutBytes;
    private ByteArrayOutputStream rawStdErrBytes;
    private boolean captureOutput;
    private static final String ENCODING = "UTF-8";

    TestListener(boolean captureOutput) {
        this.captureOutput = captureOutput;
    }

    public TestSuiteResult getResult() {
        return this.result;
    }

    @Override
    public void testRunStarted(Description description) {
        this.result = new TestSuiteResult(description.getClassName());
        this.currentTestStart = null;
        this.currentState = null;
    }

    @Override
    public void testStarted(Description description) throws Exception {
        this.rawStdOutBytes = new ByteArrayOutputStream();
        this.rawStdErrBytes = new ByteArrayOutputStream();
        this.stdOutStream = new PrintStream((OutputStream)this.rawStdOutBytes, true, ENCODING);
        this.stdErrStream = new PrintStream((OutputStream)this.rawStdErrBytes, true, ENCODING);
        if (this.captureOutput) {
            this.originalOut = System.out;
            this.originalErr = System.err;
            System.setOut(this.stdOutStream);
            System.setErr(this.stdErrStream);
        }
        this.currentTestStart = System.nanoTime();
    }

    @Override
    public void testFinished(Description description) throws Exception {
        String stdErr;
        long duration = System.nanoTime() - this.currentTestStart;
        if (this.captureOutput) {
            System.setOut(this.originalOut);
            System.setErr(this.originalErr);
        }
        this.stdOutStream.flush();
        this.stdErrStream.flush();
        String stdOut = this.rawStdOutBytes.size() == 0 ? null : this.rawStdOutBytes.toString(ENCODING);
        String string = stdErr = this.rawStdErrBytes.size() == 0 ? null : this.rawStdErrBytes.toString(ENCODING);
        if (this.currentState == null) {
            this.currentState = SuccessCaseResult.fromDescription(description);
        }
        this.currentState.setDuration(TimeUnit.NANOSECONDS.toMillis(duration));
        this.currentState.setStdOut(stdOut);
        this.currentState.setStdErr(stdErr);
        this.result.caseResults.add(this.currentState);
        this.currentState = null;
    }

    @Override
    public void testRunFinished(Result result) {
        this.result.duration = result.getRunTime();
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
    }

    @Override
    public void testFailure(Failure failure) {
        this.currentState = failure.getException() instanceof AssertionError ? FailureCaseResult.fromFailure(failure) : ErrorCaseResult.fromFailure(failure);
    }

    @Override
    public void testIgnored(Description description) {
        String skippedReason = description.getAnnotation(Ignore.class).value();
        SkippedCaseResult result = new SkippedCaseResult(description.getClassName(), description.getMethodName(), skippedReason);
        result.setDuration(0L);
        result.setStdOut(null);
        result.setStdErr(null);
        this.result.caseResults.add(result);
    }
}

