/*
 * Decompiled with CFR 0.152.
 */
package build.please.test.result;

import build.please.test.result.TestCaseResult;
import org.junit.runner.notification.Failure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ErrorCaseResult
extends TestCaseResult {
    private final String message;
    private final String type;
    private final String stackTrace;

    public ErrorCaseResult(String testClassName, String testMethodName, String message, String type, String stackTrace) {
        super(testClassName, testMethodName);
        this.message = message;
        this.type = type;
        this.stackTrace = stackTrace;
    }

    public static ErrorCaseResult fromFailure(Failure failure) {
        return new ErrorCaseResult(failure.getDescription().getClassName(), failure.getDescription().getMethodName(), failure.getMessage(), failure.getException().getClass().getName(), failure.getTrace());
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public void renderToXml(Document doc, Element testCaseElement) {
        super.renderToXml(doc, testCaseElement);
        Element error = doc.createElement("error");
        if (this.message != null) {
            error.setAttribute("message", this.message);
        }
        error.setAttribute("type", this.type);
        error.setTextContent(this.stackTrace);
        testCaseElement.appendChild(error);
    }

    public String getMessage() {
        return this.message;
    }
}

