/*
 * Decompiled with CFR 0.152.
 */
package build.please.main;

import build.please.common.report.PrettyPrintingXmlWriter;
import build.please.common.source.SourceMap;
import build.please.cover.report.XmlCoverageReporter;
import build.please.cover.result.CoverageRunResult;
import build.please.cover.runner.PleaseCoverageRunner;
import build.please.main.ClassFinder;
import build.please.test.report.XmlTestReporter;
import build.please.test.result.TestSuiteResult;
import build.please.test.runner.PleaseTestRunner;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;

public class TestMain {
    private static final String RESULTS_DIR = "test.results";
    private static final String OUTPUT_FILE = System.getenv("COVERAGE_FILE");
    private static final int SUCCESS_EXIT = 0;
    private static final int FAILURE_EXIT = 1;
    private static final int EXCEPTION_EXIT = 2;

    public static void main(String[] args) throws Exception {
        List<TestSuiteResult> testResults;
        String testPackage;
        Set<String> allClasses;
        String tmpDir = System.getenv("TMP_DIR");
        if (tmpDir != null) {
            System.setProperty("java.io.tmpdir", tmpDir);
        }
        if ((allClasses = TestMain.findClasses(testPackage = System.getProperty("build.please.testpackage"))).isEmpty()) {
            throw new RuntimeException("No test classes found");
        }
        PleaseTestRunner tester = new PleaseTestRunner(System.getProperty("PLZ_NO_OUTPUT_CAPTURE") == null, args);
        XmlTestReporter testReporter = new XmlTestReporter();
        boolean error = false;
        boolean failure = false;
        int numTests = 0;
        if (System.getenv("COVERAGE") == null) {
            testResults = tester.runTests(allClasses);
        } else {
            PleaseCoverageRunner coverage = new PleaseCoverageRunner(tester);
            XmlCoverageReporter coverageReporter = new XmlCoverageReporter();
            coverage.instrument(allClasses);
            String prefix = System.getProperty("build.please.instrumentationPrefix", "");
            if (!prefix.isEmpty()) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                ClassFinder finder = new ClassFinder(loader, prefix);
                coverage.instrument(finder.getClasses());
            }
            CoverageRunResult coverageRunResult = coverage.runTests(allClasses);
            testResults = coverageRunResult.testResults;
            Document coverageDoc = coverageReporter.buildDocument(coverageRunResult.coverageBuilder, coverageRunResult.testClassNames);
            PrettyPrintingXmlWriter.writeXMLDocumentToFile(OUTPUT_FILE, coverageDoc);
        }
        File dir = new File(RESULTS_DIR);
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Failed to create output directory: test.results");
        }
        for (TestSuiteResult result : testResults) {
            Document doc = testReporter.buildDocument(result);
            error |= result.isError();
            failure |= result.isFailure();
            numTests += result.caseResults.size();
            PrettyPrintingXmlWriter.writeXMLDocumentToFile(new File(RESULTS_DIR, "TEST-" + result.getClassName() + ".xml").getPath(), doc);
        }
        if (args.length > 0 && numTests == 0) {
            throw new RuntimeException("No tests were run.");
        }
        if (error) {
            System.exit(2);
        } else if (failure) {
            System.exit(1);
        }
        System.exit(0);
    }

    private static URLClassLoader getClassLoader() throws MalformedURLException {
        String classpath = ManagementFactory.getRuntimeMXBean().getClassPath();
        String[] classpathEntries = classpath.split(":");
        URL[] classpathUrls = new URL[classpathEntries.length];
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpathUrls[i] = new File(classpathEntries[i]).toURI().toURL();
        }
        return new URLClassLoader(classpathUrls);
    }

    private static Set<String> findClasses(String testPackage) throws Exception {
        URLClassLoader loader = TestMain.getClassLoader();
        if (testPackage != null && !testPackage.isEmpty()) {
            return new ClassFinder(loader, testPackage).getClasses();
        }
        ClassFinder finder = new ClassFinder(loader);
        for (String key : SourceMap.readSourceMap().keySet()) {
            finder.loadClass(key.substring(0, key.lastIndexOf(46)) + ".class");
        }
        return finder.getClasses();
    }
}

