/*
 * Decompiled with CFR 0.152.
 */
package build.please.main;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassFinder {
    private final String prefix;
    private final ClassLoader loader;
    private final Set<String> classes = new LinkedHashSet<String>();

    public ClassFinder(ClassLoader loader) throws IOException {
        this.prefix = "";
        this.loader = loader;
    }

    public ClassFinder(ClassLoader loader, String prefix) throws IOException {
        this.prefix = prefix;
        this.loader = loader;
        this.scan(this.getClassPathEntries(loader));
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    private Map<File, ClassLoader> getClassPathEntries(ClassLoader loader) {
        HashMap<File, ClassLoader> entries = new HashMap<File, ClassLoader>();
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            entries.putAll(this.getClassPathEntries(parent));
        }
        if (loader instanceof URLClassLoader) {
            for (URL entry : ((URLClassLoader)loader).getURLs()) {
                if (!entry.getProtocol().equals("file")) continue;
                try {
                    File file = Paths.get(entry.toURI()).toFile();
                    if (entries.containsKey(file)) continue;
                    entries.put(file, loader);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return entries;
    }

    private void scan(Map<File, ClassLoader> loaders) throws IOException {
        for (Map.Entry<File, ClassLoader> entry : loaders.entrySet()) {
            this.scan(entry.getKey(), entry.getValue());
        }
    }

    private void scan(File file, ClassLoader loader) throws IOException {
        try {
            if (!file.exists()) {
                return;
            }
        }
        catch (SecurityException e) {
            System.err.println("Cannot access " + file + ": " + e);
            return;
        }
        if (file.isDirectory()) {
            System.err.println("Directory scanning not supported for " + file);
        } else {
            this.scanJar(file, loader);
        }
    }

    private void scanJar(File file, ClassLoader loader) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
            this.loadClass(loader, entry.getName());
        }
        jarFile.close();
    }

    private void loadClass(ClassLoader loader, String filename) {
        if (!filename.endsWith(".class")) {
            return;
        }
        int classNameEnd = filename.length() - ".class".length();
        String className = filename.substring(0, classNameEnd).replace('/', '.');
        if (className.startsWith(this.prefix)) {
            try {
                this.classes.add(className);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public void loadClass(String filename) {
        this.loadClass(this.loader, filename);
    }
}

