/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.builder;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.playframework.playclipse.PlayPlugin;
import org.playframework.playclipse.builder.RouteChecker;
import org.playframework.playclipse.builder.TemplateChecker;

public class PlayBuilder
extends IncrementalProjectBuilder
implements IPropertyChangeListener {
    public static final String BUILDER_ID = "org.playframework.playclipse.PlayBuilder";
    private static Set<String> observedProperties = new HashSet<String>();

    static {
        observedProperties.add("route_missing_route");
        observedProperties.add("html_missing_action");
    }

    public PlayBuilder() {
        PlayPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.fullBuild(monitor);
        return null;
    }

    void checkRoute(IFile file) {
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        System.out.println("Play full build...");
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        for (String property : observedProperties) {
            if (!event.getProperty().equals(property)) continue;
            try {
                this.fullBuild(null);
            }
            catch (CoreException coreException) {}
            return;
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (!(resource instanceof IFile)) {
                return true;
            }
            IFile file = (IFile)resource;
            if (resource.getName().equals("routes")) {
                PlayBuilder.this.deleteMarkers(file);
                new RouteChecker(file, "route_missing_route").check();
                return false;
            }
            if (TemplateChecker.isTemplate(resource.getFullPath())) {
                PlayBuilder.this.deleteMarkers(file);
                new TemplateChecker(file, "html_missing_action").check();
                return false;
            }
            return true;
        }
    }
}

