/*
 * Decompiled with CFR 0.152.
 */
package fr.zenexity.pdt.editors;

import fr.zenexity.pdt.editors.AutoCloser;
import fr.zenexity.pdt.editors.ColorManager;
import fr.zenexity.pdt.editors.Configuration;
import fr.zenexity.pdt.editors.DocumentProvider;
import fr.zenexity.pdt.editors.EditorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.playframework.playclipse.PlayPlugin;

public abstract class Editor
extends TextEditor
implements VerifyListener,
IPropertyChangeListener {
    ColorManager colorManager = new ColorManager();
    DocumentProvider documentProvider;
    EditorHelper helper;
    private List<Template> templates = new ArrayList<Template>();
    public static String SKIP = "__skip";
    protected boolean useSoftTabs = false;
    protected int softTabsWidth = 4;
    protected String content;
    protected int begin;
    protected int end;
    protected int end2;
    protected int begin2;
    protected int len;
    protected String state = "default";
    boolean eof = false;

    public Editor() {
        this.setSourceViewerConfiguration(new Configuration(this));
        this.documentProvider = new DocumentProvider(this);
        this.setDocumentProvider((IDocumentProvider)this.documentProvider);
        String[] stringArray = this.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            type.intern();
            ++n2;
        }
        PlayPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.colorManager.dispose();
        PlayPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected EditorHelper getHelper() {
        if (this.helper == null) {
            this.helper = new EditorHelper((ITextEditor)this);
        }
        return this.helper;
    }

    protected IPath getPath() {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        return input.getFile().getFullPath();
    }

    public IProject getProject() {
        IFile curfile = ((IFileEditorInput)this.getEditorInput()).getFile();
        IContainer container = curfile.getParent();
        while (container != null) {
            if (container instanceof IProject) {
                return (IProject)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public Template[] getTemplates(String contentType, String ctx) {
        this.templates.clear();
        this.templates(contentType, ctx);
        List<Object> result = new ArrayList();
        for (Template t : this.templates) {
            if (!t.getName().startsWith(ctx) && !ctx.endsWith(t.getName())) continue;
            result.add(t);
        }
        if (result.isEmpty() && ctx.equals("")) {
            result = this.templates;
        }
        return result.toArray(new Template[result.size()]);
    }

    public abstract void templates(String var1, String var2);

    public void template(String name, String description, String pattern) {
        this.templates.add(new Template(name, description, ((Object)((Object)this)).getClass().getName(), pattern, true));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ITextViewerExtension tve = (ITextViewerExtension)this.getSourceViewer();
        tve.appendVerifyKeyListener((VerifyKeyListener)new AutoCloser(this, (SourceViewer)this.getSourceViewer()));
    }

    public abstract String autoClose(char var1, char var2, char var3);

    public abstract IHyperlink detectHyperlink(ITextViewer var1, IRegion var2);

    public abstract void openLink(IHyperlink var1);

    protected BestMatch findBestMatch(final int position, Pattern ... patterns) {
        Object[] line = this.getLine(position);
        int offset = (Integer)line[1];
        String text = (String)line[0];
        ArrayList<Matcher> matches = new ArrayList<Matcher>();
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                matches.add(matcher);
            }
            ++n2;
        }
        ArrayList<BestMatch> bestMatches = new ArrayList<BestMatch>();
        for (Matcher matcher : matches) {
            if (matcher.start() + offset >= position || matcher.end() + offset <= position) continue;
            bestMatches.add(new BestMatch(matcher, offset));
        }
        Collections.sort(bestMatches, new Comparator<BestMatch>(){

            @Override
            public int compare(BestMatch o1, BestMatch o2) {
                return o1.matcher.start(1) - position - (o2.matcher.start(1) - position);
            }
        });
        if (bestMatches.isEmpty()) {
            return null;
        }
        return (BestMatch)bestMatches.get(0);
    }

    protected Object[] getLine(int offset) {
        String text = this.documentProvider.document.get();
        if (offset > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = offset;
        int end = offset;
        while (start > 0 && text.charAt(start) != '\n') {
            --start;
        }
        while (end < text.length() && text.charAt(end) != '\n') {
            ++end;
        }
        return new Object[]{text.substring(start > 0 ? start + 1 : 0, end), start > 0 ? start + 1 : 0};
    }

    public abstract String[] getTypes();

    public abstract String getStylePref(String var1);

    public void propertyChange(PropertyChangeEvent event) {
        String[] stringArray = this.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (event.getProperty().equals(this.getStylePref(type))) {
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer instanceof ISourceViewerExtension2) {
                    ((ISourceViewerExtension2)viewer).unconfigure();
                    viewer.configure(this.getSourceViewerConfiguration());
                }
                return;
            }
            ++n2;
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        viewer.getTextWidget().addVerifyListener((VerifyListener)this);
        return viewer;
    }

    public void verifyText(VerifyEvent evt) {
        if (this.useSoftTabs && evt.text.equals("\t")) {
            String softTab = "";
            int i = 0;
            while (i < this.softTabsWidth) {
                softTab = String.valueOf(softTab) + " ";
                ++i;
            }
            evt.text = softTab;
        }
    }

    protected String found(String newState, int skip) {
        this.begin2 = this.begin;
        this.end2 = --this.end + skip;
        this.begin = this.end += skip;
        String lastState = this.state;
        this.state = newState;
        return lastState;
    }

    protected void reset() {
        this.eof = false;
        this.begin2 = 0;
        this.end2 = 0;
        this.begin = 0;
        this.end = 0;
        this.state = "default";
        this.content = ((DocumentProvider)this.getDocumentProvider()).document.get();
        this.len = this.content.length();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isNext(String s) {
        try {
            int i = this.end - 1;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                char c = cArray[n2];
                if (c != this.content.charAt(i++)) {
                    return false;
                }
                if (i > this.content.length()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    protected boolean nextIsSpace() {
        return this.isNext(" ") || this.isNext("\t");
    }

    public TypedRegion nextToken() {
        String token;
        do {
            int left;
            if ((left = this.len - this.end) == 0) {
                ++this.end;
                this.found("default", 0);
                this.eof = true;
                return new TypedRegion(this.begin2, this.end2 - this.begin2, "default");
            }
            ++this.end;
        } while ((token = this.scan()) == null);
        return new TypedRegion(this.begin2, this.end2 - this.begin2, token);
    }

    public abstract String scan();

    public class BestMatch {
        public Matcher matcher;
        public int offset;

        public BestMatch(Matcher matcher, int offset) {
            this.matcher = matcher;
            this.offset = offset;
        }

        public boolean is(Pattern pattern) {
            return this.matcher.pattern().equals(pattern);
        }

        public String text() {
            return this.matcher.group(1);
        }

        public IHyperlink hyperlink(String type, int startOffset, int endOffset) {
            Region region = new Region(this.offset + this.matcher.start() + startOffset, this.matcher.end() - this.matcher.start() - startOffset + endOffset);
            return new IHyperlink((IRegion)region, type){
                private final /* synthetic */ IRegion val$region;
                private final /* synthetic */ String val$type;
                {
                    this.val$region = iRegion;
                    this.val$type = string;
                }

                public IRegion getHyperlinkRegion() {
                    return this.val$region;
                }

                public String getHyperlinkText() {
                    return BestMatch.this.matcher.group(1);
                }

                public String getTypeLabel() {
                    return this.val$type;
                }

                public void open() {
                    Editor.this.openLink(this);
                }

                public String toString() {
                    return String.valueOf(this.getTypeLabel()) + " --> " + this.getHyperlinkText();
                }
            };
        }
    }
}

