/*
 * Decompiled with CFR 0.152.
 */
package fr.zenexity.pdt.editors;

import fr.zenexity.pdt.editors.Editor;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class DocumentProvider
extends FileDocumentProvider {
    Editor editor;
    IDocument document;

    public DocumentProvider(Editor editor) {
        this.editor = editor;
    }

    public String getDefaultEncoding() {
        return "utf-8";
    }

    protected IDocument createDocument(Object element) throws CoreException {
        this.document = super.createDocument(element);
        if (this.document != null) {
            IDocumentPartitioner partitioner = new IDocumentPartitioner(){

                public ITypedRegion getPartition(int offset) {
                    ITypedRegion[] iTypedRegionArray = this.computePartitioning(offset, 0);
                    int n = iTypedRegionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypedRegion region = iTypedRegionArray[n2];
                        if (region.getOffset() + region.getLength() >= offset) {
                            return region;
                        }
                        ++n2;
                    }
                    return null;
                }

                public String[] getLegalContentTypes() {
                    return DocumentProvider.this.editor.getTypes();
                }

                public String getContentType(int offset) {
                    return this.getPartition(offset).getType();
                }

                public boolean documentChanged(DocumentEvent event) {
                    return true;
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void disconnect() {
                }

                public void connect(IDocument document) {
                    document.addPositionCategory("__dflt_position_category");
                    document.setDocumentPartitioner((IDocumentPartitioner)this);
                }

                public ITypedRegion[] computePartitioning(int offset, int length) {
                    ArrayList<TypedRegion> regions = new ArrayList<TypedRegion>();
                    DocumentProvider.this.editor.reset();
                    while (!DocumentProvider.this.editor.eof) {
                        TypedRegion current = DocumentProvider.this.editor.nextToken();
                        int start = current.getOffset();
                        int stop = current.getOffset() + current.getLength();
                        if (start >= offset && stop <= offset + length) {
                            regions.add(current);
                            continue;
                        }
                        if (start < offset && stop >= offset) {
                            regions.add(new TypedRegion(offset, stop - offset, current.getType()));
                            continue;
                        }
                        if (start > offset || stop <= offset + length) continue;
                        regions.add(new TypedRegion(start, offset + length - start, current.getType()));
                    }
                    return regions.toArray(new ITypedRegion[regions.size()]);
                }
            };
            partitioner.connect(this.document);
        }
        return this.document;
    }
}

