/*
 * Decompiled with CFR 0.152.
 */
package fr.zenexity.pdt.editors;

import fr.zenexity.pdt.editors.CompletionProcessor;
import fr.zenexity.pdt.editors.Editor;
import fr.zenexity.pdt.editors.NonRuleBasedDamagerRepairer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class Configuration
extends SourceViewerConfiguration {
    protected Editor editor;

    public Configuration(Editor editor) {
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.editor.getTypes();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        String[] stringArray = this.editor.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(this.editor.getStylePref(type));
            presentationReconciler.setDamager((IPresentationDamager)ndr, type);
            presentationReconciler.setRepairer((IPresentationRepairer)ndr, type);
            ++n2;
        }
        return presentationReconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] parent = super.getHyperlinkDetectors(sourceViewer);
        IHyperlinkDetector mine = new IHyperlinkDetector(){

            public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                IHyperlink link = Configuration.this.editor.detectHyperlink(textViewer, region);
                if (link == null) {
                    return new IHyperlink[0];
                }
                return new IHyperlink[]{link};
            }
        };
        IHyperlinkDetector[] result = new IHyperlinkDetector[parent.length + 1];
        System.arraycopy(parent, 0, result, 0, parent.length);
        result[result.length - 1] = mine;
        return result;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        String[] stringArray = this.editor.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            CompletionProcessor processor = new CompletionProcessor(type, sourceViewer, this.editor);
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, type);
            ++n2;
        }
        return assistant;
    }
}

