/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.editors.route;

import fr.zenexity.pdt.editors.Editor;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.playframework.playclipse.ModelInspector;
import org.playframework.playclipse.PlayPlugin;
import org.playframework.playclipse.editors.PlayEditor;
import org.playframework.playclipse.editors.route.RouteConfiguration;

public class RouteEditor
extends PlayEditor {
    public static final String KEYWORD_COLOR = "route_keyword_color";
    public static final String URL_COLOR = "route_url_color";
    public static final String COMMENT_COLOR = "route_comment_color";
    public static final String ACTION_COLOR = "route_action_color";
    public static final String DEFAULT_COLOR = "route_default_color";
    public static final String MISSING_ROUTE = "route_missing_route";
    public static final String SOFT_TABS = "route_soft_tabs";
    public static final String SOFT_TABS_WIDTH = "route_soft_tabs_width";
    String oldState = "default";
    IJavaProject javaProject;
    ModelInspector inspector;
    Pattern action = Pattern.compile("\\s(\\w[\\.\\w]+)");

    public RouteEditor() {
        this.setSourceViewerConfiguration(new RouteConfiguration(this));
        IPreferenceStore store = PlayPlugin.getDefault().getPreferenceStore();
        this.useSoftTabs = store.getBoolean(SOFT_TABS);
        this.softTabsWidth = store.getInt(SOFT_TABS_WIDTH);
    }

    @Override
    public String[] getTypes() {
        return new String[]{"default", "keyword", "url", "action", "comment"};
    }

    @Override
    public String autoClose(char pc, char c, char nc) {
        return null;
    }

    @Override
    public IHyperlink detectHyperlink(ITextViewer textViewer, IRegion region) {
        Editor.BestMatch match = this.findBestMatch(region.getOffset(), this.action);
        if (match != null && match.is(this.action)) {
            return match.hyperlink("action", 1, 0);
        }
        return null;
    }

    @Override
    public String getStylePref(String type) {
        if (type.equals("keyword")) {
            return KEYWORD_COLOR;
        }
        if (type.equals("url")) {
            return URL_COLOR;
        }
        if (type.equals("comment")) {
            return COMMENT_COLOR;
        }
        if (type.equals("action")) {
            return ACTION_COLOR;
        }
        return DEFAULT_COLOR;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(SOFT_TABS)) {
            this.useSoftTabs = (Boolean)event.getNewValue();
        }
        super.propertyChange(event);
    }

    @Override
    public String scan() {
        if (this.isNext("\n")) {
            return this.found("default", 1);
        }
        if (this.state != "comment" && this.isNext("#")) {
            return this.found("comment", 0);
        }
        if (this.state == "default" && this.isNext("GET")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("POST")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("PUT")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("DELETE")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("OPTIONS")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("HEAD")) {
            return this.found("keyword", 0);
        }
        if (this.state == "default" && this.isNext("*")) {
            return this.found("keyword", 0);
        }
        if ((this.state == "keyword" || this.state == "url") && this.nextIsSpace()) {
            this.oldState = this.state;
            return this.found("default", 0);
        }
        if (this.state == "default" && this.isNext("/")) {
            return this.found("url", 0);
        }
        if (this.state == "default" && this.oldState == "url" && !this.nextIsSpace()) {
            return this.found("action", 0);
        }
        return null;
    }

    @Override
    public void templates(String contentType, String ctx) {
    }
}

