/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.editors;

import fr.zenexity.pdt.editors.CompletionProcessor;
import fr.zenexity.pdt.editors.Editor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Image;
import org.playframework.playclipse.PlayPlugin;

public class ActionCompletionProcessor
extends CompletionProcessor {
    private Map<String, Image> templateImages = new HashMap<String, Image>();

    public ActionCompletionProcessor(ISourceViewer sourceViewer, Editor editor) {
        super("action", sourceViewer, editor);
        this.templateImages.put("Package", PlayPlugin.getImageDescriptor("icons/package_obj.gif").createImage());
        this.templateImages.put("Controller", PlayPlugin.getImageDescriptor("icons/class_obj.gif").createImage());
        this.templateImages.put("Action", PlayPlugin.getImageDescriptor("icons/controller.png").createImage());
    }

    @Override
    public Template[] getTemplates(String contextTypeId) {
        String ctx = this.getCtx();
        if (ctx.contains("@@{")) {
            ctx = ctx.substring(ctx.indexOf("@@{") + 3);
        }
        if (ctx.contains("@{")) {
            ctx = ctx.substring(ctx.indexOf("@{") + 2);
        }
        System.out.println("templates " + contextTypeId + " - " + ctx);
        ArrayList<Template> result = new ArrayList<Template>();
        IJavaProject javaProject = JavaCore.create((IProject)this.editor.getProject());
        if (ctx.isEmpty() || !ctx.contains(".")) {
            result.addAll(this.getMatchingTemplates("controllers", ctx, contextTypeId));
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && (ctx.isEmpty() || root.getElementName().startsWith(ctx))) {
                        result.add(this.getTemplate(contextTypeId, root));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                return result.toArray(new Template[result.size()]);
            }
        } else {
            String typeName = ctx.substring(0, ctx.lastIndexOf(46));
            String query = ctx.substring(ctx.lastIndexOf(46) + 1);
            result.addAll(this.getMatchingTemplates("controllers." + typeName, query, contextTypeId));
        }
        return result.toArray(new Template[result.size()]);
    }

    private Template getTemplate(String contextTypeId, IPackageFragmentRoot root) {
        String name = root.getElementName();
        String description = "Package";
        return new Template(name, description, contextTypeId, name, true);
    }

    private Template getTemplate(String contextTypeId, IMethod javaMethod) {
        String name = javaMethod.getElementName();
        String description = "Action";
        return new Template(name, description, contextTypeId, name, true);
    }

    private Template getTemplate(String contextTypeId, IPackageFragment packageFragment) {
        String name = packageFragment.getElementName();
        String description = "Package";
        return new Template(name, description, contextTypeId, name, true);
    }

    private Template getTemplate(String contextTypeId, ICompilationUnit compilationUnit) {
        String name = compilationUnit.getElementName().replace(".java", "");
        String description = "Controller";
        return new Template(name, description, contextTypeId, name, true);
    }

    private List<Template> getMatchingTemplates(String fullClassName, String query, String contextTypeId) {
        System.out.println("getMatchingMethods {" + fullClassName + "}.{" + query + "}");
        ArrayList<Template> result = new ArrayList<Template>();
        IJavaProject javaProject = JavaCore.create((IProject)this.editor.getProject());
        try {
            IType parent = javaProject.findType(fullClassName);
            if (parent != null) {
                return this.getAllMethodsTemplates(parent, query, contextTypeId);
            }
            parent = this.getPackageFragment(javaProject, fullClassName);
            if (parent == null) {
                return result;
            }
            IJavaElement[] iJavaElementArray = parent.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof IPackageFragment) {
                    result.add(this.getTemplate(contextTypeId, (IPackageFragment)child));
                } else if (child instanceof ICompilationUnit) {
                    result.add(this.getTemplate(contextTypeId, (ICompilationUnit)child));
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Template> getAllMethodsTemplates(IType type, String query, String contextTypeId) throws JavaModelException {
        ArrayList<Template> result = new ArrayList<Template>();
        TreeSet<String> seen = new TreeSet<String>();
        for (Template template : this.getMethodsTemplates(type, query, contextTypeId)) {
            result.add(template);
            seen.add(template.getName());
        }
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] iTypeArray = hierarchy.getAllSuperclasses(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superclass = iTypeArray[n2];
            for (Template template : this.getMethodsTemplates(superclass, query, contextTypeId)) {
                if (seen.contains(template.getName())) continue;
                result.add(template);
                seen.add(template.getName());
            }
            ++n2;
        }
        return result;
    }

    private List<Template> getMethodsTemplates(IType type, String query, String contextTypeId) throws JavaModelException {
        ArrayList<Template> result = new ArrayList<Template>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            int flags = method.getFlags();
            if (Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && method.getReturnType().equals("V") && (query.equals("") || method.getElementName().startsWith(query))) {
                result.add(this.getTemplate(contextTypeId, method));
            }
            ++n2;
        }
        return result;
    }

    private IPackageFragment getPackageFragment(IJavaProject project, String fragmentName) {
        try {
            IPackageFragment[] frags = project.getPackageFragments();
            int i = 0;
            while (i < frags.length) {
                if (frags[i].getElementName().equals(fragmentName)) {
                    return frags[i];
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected Image getImage(Template template) {
        if (this.templateImages.containsKey(template.getDescription())) {
            return this.templateImages.get(template.getDescription());
        }
        return null;
    }
}

