/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.builder;

import fr.zenexity.pdt.editors.IO;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.playframework.playclipse.builder.ErrorChecker;

public class TemplateChecker
extends ErrorChecker {
    private static Pattern action = Pattern.compile("@\\{([^}]+)\\}");
    private static Pattern action_in_tag = Pattern.compile("#\\{.+(@.+[)])");

    public TemplateChecker(IFile file, String preference) {
        super(file, preference);
    }

    public static boolean isTemplate(IPath path) {
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.equals("views")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void check() {
        int offset;
        String action;
        if (this.getSeverity() < 0) {
            return;
        }
        String content = "";
        try {
            content = IO.readContentAsString(this.file);
        }
        catch (Exception exception) {
            return;
        }
        Matcher matcher = TemplateChecker.action.matcher(content);
        while (matcher.find()) {
            action = matcher.group(1);
            offset = matcher.start() + 2;
            this.checkAction(action, TemplateChecker.lineNumberOf(content, offset), offset);
        }
        matcher = action_in_tag.matcher(content);
        while (matcher.find()) {
            action = matcher.group(1).substring(1);
            offset = content.indexOf("@", matcher.start()) + 1;
            this.checkAction(action, TemplateChecker.lineNumberOf(content, offset), offset);
        }
    }

    private void checkAction(String action, int lineNo, int offset) {
        if (action.indexOf(47) > -1) {
            this.checkStaticAction(action, lineNo, offset);
            return;
        }
        if (action.indexOf(40) > -1) {
            action = action.substring(0, action.indexOf(40));
        }
        if (action.indexOf(46) == -1) {
            return;
        }
        if (this.getInspector().resolveAction(action) == null) {
            try {
                this.addMarker("Missing action: " + action, lineNo, this.getSeverity(), offset, offset + action.length());
            }
            catch (CoreException coreException) {}
        }
    }

    private void checkStaticAction(String action, int lineNo, int offset) {
    }

    private static int lineNumberOf(String content, int offset) {
        int lineNo = 1;
        String region = content.substring(0, offset);
        while (region.indexOf("\n") > -1) {
            ++lineNo;
            region = region.substring(region.indexOf("\n") + 1);
        }
        return lineNo;
    }
}

