/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png.quantx;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.png.quantx.QuantizerMap;

public final class QuantizerWuOKLab {
    int[] weights;
    double[] momentsL;
    double[] momentsA;
    double[] momentsB;
    double[] momentsSS;
    Box[] cubes;
    private static final int INDEX_BITS = 5;
    private static final int INDEX_COUNT = 33;
    private static final int TOTAL_SIZE = 35937;
    private static final float A_MIN = -0.5f;
    private static final float A_MAX = 0.5f;
    private static final float B_MIN = -0.5f;
    private static final float B_MAX = 0.5f;
    private static final int INDEX_MAX = 31;

    public Map<Integer, Integer> quantize(int[] pixels, int colorCount) {
        Map<Integer, Integer> mapResult = new QuantizerMap().quantize(pixels, colorCount);
        this.constructHistogram(mapResult);
        this.createMoments();
        CreateBoxesResult createBoxesResult = this.createBoxes(colorCount);
        List<Integer> colors = this.createResult(createBoxesResult.resultCount);
        LinkedHashMap<Integer, Integer> resultMap = new LinkedHashMap<Integer, Integer>();
        for (int color : colors) {
            resultMap.put(color, 0);
        }
        return resultMap;
    }

    static int getIndex(int l, int a, int b) {
        return (l << 10) + (l << 6) + l + (a << 5) + a + b;
    }

    void constructHistogram(Map<Integer, Integer> pixels) {
        this.weights = new int[35937];
        this.momentsL = new double[35937];
        this.momentsA = new double[35937];
        this.momentsB = new double[35937];
        this.momentsSS = new double[35937];
        for (Map.Entry<Integer, Integer> pair : pixels.entrySet()) {
            int index;
            int argb = pair.getKey();
            int count = pair.getValue();
            int r8 = argb >> 16 & 0xFF;
            int g8 = argb >> 8 & 0xFF;
            int b8 = argb & 0xFF;
            float[] lab = QuantizerWuOKLab.srgb8ToOKLab(r8, g8, b8);
            float L = lab[0];
            float A = lab[1];
            float B = lab[2];
            int iL = QuantizerWuOKLab.toIndexL(L);
            int iA = QuantizerWuOKLab.toIndexA(A);
            int iB = QuantizerWuOKLab.toIndexB(B);
            int n = index = QuantizerWuOKLab.getIndex(iL, iA, iB);
            this.weights[n] = this.weights[n] + count;
            int n2 = index;
            this.momentsL[n2] = this.momentsL[n2] + (double)L * (double)count;
            int n3 = index;
            this.momentsA[n3] = this.momentsA[n3] + (double)A * (double)count;
            int n4 = index;
            this.momentsB[n4] = this.momentsB[n4] + (double)B * (double)count;
            int n5 = index;
            this.momentsSS[n5] = this.momentsSS[n5] + (double)count * (double)(L * L + A * A + B * B);
        }
    }

    void createMoments() {
        for (int l = 1; l < 33; ++l) {
            int[] areaW = new int[33];
            double[] areaL = new double[33];
            double[] areaA = new double[33];
            double[] areaB = new double[33];
            double[] areaSS = new double[33];
            for (int a = 1; a < 33; ++a) {
                int lineW = 0;
                double lineL = 0.0;
                double lineA = 0.0;
                double lineB = 0.0;
                double lineSS = 0.0;
                for (int b = 1; b < 33; ++b) {
                    int index = QuantizerWuOKLab.getIndex(l, a, b);
                    lineW += this.weights[index];
                    lineL += this.momentsL[index];
                    lineA += this.momentsA[index];
                    lineB += this.momentsB[index];
                    lineSS += this.momentsSS[index];
                    int n = b;
                    areaW[n] = areaW[n] + lineW;
                    int n2 = b;
                    areaL[n2] = areaL[n2] + lineL;
                    int n3 = b;
                    areaA[n3] = areaA[n3] + lineA;
                    int n4 = b;
                    areaB[n4] = areaB[n4] + lineB;
                    int n5 = b;
                    areaSS[n5] = areaSS[n5] + lineSS;
                    int prev = QuantizerWuOKLab.getIndex(l - 1, a, b);
                    this.weights[index] = this.weights[prev] + areaW[b];
                    this.momentsL[index] = this.momentsL[prev] + areaL[b];
                    this.momentsA[index] = this.momentsA[prev] + areaA[b];
                    this.momentsB[index] = this.momentsB[prev] + areaB[b];
                    this.momentsSS[index] = this.momentsSS[prev] + areaSS[b];
                }
            }
        }
    }

    CreateBoxesResult createBoxes(int maxColorCount) {
        this.cubes = new Box[maxColorCount];
        for (int i = 0; i < maxColorCount; ++i) {
            this.cubes[i] = new Box();
        }
        double[] volumeVariance = new double[maxColorCount];
        Box first = this.cubes[0];
        first.l1 = 32;
        first.a1 = 32;
        first.b1 = 32;
        int generatedColorCount = maxColorCount;
        int next = 0;
        for (int i = 1; i < maxColorCount; ++i) {
            if (this.cut(this.cubes[next], this.cubes[i]).booleanValue()) {
                volumeVariance[next] = this.cubes[next].vol > 1 ? this.variance(this.cubes[next]) : 0.0;
                volumeVariance[i] = this.cubes[i].vol > 1 ? this.variance(this.cubes[i]) : 0.0;
            } else {
                volumeVariance[next] = 0.0;
                --i;
            }
            next = 0;
            double best = volumeVariance[0];
            for (int j = 1; j <= i; ++j) {
                if (!(volumeVariance[j] > best)) continue;
                best = volumeVariance[j];
                next = j;
            }
            if (!(best <= 0.0)) continue;
            generatedColorCount = i + 1;
            break;
        }
        return new CreateBoxesResult(maxColorCount, generatedColorCount);
    }

    List<Integer> createResult(int colorCount) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < colorCount; ++i) {
            Box cube = this.cubes[i];
            int w = QuantizerWuOKLab.volume(cube, this.weights);
            if (w <= 0) continue;
            double L = QuantizerWuOKLab.volume(cube, this.momentsL) / (double)w;
            double A = QuantizerWuOKLab.volume(cube, this.momentsA) / (double)w;
            double B = QuantizerWuOKLab.volume(cube, this.momentsB) / (double)w;
            int argb = QuantizerWuOKLab.oklabToSrgb8Clamp((float)L, (float)A, (float)B);
            colors.add(argb);
        }
        return colors;
    }

    double variance(Box cube) {
        double dL = QuantizerWuOKLab.volume(cube, this.momentsL);
        double dA = QuantizerWuOKLab.volume(cube, this.momentsA);
        double dB = QuantizerWuOKLab.volume(cube, this.momentsB);
        double xx = this.momentsSS[QuantizerWuOKLab.getIndex(cube.l1, cube.a1, cube.b1)] - this.momentsSS[QuantizerWuOKLab.getIndex(cube.l1, cube.a1, cube.b0)] - this.momentsSS[QuantizerWuOKLab.getIndex(cube.l1, cube.a0, cube.b1)] + this.momentsSS[QuantizerWuOKLab.getIndex(cube.l1, cube.a0, cube.b0)] - this.momentsSS[QuantizerWuOKLab.getIndex(cube.l0, cube.a1, cube.b1)] + this.momentsSS[QuantizerWuOKLab.getIndex(cube.l0, cube.a1, cube.b0)] + this.momentsSS[QuantizerWuOKLab.getIndex(cube.l0, cube.a0, cube.b1)] - this.momentsSS[QuantizerWuOKLab.getIndex(cube.l0, cube.a0, cube.b0)];
        double hyp = dL * dL + dA * dA + dB * dB;
        int volW = QuantizerWuOKLab.volume(cube, this.weights);
        return xx - hyp / (double)volW;
    }

    Boolean cut(Box one, Box two) {
        double wholeL = QuantizerWuOKLab.volume(one, this.momentsL);
        double wholeA = QuantizerWuOKLab.volume(one, this.momentsA);
        double wholeB = QuantizerWuOKLab.volume(one, this.momentsB);
        int wholeW = QuantizerWuOKLab.volume(one, this.weights);
        MaximizeResult maxL = this.maximize(one, Direction.L, one.l0 + 1, one.l1, wholeL, wholeA, wholeB, wholeW);
        MaximizeResult maxA = this.maximize(one, Direction.A, one.a0 + 1, one.a1, wholeL, wholeA, wholeB, wholeW);
        MaximizeResult maxB = this.maximize(one, Direction.B, one.b0 + 1, one.b1, wholeL, wholeA, wholeB, wholeW);
        MaximizeResult best = maxL;
        Direction dir = Direction.L;
        if (maxA.maximum >= best.maximum) {
            best = maxA;
            dir = Direction.A;
        }
        if (maxB.maximum >= best.maximum) {
            best = maxB;
            dir = Direction.B;
        }
        if (best.cutLocation < 0) {
            return false;
        }
        two.l1 = one.l1;
        two.a1 = one.a1;
        two.b1 = one.b1;
        switch (dir) {
            case L: {
                two.l0 = one.l1 = best.cutLocation;
                two.a0 = one.a0;
                two.b0 = one.b0;
                break;
            }
            case A: {
                one.a1 = best.cutLocation;
                two.l0 = one.l0;
                two.a0 = one.a1;
                two.b0 = one.b0;
                break;
            }
            case B: {
                one.b1 = best.cutLocation;
                two.l0 = one.l0;
                two.a0 = one.a0;
                two.b0 = one.b1;
            }
        }
        one.vol = (one.l1 - one.l0) * (one.a1 - one.a0) * (one.b1 - one.b0);
        two.vol = (two.l1 - two.l0) * (two.a1 - two.a0) * (two.b1 - two.b0);
        return true;
    }

    MaximizeResult maximize(Box cube, Direction direction, int first, int last, double wholeL, double wholeA, double wholeB, int wholeW) {
        double bottomL = QuantizerWuOKLab.bottom(cube, direction, this.momentsL);
        double bottomA = QuantizerWuOKLab.bottom(cube, direction, this.momentsA);
        double bottomB = QuantizerWuOKLab.bottom(cube, direction, this.momentsB);
        int bottomW = QuantizerWuOKLab.bottom(cube, direction, this.weights);
        double max = 0.0;
        int cut = -1;
        for (int i = first; i < last; ++i) {
            double halfL = bottomL + QuantizerWuOKLab.top(cube, direction, i, this.momentsL);
            double halfA = bottomA + QuantizerWuOKLab.top(cube, direction, i, this.momentsA);
            double halfB = bottomB + QuantizerWuOKLab.top(cube, direction, i, this.momentsB);
            int halfW = bottomW + QuantizerWuOKLab.top(cube, direction, i, this.weights);
            if (halfW == 0) continue;
            double t = (halfL * halfL + halfA * halfA + halfB * halfB) / (double)halfW;
            double rL = wholeL - halfL;
            double rA = wholeA - halfA;
            double rB = wholeB - halfB;
            int rW = wholeW - halfW;
            if (rW == 0 || !((t += (rL * rL + rA * rA + rB * rB) / (double)rW) > max)) continue;
            max = t;
            cut = i;
        }
        return new MaximizeResult(cut, max);
    }

    static int volume(Box c, int[] m) {
        return m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
    }

    static double volume(Box c, double[] m) {
        return m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
    }

    static int bottom(Box c, Direction d, int[] m) {
        switch (d) {
            case L: {
                return -m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
            case A: {
                return -m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
            case B: {
                return -m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)d));
    }

    static double bottom(Box c, Direction d, double[] m) {
        switch (d) {
            case L: {
                return -m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
            case A: {
                return -m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
            case B: {
                return -m[QuantizerWuOKLab.getIndex(c.l1, c.a1, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l1, c.a0, c.b0)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a0, c.b0)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)d));
    }

    static int top(Box c, Direction d, int pos, int[] m) {
        switch (d) {
            case L: {
                return m[QuantizerWuOKLab.getIndex(pos, c.a1, c.b1)] - m[QuantizerWuOKLab.getIndex(pos, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(pos, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(pos, c.a0, c.b0)];
            }
            case A: {
                return m[QuantizerWuOKLab.getIndex(c.l1, pos, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l1, pos, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, pos, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, pos, c.b0)];
            }
            case B: {
                return m[QuantizerWuOKLab.getIndex(c.l1, c.a1, pos)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a0, pos)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a1, pos)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, pos)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)d));
    }

    static double top(Box c, Direction d, int pos, double[] m) {
        switch (d) {
            case L: {
                return m[QuantizerWuOKLab.getIndex(pos, c.a1, c.b1)] - m[QuantizerWuOKLab.getIndex(pos, c.a1, c.b0)] - m[QuantizerWuOKLab.getIndex(pos, c.a0, c.b1)] + m[QuantizerWuOKLab.getIndex(pos, c.a0, c.b0)];
            }
            case A: {
                return m[QuantizerWuOKLab.getIndex(c.l1, pos, c.b1)] - m[QuantizerWuOKLab.getIndex(c.l1, pos, c.b0)] - m[QuantizerWuOKLab.getIndex(c.l0, pos, c.b1)] + m[QuantizerWuOKLab.getIndex(c.l0, pos, c.b0)];
            }
            case B: {
                return m[QuantizerWuOKLab.getIndex(c.l1, c.a1, pos)] - m[QuantizerWuOKLab.getIndex(c.l1, c.a0, pos)] - m[QuantizerWuOKLab.getIndex(c.l0, c.a1, pos)] + m[QuantizerWuOKLab.getIndex(c.l0, c.a0, pos)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)d));
    }

    private static int toIndexL(float L) {
        if (L < 0.0f) {
            L = 0.0f;
        } else if (L > 1.0f) {
            L = 1.0f;
        }
        int i = (int)(L * 31.0f);
        if (i < 0) {
            i = 0;
        } else if (i > 31) {
            i = 31;
        }
        return i + 1;
    }

    private static int toIndexA(float a) {
        if (a < -0.5f) {
            a = -0.5f;
        } else if (a > 0.5f) {
            a = 0.5f;
        }
        float norm = (a - -0.5f) / 1.0f;
        int i = (int)(norm * 31.0f);
        if (i < 0) {
            i = 0;
        } else if (i > 31) {
            i = 31;
        }
        return i + 1;
    }

    private static int toIndexB(float b) {
        if (b < -0.5f) {
            b = -0.5f;
        } else if (b > 0.5f) {
            b = 0.5f;
        }
        float norm = (b - -0.5f) / 1.0f;
        int i = (int)(norm * 31.0f);
        if (i < 0) {
            i = 0;
        } else if (i > 31) {
            i = 31;
        }
        return i + 1;
    }

    private static float[] srgb8ToOKLab(int r8, int g8, int b8) {
        double r = (double)r8 / 255.0;
        double g = (double)g8 / 255.0;
        double b = (double)b8 / 255.0;
        double rl = QuantizerWuOKLab.srgbToLinear(r);
        double gl = QuantizerWuOKLab.srgbToLinear(g);
        double bl = QuantizerWuOKLab.srgbToLinear(b);
        double l = 0.4122214708 * rl + 0.5363325363 * gl + 0.0514459929 * bl;
        double m = 0.2119034982 * rl + 0.6806995451 * gl + 0.1073969566 * bl;
        double s = 0.0883024619 * rl + 0.2817188376 * gl + 0.6299787005 * bl;
        double l_ = Math.cbrt(l);
        double m_ = Math.cbrt(m);
        double s_ = Math.cbrt(s);
        double L = 0.2104542553 * l_ + 0.793617785 * m_ - 0.0040720468 * s_;
        double A = 1.9779984951 * l_ - 2.428592205 * m_ + 0.4505937099 * s_;
        double B = 0.0259040371 * l_ + 0.7827717662 * m_ - 0.808675766 * s_;
        return new float[]{(float)L, (float)A, (float)B};
    }

    private static int oklabToSrgb8Clamp(float L, float A, float B) {
        double l_ = (double)L + 0.3963377774 * (double)A + 0.2158037573 * (double)B;
        double m_ = (double)L - 0.1055613458 * (double)A - 0.0638541728 * (double)B;
        double s_ = (double)L - 0.0894841775 * (double)A - 1.291485548 * (double)B;
        double l = l_ * l_ * l_;
        double m = m_ * m_ * m_;
        double s = s_ * s_ * s_;
        double rl = 4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s;
        double gl = -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s;
        double bl = -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s;
        double r = QuantizerWuOKLab.linearToSrgb(rl);
        double g = QuantizerWuOKLab.linearToSrgb(gl);
        double b = QuantizerWuOKLab.linearToSrgb(bl);
        int r8 = QuantizerWuOKLab.clamp8((int)Math.round(r * 255.0));
        int g8 = QuantizerWuOKLab.clamp8((int)Math.round(g * 255.0));
        int b8 = QuantizerWuOKLab.clamp8((int)Math.round(b * 255.0));
        return 0xFF000000 | r8 << 16 | g8 << 8 | b8;
    }

    private static double srgbToLinear(double c) {
        return c <= 0.04045 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }

    private static double linearToSrgb(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return x <= 0.0031308 ? 12.92 * x : 1.055 * Math.pow(x, 0.4166666666666667) - 0.055;
    }

    private static int clamp8(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    private static final class CreateBoxesResult {
        int requestedCount;
        int resultCount;

        CreateBoxesResult(int requestedCount, int resultCount) {
            this.requestedCount = requestedCount;
            this.resultCount = resultCount;
        }
    }

    private static final class Box {
        int l0 = 0;
        int l1 = 0;
        int a0 = 0;
        int a1 = 0;
        int b0 = 0;
        int b1 = 0;
        int vol = 0;

        private Box() {
        }
    }

    private static enum Direction {
        L,
        A,
        B;

    }

    private static final class MaximizeResult {
        int cutLocation;
        double maximum;

        MaximizeResult(int cut, double max) {
            this.cutLocation = cut;
            this.maximum = max;
        }
    }
}

