/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.SName;

class USymbolProcess
extends USymbol {
    private final SName sname;

    public USymbolProcess(SName sname) {
        this.sname = sname;
    }

    @Override
    public SName[] getSNames() {
        return new SName[]{this.sname};
    }

    private void drawProcess(UGraphic ug, double width, double height, double shadowing, double roundCorner, double diagonalCorner) {
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 0.0);
        shape.addPoint(width - 10.0, 0.0);
        shape.addPoint(width, height / 2.0);
        shape.addPoint(width - 10.0, height);
        shape.addPoint(0.0, height);
        shape.addPoint(10.0, height / 2.0);
        ug.draw(shape);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(20.0, 20.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolProcess.this.drawProcess(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                USymbol.Margin margin = USymbolProcess.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolProcess.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    private double getHTitle(XDimension2D dimTitle) {
        double htitle = dimTitle.getWidth() == 0.0 ? 10.0 : dimTitle.getHeight();
        return htitle;
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                XDimension2D dim = this.calculateDimension(stringBounder);
                ug = symbolContext.apply(ug);
                XDimension2D dimTitle = title.calculateDimension(stringBounder);
                USymbolProcess.this.drawProcess(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0)));
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(4.0 + posStereo, 2.0 + USymbolProcess.this.getHTitle(dimTitle))));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

