/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.regex.RegexResult;

public enum Direction {
    RIGHT,
    LEFT,
    DOWN,
    UP;


    public Direction getInv() {
        switch (this) {
            case RIGHT: {
                return LEFT;
            }
            case LEFT: {
                return RIGHT;
            }
            case DOWN: {
                return UP;
            }
            case UP: {
                return DOWN;
            }
        }
        throw new IllegalStateException();
    }

    public String getShortCode() {
        return this.name().substring(0, 1);
    }

    public static Direction fromChar(char c) {
        switch (c) {
            case '<': {
                return LEFT;
            }
            case '>': {
                return RIGHT;
            }
            case '^': {
                return UP;
            }
        }
        return DOWN;
    }

    public static Direction getWBSDirection(RegexResult arg) {
        String type = arg.get("TYPE", 0);
        Direction direction = type.contains("-") ? LEFT : RIGHT;
        String dir = arg.getLazzy("DIRECTION", 0);
        if ("<".equals(dir)) {
            direction = LEFT;
        } else if (">".equals(dir)) {
            direction = RIGHT;
        }
        return direction;
    }

    public Direction clockwise() {
        switch (this) {
            case RIGHT: {
                return DOWN;
            }
            case LEFT: {
                return UP;
            }
            case DOWN: {
                return LEFT;
            }
            case UP: {
                return RIGHT;
            }
        }
        throw new IllegalStateException();
    }

    public static Direction leftOrRight(XPoint2D p1, XPoint2D p2) {
        if (p1.getX() < p2.getX()) {
            return LEFT;
        }
        if (p1.getX() > p2.getX()) {
            return RIGHT;
        }
        throw new IllegalArgumentException();
    }

    public static Direction fromVector(XPoint2D p1, XPoint2D p2) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        if (x1 == x2) {
            if (y2 > y1) {
                return DOWN;
            }
            return UP;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                return RIGHT;
            }
            return LEFT;
        }
        throw new IllegalArgumentException("Not a H or V line!");
    }

    public static Direction lazzyValueOf(String s) {
        if ("TOP".equals(s = s.toUpperCase())) {
            return UP;
        }
        if ("BOTTOM".equals(s)) {
            return DOWN;
        }
        return Direction.valueOf(s);
    }
}

