/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.StdrptNull;
import net.sourceforge.plantuml.StdrptPipe0;
import net.sourceforge.plantuml.StdrptV1;
import net.sourceforge.plantuml.StdrptV2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.CliParsed;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.file.FileGroup;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;

public class CliOptions {
    private final List<String> config = new ArrayList<String>();
    private File outputDir = null;
    public final CliParsed flags;
    private FileFormatOption fileFormatOption = null;

    public CliOptions() {
        this.flags = new CliParsed();
    }

    @Deprecated
    public final void setFileFormat(FileFormat fileFormat) {
        this.setFileFormatOption(new FileFormatOption(fileFormat));
    }

    public final void setFileFormatOption(FileFormatOption newFormat) {
        this.fileFormatOption = newFormat;
    }

    CliOptions(String ... arg) throws InterruptedException, IOException {
        if (arg.length == 0) {
            GlobalConfig.getInstance().put(GlobalConfigKey.GUI, true);
        }
        this.initInclude(GraphvizUtils.getenvDefaultConfigFilename());
        this.flags = CliParsed.parse(arg);
        String limitSize = this.defines().get("PLANTUML_LIMIT_SIZE");
        if (limitSize != null) {
            System.setProperty("PLANTUML_LIMIT_SIZE", limitSize);
        }
        for (String string : this.flags.getMap(CliFlag.INCLUDE, CliFlag.INCLUDE_LONG).keySet()) {
            this.initInclude(string);
        }
        for (Object object : this.flags.getList(CliFlag.THEME)) {
            this.config.add("!theme " + object);
        }
        for (Object object : this.flags.getList(CliFlag.CONFIG)) {
            this.addInConfig(object.toString());
        }
        for (Map.Entry entry : this.flags.getMap(CliFlag.PRAGMA, CliFlag.PRAGMA_LONG).entrySet()) {
            this.config.add("!pragma " + (String)entry.getKey() + " " + (String)entry.getValue());
        }
        for (Map.Entry entry : this.flags.getMap(CliFlag.SKINPARAM, CliFlag.SKINPARAM_LONG).entrySet()) {
            this.config.add("skinparamlocked " + (String)entry.getKey() + " " + (String)entry.getValue());
        }
    }

    public Stdrpt getStdrpt() {
        String stdrpt = this.flags.getString(CliFlag.STDRPT);
        if ("1".equals(stdrpt)) {
            return new StdrptV1();
        }
        if ("2".equals(stdrpt)) {
            return new StdrptV2();
        }
        if (this.isTrue(CliFlag.PIPE) || this.isTrue(CliFlag.PIPEMAP) || this.isTrue(CliFlag.SYNTAX)) {
            return new StdrptPipe0();
        }
        return new StdrptNull();
    }

    public int getFtpPort() {
        String ftp = this.flags.getString(CliFlag.FTP);
        if (ftp == null) {
            return 4242;
        }
        return Integer.parseInt(ftp);
    }

    public String getPicowebBindAddress() {
        String picoweb = this.flags.getString(CliFlag.PICOWEB);
        if (picoweb == null) {
            return null;
        }
        String[] parts = picoweb.split(":");
        return parts.length > 1 ? parts[1] : null;
    }

    public int getPicowebPort() {
        String picoweb = this.flags.getString(CliFlag.PICOWEB);
        if (picoweb == null) {
            return 8080;
        }
        String[] parts = picoweb.split(":");
        return Integer.parseInt(parts[0]);
    }

    public boolean getPicowebEnableStop() {
        String picoweb = this.flags.getString(CliFlag.PICOWEB);
        if (picoweb == null) {
            return false;
        }
        return picoweb.toLowerCase().contains("stop");
    }

    private void addFileInConfig(File file) throws IOException {
        if (file.exists() && file.canRead()) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String s = null;
                while ((s = br.readLine()) != null) {
                    this.config.add(s);
                }
            }
        }
    }

    public void addInConfig(String filename) throws IOException {
        this.addFileInConfig(new File(filename));
    }

    private void initInclude(String filename) throws IOException {
        if (filename == null) {
            return;
        }
        if (filename.contains("*")) {
            for (File f : new FileGroup(filename, Collections.emptyList()).getFiles()) {
                this.addFileInConfig(f);
            }
        } else {
            this.addFileInConfig(new File(filename));
        }
    }

    public final File getOutputDir() {
        if (this.outputDir != null) {
            return this.outputDir;
        }
        String tmp = this.flags.getString(CliFlag.OUTPUT_DIR);
        if (tmp != null) {
            return new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(tmp));
        }
        return null;
    }

    public static final String getPattern() {
        return "(?i)^.*\\.(txt|tex|java|htm|html|c|h|cpp|apt|pu|puml|hpp|hh)$";
    }

    public void setOutputDir(File f) {
        this.outputDir = f;
    }

    public final List<String> getExcludes() {
        if (this.isTrue(CliFlag.EXCLUDE)) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object s : this.flags.getList(CliFlag.EXCLUDE)) {
                result.add(s.toString());
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public Defines getDefaultDefines(SFile f) {
        Defines result = Defines.createWithFileName(f);
        for (Map.Entry<String, String> ent : this.defines().entrySet()) {
            String value = ent.getValue();
            if (value == null) {
                value = "";
            }
            result.define(ent.getKey(), Arrays.asList(value), false, null);
        }
        return result;
    }

    public Defines getDefaultDefines(File f) {
        Defines result = Defines.createWithFileName(f);
        for (Map.Entry<String, String> ent : this.defines().entrySet()) {
            String value = ent.getValue();
            if (value == null) {
                value = "";
            }
            result.define(ent.getKey(), Arrays.asList(value), false, null);
        }
        return result;
    }

    public Defines getDefaultDefines() {
        Defines result = Defines.createEmpty();
        result.overrideFilename(this.flags.getString(CliFlag.FILENAME));
        result.overrideDirPath(this.flags.getString(CliFlag.FILE_DIR));
        for (Map.Entry<String, String> ent : this.defines().entrySet()) {
            result.define(ent.getKey(), Arrays.asList(ent.getValue()), false, null);
        }
        return result;
    }

    private Map<String, String> defines() {
        Map<String, String> result = this.flags.getMap(CliFlag.DEFINE, CliFlag.DEFINE_LONG);
        return Collections.unmodifiableMap(result);
    }

    public List<String> getConfig() {
        return Collections.unmodifiableList(this.config);
    }

    public final List<String> getRemainingArgs() {
        return this.flags.getRemainingArgs();
    }

    public FileFormatOption getFileFormatOption() {
        if (this.fileFormatOption != null) {
            return this.fileFormatOption;
        }
        FileFormat format = null;
        String formatFlag = this.flags.getString(CliFlag.FORMAT);
        if (formatFlag != null) {
            format = FileFormat.fromCli(formatFlag);
        }
        if (format == null) {
            format = (FileFormat)((Object)this.flags.getFromType(FileFormat.class));
        }
        if (format == null) {
            format = FileFormat.PNG;
        }
        this.fileFormatOption = new FileFormatOption(format);
        if (this.flags.isTrue(CliFlag.DEBUG_SVEK)) {
            this.fileFormatOption.setDebugSvek(true);
        }
        if (this.flags.isTrue(CliFlag.NO_METADATA)) {
            this.fileFormatOption.hideMetadata();
        }
        if (this.flags.isTrue(CliFlag.DARK_MODE)) {
            this.fileFormatOption = this.fileFormatOption.withColorMapper(ColorMapper.DARK_MODE);
        }
        return this.fileFormatOption;
    }

    public final int getNbThreads() {
        String value = this.flags.getString(CliFlag.NB_THREAD);
        if (value != null && !"auto".equalsIgnoreCase(value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return CliOptions.defaultNbThreads();
    }

    public static int defaultNbThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final boolean isFailfastOrFailfast2() {
        return this.isTrue(CliFlag.FAIL_FAST) || this.isTrue(CliFlag.FAIL_FAST2);
    }

    public final int getImageIndex() {
        try {
            return Integer.parseInt(this.flags.getString(CliFlag.PIPE_IMAGE_INDEX));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getFileDir() {
        return this.flags.getString(CliFlag.FILE_DIR);
    }

    public boolean isTrue(CliFlag flag2) {
        return this.flags.isTrue(flag2);
    }

    public String getString(CliFlag flag2) {
        return this.flags.getString(flag2);
    }

    public void setValue(CliFlag flag2, Object value) {
        this.flags.putValue(flag2, value);
    }
}

