<?php

if (!extension_loaded("pop3")) 
{
	        dl("pop3.so");
}

// Establish a connection
//
// Enter your data below for this script to work
// on your server!

$username = "";
$password = "";
$server = "tcp://server:110";	// you can also use ssl://server:110 (or 995 for some servers)
								// if you want to use POP3+SSL

$session = pop3_open ($server, $username, $password);	// $port is optional

if (is_null ($session))
{
	die ("CONNECTION ERROR");
}

// Retrieve the number of messages available

$message_count = pop3_get_message_count ($session);

echo "Message count: $message_count\n";

// Retrieve a list of available messages and their IDs
// The list is returned as an array of arrays
// with the following entries:
//
// message_id -> the numeric id of the message (also the key of the array)
// id -> the unique ID of the message

$messages = pop3_get_message_ids ($session);

echo "Message ID list follows:\n";

var_dump ($messages);

// Retrieve a list of available messages and their sizes
// The list is returned as an array of arrays
// with the following entries:
//
// message_id -> the numeric id of the message (also the key of the array)
// size -> the unique ID of the message

$messages = pop3_get_message_sizes ($session);

echo "Message size list follows:\n";

var_dump ($messages);

// Retrieve a particular message

$message_id = 1; 	// Must be a numeric id between 1 and pop3_get_message_count()

// Get only the headers

$message_headers = pop3_get_message_header ($session, $message_id);

echo "Message headers for message #$message_id:\n$message_headers";

// Get the whole thing

$message = pop3_get_message ($session, $message_id);

echo "Message #$message_id:\n$message";

// Delete message

if (pop3_delete_message ($session, $message_id) === true)
{
	echo "Deleted message #$message_id successfully\n\n";
}
else
{
	echo "Error deleting message #$message_id";
}

// Undelete all deleted messages

if (pop3_undelete ($session) === true)
{
	echo "Successfully undeleted all messages\n\n";
}
else
{
	echo "Error undeleting messages\n\n";
}

?>
