% Press

Here are some books, articles, and blogs that discuss pandoc:

# Articles

- [Pandoc](http://en.wikipedia.org/wiki/Pandoc) on Wikipedia.

- Egon Willighagen, [Two years of explicit CiTO
  annotations](https://doi.org/10.1186/s13321-023-00683-2).
  Journal of Cheminformatics 15, 14 (2023). doi:
  10.1186/s13321-023-00683-2.

- Albert Krewinkel, Juanjo Bazán, and Afron M. Smith,
  ["JATS from Markdown: Developer friendly single-source
  scholarly
  publishing"](https://www.ncbi.nlm.nih.gov/books/NBK579698/),
  *JATS-Con Proceedings 2022*.

- A. Ohri and T. Schmah, ["Machine Translation of Mathematical
  Text,"](https://doi.org/10.1109/ACCESS.2021.3063715) in
  *IEEE Access*, vol. 9, pp. 38078-38086, 2021,
  doi: 10.1109/ACCESS.2021.3063715.

- Julien Dehut, ["En finir avec Word ! Pour une analyse des
  enjeux relatifs aux traitements de texte et à leur
  utilisation"](https://eriac.hypotheses.org/80),
  *L'Atelier des Savoirs*, January 23, 2018.

- Phillips, Lee.  ["Technical Writing with Pandoc and
  Panflute"](https://lee-phillips.org/panflute-gnuplot/).
  Reproduced with permission from *Linux Journal*, September, 2017.

- Krewinkel, Albert and Robert Winkler.  ["Formatting Open
  Science: agile creation of multiple document types by writing
  academic manuscripts in pandoc
  markdown."](https://peerj.com/preprints/2648/).
  *PeerJ Preprints*.

- Krijnen, Jacco, Doaitse Swierstra, and Marcos O. Viera. ["Expand:
  Towards an Extensible Pandoc
  System."](http://dx.doi.org/10.1007/978-3-319-04132-2_14)
  *Practical Aspects of Declarative Languages* (Springer International
  Publishing, 2014), 200--215.

- Kielhorn, Axel. ["Multi-target publishing-Generating ePub, PDF, and
  more, from Markdown using
  pandoc."](https://www.tug.org/TUGboat/tb32-3/tb102kielhorn.pdf)
  *TUGboat-TeX Users Group* 32, no. 3 (2011): 272.

- Massimiliano Dominici. ["An Overview of Pandoc."](http://www.dw.tug.org/TUGboat/tb35-1/tb109dominici.pdf),
  *TUGboat* 32 (2014), n. 1: 44-50.

- Gieben, R. ["Writing I-Ds and RFCs Using Pandoc and a Bit of
  XML."](https://tools.ietf.org/html/rfc7328.html) (RFC 7328, 2014).

- Ovadia, Steven (2014). ["Markdown for Librarians and
  Academics".](http://www.tandfonline.com/doi/pdf/10.1080/01639269.2014.904696)
  *Behavioral & Social Sciences Librarian* 33 (2): 120–124.
  doi:10.1080/01639269.2014.904696

- Daniel Burgos and Alberto Corbí, "Semi-Automated Correction Tools for
  Mathematics-Based Exercises in MOOC Environments,"
  [*International Journal of Artificial Intelligence and Interactive Multimedia*,
  3](http://www.ijimai.org/journal/sites/default/files/journals/IJIMAI20153_3.pdf), 89-95.

- Garnett A, Alperin JP, Willinsky J. "The Public Knowledge Project XML
  Publishing Service and meTypeset: Don't call it 'Yet Another
  Word-to-JATS Conversion Kit'." *Journal Article Tag Suite
  Conference (JATS-Con) Proceedings* 2015 [Internet]. Bethesda (MD):
  National Center for Biotechnology Information (US); 2015. Available
  from: <http://www.ncbi.nlm.nih.gov/books/NBK279666/>

# Books

- Digital Publishing Toolkit Collective,
  [*From Print to EBooks: A Hybrid Publishing Toolkit for the Arts*](http://networkcultures.org/blog/publication/from-print-to-ebooks-a-hybrid-publishing-toolkit-for-the-arts/)
  (Institute of Network Cultures), ch. 6.

- Hasecke, Jan Ulrich. [*Das ZEN von Pandoc: Bücher und E-Books einfach
und professionell
produzieren*](http://www.amazon.com/Das-ZEN-von-Pandoc-professionell-ebook/dp/B00TQ55D34).

- Michael Kofler,
  [*Markdown und
  Pandoc*](http://www.amazon.com/Markdown-Pandoc-German-Michael-Kofler-ebook/dp/B00CX7HIOO/ref=sr_1_1?ie=UTF8&qid=1424543894&sr=8-1&keywords=pandoc).

# Blog posts

- Grec, Dan (2021), ["How I self-published a professional paperback and
  eBook using LaTeX and
  Pandoc"](http://theroadchoseme.com/how-i-self-published-a-professional-paperback-and-ebook-using-latex-and-pandoc),
  The Road Chose Me.

- Grandesso, Piero (2018-03-23). ["A pandoc-based layout workflow for
  scholarly journals"](http://pierog.it/en/2018/03/markdown-workflow/).
  Piero G: Notes on Open Access, Scholarly Publishing etc.

- Krewinkel, Albert (2017-12-23). ["Extending pandoc with
  Lua"](http://lua.space/general/extending-pandoc-with-lua).
  Lua.Space.

- Pullum, Geoffrey (2017-03-13).  ["Word-Processing
  Misery"](http://www.chronicle.com/blogs/linguafranca/2017/03/13/word-processing-hell/).
  The Chronicle of Higher Education Blogs: Lingua Franca.

- Curiositry (2017-02-28).  ["Pandoc for
  Writers"](http://www.autodidacts.io/convert-markdown-to-standard-manuscript-format-odts-docs-and-pdfs-with-pandoc/).
  The Autodidacts.

- Tenen, Dennis and Grant Wythoff (2014-03-19). ["Sustainable Authorship
  in Plain Text using Pandoc and Markdown"](http://programminghistorian.org/lessons/sustainable-authorship-in-plain-text-using-pandoc-and-markdown). The Programming
  Historian.

- Mullen, Lincoln (2012-02-23). ["Pandoc Converts All Your (Text)
   Documents"](http://chronicle.com/blogs/profhacker/pandoc-converts-all-your-text-documents/38700), The Chronicle of Higher Education Blogs: ProfHacker.

- Mullen, Lincoln (2012-03-20). ["Make Your Own E-Books with
  Pandoc"](http://chronicle.com/blogs/profhacker/make-your-own-e-books-with-pandoc/39067). The Chronicle of Higher Education Blogs: ProfHacker.

- Fenner, Martin (2013-12-12). ["From Markdown to JATS XML in one
  Step"](http://blog.martinfenner.org/2013/12/12/from-markdown-to-jats-xml-in-one-step/). Gobbledygook.

- McDaniel, W. Caleb (2012-09-28). ["Why (and How) I Wrote My Academic
  Book in Plain Text"](http://wcm1.web.rice.edu/my-academic-book-in-plain-text.html).

- Healy, Kieran (2014-01-23). ["Plain Text, Papers, Pandoc"](http://kieranhealy.org/blog/archives/2014/01/23/plain-text/).

- Till, Kaitlyn, Shed Simas, and Velma Larkai (2014-04-14). ["The Flying
  Narwhal: Small mag workflow"](http://tkbr.ccsp.sfu.ca/mpub/2014/04/14/the-flying-narwhal-small-mag-workflow/#more-639). Publishing @ SFU.

- Maxwell, John (2013-11-01). ["Building Publishing Workflows with
 Pandoc and Git"](http://www.ccsp.sfu.ca/2013/11/building-publishing-workflows-with-pandoc-and-git/). Publishing @ SFU.

- Maxwell, John (2014-02-26). ["On Pandoc"](http://tkbr.ccsp.sfu.ca:5001/Slides/On%20Pandoc). eBound Canada: Digital Production Workshop, Vancouver, BC.

- Puppet labs (2013-11-28).
  ["How We Automated our Ebook Builds with Pandoc and KindleGen."](http://puppetlabs.com/blog/automated-ebook-generation-convert-markdown-epub-mobi-pandoc-kindlegen).

- Fenner, Martin (2014-08-25).
  ["Using Microsoft Word with
  git."](http://blog.martinfenner.org/2014/08/25/using-microsoft-word-with-git/).

- Wouter Soudan (2015-12-02). ["From Word to Markdown to InDesign: 
   Fully automated typesetting."](http://rhythmus.be/md2indd/)

- Mattia Tezzele (2015-11-24), ["Typesetting automation: A Plain-text workflow for painless
  production of personal documents & offline
  correspondence---featuring Pandoc, LaTeX, and a simple
  makefile](http://mrzool.cc/writing/typesetting-automation/)

# Talks

- MacFarlane, John (2014-05-17). ["Pandoc for Haskell Hackers"](http://johnmacfarlane.net/BayHac2014/#/). BayHac 2014, Mountain View, CA.


