=head1 NAME

iPE::Sequence::Malign - Alignment sequence class for iPE.

=head1 DESCRIPTION

=head1 FUNCTIONS

=over 8

=cut

package iPE::Sequence::Malign;
use iPE;
use iPE::Util::DNATools;
use base ("iPE::Sequence");
use strict;

our @alphabet = ("A","C","G","T","_",".");
our %ambigCodes = ( R => [ "A", "G" ],
                    Y => [ "C", "T" ],
                    W => [ "A", "T" ],
                    S => [ "C", "G" ],
                    M => [ "A", "C" ],
                    K => [ "G", "T" ],
                    B => [ "C", "G", "T" ],
                    D => [ "A", "G", "T" ],
                    H => [ "A", "C", "T" ],
                    V => [ "A", "C", "G" ],
                    N => [ "A", "C", "G", "T" ],
                    "w" => [ "A", "C", "G", "T", "_", "." ]);
our $wildCard = "w";


# this isn't done in alignments
sub getAllSequences {}
sub expandAmbigSeq {}
sub getWildCardSeq {}

sub new {
    my $class = shift;
    my ($m) = @_;
    my $this = $class->SUPER::new(@_);

    return undef if not defined $this;
    $this->{seqNames_} = $this->seqReader->seqNames;
    $this->{numSeqs_}  = $this->seqReader->numSeqs;

    return $this;
}

=item seqRef (), rcRef ()

These functions are NOT present in the alignment sequence object, and should not be called.

=cut
sub seqRef { return undef }
sub rcRef  { return undef }

=item seqNames (), numSeqs ()

seqNames () returns the names of the sequences in the alignment.  These are defined when the sequenceReader is instantiated.  numSeqs is equivalent to the number of elements in the array reference returned by seqNames ().

=cut
sub seqNames { shift->{seqNames_}   }
sub numSeqs  { shift->{numSeqs_}    }

sub type { "malign" }

=back

=head1 SEE ALSO

L<iPE::Sequence>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)
(With much acknowledgement to Sam Gross's code).

=cut

1;
