=head1 NAME

NullRegion - A simple container class for a null region in the transcript.

=head1 DESCRIPTION

=head1 FUNCTIONS

=over 8

=cut

package iPE::Annotation::NullRegion;

use strict;

=item new (memberhash)

Creates a new NullRegion.  This contains the name of the sequence type and the name start and end values of the region itself.

=cut
sub new {
    my ($class, $m) = @_;

    die __PACKAGE__.": new() requires the following fields defined:\n".
        "start, end, and seqtype\n" 
        if(!defined($m->{start}) || !defined($m->{end}) || 
           !defined($m->{seqtype}));

    my $this = bless {}, $class;
    $this->{$_."_"} = $m->{$_} for (keys %$m);

    return $this;
}

=item start (), end ()

Return the start or end values of the NullRegion.

=item seqtype ()

Retruns the sequence type that this null region pertains to.

=cut
sub start   { shift->{start_}   }
sub end     { shift->{end_}     }
sub seqtype { shift->{seqtype_} }

=back

=head1 SEE ALSO

L<iPE::Annotation>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
