=head1 NAME

iPE::Model::Emission::SPLIT - A split model represented as one in a zoe file.

=head1 DESCRIPTION

This is a hack that was specifically designed for the heterogenous WAMM used for the Acceptor model in the original Burge thesis.  With this model, you can defined separate subsections of the larger model which may have different paramter sizes/types.

=head1 FUNCTIONS

=over 8

=cut

package iPE::Model::Emission::SPLIT;
use iPE;
use base ("iPE::Model::Emission");
use strict;

sub init {
    my ($this) = @_;

    unless($this->hasSettings) {
        #XXX deprecated.  remove when moving to settings format
        $this->settings->{zoeHeaderEnd} = $this->{data_};
    }

    $this->{chain_} = new iPE::Model::EmissionChain($this->name);
    for my $model (@{$this->submodels}) {
        $this->{chain_}->addEmission($model);
    }
    $this->{chain_}->init;
}

sub printSubmodelsToZhmm { $_[0]->settings->{printSubmodelsToZhmm} }
sub numZoeSubmodels { 
    if($_[0]->printSubmodelsToZhmm) { return scalar(@{$_[0]->submodels}) }
    else                            { return 0                           }
}

sub getZoeHeaderEnd {
    return (shift->settings->{zoeHeaderEnd} || "");
}

sub outputZoe {
    my ($this, $out, $mode) = @_;
    my @submodels = sort { $a->interval->cmp($b->interval) } 
        @{$this->submodels};
    $out->print ($out->indent.$this->getZoeHeader);
    $out->increaseIndent;
    for my $submodel (@submodels) {
        $out->print ($out->indent.$submodel->getZoeHeader)
            if($this->printSubmodelsToZhmm);
        $out->printPCData ($submodel->getParamString());
    }
    $out->decreaseIndent;
}

sub countRegion {
    my ($this, $region) = @_;
    $this->{chain_}->countRegion($region);
}

sub countNullRegion {
    my ($this, $region) = @_;
    $this->{chain_}->countNullRegion($region);
}

sub _adjustProb {
    my ($this, $pos, $letter, $prior, $null) = @_;

    for my $submodel (@{$this->submodels}) {
        if ($pos >= $submodel->interval->low->coord && 
                $pos <= $submodel->interval->high->coord) {
            if($null)   { $submodel->adjustNullProb($pos, $letter, $prior); }
            else        { $submodel->adjustPosProb($pos, $letter, $prior);  }
        }
    }
}

sub adjustPosProb  { _adjustProb(@_, 0) }
sub adjustNullProb { _adjustProb(@_, 1) }

sub setNullProb {
    my ($this, $pos, $letter, $prior) = @_;

    for my $submodel (@{$this->submodels}) {
        if ($pos >= $submodel->interval->low->coord && 
                $pos <= $submodel->interval->high->coord) {
            $submodel->setNullProb($pos, $letter, $prior);
        }
    }
}

=back

=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu).

=cut

1;
