/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class FallbackDateParser {
    private static final Logger LOG = Logger.getLogger(FallbackDateParser.class.getName());
    private static final String[] FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy'T'HH:mm:ss.SSS'Z'", "MM/dd/yyyy'T'HH:mm:ss.SSSZ", "MM/dd/yyyy'T'HH:mm:ss.SSS", "MM/dd/yyyy'T'HH:mm:ssZ", "MM/dd/yyyy'T'HH:mm:ss", "yyyy:MM:dd HH:mm:ss"};
    private List<DateFormat> dateParsers = new ArrayList<DateFormat>(FORMATS.length);
    private int activeDateParser;

    public FallbackDateParser() {
        for (int i = 0; i < FORMATS.length; ++i) {
            this.dateParsers.add(new SimpleDateFormat(FORMATS[i]));
        }
        this.activeDateParser = -1;
    }

    public Date parse(String date) {
        Object correctedDate = date.length() == 25 && date.charAt(22) == ':' ? date.substring(0, 22) + date.substring(23, 25) : date;
        if (this.activeDateParser >= 0) {
            try {
                return this.dateParsers.get(this.activeDateParser).parse((String)correctedDate);
            }
            catch (ParseException e) {
                this.activeDateParser = -1;
            }
        }
        for (int i = 0; i < this.dateParsers.size(); ++i) {
            try {
                Date result = this.dateParsers.get(i).parse((String)correctedDate);
                this.activeDateParser = i;
                return result;
            }
            catch (ParseException e) {
                LOG.log(Level.FINER, "Pattern " + i + " could not parse the date.", e);
                continue;
            }
        }
        throw new OsmosisRuntimeException("The date string (" + date + ") could not be parsed.");
    }
}

