/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.IndexElement;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStore;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;

public class IndexStore<K, T extends IndexElement<K>>
implements Completable {
    private ObjectSerializationFactory serializationFactory;
    private RandomAccessObjectStore<T> indexStore;
    private Comparator<K> ordering;
    private String tempFilePrefix;
    private File indexFile;
    private K previousKey;
    private boolean sorted;
    private long elementCount;
    private long elementSize;
    private boolean complete;

    public IndexStore(Class<T> elementType, Comparator<K> ordering, File indexFile) {
        this.ordering = ordering;
        this.indexFile = indexFile;
        this.serializationFactory = new SingleClassObjectSerializationFactory(elementType);
        this.indexStore = new RandomAccessObjectStore(this.serializationFactory, indexFile);
        this.sorted = true;
        this.elementCount = 0L;
        this.elementSize = -1L;
        this.complete = false;
    }

    public IndexStore(Class<T> elementType, Comparator<K> ordering, String tempFilePrefix) {
        this.ordering = ordering;
        this.tempFilePrefix = tempFilePrefix;
        this.serializationFactory = new SingleClassObjectSerializationFactory(elementType);
        this.indexStore = new RandomAccessObjectStore(this.serializationFactory, tempFilePrefix);
        this.sorted = true;
        this.elementCount = 0L;
        this.elementSize = -1L;
        this.complete = false;
    }

    public void write(T element) {
        long expectedOffset;
        if (this.complete) {
            throw new OsmosisRuntimeException("Cannot write new data once reading has begun.");
        }
        long fileOffset = this.indexStore.add(element);
        Object key = element.getKey();
        if (this.previousKey != null && this.ordering.compare(this.previousKey, key) > 0) {
            this.sorted = false;
        }
        this.previousKey = key;
        ++this.elementCount;
        if (this.elementCount == 2L) {
            this.elementSize = fileOffset;
        } else if (this.elementCount > 2L && (expectedOffset = (this.elementCount - 1L) * this.elementSize) != fileOffset) {
            throw new OsmosisRuntimeException("Inconsistent element sizes, new file offset=" + fileOffset + ", expected offset=" + expectedOffset + ", element size=" + this.elementSize + ", element count=" + this.elementCount);
        }
    }

    public IndexStoreReader<K, T> createReader() {
        return new IndexStoreReader<K, T>(this.indexStore.createReader(), this.ordering);
    }

    @Override
    public void complete() {
        if (!this.complete) {
            this.indexStore.complete();
            if (!this.sorted) {
                final Comparator<K> keyOrdering = this.ordering;
                try (FileBasedSort<IndexElement> fileSort = new FileBasedSort<IndexElement>(this.serializationFactory, new Comparator<T>(){
                    private Comparator<K> elementKeyOrdering;
                    {
                        this.elementKeyOrdering = keyOrdering;
                    }

                    @Override
                    public int compare(T o1, T o2) {
                        return this.elementKeyOrdering.compare(o1.getKey(), o2.getKey());
                    }
                }, true);){
                    try (RandomAccessObjectStoreReader<T> indexStoreReader = this.indexStore.createReader();){
                        Iterator<T> indexIterator = indexStoreReader.iterate();
                        while (indexIterator.hasNext()) {
                            fileSort.add((IndexElement)indexIterator.next());
                        }
                    }
                    this.indexStore.close();
                    this.indexStore = this.indexFile != null ? new RandomAccessObjectStore(this.serializationFactory, this.indexFile) : new RandomAccessObjectStore(this.serializationFactory, this.tempFilePrefix);
                    try (ReleasableIterator sortIterator = fileSort.iterate();){
                        while (sortIterator.hasNext()) {
                            this.indexStore.add((IndexElement)sortIterator.next());
                        }
                    }
                }
            }
            this.complete = true;
        }
    }

    @Override
    public void close() {
        this.indexStore.close();
    }
}

