/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.ChangeAsEntityComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class SortedDeltaChangePipeValidator
implements ChangeSinkChangeSource {
    private ChangeSink changeSink;
    private Comparator<ChangeContainer> comparator = new ChangeAsEntityComparator(new EntityContainerComparator(new EntityByTypeThenIdComparator()));
    private ChangeContainer previousChangeContainer;

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.changeSink.initialize(metaData);
    }

    @Override
    public void complete() {
        this.changeSink.complete();
    }

    @Override
    public void process(ChangeContainer changeContainer) {
        if (this.previousChangeContainer != null && this.comparator.compare(this.previousChangeContainer, changeContainer) >= 0) {
            throw new OsmosisRuntimeException("Pipeline entities are not sorted or contain multiple versions of a single entity, previous entity type=" + this.previousChangeContainer.getEntityContainer().getEntity().getType() + ", id=" + this.previousChangeContainer.getEntityContainer().getEntity().getId() + ", version=" + this.previousChangeContainer.getEntityContainer().getEntity().getVersion() + " current entity type=" + changeContainer.getEntityContainer().getEntity().getType() + ", id=" + changeContainer.getEntityContainer().getEntity().getId() + ", version=" + changeContainer.getEntityContainer().getEntity().getVersion() + ".");
        }
        this.changeSink.process(changeContainer);
        this.previousChangeContainer = changeContainer;
    }

    @Override
    public void close() {
        this.changeSink.close();
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }
}

