/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.runner;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.Osmosis;
import org.openstreetmap.osmosis.core.TaskRegistrar;
import org.openstreetmap.osmosis.core.pipeline.common.Pipeline;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.runner.OsmosisTask;

public class OsmosisRunner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Osmosis.class.getName());
    private final OsmosisTask inTask;
    private final OsmosisTask outTask;

    public OsmosisRunner(OsmosisTask inTask, OsmosisTask outTask) {
        this.inTask = inTask;
        this.outTask = outTask;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        LOG.info("Osmosis Version 0.49.2");
        TaskRegistrar taskRegistrar = new TaskRegistrar();
        taskRegistrar.loadPlugin(this.inTask.getLoader());
        taskRegistrar.loadPlugin(this.outTask.getLoader());
        Pipeline pipeline = new Pipeline(taskRegistrar.getFactoryRegister());
        LOG.info("Preparing pipeline.");
        ArrayList<TaskConfiguration> taskConfigurations = new ArrayList<TaskConfiguration>();
        taskConfigurations.add(this.inTask.getTaskConfiguration(1));
        taskConfigurations.add(this.outTask.getTaskConfiguration(2));
        pipeline.prepare(taskConfigurations);
        LOG.info("Launching pipeline execution.");
        pipeline.execute();
        LOG.info("Pipeline executing, waiting for completion.");
        pipeline.waitForCompletion();
        LOG.info("Pipeline complete.");
        LOG.info("Total execution time: " + (System.currentTimeMillis() - startTime) + " milliseconds.");
    }
}

