/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6;

import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.progress.v0_6.impl.ProgressTracker;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeProgressLogger
implements ChangeSinkChangeSource {
    private static final Logger LOG = Logger.getLogger(ChangeProgressLogger.class.getName());
    private ChangeSink changeSink;
    private ProgressTracker progressTracker;
    private String prefix;

    public ChangeProgressLogger(int interval, String label) {
        this.progressTracker = new ProgressTracker(interval);
        this.prefix = label != null && !label.equals("") ? "[" + label + "] " : "";
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.progressTracker.initialize();
        this.changeSink.initialize(metaData);
    }

    @Override
    public void process(ChangeContainer changeContainer) {
        Entity entity = changeContainer.getEntityContainer().getEntity();
        ChangeAction action = changeContainer.getAction();
        if (this.progressTracker.updateRequired()) {
            LOG.info(this.prefix + "Processing " + entity.getType() + " " + entity.getId() + " with action " + action + ", " + this.progressTracker.getObjectsPerSecond() + " objects/second.");
        }
        this.changeSink.process(changeContainer);
    }

    @Override
    public void complete() {
        LOG.info("Processing completion steps.");
        long start = System.currentTimeMillis();
        this.changeSink.complete();
        long duration = System.currentTimeMillis() - start;
        LOG.info("Completion steps took " + (double)duration / 1000.0 + " seconds.");
        LOG.info("Processing complete.");
    }

    @Override
    public void close() {
        this.changeSink.close();
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }
}

