/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.filter.common;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.filter.common.BitSetIdTracker;
import org.openstreetmap.osmosis.core.filter.common.DynamicIdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;
import org.openstreetmap.osmosis.core.filter.common.ListIdTracker;

public final class IdTrackerFactory {
    private IdTrackerFactory() {
    }

    public static IdTracker createInstance(IdTrackerType idTrackerType) {
        if (IdTrackerType.BitSet.equals((Object)idTrackerType)) {
            return new BitSetIdTracker();
        }
        if (IdTrackerType.IdList.equals((Object)idTrackerType)) {
            return new ListIdTracker();
        }
        if (IdTrackerType.Dynamic.equals((Object)idTrackerType)) {
            return new DynamicIdTracker();
        }
        throw new OsmosisRuntimeException("The IdTrackerType " + idTrackerType + " is not recognised.");
    }
}

