/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;

public class Way
extends Entity
implements Comparable<Way> {
    private List<WayNode> wayNodes;

    @Deprecated
    public Way(long id, int version, Date timestamp, OsmUser user, long changesetId) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId);
    }

    @Deprecated
    public Way(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId) {
        super(id, version, timestampContainer, user, changesetId);
        this.wayNodes = new ArrayList<WayNode>();
    }

    public Way(CommonEntityData entityData) {
        super(entityData);
        this.wayNodes = new ArrayList<WayNode>();
    }

    @Deprecated
    public Way(long id, int version, Date timestamp, OsmUser user, long changesetId, Collection<Tag> tags, List<WayNode> wayNodes) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId, tags, wayNodes);
    }

    @Deprecated
    public Way(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, Collection<Tag> tags, List<WayNode> wayNodes) {
        super(id, version, timestampContainer, user, changesetId, tags);
        this.wayNodes = new ArrayList<WayNode>(wayNodes);
    }

    public Way(CommonEntityData entityData, List<WayNode> wayNodes) {
        super(entityData);
        this.wayNodes = new ArrayList<WayNode>(wayNodes);
    }

    private Way(Way originalWay) {
        super(originalWay);
        this.wayNodes = new ArrayList<WayNode>(originalWay.wayNodes);
    }

    public Way(StoreReader sr, StoreClassRegister scr) {
        super(sr, scr);
        int featureCount = sr.readInteger();
        this.wayNodes = new ArrayList<WayNode>();
        for (int i = 0; i < featureCount; ++i) {
            this.wayNodes.add(new WayNode(sr, scr));
        }
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        super.store(sw, scr);
        sw.writeInteger(this.wayNodes.size());
        for (WayNode wayNode : this.wayNodes) {
            wayNode.store(sw, scr);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.Way;
    }

    public boolean equals(Object o) {
        if (o instanceof Way) {
            return this.compareTo((Way)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    protected int compareWayNodes(List<WayNode> comparisonWayNodes) {
        if (this.wayNodes.size() != comparisonWayNodes.size()) {
            return this.wayNodes.size() - comparisonWayNodes.size();
        }
        Iterator<WayNode> i = this.wayNodes.iterator();
        Iterator<WayNode> j = comparisonWayNodes.iterator();
        while (i.hasNext()) {
            int result = i.next().compareTo(j.next());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public int compareTo(Way comparisonWay) {
        int result;
        if (this.getId() < comparisonWay.getId()) {
            return -1;
        }
        if (this.getId() > comparisonWay.getId()) {
            return 1;
        }
        if (this.getVersion() < comparisonWay.getVersion()) {
            return -1;
        }
        if (this.getVersion() > comparisonWay.getVersion()) {
            return 1;
        }
        if (this.getTimestamp() == null && comparisonWay.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && comparisonWay.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && comparisonWay.getTimestamp() != null && (result = this.getTimestamp().compareTo(comparisonWay.getTimestamp())) != 0) {
            return result;
        }
        int wayNodeListResult = this.compareWayNodes(comparisonWay.getWayNodes());
        if (wayNodeListResult != 0) {
            return wayNodeListResult;
        }
        return this.compareTags(comparisonWay.getTags());
    }

    @Override
    public void makeReadOnly() {
        if (!this.isReadOnly()) {
            this.wayNodes = Collections.unmodifiableList(this.wayNodes);
        }
        super.makeReadOnly();
    }

    public List<WayNode> getWayNodes() {
        return this.wayNodes;
    }

    @Override
    public Way getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Way(this);
        }
        return this;
    }

    public boolean isClosed() {
        return this.wayNodes.get(0).getNodeId() == this.wayNodes.get(this.wayNodes.size() - 1).getNodeId();
    }

    public String toString() {
        String name = null;
        Collection<Tag> tags = this.getTags();
        for (Tag tag : tags) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("name")) continue;
            name = tag.getValue();
            break;
        }
        if (name != null) {
            return "Way(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", name='" + name + "')";
        }
        return "Way(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

