/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;

public class AuthenticationPropertiesLoader {
    private static final String KEY_HOST = "host";
    private static final String KEY_DATABASE = "database";
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_DBTYPE = "dbType";
    private final File propertiesFile;
    private Properties properties;

    public AuthenticationPropertiesLoader(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    private Properties loadProperties(File configFile) {
        Properties loadedProperties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            loadedProperties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to load properties from config file " + configFile + ".", e);
        }
        return loadedProperties;
    }

    public void updateLoginCredentials(DatabaseLoginCredentials loginCredentials) {
        if (this.properties == null) {
            this.properties = this.loadProperties(this.propertiesFile);
        }
        if (this.properties.containsKey(KEY_HOST)) {
            loginCredentials.setHost(this.properties.getProperty(KEY_HOST));
        }
        if (this.properties.containsKey(KEY_DATABASE)) {
            loginCredentials.setDatabase(this.properties.getProperty(KEY_DATABASE));
        }
        if (this.properties.containsKey(KEY_USER)) {
            loginCredentials.setUser(this.properties.getProperty(KEY_USER));
        }
        if (this.properties.containsKey(KEY_PASSWORD)) {
            loginCredentials.setPassword(this.properties.getProperty(KEY_PASSWORD));
        }
        if (this.properties.containsKey(KEY_DBTYPE)) {
            loginCredentials.setDbType(this.properties.getProperty(KEY_DBTYPE));
        }
    }
}

