/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistoryListReader;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;

public class EntitySnapshotReader
implements ReleasableIterator<EntityContainer> {
    private PeekableIterator<List<ChangeContainer>> sourceIterator;
    private Date snapshotInstant;
    private EntityContainer nextValue;
    private boolean nextValueLoaded;

    public EntitySnapshotReader(ReleasableIterator<ChangeContainer> sourceIterator, Date snapshotInstant) {
        this.sourceIterator = new PeekableIterator((ReleasableIterator)new EntityHistoryListReader(sourceIterator));
        this.snapshotInstant = snapshotInstant;
        this.nextValueLoaded = false;
    }

    public boolean hasNext() {
        while (!this.nextValueLoaded && this.sourceIterator.hasNext()) {
            List changeList = (List)this.sourceIterator.next();
            ChangeContainer changeContainer = null;
            for (ChangeContainer tmpChangeContainer : changeList) {
                if (tmpChangeContainer.getEntityContainer().getEntity().getTimestamp().compareTo(this.snapshotInstant) > 0) continue;
                changeContainer = tmpChangeContainer;
            }
            if (changeContainer == null || ChangeAction.Delete.equals((Object)changeContainer.getAction())) continue;
            this.nextValue = changeContainer.getEntityContainer();
            this.nextValueLoaded = true;
        }
        return this.nextValueLoaded;
    }

    public EntityContainer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextValueLoaded = false;
        return this.nextValue;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.sourceIterator.close();
    }
}

