/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6;

import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.database.DatabaseTaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkManager;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsimple.v0_6.PostgreSqlWriter;

public class PostgreSqlWriterFactory
extends DatabaseTaskManagerFactory {
    private static final String ARG_ENABLE_BBOX_BUILDER = "enableBboxBuilder";
    private static final String ARG_ENABLE_LINESTRING_BUILDER = "enableLinestringBuilder";
    private static final String ARG_ENABLE_KEEP_PARTIAL_LINESTRING = "enableKeepPartialLinestring";
    private static final String ARG_NODE_LOCATION_STORE_TYPE = "nodeLocationStoreType";
    private static final boolean DEFAULT_ENABLE_BBOX_BUILDER = false;
    private static final boolean DEFAULT_ENABLE_LINESTRING_BUILDER = false;
    private static final boolean DEFAULT_ENABLE_KEEP_PARTIAL_LINESTRING = false;
    private static final String DEFAULT_NODE_LOCATION_STORE_TYPE = "CompactTempFile";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        DatabaseLoginCredentials loginCredentials = this.getDatabaseLoginCredentials(taskConfig);
        DatabasePreferences preferences = this.getDatabasePreferences(taskConfig);
        boolean enableBboxBuilder = this.getBooleanArgument(taskConfig, ARG_ENABLE_BBOX_BUILDER, false);
        boolean enableLinestringBuilder = this.getBooleanArgument(taskConfig, ARG_ENABLE_LINESTRING_BUILDER, false);
        boolean enableKeepPartialLinestring = this.getBooleanArgument(taskConfig, ARG_ENABLE_KEEP_PARTIAL_LINESTRING, false);
        NodeLocationStoreType storeType = Enum.valueOf(NodeLocationStoreType.class, this.getStringArgument(taskConfig, ARG_NODE_LOCATION_STORE_TYPE, DEFAULT_NODE_LOCATION_STORE_TYPE));
        return new SinkManager(taskConfig.getId(), (Sink)new PostgreSqlWriter(loginCredentials, preferences, enableBboxBuilder, enableLinestringBuilder, enableKeepPartialLinestring, storeType), taskConfig.getPipeArgs());
    }
}

