/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6;

import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.CopyFilesetBuilder;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.CopyFilesetLoader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.TempCopyFileset;

public class PostgreSqlCopyWriter
implements Sink {
    private static final Logger LOG = Logger.getLogger(PostgreSqlCopyWriter.class.getName());
    private CopyFilesetBuilder copyFilesetBuilder;
    private CopyFilesetLoader copyFilesetLoader;
    private TempCopyFileset copyFileset;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private NodeLocationStoreType storeType;
    private boolean populateBbox;
    private boolean populateLinestring;
    private boolean enableKeepPartialLinestring;
    private boolean initialized;

    public PostgreSqlCopyWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, NodeLocationStoreType storeType, boolean enableKeepPartialLinestring) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.storeType = storeType;
        this.enableKeepPartialLinestring = enableKeepPartialLinestring;
        this.copyFileset = new TempCopyFileset();
    }

    private void initialize() {
        if (!this.initialized) {
            LOG.fine("Initializing the database and temporary processing files.");
            try (DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);){
                DatabaseCapabilityChecker capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
                this.populateBbox = capabilityChecker.isWayBboxSupported();
                this.populateLinestring = capabilityChecker.isWayLinestringSupported();
                this.copyFilesetBuilder = new CopyFilesetBuilder(this.copyFileset, this.populateBbox, this.populateLinestring, this.enableKeepPartialLinestring, this.storeType);
                this.copyFilesetLoader = new CopyFilesetLoader(this.loginCredentials, this.preferences, this.copyFileset);
                LOG.fine("Processing input data, building geometries and creating database load files.");
            }
            this.initialized = true;
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(EntityContainer entityContainer) {
        this.initialize();
        this.copyFilesetBuilder.process(entityContainer);
    }

    public void complete() {
        this.initialize();
        LOG.fine("All data has been received, beginning database load.");
        this.copyFilesetBuilder.complete();
        this.copyFilesetLoader.run();
        LOG.fine("Processing complete.");
    }

    public void close() {
        this.copyFilesetBuilder.close();
        this.copyFileset.close();
        this.initialized = false;
    }
}

