/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.binary.BinaryWriter;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Completable;

public class CopyFileWriter
implements Completable {
    private static Logger log = Logger.getLogger(CopyFileWriter.class.getName());
    private File file;
    private boolean initialized;
    private BufferedWriter writer;
    private boolean midRecord;
    private SimpleDateFormat dateFormat;
    private BinaryWriter postgisBinaryWriter;

    public CopyFileWriter(File file) {
        this.file = file;
        this.midRecord = false;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        this.postgisBinaryWriter = new BinaryWriter();
    }

    private void separateField() throws IOException {
        if (this.midRecord) {
            this.writer.write(9);
        } else {
            this.midRecord = true;
        }
    }

    public void writeField(boolean data) {
        this.initialize();
        try {
            this.separateField();
            if (data) {
                this.writer.write("t");
            } else {
                this.writer.write("f");
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    public void writeField(int data) {
        this.initialize();
        try {
            this.separateField();
            this.writer.write(Integer.toString(data));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    public void writeField(long data) {
        this.initialize();
        try {
            this.separateField();
            this.writer.write(Long.toString(data));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    private String escapeString(String data) {
        if (data == null) {
            return "\\N";
        }
        StringBuilder result = new StringBuilder(data.length());
        char[] dataArray = data.toCharArray();
        block9: for (int i = 0; i < dataArray.length; ++i) {
            char currentChar = dataArray[i];
            switch (currentChar) {
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\u000b': {
                    result.append("\\v");
                    continue block9;
                }
                default: {
                    result.append(currentChar);
                }
            }
        }
        return result.toString();
    }

    public void writeField(String data) {
        this.initialize();
        try {
            this.separateField();
            this.writer.write(this.escapeString(data));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    public void writeField(Date data) {
        this.initialize();
        try {
            this.separateField();
            this.writer.write(this.dateFormat.format(data));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    public void writeField(Geometry data) {
        this.initialize();
        try {
            this.separateField();
            if (data == null) {
                this.writer.write(this.escapeString(null));
            } else {
                this.writer.write(this.postgisBinaryWriter.writeHexed(data));
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write value (" + data + ")", (Throwable)e);
        }
    }

    public void endRecord() {
        try {
            this.writer.newLine();
            this.midRecord = false;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to end record.", (Throwable)e);
        }
    }

    private void initialize() {
        if (!this.initialized) {
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.file), 65536), "UTF-8"));
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open file for writing.", (Throwable)e);
            }
            this.initialized = true;
        }
    }

    public void complete() {
        this.initialize();
        try {
            if (this.midRecord) {
                throw new OsmosisRuntimeException("The current record has not been ended.");
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to complete writing to the data stream.", (Throwable)e);
        }
        finally {
            this.initialized = false;
            this.writer = null;
        }
    }

    public void close() {
        try {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to close writer.", e);
            }
        }
        finally {
            this.initialized = false;
            this.writer = null;
        }
    }
}

