/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.common;

import java.util.Objects;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.springframework.jdbc.core.JdbcTemplate;

public class SchemaVersionValidator {
    private static final String SELECT_SQL = "SELECT version FROM schema_info";
    private DatabasePreferences preferences;
    private JdbcTemplate jdbcTemplate;
    private boolean validated;

    public SchemaVersionValidator(JdbcTemplate jdbcTemplate, DatabasePreferences preferences) {
        this.jdbcTemplate = jdbcTemplate;
        this.preferences = preferences;
    }

    public void validateVersion(int expectedVersion) {
        if (!this.validated) {
            this.validateDBVersion(expectedVersion);
            this.validated = true;
        }
    }

    private void validateDBVersion(int expectedVersion) {
        int dbVersion;
        if (this.preferences.getValidateSchemaVersion() && (dbVersion = Objects.requireNonNull((Integer)this.jdbcTemplate.queryForObject(SELECT_SQL, Integer.class), "Schema version was not found").intValue()) != expectedVersion) {
            throw new OsmosisRuntimeException("The database schema version of " + dbVersion + " does not match the expected version of " + expectedVersion + ".");
        }
    }
}

