/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.geometry.binary;

import net.postgis.jdbc.geometry.binary.ByteSetter;

public abstract class ValueSetter {
    ByteSetter data;
    int position = 0;
    public final byte endian;

    public ValueSetter(ByteSetter data, byte endian) {
        this.data = data;
        this.endian = endian;
    }

    public void setByte(byte value) {
        this.data.set(value, this.position);
        ++this.position;
    }

    public void setInt(int value) {
        this.setInt(value, this.position);
        this.position += 4;
    }

    public void setLong(long value) {
        this.setLong(value, this.position);
        this.position += 8;
    }

    protected abstract void setInt(int var1, int var2);

    protected abstract void setLong(long var1, int var3);

    public void setDouble(double data) {
        long bitrep = Double.doubleToLongBits(data);
        this.setLong(bitrep);
    }

    public String toString() {
        String name = this.getClass().getName();
        int pointpos = name.lastIndexOf(46);
        String klsName = name.substring(pointpos + 1);
        return klsName + "('" + (this.data == null ? "NULL" : this.data.toString() + "')");
    }

    public static class NDR
    extends ValueSetter {
        public static final byte NUMBER = 1;

        public NDR(ByteSetter data) {
            super(data, (byte)1);
        }

        @Override
        protected void setInt(int value, int index) {
            this.data.set((byte)(value >>> 24), index + 3);
            this.data.set((byte)(value >>> 16), index + 2);
            this.data.set((byte)(value >>> 8), index + 1);
            this.data.set((byte)value, index);
        }

        @Override
        protected void setLong(long value, int index) {
            this.data.set((byte)(value >>> 56), index + 7);
            this.data.set((byte)(value >>> 48), index + 6);
            this.data.set((byte)(value >>> 40), index + 5);
            this.data.set((byte)(value >>> 32), index + 4);
            this.data.set((byte)(value >>> 24), index + 3);
            this.data.set((byte)(value >>> 16), index + 2);
            this.data.set((byte)(value >>> 8), index + 1);
            this.data.set((byte)value, index);
        }
    }

    public static class XDR
    extends ValueSetter {
        public static final byte NUMBER = 0;

        public XDR(ByteSetter data) {
            super(data, (byte)0);
        }

        @Override
        protected void setInt(int value, int index) {
            this.data.set((byte)(value >>> 24), index);
            this.data.set((byte)(value >>> 16), index + 1);
            this.data.set((byte)(value >>> 8), index + 2);
            this.data.set((byte)value, index + 3);
        }

        @Override
        protected void setLong(long value, int index) {
            this.data.set((byte)(value >>> 56), index);
            this.data.set((byte)(value >>> 48), index + 1);
            this.data.set((byte)(value >>> 40), index + 2);
            this.data.set((byte)(value >>> 32), index + 3);
            this.data.set((byte)(value >>> 24), index + 4);
            this.data.set((byte)(value >>> 16), index + 5);
            this.data.set((byte)(value >>> 8), index + 6);
            this.data.set((byte)value, index + 7);
        }
    }
}

