/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vec extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora de\u2019l meridian de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ora normale de Apia",
               "",
               "Ora d\u2019ist\u00e0 de Apia",
               "",
               "Ora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Ora normale de le \u00cczole Cook",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Cook",
               "",
               "Ora de le \u00cczole Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora normale de Cuba",
               "CST",
               "Ora d\u2019ist\u00e0 de Cuba",
               "CDT",
               "Ora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Ora normale de le \u00cczole Fiji",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Fiji",
               "",
               "Ora de le \u00cczole Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora de\u2019l Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora normale de Hovd",
               "",
               "Ora d\u2019ist\u00e0 de Hovd",
               "",
               "Ora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ora normale de l\u2019Iran",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Iran",
               "",
               "Ora de l\u2019Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Ora de l\u2019\u00cczola Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora normale de Omsk",
               "",
               "Ora d\u2019ist\u00e0 de Omsk",
               "",
               "Ora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ora normale de\u2019l Per\u00f9",
               "",
               "Ora d\u2019ist\u00e0 de\u2019l Per\u00f9",
               "",
               "Ora de\u2019l Per\u00f9",
               "",
            };
        final String[] Truk = new String[] {
               "Ora de\u2019l Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora de l\u2019Atolo Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora normale de\u2019l Cile",
               "",
               "Ora d\u2019ist\u00e0 de\u2019l Cile",
               "",
               "Ora de\u2019l Cile",
               "",
            };
        final String[] China = new String[] {
               "Ora normale de la Sina",
               "CST",
               "Ora d\u2019ist\u00e0 de la Sina",
               "CDT",
               "Ora de la Sina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ora de le \u00cczole Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora de l\u2019India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ora normale de\u2019l Japon",
               "JST",
               "Ora d\u2019ist\u00e0 de\u2019l Japon",
               "JDT",
               "Ora de\u2019l Japon",
               "JT",
            };
        final String[] Korea = new String[] {
               "Ora normale de la Cor\u00e8a",
               "KST",
               "Ora d\u2019ist\u00e0 de la Cor\u00e8a",
               "KST",
               "Ora de la Cor\u00e8a",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ora de l\u2019\u00cczola Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora de\u2019l Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora de le \u00cczole Pal\u00e0u",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora normale de le \u00cczole Sam\u00f2a",
               "SST",
               "Ora d\u2019ist\u00e0 de le \u00cczole Sam\u00f2a",
               "SST",
               "Ora de le \u00cczole Sam\u00f2a",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora normale de le \u00cczole Tonga",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Tonga",
               "",
               "Ora de le \u00cczole Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Ora de\u2019l Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ora normale de l\u2019Alaska",
               "AKST",
               "Ora d\u2019ist\u00e0 de l\u2019Alaska",
               "AKDT",
               "Ora de l\u2019Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ora normale de l\u2019Amasonia",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Amasonia",
               "",
               "Ora de l\u2019Amasonia",
               "",
            };
        final String[] Azores = new String[] {
               "Ora normale de le Azore",
               "",
               "Ora d\u2019ist\u00e0 de le Azore",
               "",
               "Ora de le Azore",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora de\u2019l Butan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora de\u2019l Brun\u00e9i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora normale de l\u2019\u00cczola de Pascua",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019\u00cczola de Pascua",
               "",
               "Ora de l\u2019\u00cczola de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora de la Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ora normale de Izraele",
               "IST",
               "Ora d\u2019ist\u00e0 de Izraele",
               "IDT",
               "Ora de Izraele",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ora de l\u2019\u00cczola Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora normale de Mosca",
               "MSK",
               "Ora d\u2019ist\u00e0 de Mosca",
               "MSK",
               "Ora de Mosca",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ora de l\u2019\u00cczola Ponp\u00e8i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora de l\u2019\u00cczola Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora normale de Taip\u00e9i",
               "CST",
               "Ora d\u2019ist\u00e0 de Taip\u00e9i",
               "CDT",
               "Ora de Taip\u00e9i",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Ora de le \u00cczole Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora de le \u00cczole Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora normale de l\u2019Arabia",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Arabia",
               "",
               "Ora de l\u2019Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora normale de l\u2019Armenia",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Armenia",
               "",
               "Ora de l\u2019Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora de la Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora normale de le \u00cczole Ciatem",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Ciatem",
               "",
               "Ora de le \u00cczole Ciatem",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ora universale coordenada",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora de l\u2019\u00c8cuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora de le \u00cczole Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora normale de la Jeorja",
               "",
               "Ora d\u2019ist\u00e0 de la Jeorja",
               "",
               "Ora de la Jeorja",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora normale de Irkutsk",
               "",
               "Ora d\u2019ist\u00e0 de Irkutsk",
               "",
               "Ora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora normale de Magadan",
               "",
               "Ora d\u2019ist\u00e0 de Magadan",
               "",
               "Ora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora de Myanmar (Birmania)",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora normale de l\u2019\u00cczola Norfolk",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019\u00cczola Norfolk",
               "",
               "Ora de l\u2019\u00cczola Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora normale de Fernando de Noronha",
               "",
               "Ora d\u2019ist\u00e0 de Fernando de Noronha",
               "",
               "Ora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora de l\u2019\u00cczola Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora de le \u00cczole Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora de le \u00cczole Tokel\u00e0u",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora normale de l\u2019Urugu\u00e0i",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Urugu\u00e0i",
               "",
               "Ora de l\u2019Urugu\u00e0i",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora normale de le \u00cczole Vanuatu",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Vanuatu",
               "",
               "Ora de le \u00cczole Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora normale de Yakutsk",
               "",
               "Ora d\u2019ist\u00e0 de Yakutsk",
               "",
               "Ora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora normale de\u2019l nord m\u00e8rega de l\u2019Atl\u00e0ntego",
               "AST",
               "Ora d\u2019ist\u00e0 de\u2019l nord m\u00e8rega de l\u2019Atl\u00e0ntego",
               "AST",
               "Ora de\u2019l nord m\u00e8rega de l\u2019Atl\u00e0ntego",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Ora normale de Brazilia",
               "",
               "Ora d\u2019ist\u00e0 de Brazilia",
               "",
               "Ora de Brazilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora de Chamoro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Ora normale de la Colonbia",
               "",
               "Ora d\u2019ist\u00e0 de la Colonbia",
               "",
               "Ora de la Colonbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora normale de le \u00cczole Malvine",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Malvine",
               "",
               "Ora de le \u00cczole Malvine",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora de la Malezia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora de le \u00cczole Maldive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora normale de Ulan B\u00e0tor",
               "",
               "Ora d\u2019ist\u00e0 de Ulan B\u00e0tor",
               "",
               "Ora de Ulan B\u00e0tor",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora normale de\u2019l Pakistan",
               "PKT",
               "Ora d\u2019ist\u00e0 de\u2019l Pakistan",
               "PKST",
               "Ora de\u2019l Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Ora normale de\u2019l Paragu\u00e0i",
               "",
               "Ora d\u2019ist\u00e0 de\u2019l Paragu\u00e0i",
               "",
               "Ora de\u2019l Paragu\u00e0i",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora de le \u00cczole Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora normale de Sakalin",
               "",
               "Ora d\u2019ist\u00e0 de Sakalin",
               "",
               "Ora de Sakalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora de\u2019l Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora normale de l\u2019Arjentina",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Arjentina",
               "",
               "Ora de l\u2019Arjentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora de l\u2019\u00cczola de Nadale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora de le Gal\u00e0pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora normale de Hong Kong",
               "HKT",
               "Ora d\u2019ist\u00e0 de Hong Kong",
               "HKST",
               "Ora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ora de l\u2019Indosina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora de\u2019l Kirghizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora normale de l\u2019\u00cczola Lord Howe",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019\u00cczola Lord Howe",
               "",
               "Ora de l\u2019\u00cczola Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora de le \u00cczole Marchezi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora normale de le \u00cczole Maurisio",
               "",
               "Ora d\u2019ist\u00e0 de le \u00cczole Maurisio",
               "",
               "Ora de le \u00cczole Maurisio",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora de Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora de\u2019l Venesuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Ora normale de Volgogrado",
               "MSK",
               "Ora d\u2019ist\u00e0 de Volgogrado",
               "MSK",
               "Ora de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Ora normale de l\u2019Azerbaijan",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Azerbaijan",
               "",
               "Ora de l\u2019Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora normale de\u2019l Bangladesh",
               "",
               "Ora d\u2019ist\u00e0 de\u2019l Bangladesh",
               "",
               "Ora de\u2019l Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora normale de Cao Verdo",
               "",
               "Ora d\u2019ist\u00e0 de Cao Verdo",
               "",
               "Ora de Cao Verdo",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora de\u2019l Timor Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora d\u2019ist\u00e0 de le \u00cczole Seisel",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora de\u2019l Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora normale de l\u2019Uzbekistan",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Uzbekistan",
               "",
               "Ora de l\u2019Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora de l\u2019Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora normale de Krasnoyarsk",
               "",
               "Ora d\u2019ist\u00e0 de Krasnoyarsk",
               "",
               "Ora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora normale de la Nova Zelanda",
               "NZST",
               "Ora d\u2019ist\u00e0 de la Nova Zelanda",
               "NZDT",
               "Ora de la Nova Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora normale de Novosibirsk",
               "",
               "Ora d\u2019ist\u00e0 de Novosibirsk",
               "",
               "Ora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora normale de le \u00cczole Filipine",
               "PST",
               "Ora d\u2019ist\u00e0 de le \u00cczole Filipine",
               "PDT",
               "Ora de le \u00cczole Filipine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Ora normale de Vladivostok",
               "",
               "Ora d\u2019ist\u00e0 de Vladivostok",
               "",
               "Ora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora de l\u2019Os\u00e8ano Indian",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora de le \u00cczole Ecuatoriali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora normale de Teranova",
               "NST",
               "Ora d\u2019ist\u00e0 de Teranova",
               "NDT",
               "Ora de Teranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora normale de\u2019l Turkmenistan",
               "",
               "Ora d\u2019ist\u00e0 de\u2019l Turkmenistan",
               "",
               "Ora de\u2019l Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora de la Guyana franseze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora normale de la Nova Caledonia",
               "",
               "Ora d\u2019ist\u00e0 de la Nova Caledonia",
               "",
               "Ora de la Nova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora de la Georgia de\u2019l sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora normale de Ekaterinburgo",
               "",
               "Ora d\u2019ist\u00e0 de Ekaterinburgo",
               "",
               "Ora de Ekaterinburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora de l\u2019\u00c0frega sentrale",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora de l\u2019\u00c0frega orientale",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ora normale de l\u2019\u00c0frega osidentale",
               "WAT",
               "Ora d\u2019ist\u00e0 de l\u2019\u00c0frega osidentale",
               "WAT",
               "Ora de l\u2019\u00c0frega osidentale",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora de Dumont d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora normale de l\u2019Europa sentrale",
               "CET",
               "Ora d\u2019ist\u00e0 de l\u2019Europa sentrale",
               "CEST",
               "Ora de l\u2019Europa sentrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora normale de l\u2019Europa orientale",
               "EET",
               "Ora d\u2019ist\u00e0 de l\u2019Europa orientale",
               "EEST",
               "Ora de l\u2019Europa orientale",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ora normale de l\u2019Europa osidentale",
               "WET",
               "Ora d\u2019ist\u00e0 de l\u2019Europa osidentale",
               "WEST",
               "Ora de l\u2019Europa osidentale",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora normale de\u2019l M\u00e8sego de\u2019l Pas\u00ecfego",
               "MST",
               "Ora d\u2019ist\u00e0 de\u2019l M\u00e8sego de\u2019l Pas\u00ecfego",
               "MDT",
               "Ora de\u2019l M\u00e8sego de\u2019l Pas\u00ecfego",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora de l\u2019\u00c0frega meridionale",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ora normale de\u2019l nord m\u00e8rega sentrale",
               "CST",
               "Ora d\u2019ist\u00e0 de\u2019l nord m\u00e8rega sentrale",
               "CDT",
               "Ora de\u2019l nord m\u00e8rega sentrale",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ora normale de\u2019l nord m\u00e8rega orientale",
               "EST",
               "Ora d\u2019ist\u00e0 de\u2019l nord m\u00e8rega orientale",
               "EST",
               "Ora de\u2019l nord m\u00e8rega orientale",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Ora normale de\u2019l nord m\u00e8rega de\u2019l Pas\u00ecfego",
               "PST",
               "Ora d\u2019ist\u00e0 de\u2019l nord m\u00e8rega de\u2019l Pas\u00ecfego",
               "PDT",
               "Ora de\u2019l nord m\u00e8rega de\u2019l Pas\u00ecfego",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ora de le Tere fransezi de\u2019l sud e de l\u2019Ant\u00e0rtego",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora de le \u00cczole Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora normale de Hawai e Aleutine",
               "HST",
               "Ora d\u2019ist\u00e0 de Hawai e Aleutine",
               "HST",
               "Ora de Hawai e Aleutine",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora de le \u00cczole Fenize",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora normale de S. Piero e Michelon",
               "",
               "Ora d\u2019ist\u00e0 de S. Piero e Michelon",
               "",
               "Ora de S. Piero e Michelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora normale de\u2019l nord m\u00e8rega de le montagne",
               "MST",
               "Ora d\u2019ist\u00e0 de\u2019l nord m\u00e8rega de le montagne",
               "MST",
               "Ora de\u2019l nord m\u00e8rega de le montagne",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora de le \u00cczole Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora de la Papua Nova Guin\u00e8a",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora normale de l\u2019Australia sentrale",
               "ACST",
               "Ora d\u2019ist\u00e0 de l\u2019Australia sentrale",
               "ACDT",
               "Ora de l\u2019Australia sentrale",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora normale de l\u2019Australia orientale",
               "AEST",
               "Ora d\u2019ist\u00e0 de l\u2019Australia orientale",
               "AEDT",
               "Ora de l\u2019Australia orientale",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ora normale de l\u2019Australia osidentale",
               "AWST",
               "Ora d\u2019ist\u00e0 de l\u2019Australia osidentale",
               "AWDT",
               "Ora de l\u2019Australia osidentale",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora de l\u2019Indonezia sentrale",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora de l\u2019Indonezia orientale",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora de l\u2019Indonezia osidentale",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora de\u2019l Kazakistan osidentale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora normale de l\u2019Australia sentro osidentale",
               "",
               "Ora d\u2019ist\u00e0 de l\u2019Australia sentro osidentale",
               "",
               "Ora de l\u2019Australia sentro osidentale",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 irlandeze",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 irlandeze",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Ora de\u2019l meridian de Greenwich",
                    "GMT",
                    "Ora d\u2019ist\u00e0 brit\u00e0nega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Akt\u00e0u" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "timezone.excity.Asia/Dubai", "Dub\u00e0i" },
            { "timezone.excity.Asia/Macau", "Mac\u00e0o" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyr\u00e0u" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e9i" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9i" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urumchi" },
            { "timezone.excity.Etc/Unknown", "Sit\u00e0 desconos\u00f9a" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Ozlo" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "El Cairo" },
            { "timezone.excity.Africa/Ceuta", "C\u00e8uta" },
            { "timezone.excity.Africa/Tunis", "T\u00f9nezi" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Colombo", "Colonbo" },
            { "timezone.excity.Asia/Tbilisi", "Tiblisi" },
            { "timezone.excity.Asia/Thimphu", "Tinpu" },
            { "timezone.excity.Asia/Yerevan", "J\u00e8revan" },
            { "timezone.excity.Europe/Paris", "Pariji" },
            { "timezone.excity.Indian/Cocos", "\u00cczole Cocos" },
            { "timezone.excity.Pacific/Niue", "\u00cczola Niue" },
            { "timezone.excity.Pacific/Truk", "\u00cczole Chuuk" },
            { "timezone.excity.Pacific/Wake", "Atolo Wake" },
            { "timezone.excity.Africa/Asmera", "Azmara" },
            { "timezone.excity.Africa/Bangui", "Bangh\u00ec" },
            { "timezone.excity.Africa/Bissau", "Bis\u00e0o" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Maseru", "Mazeru" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00f9" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostan\u00e0i" },
            { "timezone.excity.Asia/Shanghai", "Shangh\u00e0i" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Lisbon", "Lizbona" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Monaco", "M\u00f2naco" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsavia" },
            { "timezone.excity.Europe/Zurich", "Zurigo" },
            { "timezone.excity.Indian/Chagos", "Ciagos" },
            { "timezone.excity.Indian/Comoro", "\u00cczole Comore" },
            { "timezone.excity.Pacific/Efate", "\u00cczola Efate" },
            { "timezone.excity.Pacific/Nauru", "\u00cczola Nauru" },
            { "timezone.excity.Pacific/Palau", "Pal\u00e0u" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abijan" },
            { "timezone.excity.Africa/Algiers", "Aljeri" },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Africa/Kampala", "Kanpala" },
            { "timezone.excity.Africa/Mbabane", "Nbabane" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00ecpoli" },
            { "timezone.excity.America/Bogota", "Bogot\u00e0" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e0" },
            { "timezone.excity.America/Denver", "D\u00e8nver" },
            { "timezone.excity.America/Havana", "L\u2019Avana" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Panama", "P\u00e0nama" },
            { "timezone.excity.Asia/Famagusta", "Famagosta" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzaleme" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vategan" },
            { "timezone.excity.Indian/Mayotte", "\u00cczole Maiote" },
            { "timezone.excity.Indian/Reunion", "\u00cczola Reunion" },
            { "timezone.excity.Pacific/Easter", "\u00cczola de Pascua" },
            { "timezone.excity.Pacific/Kanton", "Atolo Canton" },
            { "timezone.excity.Pacific/Kosrae", "\u00cczola Kosrae" },
            { "timezone.excity.Pacific/Midway", "Atolo Midway" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Ponape", "\u00cczola Ponp\u00e8i" },
            { "timezone.excity.Pacific/Saipan", "\u00cczola Saip\u00e0n" },
            { "timezone.excity.Pacific/Tahiti", "\u00cczola Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Atollo Tarawa" },
            { "timezone.excity.Pacific/Wallis", "\u00cczola Wallis" },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ajun" },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "timezone.excity.Africa/Ndjamena", "Jamena" },
            { "timezone.excity.Africa/Sao_Tome", "\u00cczola S. Tomazo" },
            { "timezone.excity.America/Cayenne", "Cayena" },
            { "timezone.excity.America/Cordoba", "C\u00f2rdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Jamaica", "Jam\u00e0ega" },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.America/Tortola", "T\u00f2rtola" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom Pen" },
            { "timezone.excity.Atlantic/Azores", "\u00cczole Azore" },
            { "timezone.excity.Atlantic/Canary", "\u00cczole Canarie" },
            { "timezone.excity.Atlantic/Faeroe", "\u00cczole F\u00e0roe" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Istanbul", "\u00ccstanbul" },
            { "timezone.excity.Indian/Maldives", "\u00cczole Maldive" },
            { "timezone.excity.Pacific/Chatham", "\u00cczole Ciatem" },
            { "timezone.excity.Pacific/Fakaofo", "Atolo Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "\u00cczole Gambier" },
            { "timezone.excity.Pacific/Norfolk", "\u00cczola Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujunbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiso" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Asunsion" },
            { "timezone.excity.America/Dominica", "Dom\u00e9nega" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Miquelon", "Michelon" },
            { "timezone.excity.America/St_Johns", "S. Joani" },
            { "timezone.excity.America/St_Kitts", "S. Cristofer" },
            { "timezone.excity.America/St_Lucia", "S. Lus\u00eca" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan B\u00e0tor" },
            { "timezone.excity.Atlantic/Madeira", "\u00cczola Mad\u00e8ira" },
            { "timezone.excity.Europe/Amsterdam", "\u00c0msterdam" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Jibiltera" },
            { "timezone.excity.Europe/Ljubljana", "Lubliana" },
            { "timezone.excity.Europe/Podgorica", "Podgorisa" },
            { "timezone.excity.Europe/Stockholm", "Stocolma" },
            { "timezone.excity.Indian/Christmas", "\u00cczola de Nadale" },
            { "timezone.excity.Indian/Mauritius", "\u00cczole Maurisio" },
            { "timezone.excity.Pacific/Funafuti", "Atolo Funafuti" },
            { "timezone.excity.Pacific/Pitcairn", "\u00cczola Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Cazablanca" },
            { "timezone.excity.Africa/Lubumbashi", "Lubunbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nuakchot" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Monterrey", "Monterey" },
            { "timezone.excity.America/Sao_Paulo", "San Polo" },
            { "timezone.excity.America/St_Thomas", "S. Tomazo" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lunpur" },
            { "timezone.excity.Europe/Bratislava", "Bratizlava" },
            { "timezone.excity.Europe/Copenhagen", "Copenaghen" },
            { "timezone.excity.Europe/Luxembourg", "Lusenburgo" },
            { "timezone.excity.Europe/San_Marino", "San Marin" },
            { "timezone.excity.Europe/Simferopol", "Sinfer\u00f2poli" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e0pagos" },
            { "timezone.excity.Pacific/Kwajalein", "Atolo Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "\u00cczole Marchezi" },
            { "timezone.excity.Pacific/Pago_Pago", "Pango Pango" },
            { "timezone.excity.Pacific/Rarotonga", "\u00cczola Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "\u00cczola Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadug\u00f9" },
            { "timezone.excity.America/Guadeloupe", "Guadalupa" },
            { "timezone.excity.America/Martinique", "Martiniga" },
            { "timezone.excity.America/Montserrat", "Montserat" },
            { "timezone.excity.America/St_Vincent", "S. Vincenso" },
            { "timezone.excity.Atlantic/Reykjavik", "Rekiavik" },
            { "timezone.excity.Atlantic/St_Helena", "\u00cczola S. Elena" },
            { "timezone.excity.Australia/Adelaide", "Adel\u00e0ide" },
            { "timezone.excity.Australia/Brisbane", "Brizbane" },
            { "timezone.excity.Europe/Isle_of_Man", "\u00cczola de Man" },
            { "timezone.excity.Pacific/Kiritimati", "Atolo Kiritimati" },
            { "timezone.excity.America/Los_Angeles", "Los \u00c0ngeles" },
            { "timezone.excity.America/Mexico_City", "Sit\u00e0 de\u2019l M\u00e8sego" },
            { "timezone.excity.America/Puerto_Rico", "Portorico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cao Verdo" },
            { "timezone.excity.Australia/Lord_Howe", "\u00cczola Lord Howe" },
            { "timezone.excity.Pacific/Guadalcanal", "\u00cczola Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salam" },
            { "timezone.excity.America/Campo_Grande", "Canpo Grande" },
            { "timezone.excity.America/Indiana/Knox", "Knox (Indiana)" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e0polis" },
            { "timezone.excity.Antarctica/Macquarie", "\u00cczola Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "\u00cczola Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Porto Moresby" },
            { "timezone.excity.America/Ciudad_Juarez", "Ju\u00e1rez" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay (Indiana)" },
            { "timezone.excity.America/Port_of_Spain", "Porto de Spagna" },
            { "timezone.excity.America/St_Barthelemy", "S. Bartolom\u00e8o" },
            { "timezone.excity.America/Bahia_Banderas", "Baia de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Pr\u00ecnsipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia de\u2019l sud" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo (Indiana)" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac (Indiana)" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City (Indiana)" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes (Indiana)" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg (Indiana)" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello (Kentucky)" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah (Nord Dakota)" },
            { "timezone.excity.America/North_Dakota/Center", "Center (Nord Dakota)" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio G\u00e0legos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem (Nord Dakota)" },
        };
        return data;
    }
}
