/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichtid",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "v\u00e4stbrasiliansk normaltid",
               "",
               "v\u00e4stbrasiliansk sommartid",
               "",
               "v\u00e4stbrasiliansk tid",
               "",
            };
        final String[] Apia = new String[] {
               "Apia, normaltid",
               "",
               "Apia, sommartid",
               "",
               "Apiatid",
               "",
            };
        final String[] Cook = new String[] {
               "Cook\u00f6arnas normaltid",
               "",
               "Cook\u00f6arnas sommartid",
               "",
               "Cook\u00f6arnas tid",
               "",
            };
        final String[] Cuba = new String[] {
               "kubansk normaltid",
               "CST",
               "kubansk sommartid",
               "CDT",
               "kubansk tid",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji, normaltid",
               "",
               "Fiji, sommartid",
               "",
               "Fijitid",
               "",
            };
        final String[] Gulf = new String[] {
               "Persiska vikentid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Chovd, normaltid",
               "",
               "Chovd, sommartid",
               "",
               "Chovdtid",
               "",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "",
               "iransk sommartid",
               "",
               "iransk tid",
               "",
            };
        final String[] Niue = new String[] {
               "Niuetid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk, normaltid",
               "",
               "Omsk, sommartid",
               "",
               "Omsktid",
               "",
            };
        final String[] Peru = new String[] {
               "peruansk normaltid",
               "",
               "peruansk sommartid",
               "",
               "peruansk tid",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuktid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "",
               "chilensk sommartid",
               "",
               "chilensk tid",
               "",
            };
        final String[] China = new String[] {
               "kinesisk normaltid",
               "CST",
               "kinesisk sommartid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Keeling\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davistid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indisk tid",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japansk normaltid",
               "JST",
               "japansk sommartid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "KST",
               "koreansk sommartid",
               "KST",
               "koreansk tid",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Naurutid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepalesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palautid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samoansk normaltid",
               "SST",
               "samoansk sommartid",
               "SST",
               "samoansk tid",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowatid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga, normaltid",
               "",
               "Tonga, sommartid",
               "",
               "Tongatid",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukontid",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska, normaltid",
               "AKST",
               "Alaska, sommartid",
               "AKDT",
               "Alaskatid",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonas, normaltid",
               "",
               "Amazonas, sommartid",
               "",
               "Amazonastid",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrnormaltid",
               "",
               "Anadyrsommartid",
               "",
               "Anadyrtid",
               "",
            };
        final String[] Azores = new String[] {
               "azorisk normaltid",
               "",
               "azorisk sommartid",
               "",
               "azorisk tid",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhutansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneitid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "P\u00e5sk\u00f6n, normaltid",
               "",
               "P\u00e5sk\u00f6n, sommartid",
               "",
               "P\u00e5sk\u00f6tid",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyanatid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "israelisk normaltid",
               "IST",
               "israelisk sommartid",
               "IDT",
               "israelisk tid",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraetid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsontid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva, normaltid",
               "MSK",
               "Moskva, sommartid",
               "MSK",
               "Moskvatid",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapetid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samaranormaltid",
               "",
               "Samarasommartid",
               "",
               "Samaratid",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahititid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei, normaltid",
               "CST",
               "Taipei, sommartid",
               "CDT",
               "Taipeitid",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalutid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoktid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- och Futuna\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "saudiarabisk normaltid",
               "",
               "saudiarabisk sommartid",
               "",
               "saudiarabisk tid",
               "",
            };
        final String[] Armenia = new String[] {
               "armenisk normaltid",
               "",
               "armenisk sommartid",
               "",
               "armenisk tid",
               "",
            };
        final String[] Bolivia = new String[] {
               "boliviansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham, normaltid",
               "",
               "Chatham, sommartid",
               "",
               "Chathamtid",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinerad universell tid",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ecuadoriansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiertid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "",
               "georgisk sommartid",
               "",
               "georgisk tid",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk, normaltid",
               "",
               "Irkutsk, sommartid",
               "",
               "Irkutsktid",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan, normaltid",
               "",
               "Magadan, sommartid",
               "",
               "Magadantid",
               "",
            };
        final String[] Myanmar = new String[] {
               "burmesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk\u00f6ns normaltid",
               "",
               "Norfolk\u00f6ns sommartid",
               "",
               "Norfolk\u00f6ns tid",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha, normaltid",
               "",
               "Fernando de Noronha, sommartid",
               "",
               "Fernando de Noronhatid",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9uniontid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotheratid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomon\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelautid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "",
               "uruguayansk sommartid",
               "",
               "uruguayansk tid",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu, normaltid",
               "",
               "Vanuatu, sommartid",
               "",
               "Vanuatutid",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk, normaltid",
               "",
               "Jakutsk, sommartid",
               "",
               "Jakutsktid",
               "",
            };
        final String[] Atlantic = new String[] {
               "nordamerikansk atlantnormaltid",
               "AST",
               "nordamerikansk atlantsommartid",
               "AST",
               "nordamerikansk atlanttid",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia, normaltid",
               "",
               "Brasilia, sommartid",
               "",
               "Brasiliatid",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorrotid",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "colombiansk normaltid",
               "",
               "colombiansk sommartid",
               "",
               "colombiansk tid",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklands\u00f6arna, normaltid",
               "",
               "Falklands\u00f6arna, sommartid",
               "",
               "Falklands\u00f6arnas tid",
               "",
            };
        final String[] Malaysia = new String[] {
               "malaysisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivernatid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar, normaltid",
               "",
               "Ulaanbaatar, sommartid",
               "",
               "Ulaanbaatartid",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "PKT",
               "pakistansk sommartid",
               "PKST",
               "pakistansk tid",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "",
               "paraguayansk sommartid",
               "",
               "paraguayansk tid",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairntid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin, normaltid",
               "",
               "Sachalin, sommartid",
               "",
               "Sachalintid",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamtid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "\u00f6stargentinsk normaltid",
               "",
               "\u00f6stargentinsk sommartid",
               "",
               "\u00f6stargentinsk tid",
               "",
            };
        final String[] Christmas = new String[] {
               "Jul\u00f6ns tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1pagostid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong, normaltid",
               "HKT",
               "Hongkong, sommartid",
               "HKST",
               "Hongkongtid",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamtjatkanormaltid",
               "",
               "Kamtjatkasommartid",
               "",
               "Kamtjatkatid",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe, normaltid",
               "",
               "Lord Howe, sommartid",
               "",
               "Lord Howetid",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesastid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius, normaltid",
               "",
               "Mauritius, sommartid",
               "",
               "Mauritiustid",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporetid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd, normaltid",
               "MSK",
               "Volgograd, sommartid",
               "MSK",
               "Volgogradtid",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzjansk normaltid",
               "",
               "azerbajdzjansk sommartid",
               "",
               "azerbajdzjansk tid",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "",
               "bangladeshisk sommartid",
               "",
               "bangladeshisk tid",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verde, normaltid",
               "",
               "Kap Verde, sommartid",
               "",
               "Kap Verdetid",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00f6sttimorisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellernatid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjikistantid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekisk normaltid",
               "",
               "uzbekisk sommartid",
               "",
               "uzbekisk tid",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afghansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk, normaltid",
               "",
               "Krasnojarsk, sommartid",
               "",
               "Krasnojarsktid",
               "",
            };
        final String[] New_Zealand = new String[] {
               "nyzeel\u00e4ndsk normaltid",
               "NZST",
               "nyzeel\u00e4ndsk sommartid",
               "NZDT",
               "nyzeel\u00e4ndsk tid",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk, normaltid",
               "",
               "Novosibirsk, sommartid",
               "",
               "Novosibirsktid",
               "",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "PST",
               "filippinsk sommartid",
               "PDT",
               "filippinsk tid",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok, normaltid",
               "",
               "Vladivostok, sommartid",
               "",
               "Vladivostoktid",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Brittiska Indiska ocean\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland, normaltid",
               "NST",
               "Newfoundland, sommartid",
               "NDT",
               "Newfoundlandtid",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "",
               "turkmensk sommartid",
               "",
               "turkmensk tid",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Franska Guyanatid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nya Kaledonien, normaltid",
               "",
               "Nya Kaledonien, sommartid",
               "",
               "Nya Kaledonientid",
               "",
            };
        final String[] South_Georgia = new String[] {
               "sydgeorgisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg, normaltid",
               "",
               "Jekaterinburg, sommartid",
               "",
               "Jekaterinburgtid",
               "",
            };
        final String[] Africa_Central = new String[] {
               "centralafrikansk tid",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f6stafrikansk tid",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "v\u00e4stafrikansk normaltid",
               "WAT",
               "v\u00e4stafrikansk sommartid",
               "WAT",
               "v\u00e4stafrikansk tid",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u2019Urville-tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "centraleuropeisk normaltid",
               "CET",
               "centraleuropeisk sommartid",
               "CEST",
               "centraleuropeisk tid",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00f6steuropeisk normaltid",
               "EET",
               "\u00f6steuropeisk sommartid",
               "EEST",
               "\u00f6steuropeisk tid",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "v\u00e4steuropeisk normaltid",
               "WET",
               "v\u00e4steuropeisk sommartid",
               "WEST",
               "v\u00e4steuropeisk tid",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexikansk stillahavstid, normaltid",
               "MST",
               "mexikansk stillahavstid, sommartid",
               "MDT",
               "mexikansk stillahavstid",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "sydafrikansk tid",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "centralnordamerikansk normaltid",
               "CST",
               "centralnordamerikansk sommartid",
               "CDT",
               "centralnordamerikansk tid",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u00f6stnordamerikansk normaltid",
               "EST",
               "\u00f6stnordamerikansk sommartid",
               "EST",
               "\u00f6stnordamerikansk tid",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "v\u00e4stnordamerikansk normaltid",
               "PST",
               "v\u00e4stnordamerikansk sommartid",
               "PDT",
               "v\u00e4stnordamerikansk tid",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franska Sydterritoriernas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Kiribatitid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Honolulu, normaltid",
               "HST",
               "Honolulu, sommartid",
               "HDT",
               "Honolulutid",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Enderburytid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-et-Miquelon, normaltid",
               "",
               "Saint-Pierre-et-Miquelon, sommartid",
               "",
               "Saint-Pierre-et-Miquelon-tid",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Klippiga bergen, normaltid",
               "MST",
               "Klippiga bergen, sommartid",
               "MST",
               "Klippiga bergentid",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall\u00f6arnas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nya Guineas tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "centralaustralisk normaltid",
               "ACST",
               "centralaustralisk sommartid",
               "ACDT",
               "centralaustralisk tid",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f6staustralisk normaltid",
               "AEST",
               "\u00f6staustralisk sommartid",
               "AEDT",
               "\u00f6staustralisk tid",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "v\u00e4staustralisk normaltid",
               "AWST",
               "v\u00e4staustralisk sommartid",
               "AWDT",
               "v\u00e4staustralisk tid",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "centralindonesisk tid",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f6stindonesisk tid",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "v\u00e4stindonesisk tid",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "v\u00e4stkazakstansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "v\u00e4stcentralaustralisk normaltid",
               "",
               "v\u00e4stcentralaustralisk sommartid",
               "",
               "v\u00e4stcentralaustralisk tid",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Honolulu, normaltid",
                    "Honolulunormaltid",
                    "Honolulu, sommartid",
                    "Honolulusommartid",
                    "Honolulutid",
                    "Honolulutid",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST",
                new String[] {
                    "Honolulu, normaltid",
                    "Honolulunormaltid",
                    "Honolulu, sommartid",
                    "Honolulusommartid",
                    "Honolulutid",
                    "Honolulutid",
                }
            },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "irl\u00e4ndsk sommartid",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "Honolulu, normaltid",
                    "Honolulunormaltid",
                    "Honolulu, sommartid",
                    "Honolulusommartid",
                    "Honolulutid",
                    "Honolulutid",
                }
            },
            { "Universal",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinerad universell tid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "irl\u00e4ndsk sommartid",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "Honolulu, normaltid",
                    "Honolulunormaltid",
                    "Honolulu, sommartid",
                    "Honolulusommartid",
                    "Honolulutid",
                    "Honolulutid",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "Honolulu, normaltid",
                    "Honolulunormaltid",
                    "Honolulu, sommartid",
                    "Honolulusommartid",
                    "Honolulutid",
                    "Honolulutid",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwichtid",
                    "GMT",
                    "brittisk sommartid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Chovd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Tjita" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh-staden" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "ok\u00e4nd stad" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "Kokos\u00f6arna" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Jujuy", "San Salvador de Jujuy" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Dusjanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "timezone.excity.Europe/Athens", "Aten" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warszawa" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komorerna" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Cayman\u00f6arna" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtjatka" },
            { "timezone.excity.Europe/Vatican", "Vatikanen" },
            { "timezone.excity.Pacific/Easter", "P\u00e5sk\u00f6n" },
            { "timezone.excity.Pacific/Midway", "Midway\u00f6arna" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Wallis", "Wallis\u00f6n" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aai\u00fan" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.Asia/Choibalsan", "Tjojbalsan" },
            { "timezone.excity.Atlantic/Azores", "Azorerna" },
            { "timezone.excity.Atlantic/Canary", "Kanarie\u00f6arna" },
            { "timezone.excity.Atlantic/Faeroe", "Torshamn" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bryssel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen am Hochrhein" },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.Europe/Helsinki", "Helsingfors" },
            { "timezone.excity.Indian/Maldives", "Maldiverna" },
            { "timezone.excity.Pacific/Gambier", "Gambier\u00f6arna" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Jul\u00f6n" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen\u00f6arna" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn\u00f6arna" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "K\u00f6penhamn" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas\u00f6arna" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sankt Helena" },
            { "timezone.excity.America/Mexico_City", "Mexiko City" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es-Salaam" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Sydgeorgien" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
        };
        return data;
    }
}
