/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;

public class XmfWriter {
    public static final String DEFAULT_SPC_CHARS = " ";
    public static final String DEFAULT_INDENT_CHARS = " ";
    public static final int MAX_INDENT_LEVEL = 8;
    public static final int DEFAULT_MAX_COLUMN_COUNT = 132;
    public static final int RESERVE_COLUMN_COUNT = 2;
    private PrintWriter _out;
    private String _indentChars = " ";
    private int _indentCharsLength = " ".length();
    private int _maxColumnCount = 132;
    private boolean _wrapStringLiteral = true;
    private int _lineNumber = 0;
    private int _columnNumber = 0;
    private int _indentLevel = 0;
    private boolean _needSeparator = false;
    private StatementMode _mode = StatementMode.FORTRAN;

    public XmfWriter(PrintWriter printWriter) {
        this._out = printWriter;
    }

    public void setStatementMode(StatementMode statementMode) {
        this._mode = statementMode;
    }

    public StatementMode getStatementMode() {
        return this._mode;
    }

    private static int _getColumnCount(char c) {
        if (c < '\u0100') {
            return 1;
        }
        return 2;
    }

    private static int _getColumnCount(char[] cArray) {
        int n = 0;
        for (char c : cArray) {
            n += XmfWriter._getColumnCount(c);
        }
        return n;
    }

    private static int _getColumnCount(String string) {
        return XmfWriter._getColumnCount(string.toCharArray());
    }

    private boolean _isLineDirty() {
        return this._columnNumber != 0;
    }

    private boolean _checkLineFull(int n) {
        return this._columnNumber + n > this._maxColumnCount - 2;
    }

    private void _writeIndent() {
        if (this._isLineDirty()) {
            return;
        }
        for (int i = 0; i < this.getIndentLevel(); ++i) {
            this._out.print(this._indentChars);
            this._columnNumber += this._indentCharsLength;
        }
    }

    private void _setupLine(int n) {
        if (!this._isLineDirty()) {
            this._writeIndent();
        } else if (this._checkLineFull(n)) {
            this._out.print("&");
            this.setupNewLine();
            this._writeIndent();
            if (this._mode == StatementMode.OMP) {
                this._out.print("!$OMP");
                this._columnNumber += 5;
            } else if (this._mode == StatementMode.ACC) {
                this._out.print("!$ACC");
                this._columnNumber += 5;
            }
        }
    }

    private static String _toStringLiteral(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2 + 2);
        stringBuilder.append('\"');
        for (char c : string.toCharArray()) {
            if (c == '\"') {
                stringBuilder.append("\"\"");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public int getMaxColumnCount() {
        return this._maxColumnCount;
    }

    public void setMaxColumnCount(int n) {
        this._maxColumnCount = n;
    }

    public int getIndentLevel() {
        if (this._indentLevel < 0) {
            return 0;
        }
        if (this._indentLevel > 8) {
            return 8;
        }
        return this._indentLevel;
    }

    public void incrementIndentLevel() {
        ++this._indentLevel;
    }

    public void decrementIndentLevel() {
        --this._indentLevel;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public Writer getWriter() {
        return this._out;
    }

    public void setupNewLine() {
        this._out.println();
        this._columnNumber = 0;
        ++this._lineNumber;
        this._needSeparator = false;
        this.flush();
    }

    public void setupContiguousNewLine() {
        this._out.print(" &");
        this.setupNewLine();
    }

    private boolean _isWhitespace(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public void writeToken(String string) {
        if (string == null || string.length() == 0 || this._isWhitespace(string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this._needSeparator) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string.trim());
        int n = XmfWriter._getColumnCount(stringBuilder.toString());
        this._setupLine(n);
        this._writeCharacterArray(stringBuilder.toString().toCharArray());
    }

    public void writeLiteralString(String string) {
        Object object;
        string = string == null || string.length() == 0 ? "\"\"" : XmfWriter._toStringLiteral(string);
        if (this._needSeparator) {
            object = new StringBuilder();
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(string);
            string = ((StringBuilder)object).toString();
        }
        object = string.toCharArray();
        if (!this._wrapStringLiteral) {
            this._setupLine(2);
        } else {
            this._setupLine(XmfWriter._getColumnCount((char[])object));
        }
        this._writeCharacterArray((char[])object);
    }

    private void _writeCharacterArray(char[] cArray) {
        int n;
        for (int i = 0; i < cArray.length; i += n) {
            int n2;
            int n3;
            if (i > 0) {
                this._out.print("&");
                this.setupNewLine();
                this._setupLine(1);
                this._out.print("&");
                ++this._columnNumber;
            }
            if ((n3 = this._maxColumnCount - this._columnNumber - 2) < 1) {
                n3 = 1;
            }
            n = 0;
            int n4 = 0;
            for (int j = i; j < cArray.length && n3 >= n4 + (n2 = XmfWriter._getColumnCount(cArray[j])); ++j) {
                n4 += n2;
                ++n;
            }
            if (n < 1) {
                n = 1;
            }
            this._out.write(cArray, i, n);
            this._columnNumber += n4;
        }
        this._needSeparator = true;
    }

    public void writeBlockComment(String string) {
        if (this._isLineDirty()) {
            this.setupNewLine();
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                this._out.print("!");
                this._out.print(string2);
                this.setupNewLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeIsolatedLine(String string) {
        if (this._isLineDirty()) {
            this.setupNewLine();
        }
        this._out.print(string);
        this.setupNewLine();
    }

    public void skipSeparator() {
        this._needSeparator = false;
    }

    public void needSeparator() {
        this._needSeparator = true;
    }

    public void flush() {
        this._out.flush();
    }

    public void close() {
        this._out.close();
    }

    public static enum StatementMode {
        FORTRAN,
        XMP,
        OMP,
        ACC;

    }
}

