/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

import xcodeml.f.decompile.XfError;
import xcodeml.f.decompile.XfTypeManagerForDom;
import xcodeml.f.util.XmfWriter;
import xcodeml.util.XmDecompilerContext;
import xcodeml.util.XmOption;

public class XmfDecompilerContext
implements XmDecompilerContext {
    private int _maxColumnCount = 132;
    private String _lastErrorMessage = null;
    private XmfWriter _writer;
    private XfTypeManagerForDom _typeManagerForDom = new XfTypeManagerForDom();
    private Exception _lastCause;

    public void setProperty(String string, Object object) {
        if (string.equals("MAX_COLUMNS")) {
            this.setMaxColumnCount(Integer.parseInt(object.toString()));
        }
    }

    public boolean isDebugMode() {
        return XmOption.isDebugOutput();
    }

    public Exception getLastCause() {
        return this._lastCause;
    }

    public boolean isOutputLineDirective() {
        return !XmOption.isSuppressLineDirective();
    }

    public void setOutputLineDirective(boolean bl) {
        XmOption.setIsSuppressLineDirective((!bl ? 1 : 0) != 0);
    }

    public int getMaxColumnCount() {
        return this._maxColumnCount;
    }

    public void setMaxColumnCount(int n) {
        this._maxColumnCount = n;
    }

    public XmfWriter getWriter() {
        return this._writer;
    }

    public void setWriter(XmfWriter xmfWriter) {
        this._writer = xmfWriter;
    }

    public XfTypeManagerForDom getTypeManagerForDom() {
        return this._typeManagerForDom;
    }

    public boolean hasError() {
        return this._lastErrorMessage != null;
    }

    public void setLastErrorMessage(String string) {
        this._lastErrorMessage = string;
        this._lastCause = new Exception();
    }

    public String getLastErrorMessage() {
        if (!this.hasError()) {
            return XfError.SUCCESS.message();
        }
        return this._lastErrorMessage;
    }

    public void debugPrint(String string) {
        if (this.isDebugMode()) {
            System.out.print("Debug: ");
            System.out.print(string);
        }
    }

    public void debugPrint(String string, Object ... objectArray) {
        if (this.isDebugMode()) {
            System.out.print("Debug: ");
            System.out.format(string, objectArray);
        }
    }

    public void debugPrintLine(String string) {
        if (this.isDebugMode()) {
            System.out.print("Debug: ");
            System.out.println(string);
        }
    }
}

