/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

import java.util.LinkedList;
import org.w3c.dom.Node;
import xcodeml.f.decompile.XfError;

public class XfUtilForDom {
    public static void errorPrint(String string) {
        System.err.println(string);
    }

    public static String[] getNodePath(Node node) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addFirst(node.getNodeName());
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            linkedList.addFirst(node.getNodeName());
        }
        return linkedList.toArray(new String[0]);
    }

    public static String formatError(Node node, XfError xfError, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error(");
        stringBuilder.append(xfError.ordinal());
        stringBuilder.append("): ");
        stringBuilder.append(xfError.format(objectArray));
        if (node == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append("\n<Element Tree>\n");
        String[] stringArray = XfUtilForDom.getNodePath(node);
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            stringBuilder.append("\n");
        }
        for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                stringBuilder.append("  ");
            }
            stringBuilder.append("+");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

