/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import xcodeml.f.decompile.XfStorageClass;
import xcodeml.f.decompile.XfType;
import xcodeml.f.decompile.XfUtilForDom;
import xcodeml.util.XmDomUtil;
import xcodeml.util.XmException;

class XfTypeManagerForDom {
    private TypeMap _typeMap = new TypeMap();
    private SymbolMapStack _symbolMapStack = new SymbolMapStack();
    private AliasMapStack _aliasMapStack = new AliasMapStack();
    private AliasMap _reverseBasicRefMap;
    private final AliasMapStack _typeToSymbolMapStack = new AliasMapStack();

    public XfTypeManagerForDom() {
        this._reverseBasicRefMap = new AliasMap();
    }

    private SymbolMap _getCurrentSymbolMap() {
        return (SymbolMap)this._symbolMapStack.peekFirst();
    }

    private AliasMap _getCurrentAliasMap() {
        return (AliasMap)this._aliasMapStack.peekFirst();
    }

    private AliasMap _getCurrentTypeToSymbolMap() {
        return (AliasMap)this._typeToSymbolMapStack.peekFirst();
    }

    public void enterScope() {
        this._symbolMapStack.push(new SymbolMap());
        this._aliasMapStack.push(new AliasMap());
        this._typeToSymbolMapStack.push(new AliasMap());
    }

    public void leaveScope() {
        this._symbolMapStack.pop();
        this._aliasMapStack.pop();
        this._typeToSymbolMapStack.pop();
    }

    public void addSymbol(Node node) {
        Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
        if (node2 == null) {
            return;
        }
        String string = XmDomUtil.getContentText((Node)node2);
        if (string == null) {
            return;
        }
        if ((string = string.trim()).isEmpty()) {
            return;
        }
        String string2 = XmDomUtil.getAttr((Node)node, (String)"sclass");
        if (string2 == null) {
            return;
        }
        if (XfStorageClass.FTYPE_NAME.toXcodeString().equalsIgnoreCase(string2)) {
            String string3 = XmDomUtil.getAttr((Node)node, (String)"type");
            if (XfUtilForDom.isNullOrEmpty(string3)) {
                return;
            }
            AliasMap aliasMap = this._getCurrentAliasMap();
            assert (aliasMap != null);
            aliasMap.put(string3, string);
        } else if (!XfStorageClass.FCOMMON_NAME.toXcodeString().equalsIgnoreCase(string2) && !XfStorageClass.FNAMELIST_NAME.toXcodeString().equalsIgnoreCase(string2)) {
            SymbolMap symbolMap = this._getCurrentSymbolMap();
            assert (symbolMap != null);
            symbolMap.put(string, node);
            AliasMap aliasMap = this._getCurrentTypeToSymbolMap();
            String string4 = XmDomUtil.getAttr((Node)node, (String)"type");
            if (!XfUtilForDom.isNullOrEmpty(string4)) {
                aliasMap.put(string4, string);
            }
        }
    }

    public Node findSymbol(String string) {
        SymbolMap symbolMap;
        Node node = null;
        string = string.trim();
        Iterator iterator = this._symbolMapStack.iterator();
        while (iterator.hasNext() && (node = (Node)(symbolMap = (SymbolMap)iterator.next()).get(string)) == null) {
        }
        return node;
    }

    public void addType(Node node) {
        ArrayList arrayList;
        String string;
        String string2 = XmDomUtil.getAttr((Node)node, (String)"type");
        if (XfUtilForDom.isNullOrEmpty(string2)) {
            return;
        }
        String string3 = string2.trim();
        if (string3.isEmpty()) {
            return;
        }
        this._typeMap.put(string3, node);
        String string4 = node.getNodeName();
        if (string4.equals("FbasicType") && (string = XmDomUtil.getAttr((Node)node, (String)"ref")) != null && (arrayList = XmDomUtil.collectElementsExclude((Node)node, (String[])new String[]{"kind", "coShape"})).isEmpty()) {
            this._reverseBasicRefMap.put(string, string2);
        }
    }

    public Node findType(String string) {
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return null;
        }
        return (Node)this._typeMap.get(string.trim());
    }

    public Node findType(Node node) {
        if (node == null) {
            return null;
        }
        String string = XmDomUtil.getAttr((Node)node, (String)"type");
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return this.findTypeFromSymbol(XmDomUtil.getContentText((Node)node));
        }
        return this.findType(string);
    }

    public Node findTypeFromSymbol(String string) {
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return null;
        }
        Node node = this.findSymbol(string);
        if (node == null) {
            return null;
        }
        return this.findType(XmDomUtil.getAttr((Node)node, (String)"type"));
    }

    public String findNameFromType(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        for (AliasMap aliasMap : this._typeToSymbolMapStack) {
            String string2 = (String)aliasMap.get(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public void putAliasTypeName(String string, String string2) {
        if (XfUtilForDom.isNullOrEmpty(string2)) {
            return;
        }
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return;
        }
        AliasMap aliasMap = this._getCurrentAliasMap();
        aliasMap.put(string, string2);
    }

    public String getAliasTypeName(String string) {
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return null;
        }
        string = string.trim();
        for (AliasMap aliasMap : this._aliasMapStack) {
            String string2 = (String)aliasMap.get(string);
            if (string2 == null) continue;
            return string2;
        }
        String string3 = (String)this._reverseBasicRefMap.get(string);
        if (string3 != null) {
            return this.getAliasTypeName(string3);
        }
        throw new IllegalStateException("not found type name of '" + string + "'");
    }

    public TypeList getTypeReferenceList(String string) throws XmException {
        TypeList typeList = new TypeList();
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return typeList;
        }
        Node node = this.findType(string);
        while (node != null) {
            typeList.addFirst(node);
            String string2 = node.getNodeName();
            if ("FbasicType".equals(string2)) {
                Node node2 = node;
                String string3 = XmDomUtil.getAttr((Node)node2, (String)"ref");
                if (XmDomUtil.getAttrBool((Node)node2, (String)"is_class") && XfUtilForDom.isNullOrEmpty(string3) || XmDomUtil.getAttrBool((Node)node2, (String)"is_pointer") && XfUtilForDom.isNullOrEmpty(string3) || XmDomUtil.getAttrBool((Node)node2, (String)"is_procedure") && XfUtilForDom.isNullOrEmpty(string3) || XfType.DERIVED != XfType.getTypeIdFromXcodemlTypeName(string3)) break;
                node = this.findType(string3);
                if (!typeList.contains(node)) continue;
                throw new XmException("FbasicType" + XmDomUtil.getAttr((Node)node2, (String)"type") + "has cyclic definition");
            }
            if ("FstructType".equals(string2)) {
                node = null;
                continue;
            }
            if ("FfunctionType".equals(string2)) {
                node = null;
                continue;
            }
            assert (false);
        }
        return typeList;
    }

    public String getBottomTypeName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (XfType.DERIVED != XfType.getTypeIdFromXcodemlTypeName(string)) {
            return string;
        }
        TypeList typeList = null;
        try {
            typeList = this.getTypeReferenceList(string);
        }
        catch (XmException xmException) {
            return null;
        }
        if (typeList == null || typeList.size() == 0) {
            return null;
        }
        Node node = (Node)typeList.getLast();
        String string2 = node.getNodeName();
        if ("FbasicType".equals(string2)) {
            return XmDomUtil.getAttr((Node)node, (String)"ref");
        }
        if ("FstructType".equals(string2)) {
            return XmDomUtil.getAttr((Node)node, (String)"type");
        }
        if ("FfunctionType".equals(string2)) {
            return XmDomUtil.getAttr((Node)node, (String)"type");
        }
        return null;
    }

    public boolean isTypeOf(String string, XfType xfType) {
        return xfType.xcodemlName().equals(this.getBottomTypeName(string));
    }

    public boolean isDecompilableType(String string) {
        return !this.isTypeOf(string, XfType.VOID) && !this.isTypeOf(string, XfType.NUMERIC) && !this.isTypeOf(string, XfType.NUMERICALL);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._typeMap.toString());
        stringBuilder.append(this._aliasMapStack.toString());
        stringBuilder.append(this._symbolMapStack.toString());
        return stringBuilder.toString();
    }

    public Set<String> findSymbolFromCurrentScope(SymbolMatcher symbolMatcher) {
        HashSet<String> hashSet = new HashSet<String>();
        SymbolMap symbolMap = this._getCurrentSymbolMap();
        for (String string : symbolMap.keySet()) {
            Node node = (Node)symbolMap.get(string);
            String string2 = XmDomUtil.getAttr((Node)node, (String)"type");
            if (string2 == null || !symbolMatcher.match(node, this.findType(string2))) continue;
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static interface SymbolMatcher {
        public boolean match(Node var1, Node var2);
    }

    public class TypeList
    extends LinkedList<Node> {
        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[TypeList, element name -> type name]\n");
            for (Node node : this) {
                stringBuilder.append(node.getNodeName());
                stringBuilder.append(" -> ");
                stringBuilder.append(XmDomUtil.getAttr((Node)node, (String)"type"));
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public Node findChildNode(String string) {
            for (Node node : this) {
                Node node2 = XmDomUtil.getElement((Node)node, (String)string);
                if (node2 == null) continue;
                return node2;
            }
            return null;
        }
    }

    private class AliasMapStack
    extends LinkedList<AliasMap> {
        private AliasMapStack() {
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[AliasMapStack]\n");
            for (AliasMap aliasMap : XfTypeManagerForDom.this._aliasMapStack) {
                stringBuilder.append(aliasMap.toString());
            }
            return stringBuilder.toString();
        }
    }

    private class AliasMap
    extends HashMap<String, String> {
        private AliasMap() {
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[AliasMap, key(type) -> value(alias type)]\n");
            for (Map.Entry entry : this.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(" -> ");
                stringBuilder.append((String)entry.getValue());
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }

    private class SymbolMapStack
    extends LinkedList<SymbolMap> {
        private SymbolMapStack() {
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[SymbolMapStack]\n");
            for (SymbolMap symbolMap : XfTypeManagerForDom.this._symbolMapStack) {
                stringBuilder.append(symbolMap.toString());
            }
            return stringBuilder.toString();
        }
    }

    public class SymbolMap
    extends HashMap<String, Node> {
        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[SymbolMap, key(symbol name) -> value(type name)]\n");
            for (Map.Entry entry : this.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(" -> ");
                stringBuilder.append(XmDomUtil.getAttr((Node)((Node)entry.getValue()), (String)"type"));
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }

    private class TypeMap
    extends HashMap<String, Node> {
        private TypeMap() {
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[TypeMap, key(type name) -> value(class)]\n");
            for (Map.Entry entry : this.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(" -> ");
                stringBuilder.append(((Node)entry.getValue()).getNodeName());
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }
}

