/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

enum XfType {
    VOID("Fvoid", null, false),
    INT("Fint", "INTEGER", true),
    REAL("Freal", "REAL", true),
    COMPLEX("Fcomplex", "COMPLEX", true),
    LOGICAL("Flogical", "LOGICAL", true),
    CHARACTER("Fcharacter", "CHARACTER", true),
    NUMERIC("Fnumeric", null, true),
    NUMERICALL("FnumericAll", null, true),
    ENUM("FenumType", null, false),
    DERIVED(null, null, false);

    private boolean _isPrimitive = false;
    private String _xcodemlName;
    private String _fortranName;

    private XfType(String string2, String string3, boolean bl) {
        this._isPrimitive = bl;
        this._xcodemlName = string2;
        this._fortranName = string3;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public String xcodemlName() {
        return this._xcodemlName;
    }

    public boolean hasXcodemlName() {
        return this._xcodemlName != null;
    }

    public String fortranName() {
        return this._fortranName;
    }

    public boolean hasFortranName() {
        return this._fortranName != null;
    }

    public static XfType getTypeIdFromXcodemlTypeName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (XfType xfType : XfType.values()) {
            String string2 = xfType.xcodemlName();
            if (string2 == null || string.compareToIgnoreCase(xfType.xcodemlName()) != 0) continue;
            return xfType;
        }
        return DERIVED;
    }
}

