/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

import org.w3c.dom.Node;
import xcodeml.f.decompile.XfError;
import xcodeml.f.decompile.XfUtilForDom;
import xcodeml.f.util.XmfNodeVisitorMap;
import xcodeml.util.XmDomUtil;

public class XfRuntimeDomValidator {
    private String errorDescription;
    private XmfNodeVisitorMap<NodeValidator> visitorMap;
    private XmfNodeVisitorMap.Pair[] pairs = new XmfNodeVisitorMap.Pair[]{new XmfNodeVisitorMap.Pair<FbasicTypeValidator>("FbasicType", new FbasicTypeValidator()), new XmfNodeVisitorMap.Pair<FfunctionTypeValidator>("FfunctionType", new FfunctionTypeValidator()), new XmfNodeVisitorMap.Pair<FstructTypeValidator>("FstructType", new FstructTypeValidator()), new XmfNodeVisitorMap.Pair<FmoduleDefinitionValidator>("FmoduleDefinition", new FmoduleDefinitionValidator()), new XmfNodeVisitorMap.Pair<FuseDeclValidator>("FuseDecl", new FuseDeclValidator()), new XmfNodeVisitorMap.Pair<FuseOnlyDeclValidator>("FuseOnlyDecl", new FuseOnlyDeclValidator()), new XmfNodeVisitorMap.Pair<StatementLabelValidator>("statementLabel", new StatementLabelValidator()), new XmfNodeVisitorMap.Pair<FprintStatementValidator>("FprintStatement", new FprintStatementValidator()), new XmfNodeVisitorMap.Pair<FformatDeclValidator>("FformatDecl", new FformatDeclValidator()), new XmfNodeVisitorMap.Pair<FmemberRefValidator>("FmemberRef", new FmemberRefValidator())};

    public XfRuntimeDomValidator() {
        this.visitorMap = new XmfNodeVisitorMap(this.pairs);
    }

    public final boolean validateAttr(Node node) {
        NodeValidator nodeValidator = this.visitorMap.getVisitor(node.getNodeName());
        if (nodeValidator == null) {
            return true;
        }
        return nodeValidator.validateAttr(node);
    }

    public String getErrDesc() {
        return this.errorDescription;
    }

    class NamedValueValidator
    extends NodeValidator {
        NamedValueValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class RenamableValidator
    extends NodeValidator {
        RenamableValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"use_name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "use_name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class RenameValidator
    extends NodeValidator {
        RenameValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"use_name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "use_name", node.getNodeName());
                return false;
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"local_name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "local_name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class NameValidator
    extends NodeValidator {
        NameValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class IdValidator
    extends NodeValidator {
        IdValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"sclass"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "sclass", node.getNodeName());
                return false;
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FmemberRefValidator
    extends NodeValidator {
        FmemberRefValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"member"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "member", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FformatDeclValidator
    extends NodeValidator {
        FformatDeclValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"format"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "format", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FprintStatementValidator
    extends NodeValidator {
        FprintStatementValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"format"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "format", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class StatementLabelValidator
    extends NodeValidator {
        StatementLabelValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"label_name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "label_name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FuseOnlyDeclValidator
    extends NodeValidator {
        FuseOnlyDeclValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FuseDeclValidator
    extends NodeValidator {
        FuseDeclValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FblockDataDefinitionValidator
    extends NodeValidator {
        FblockDataDefinitionValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FmoduleDefinitionValidator
    extends NodeValidator {
        FmoduleDefinitionValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"name"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FstructTypeValidator
    extends NodeValidator {
        FstructTypeValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FfunctionTypeValidator
    extends NodeValidator {
        FfunctionTypeValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName());
                return false;
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"return_type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "return_type", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    class FbasicTypeValidator
    extends NodeValidator {
        FbasicTypeValidator() {
        }

        @Override
        public boolean validateAttr(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName());
                return false;
            }
            boolean bl = XmDomUtil.getAttrBool((Node)node, (String)"is_class");
            boolean bl2 = XmDomUtil.getAttrBool((Node)node, (String)"is_procedure");
            if (!bl && !bl2 && XfUtilForDom.isNullOrEmpty(XmDomUtil.getAttr((Node)node, (String)"ref"))) {
                XfRuntimeDomValidator.this.errorDescription = XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "ref", node.getNodeName());
                return false;
            }
            return true;
        }
    }

    private abstract class NodeValidator {
        private NodeValidator() {
        }

        public abstract boolean validateAttr(Node var1);
    }
}

