/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

enum XfError {
    SUCCESS{

        @Override
        public String message() {
            return "Success.";
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 0);
            return this.message();
        }
    }
    ,
    XCODEML_TYPE_NOT_FOUND{

        @Override
        public String message() {
            return "Type definition for '%1$s' is not found in type table.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 1);
            assert (objectArray[0] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_NODE_MISSING{

        @Override
        public String message() {
            return "Node '%1$s' requires node '%2$s' as a child.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 2);
            assert (objectArray[0] instanceof String);
            assert (objectArray[1] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_NAME_NOT_FOUND{

        @Override
        public String message() {
            return "name '%1$s' is not found in symbol table.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 1);
            assert (objectArray[0] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_TYPE_MISMATCH{

        @Override
        public String message() {
            return "Reference type of '%1$s' is defined as '%2$s', but it must be '%3$s'.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 3);
            assert (objectArray[0] instanceof String);
            assert (objectArray[1] instanceof String);
            assert (objectArray[2] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_NEED_ATTR{

        @Override
        public String message() {
            return "The necessary '%1$s' attribute for '%2$s' element of this context does not exist or is empty.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 2);
            assert (objectArray[0] instanceof String);
            assert (objectArray[1] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_SEMANTICS{

        @Override
        public String message() {
            return "Detected a semantic error of XcodeML/F during handling of '%1$s' element.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 1);
            assert (objectArray[0] instanceof String);
            return String.format(this.message(), objectArray);
        }
    }
    ,
    XCODEML_CYCLIC_TYPE{

        @Override
        public String message() {
            return "Type of '%1$s' has a cyclic type definition.";
        }

        @Override
        public String format(Object ... objectArray) {
            assert (objectArray.length == 1);
            assert (objectArray[0] instanceof String);
            return String.format(this.message(), objectArray);
        }
    };


    public abstract String message();

    public abstract String format(Object ... var1);

    public boolean isError() {
        return true;
    }
}

