/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.f.decompile;

import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xcodeml.f.decompile.XfDecompileDomVisitor_coarrayLibs;
import xcodeml.f.decompile.XfError;
import xcodeml.f.decompile.XfRuntimeDomValidator;
import xcodeml.f.decompile.XfSymbol;
import xcodeml.f.decompile.XfType;
import xcodeml.f.decompile.XfTypeManagerForDom;
import xcodeml.f.decompile.XfUtilForDom;
import xcodeml.f.decompile.XmfDecompilerContext;
import xcodeml.f.util.XmfNodeVisitorMap;
import xcodeml.f.util.XmfWriter;
import xcodeml.util.XmDomUtil;
import xcodeml.util.XmException;
import xcodeml.util.XmOption;
import xcodeml.util.XmTranslationException;

public class XfDecompileDomVisitor {
    static final int PRIO_LOW = 0;
    static final int PRIO_DEFINED_BINARY = 1;
    static final int PRIO_EQV = 2;
    static final int PRIO_OR = 3;
    static final int PRIO_AND = 4;
    static final int PRIO_NOT = 5;
    static final int PRIO_COMP = 6;
    static final int PRIO_CONCAT = 7;
    static final int PRIO_PLUS_MINUS = 8;
    static final int PRIO_UNARY_MINUS = 9;
    static final int PRIO_MUL_DIV = 10;
    static final int PRIO_POWER = 11;
    static final int PRIO_DEFINED_UNARY = 12;
    static final int PRIO_HIGH = 13;
    private XmfDecompilerContext _context;
    private InvokeNodeStack _invokeNodeStack;
    private XfRuntimeDomValidator _validator;
    private Node _nextNode;
    private XmfNodeVisitorMap<XcodeNodeVisitor> visitorMap;
    private static final Set<String> exprModelSet;
    private XmfNodeVisitorMap.Pair[] pairs = new XmfNodeVisitorMap.Pair[]{new XmfNodeVisitorMap.Pair<XcodeProgramVisitor>("XcodeProgram", new XcodeProgramVisitor()), new XmfNodeVisitorMap.Pair<TypeTableVisitor>("typeTable", new TypeTableVisitor()), new XmfNodeVisitorMap.Pair<BasicTypeVisitor>("FbasicType", new BasicTypeVisitor()), new XmfNodeVisitorMap.Pair<CoShapeVisitor>("coShape", new CoShapeVisitor()), new XmfNodeVisitorMap.Pair<FfunctionTypeVisitor>("FfunctionType", new FfunctionTypeVisitor()), new XmfNodeVisitorMap.Pair<FenumTypeVisitor>("FenumType", new FenumTypeVisitor()), new XmfNodeVisitorMap.Pair<FstructTypeVisitor>("FstructType", new FstructTypeVisitor()), new XmfNodeVisitorMap.Pair<TypeParamsVisitor>("typeParams", new TypeParamsVisitor()), new XmfNodeVisitorMap.Pair<TypeParamVisitor>("typeParam", new TypeParamVisitor()), new XmfNodeVisitorMap.Pair<TypeBoundProceduresVisitor>("typeBoundProcedures", new TypeBoundProceduresVisitor()), new XmfNodeVisitorMap.Pair<TypeBoundProcedureVisitor>("typeBoundProcedure", new TypeBoundProcedureVisitor()), new XmfNodeVisitorMap.Pair<TypeBoundGenericProcedureVisitor>("typeBoundGenericProcedure", new TypeBoundGenericProcedureVisitor()), new XmfNodeVisitorMap.Pair<FinalProcedureVisitor>("finalProcedure", new FinalProcedureVisitor()), new XmfNodeVisitorMap.Pair<GlobalSymbolsVisitor>("globalSymbols", new GlobalSymbolsVisitor()), new XmfNodeVisitorMap.Pair<GlobalDeclarationsVisitor>("globalDeclarations", new GlobalDeclarationsVisitor()), new XmfNodeVisitorMap.Pair<AllocVisitor>("alloc", new AllocVisitor()), new XmfNodeVisitorMap.Pair<ArgumentsVisitor>("arguments", new ArgumentsVisitor()), new XmfNodeVisitorMap.Pair<ArrayIndexVisitor>("arrayIndex", new ArrayIndexVisitor()), new XmfNodeVisitorMap.Pair<FassignStatementVisitor>("FassignStatement", new FassignStatementVisitor()), new XmfNodeVisitorMap.Pair<BodyVisitor>("body", new BodyVisitor()), new XmfNodeVisitorMap.Pair<ConditionVisitor>("condition", new ConditionVisitor()), new XmfNodeVisitorMap.Pair<ContinueStatement>("continueStatement", new ContinueStatement()), new XmfNodeVisitorMap.Pair<DeclarationsVisitor>("declarations", new DeclarationsVisitor()), new XmfNodeVisitorMap.Pair<DivExprVisitor>("divExpr", new DivExprVisitor()), new XmfNodeVisitorMap.Pair<ElseVisitor>("else", new ElseVisitor()), new XmfNodeVisitorMap.Pair<ExprStatementVisitor>("exprStatement", new ExprStatementVisitor()), new XmfNodeVisitorMap.Pair<ExternDeclVisitor>("externDecl", new ExternDeclVisitor()), new XmfNodeVisitorMap.Pair<FallocateStatement>("FallocateStatement", new FallocateStatement()), new XmfNodeVisitorMap.Pair<FallocOpt>("allocOpt", new FallocOpt()), new XmfNodeVisitorMap.Pair<FarrayConstructor>("FarrayConstructor", new FarrayConstructor()), new XmfNodeVisitorMap.Pair<FarrayRefVisitor>("FarrayRef", new FarrayRefVisitor()), new XmfNodeVisitorMap.Pair<FcoArrayRefVisitor>("FcoArrayRef", new FcoArrayRefVisitor()), new XmfNodeVisitorMap.Pair<FbackspaceStatement>("FbackspaceStatement", new FbackspaceStatement()), new XmfNodeVisitorMap.Pair<FcaseLabelVisitor>("FcaseLabel", new FcaseLabelVisitor()), new XmfNodeVisitorMap.Pair<TypeGuardVisitor>("typeGuard", new TypeGuardVisitor()), new XmfNodeVisitorMap.Pair<FcharacterConstant>("FcharacterConstant", new FcharacterConstant()), new XmfNodeVisitorMap.Pair<FcharacterRef>("FcharacterRef", new FcharacterRef()), new XmfNodeVisitorMap.Pair<FcloseStatementVisitor>("FcloseStatement", new FcloseStatementVisitor()), new XmfNodeVisitorMap.Pair<FcommonDeclVisitor>("FcommonDecl", new FcommonDeclVisitor()), new XmfNodeVisitorMap.Pair<FcomplexConstantVisitor>("FcomplexConstant", new FcomplexConstantVisitor()), new XmfNodeVisitorMap.Pair<FcomplexPartRefVisitor>("FcomplexPartRef", new FcomplexPartRefVisitor()), new XmfNodeVisitorMap.Pair<FconcatExprVisitor>("FconcatExpr", new FconcatExprVisitor()), new XmfNodeVisitorMap.Pair<FcontainsStatementVisitor>("FcontainsStatement", new FcontainsStatementVisitor()), new XmfNodeVisitorMap.Pair<FcycleStatementVisitor>("FcycleStatement", new FcycleStatementVisitor()), new XmfNodeVisitorMap.Pair<FdataDeclVisitor>("FdataDecl", new FdataDeclVisitor()), new XmfNodeVisitorMap.Pair<FdataStatementVisitor>("FdataStatement", new FdataStatementVisitor()), new XmfNodeVisitorMap.Pair<FdeallocateStatementVisitor>("FdeallocateStatement", new FdeallocateStatementVisitor()), new XmfNodeVisitorMap.Pair<FdoConcurrentStatementVisitor>("FdoConcurrentStatement", new FdoConcurrentStatementVisitor()), new XmfNodeVisitorMap.Pair<FdoLoopVisitor>("FdoLoop", new FdoLoopVisitor()), new XmfNodeVisitorMap.Pair<FdoStatementVisitor>("FdoStatement", new FdoStatementVisitor()), new XmfNodeVisitorMap.Pair<FdoWhileStatementVisitor>("FdoWhileStatement", new FdoWhileStatementVisitor()), new XmfNodeVisitorMap.Pair<FendFileStatementVisitor>("FendFileStatement", new FendFileStatementVisitor()), new XmfNodeVisitorMap.Pair<FentryDeclVisitor>("FentryDecl", new FentryDeclVisitor()), new XmfNodeVisitorMap.Pair<FequivalenceDeclVisitor>("FequivalenceDecl", new FequivalenceDeclVisitor()), new XmfNodeVisitorMap.Pair<FexitStatementVisitor>("FexitStatement", new FexitStatementVisitor()), new XmfNodeVisitorMap.Pair<FflushStatementVisitor>("FflushStatement", new FflushStatementVisitor()), new XmfNodeVisitorMap.Pair<FformatDeclVisitor>("FformatDecl", new FformatDeclVisitor()), new XmfNodeVisitorMap.Pair<FfunctionDeclVisitor>("FfunctionDecl", new FfunctionDeclVisitor()), new XmfNodeVisitorMap.Pair<FfunctionDefinitionVisitor>("FfunctionDefinition", new FfunctionDefinitionVisitor()), new XmfNodeVisitorMap.Pair<FifStatementVisitor>("FifStatement", new FifStatementVisitor()), new XmfNodeVisitorMap.Pair<FimportDeclVisitor>("FimportDecl", new FimportDeclVisitor()), new XmfNodeVisitorMap.Pair<FinquireStatementVisitor>("FinquireStatement", new FinquireStatementVisitor()), new XmfNodeVisitorMap.Pair<FintConstantVisitor>("FintConstant", new FintConstantVisitor()), new XmfNodeVisitorMap.Pair<FinterfaceDeclVisitor>("FinterfaceDecl", new FinterfaceDeclVisitor()), new XmfNodeVisitorMap.Pair<FlogicalConstantVisitor>("FlogicalConstant", new FlogicalConstantVisitor()), new XmfNodeVisitorMap.Pair<FmemberRefVisitor>("FmemberRef", new FmemberRefVisitor()), new XmfNodeVisitorMap.Pair<FmoduleDefinitionVisitor>("FmoduleDefinition", new FmoduleDefinitionVisitor()), new XmfNodeVisitorMap.Pair<FmoduleProcedureDeclVisitor>("FmoduleProcedureDecl", new FmoduleProcedureDeclVisitor()), new XmfNodeVisitorMap.Pair<FblockDataDefinitionVisitor>("FblockDataDefinition", new FblockDataDefinitionVisitor()), new XmfNodeVisitorMap.Pair<FnamelistDeclVisitor>("FnamelistDecl", new FnamelistDeclVisitor()), new XmfNodeVisitorMap.Pair<FnullifyStatementVisitor>("FnullifyStatement", new FnullifyStatementVisitor()), new XmfNodeVisitorMap.Pair<FopenStatementVisitor>("FopenStatement", new FopenStatementVisitor()), new XmfNodeVisitorMap.Pair<FpointerAssignStatementVisitor>("FpointerAssignStatement", new FpointerAssignStatementVisitor()), new XmfNodeVisitorMap.Pair<FpowerExprVisitor>("FpowerExpr", new FpowerExprVisitor()), new XmfNodeVisitorMap.Pair<FpragmaStatementVisitor>("FpragmaStatement", new FpragmaStatementVisitor()), new XmfNodeVisitorMap.Pair<FcommentLineVisitor>("FcommentLine", new FcommentLineVisitor()), new XmfNodeVisitorMap.Pair<OMPPragmaVisitor>("OMPPragma", new OMPPragmaVisitor()), new XmfNodeVisitorMap.Pair<ACCPragmaVisitor>("ACCPragma", new ACCPragmaVisitor()), new XmfNodeVisitorMap.Pair<FprintStatementVisitor>("FprintStatement", new FprintStatementVisitor()), new XmfNodeVisitorMap.Pair<FreadStatementVisitor>("FreadStatement", new FreadStatementVisitor()), new XmfNodeVisitorMap.Pair<FrealConstantVisitor>("FrealConstant", new FrealConstantVisitor()), new XmfNodeVisitorMap.Pair<FreturnStatementVisitor>("FreturnStatement", new FreturnStatementVisitor()), new XmfNodeVisitorMap.Pair<FrewindStatementVisitor>("FrewindStatement", new FrewindStatementVisitor()), new XmfNodeVisitorMap.Pair<FselectCaseStatementVisitor>("FselectCaseStatement", new FselectCaseStatementVisitor()), new XmfNodeVisitorMap.Pair<SelectTypeStatementVisitor>("selectTypeStatement", new SelectTypeStatementVisitor()), new XmfNodeVisitorMap.Pair<PassThroughVisitor>("code", new PassThroughVisitor()), new XmfNodeVisitorMap.Pair<PassThroughVisitor>("message", new PassThroughVisitor()), new XmfNodeVisitorMap.Pair<FstopStatementVisitor>("FstopStatement", new FstopStatementVisitor()), new XmfNodeVisitorMap.Pair<FerrorStopStatementVisitor>("FerrorStopStatement", new FerrorStopStatementVisitor()), new XmfNodeVisitorMap.Pair<FpauseStatementVisitor>("FpauseStatement", new FpauseStatementVisitor()), new XmfNodeVisitorMap.Pair<FstructConstructorVisitor>("FstructConstructor", new FstructConstructorVisitor()), new XmfNodeVisitorMap.Pair<FstructDeclVisitor>("FstructDecl", new FstructDeclVisitor()), new XmfNodeVisitorMap.Pair<FunctionCallVisitor>("functionCall", new FunctionCallVisitor()), new XmfNodeVisitorMap.Pair<FuseDeclVisitor>("FuseDecl", new FuseDeclVisitor()), new XmfNodeVisitorMap.Pair<FuseOnlyDeclVisitor>("FuseOnlyDecl", new FuseOnlyDeclVisitor()), new XmfNodeVisitorMap.Pair<FwhereStatementVisitor>("FwhereStatement", new FwhereStatementVisitor()), new XmfNodeVisitorMap.Pair<FwriteStatementVisitor>("FwriteStatement", new FwriteStatementVisitor()), new XmfNodeVisitorMap.Pair<GotoStatementVisitor>("gotoStatement", new GotoStatementVisitor()), new XmfNodeVisitorMap.Pair<IdVisitor>("id", new IdVisitor()), new XmfNodeVisitorMap.Pair<IndexRangeVisitor>("indexRange", new IndexRangeVisitor()), new XmfNodeVisitorMap.Pair<KindVisitor>("kind", new KindVisitor()), new XmfNodeVisitorMap.Pair<LenVisitor>("len", new LenVisitor()), new XmfNodeVisitorMap.Pair<LogAndExprVisitor>("logAndExpr", new LogAndExprVisitor()), new XmfNodeVisitorMap.Pair<LogEQExprVisitor>("logEQExpr", new LogEQExprVisitor()), new XmfNodeVisitorMap.Pair<LogEQVExprVisitor>("logEQVExpr", new LogEQVExprVisitor()), new XmfNodeVisitorMap.Pair<LogGEExprVisitor>("logGEExpr", new LogGEExprVisitor()), new XmfNodeVisitorMap.Pair<LogGTExprVisitor>("logGTExpr", new LogGTExprVisitor()), new XmfNodeVisitorMap.Pair<LogLEExprVisitor>("logLEExpr", new LogLEExprVisitor()), new XmfNodeVisitorMap.Pair<LogLTExprVisitor>("logLTExpr", new LogLTExprVisitor()), new XmfNodeVisitorMap.Pair<LogNEQExprVisitor>("logNEQExpr", new LogNEQExprVisitor()), new XmfNodeVisitorMap.Pair<LogNEQVExprVisitor>("logNEQVExpr", new LogNEQVExprVisitor()), new XmfNodeVisitorMap.Pair<LogNotExprVisitor>("logNotExpr", new LogNotExprVisitor()), new XmfNodeVisitorMap.Pair<LogOrExprVisitor>("logOrExpr", new LogOrExprVisitor()), new XmfNodeVisitorMap.Pair<LowerBoundVisitor>("lowerBound", new LowerBoundVisitor()), new XmfNodeVisitorMap.Pair<MinusExprVisitor>("minusExpr", new MinusExprVisitor()), new XmfNodeVisitorMap.Pair<MulExprVisitor>("mulExpr", new MulExprVisitor()), new XmfNodeVisitorMap.Pair<NameVisitor>("name", new NameVisitor()), new XmfNodeVisitorMap.Pair<NamedValueVisitor>("namedValue", new NamedValueVisitor()), new XmfNodeVisitorMap.Pair<NamedValueListVisitor>("namedValueList", new NamedValueListVisitor()), new XmfNodeVisitorMap.Pair<ParamsVisitor>("params", new ParamsVisitor()), new XmfNodeVisitorMap.Pair<PlusExprVisitor>("plusExpr", new PlusExprVisitor()), new XmfNodeVisitorMap.Pair<StatementLabelVisitor>("statementLabel", new StatementLabelVisitor()), new XmfNodeVisitorMap.Pair<StepVisitor>("step", new StepVisitor()), new XmfNodeVisitorMap.Pair<SymbolsVisitor>("symbols", new SymbolsVisitor()), new XmfNodeVisitorMap.Pair<ThenVisitor>("then", new ThenVisitor()), new XmfNodeVisitorMap.Pair<UnaryMinusExprVisitor>("unaryMinusExpr", new UnaryMinusExprVisitor()), new XmfNodeVisitorMap.Pair<UpperBoundVisitor>("upperBound", new UpperBoundVisitor()), new XmfNodeVisitorMap.Pair<UserBinaryExprVisitor>("userBinaryExpr", new UserBinaryExprVisitor()), new XmfNodeVisitorMap.Pair<UserUnaryExprVisitor>("userUnaryExpr", new UserUnaryExprVisitor()), new XmfNodeVisitorMap.Pair<ValueVisitor>("value", new ValueVisitor()), new XmfNodeVisitorMap.Pair<RepeatCountVisitor>("repeat_count", new RepeatCountVisitor()), new XmfNodeVisitorMap.Pair<ValueListVisitor>("valueList", new ValueListVisitor()), new XmfNodeVisitorMap.Pair<FfunctionVisitor>("Ffunction", new FfunctionVisitor()), new XmfNodeVisitorMap.Pair<VarVisitor>("Var", new VarVisitor()), new XmfNodeVisitorMap.Pair<VarDeclVisitor>("varDecl", new VarDeclVisitor()), new XmfNodeVisitorMap.Pair<VarListVisitor>("varList", new VarListVisitor()), new XmfNodeVisitorMap.Pair<VarRefVisitor>("varRef", new VarRefVisitor()), new XmfNodeVisitorMap.Pair<SyncAllStatementVisitor>("syncAllStatement", new SyncAllStatementVisitor()), new XmfNodeVisitorMap.Pair<SyncImagesStatementVisitor>("syncImagesStatement", new SyncImagesStatementVisitor()), new XmfNodeVisitorMap.Pair<SyncMemoryStatementVisitor>("syncMemoryStatement", new SyncMemoryStatementVisitor()), new XmfNodeVisitorMap.Pair<CriticalStatementVisitor>("criticalStatement", new CriticalStatementVisitor()), new XmfNodeVisitorMap.Pair<LockStatementVisitor>("lockStatement", new LockStatementVisitor()), new XmfNodeVisitorMap.Pair<UnlockStatementVisitor>("unlockStatement", new UnlockStatementVisitor()), new XmfNodeVisitorMap.Pair<SyncStatVisitor>("syncStat", new SyncStatVisitor()), new XmfNodeVisitorMap.Pair<BlockStatementVisitor>("blockStatement", new BlockStatementVisitor()), new XmfNodeVisitorMap.Pair<FmoduleProcedureDefinitionVisitor>("FmoduleProcedureDefinition", new FmoduleProcedureDefinitionVisitor()), new XmfNodeVisitorMap.Pair<ForallStatementVisitor>("forallStatement", new ForallStatementVisitor()), new XmfNodeVisitorMap.Pair<FwaitStatementVisitor>("FwaitStatement", new FwaitStatementVisitor()), new XmfNodeVisitorMap.Pair<FenumDeclVisitor>("FenumDecl", new FenumDeclVisitor()), new XmfNodeVisitorMap.Pair<AssociateStatementVisitor>("associateStatement", new AssociateStatementVisitor())};

    public static String nodeToString(Node node) {
        String string = null;
        if (node != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
                string = stringWriter.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static void printNode(PrintStream printStream, Node node) {
        String string = XfDecompileDomVisitor.nodeToString(node);
        if (string != null) {
            printStream.printf("%s\n", string);
        }
    }

    public XfDecompileDomVisitor(XmfDecompilerContext xmfDecompilerContext) {
        this._context = xmfDecompilerContext;
        this._invokeNodeStack = new InvokeNodeStack();
        this._validator = new XfRuntimeDomValidator();
        this.visitorMap = new XmfNodeVisitorMap(this.pairs);
    }

    public void invokeEnter(Document document) throws XmException {
        try {
            this._enter(document.getDocumentElement());
        }
        catch (XmTranslationException xmTranslationException) {
            throw new XmException((Throwable)xmTranslationException);
        }
    }

    private void _writeDeclAttr(Node node, Node node2) {
        String string = node.getNodeName();
        String string2 = node2.getNodeName();
        if ("FbasicType".equals(string) && "FbasicType".equals(string2)) {
            this._writeBasicTypeAttr(node, node2);
            return;
        }
        if ("FbasicType".equals(string)) {
            this._writeBasicTypeAttr(node);
        }
        if ("FbasicType".equals(string2)) {
            this._writeBasicTypeAttr(node2);
        }
    }

    private List<String> _collectBasicTypeAttr(Node ... nodeArray) {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (nodeArray == null) {
            return arrayList;
        }
        if (this._isUnderModuleDef() || this._isUnderFstructType()) {
            for (Node node : nodeArray) {
                if (!XmDomUtil.getAttrBool((Node)node, (String)"is_public")) continue;
                arrayList.add("PUBLIC");
                break;
            }
            for (Node node : nodeArray) {
                if (!XmDomUtil.getAttrBool((Node)node, (String)"is_private")) continue;
                arrayList.add("PRIVATE");
                break;
            }
            for (Node node : nodeArray) {
                if (!XmDomUtil.getAttrBool((Node)node, (String)"is_protected")) continue;
                arrayList.add("PROTECTED");
                break;
            }
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_pointer")) continue;
            arrayList.add("POINTER");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_target")) continue;
            arrayList.add("TARGET");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_optional")) continue;
            arrayList.add("OPTIONAL");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_save")) continue;
            arrayList.add("SAVE");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_parameter")) continue;
            arrayList.add("PARAMETER");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_allocatable")) continue;
            arrayList.add("ALLOCATABLE");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_cray_pointer")) continue;
            arrayList.add("$$Error (Cray Pointer #2)$$");
            break;
        }
        for (Node node : nodeArray) {
            string2 = XmDomUtil.getAttr((Node)node, (String)"intent");
            if (XfUtilForDom.isNullOrEmpty(string2)) continue;
            arrayList.add("INTENT(" + string2.toUpperCase() + ")");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_volatile")) continue;
            arrayList.add("VOLATILE");
            break;
        }
        for (Node node : nodeArray) {
            string2 = XmDomUtil.getAttr((Node)node, (String)"bind");
            string = XmDomUtil.getAttr((Node)node, (String)"bind_name");
            if (!XfUtilForDom.isNullOrEmpty(string2) && !XfUtilForDom.isNullOrEmpty(string)) {
                arrayList.add("BIND( " + string2.toUpperCase() + ", NAME='" + string + "' )");
                break;
            }
            if (XfUtilForDom.isNullOrEmpty(string2)) continue;
            arrayList.add("BIND( " + string2.toUpperCase() + " )");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_value")) continue;
            arrayList.add("VALUE");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_asynchronous")) continue;
            arrayList.add("ASYNCHRONOUS");
            break;
        }
        for (Node node : nodeArray) {
            if (!XmDomUtil.getAttrBool((Node)node, (String)"is_contiguous")) continue;
            arrayList.add("CONTIGUOUS");
            break;
        }
        for (Node node : nodeArray) {
            string2 = XmDomUtil.getAttr((Node)node, (String)"pass");
            if (XfUtilForDom.isNullOrEmpty(string2)) continue;
            if (string2.equals("pass")) {
                string = "PASS";
                String string3 = XmDomUtil.getAttr((Node)node, (String)"pass_arg_name");
                if (!XfUtilForDom.isNullOrEmpty(string3)) {
                    string = string + "(" + string3 + ")";
                }
                arrayList.add(string);
                continue;
            }
            if (!string2.equals("nopass")) continue;
            arrayList.add("NOPASS");
        }
        return arrayList;
    }

    private void _writeBasicTypeAttr(Node ... nodeArray) {
        List<String> list = this._collectBasicTypeAttr(nodeArray);
        if (nodeArray == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        for (String string : list) {
            xmfWriter.writeToken(",");
            xmfWriter.writeToken(string);
        }
    }

    private void _writeBasicTypeAttrStatements(String string, Node ... nodeArray) {
        List<String> list = this._collectBasicTypeAttr(nodeArray);
        if (nodeArray == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        for (String string2 : list) {
            xmfWriter.setupNewLine();
            xmfWriter.writeToken(string2);
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(string);
        }
    }

    private void _writeFunctionSymbol(XfSymbol xfSymbol, Node node) {
        Object object;
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        XmfWriter xmfWriter = this._context.getWriter();
        Node node2 = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = XmDomUtil.getAttr((Node)node, (String)"return_type");
        if (xfTypeManagerForDom.isDecompilableType(string) && !this._isUnderModuleDef()) {
            bl = false;
            object = XfType.getTypeIdFromXcodemlTypeName(string);
            if (object.isPrimitive()) {
                xmfWriter.writeToken(object.fortranName());
            } else {
                String string2;
                XfTypeManagerForDom.TypeList typeList = this.getTypeList(string);
                assert (typeList != null);
                node2 = (Node)typeList.getLast();
                Node node3 = (Node)typeList.getFirst();
                if (!this._writeTopType(typeList, true)) {
                    throw new XmTranslationException(node2, "Invalid return type.");
                }
                if ("FbasicType".equals(node2.getNodeName())) {
                    bl3 = XmDomUtil.getAttrBool((Node)node2, (String)"is_public");
                    bl2 = XmDomUtil.getAttrBool((Node)node2, (String)"is_private");
                    bl4 = XmDomUtil.getAttrBool((Node)node2, (String)"is_protected");
                }
                if ("FbasicType".equals(string2 = node3.getNodeName())) {
                    bl3 |= XmDomUtil.getAttrBool((Node)node3, (String)"is_public");
                    bl2 |= XmDomUtil.getAttrBool((Node)node3, (String)"is_private");
                    bl4 |= XmDomUtil.getAttrBool((Node)node2, (String)"is_protected");
                }
            }
        }
        if (this._isUnderModuleDef()) {
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_public") && !bl3) {
                xmfWriter.writeToken((bl ? "" : ", ") + "PUBLIC");
                bl = false;
            } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_private") && !bl2) {
                xmfWriter.writeToken((bl ? "" : ", ") + "PRIVATE");
                bl = false;
            } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_protected") && !bl4) {
                xmfWriter.writeToken((bl ? "" : ", ") + "PROTECTED");
                bl = false;
            }
        }
        if (XmDomUtil.getAttrBool((Node)node, (String)"is_intrinsic")) {
            if (!bl) {
                xmfWriter.writeToken(",");
            }
            xmfWriter.writeToken("INTRINSIC");
            bl = false;
        }
        if (!bl) {
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(xfSymbol.getSymbolName());
            if (node2 != null && "FbasicType".equals(node2.getNodeName()) && !((ArrayList)(object = XmDomUtil.collectElementsExclude((Node)node2, (String[])new String[]{"kind", "len", "coShape", "typeParamValues"}))).isEmpty()) {
                this._writeIndexRangeArray((ArrayList<Node>)object);
            }
        }
    }

    private void _writeExternalDecl(XfSymbol xfSymbol, XfTypeManagerForDom.TypeList typeList) {
        if (this._isNameDefinedWithUseStmt(xfSymbol.getSymbolName()).booleanValue()) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.addAll(typeList);
        Node node = (Node)typeList.getFirst();
        assert (XmDomUtil.getAttrBool((Node)node, (String)"is_external"));
        boolean bl = false;
        String string = XmDomUtil.getAttr((Node)node, (String)"return_type");
        XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
        if (xfType.isPrimitive()) {
            if (xfType.hasFortranName()) {
                xmfWriter.writeToken(xfType.fortranName());
                bl = true;
            }
        } else if (!xfType.hasXcodemlName()) {
            XfTypeManagerForDom.TypeList typeList2 = this.getTypeList(string);
            arrayList.addAll(typeList2);
            bl = this._writeTopType(typeList2, true, false);
        }
        if (!arrayList.isEmpty()) {
            if (bl) {
                this._writeBasicTypeAttr(arrayList.toArray(new Node[0]));
            } else {
                this._writeBasicTypeAttrStatements(xfSymbol.getSymbolName(), arrayList.toArray(new Node[0]));
            }
        }
        if (bl) {
            xmfWriter.writeToken(",");
        } else {
            xmfWriter.setupNewLine();
        }
        xmfWriter.writeToken("EXTERNAL");
        xmfWriter.writeToken("::");
        xmfWriter.writeToken(xfSymbol.getSymbolName());
    }

    private void _writeBasicType(Node node, XfTypeManagerForDom.TypeList typeList) {
        String string = XmDomUtil.getAttr((Node)node, (String)"ref");
        XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
        assert (xfType != null);
        if (!xfType.isPrimitive()) {
            this._context.debugPrint("Top level type is basic-type, but is not primitive type. (%s)%n", string);
            if (typeList != null) {
                this._context.debugPrintLine(typeList.toString());
            }
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "top-level FbasicType", string, "primitive type"));
            this.fail(node);
        }
        XmfWriter xmfWriter = this._context.getWriter();
        xmfWriter.writeToken(xfType.fortranName());
        Node node2 = XmDomUtil.getElement((Node)node, (String)"len");
        if (node2 != null && xfType != XfType.CHARACTER) {
            this._context.debugPrint("A 'len' element is included in a definition of '%s' type.%n", xfType.xcodemlName());
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node2, XfError.XCODEML_SEMANTICS, node2.getNodeName()));
            this.fail(node2);
        }
        Node node3 = XmDomUtil.getElement((Node)node, (String)"kind");
        this._writeTypeParam(node3, node2);
    }

    private XfTypeManagerForDom.TypeList getTypeList(String string) {
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        XfTypeManagerForDom.TypeList typeList = null;
        try {
            typeList = xfTypeManagerForDom.getTypeReferenceList(string);
        }
        catch (XmException xmException) {
            this._context.debugPrintLine(xmException.toString());
            Node node = (Node)this._invokeNodeStack.peek();
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_CYCLIC_TYPE, string));
            this.fail(node);
        }
        if (typeList == null || typeList.isEmpty()) {
            this._context.debugPrintLine("Type list is empty.");
            Node node = (Node)this._invokeNodeStack.peek();
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, string));
            this.fail(node);
        }
        return typeList;
    }

    private boolean _writeTopType(XfTypeManagerForDom.TypeList typeList, Boolean bl) {
        return this._writeTopType(typeList, bl, true);
    }

    private boolean _writeTopType(XfTypeManagerForDom.TypeList typeList, Boolean bl, Boolean bl2) {
        String string;
        Node node = (Node)typeList.getFirst();
        Node node2 = (Node)typeList.getLast();
        XmfWriter xmfWriter = this._context.getWriter();
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        boolean bl3 = XmDomUtil.getAttrBool((Node)node2, (String)"is_class");
        boolean bl4 = XmDomUtil.getAttrBool((Node)node2, (String)"is_procedure");
        if (!bl.booleanValue()) {
            assert (!bl3);
            assert (!bl4);
            bl3 = false;
            bl4 = false;
        }
        if ("FbasicType".equals(string = node.getNodeName()) && !bl3 && !bl4) {
            this._writeBasicType(node, typeList);
        } else if ("FbasicType".equals(string) && XmDomUtil.getAttr((Node)node, (String)"ref") == null && bl3) {
            xmfWriter.writeToken("CLASS");
            xmfWriter.writeToken("(");
            xmfWriter.writeToken("*");
            xmfWriter.writeToken(")");
        } else if (bl4) {
            xmfWriter.writeToken("PROCEDURE");
            xmfWriter.writeToken("(");
            if (XmDomUtil.getAttr((Node)node2, (String)"ref") != null) {
                String string2 = xfTypeManagerForDom.findNameFromType(XmDomUtil.getAttr((Node)node, (String)"type"));
                if (string2 != null) {
                    xmfWriter.writeToken(string2);
                } else {
                    String string3 = XmDomUtil.getAttr((Node)node, (String)"return_type");
                    XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string3);
                    if (xfType.isPrimitive()) {
                        xmfWriter.writeToken(xfType.fortranName());
                    } else {
                        XfTypeManagerForDom.TypeList typeList2 = this.getTypeList(string3);
                        this._writeTopType(typeList2, true);
                    }
                }
            }
            xmfWriter.writeToken(")");
        } else if ("FstructType".equals(string)) {
            Node node3 = typeList.findChildNode("typeParamValues");
            String string4 = xfTypeManagerForDom.getAliasTypeName(XmDomUtil.getAttr((Node)node, (String)"type"));
            if (bl.booleanValue()) {
                if (bl3) {
                    xmfWriter.writeToken("CLASS");
                } else {
                    xmfWriter.writeToken("TYPE");
                }
                xmfWriter.writeToken("(");
            }
            xmfWriter.writeToken(string4);
            if (node3 != null) {
                xmfWriter.writeToken("(");
                this._invokeChildEnterAndWriteDelim(node3, ",");
                xmfWriter.writeToken(")");
            }
            if (bl.booleanValue()) {
                xmfWriter.writeToken(")");
            }
        } else {
            return false;
        }
        if (bl2.booleanValue()) {
            this._writeDeclAttr(node, node2);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Boolean _writeSymbolDecl(XfSymbol xfSymbol, Node node) {
        Node node2;
        Object object;
        if (xfSymbol == null) {
            throw new IllegalArgumentException();
        }
        XfType xfType = xfSymbol.getTypeId();
        if (xfType.isPrimitive()) {
            this._writeSimplePrimitiveSymbolDecl(xfSymbol);
            return true;
        }
        XfTypeManagerForDom.TypeList typeList = this.getTypeList(xfSymbol.getDerivedName());
        assert (typeList != null);
        Node node3 = (Node)typeList.getFirst();
        Node node4 = (Node)typeList.getLast();
        XmfWriter xmfWriter = this._context.getWriter();
        if (this._isCrayPointer(node3, node4)) {
            this._writeCrayPointerDecl(xfSymbol, node);
            return false;
        }
        boolean bl = XmDomUtil.getAttrBool((Node)node4, (String)"is_class");
        boolean bl2 = XmDomUtil.getAttrBool((Node)node4, (String)"is_procedure");
        boolean bl3 = XmDomUtil.getAttrBool((Node)node3, (String)"is_external");
        String string = node3.getNodeName();
        if (!bl2 && "FfunctionType".equals(string)) {
            if (bl3) {
                this._writeExternalDecl(xfSymbol, typeList);
                return true;
            }
            this._writeFunctionSymbol(xfSymbol, node3);
            this._writeDeclAttr(node3, node4);
        } else if (!this._writeTopType(typeList, true)) {
            throw new XmTranslationException(node, "Unexpected type");
        }
        String string2 = node4.getNodeName();
        if (!"FbasicType".equals(string2)) {
            if (!"FstructType".equals(string2)) return true;
            xmfWriter.writeToken(" :: ");
            xmfWriter.writeToken(xfSymbol.getSymbolName());
            return true;
        }
        Node node5 = node4;
        String string3 = XmDomUtil.getAttr((Node)node5, (String)"ref");
        if (!bl && !bl2 && XfUtilForDom.isNullOrEmpty(string3)) {
            object = XfType.getTypeIdFromXcodemlTypeName(string3);
            assert (object != null);
        }
        xmfWriter.writeToken(" :: ");
        xmfWriter.writeToken(xfSymbol.getSymbolName());
        object = XmDomUtil.collectElementsExclude((Node)node5, (String[])new String[]{"kind", "len", "coShape"});
        if (!((ArrayList)object).isEmpty()) {
            this._writeIndexRangeArray((ArrayList<Node>)object);
        }
        if ((node2 = XmDomUtil.getElement((Node)node5, (String)"coShape")) == null) return true;
        this.invokeEnter(node2);
        return true;
    }

    private void _invokeEnter(ArrayList<Node> arrayList) {
        Node node = null;
        if (arrayList == null) {
            return;
        }
        for (Node node2 : arrayList) {
            if (!this._validator.validateAttr(node2)) {
                this._context.debugPrintLine("Detected insufficient attributes");
                this._context.setLastErrorMessage(this._validator.getErrDesc());
                this.fail(node2);
            }
            this._nextNode = node2;
            if (node != null) {
                this.invokeEnter(node);
            }
            node = node2;
        }
        this._nextNode = null;
        this.invokeEnter(node);
    }

    private void _invokeEnterAndWriteDelim(ArrayList<Node> arrayList, String string) {
        if (arrayList == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        int n = 0;
        for (Node node : arrayList) {
            if (n > 0) {
                xmfWriter.writeToken(string);
            }
            this.invokeEnter(node);
            ++n;
        }
    }

    private void _invokeChildEnterAndWriteDelim(Node node, String string) {
        if (node == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (n > 0) {
                xmfWriter.writeToken(string);
            }
            this.invokeEnter(node2);
            ++n;
        }
    }

    private void _invokeChildEnter(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if (!this._validator.validateAttr(node3)) {
                this._context.debugPrintLine("Detected insufficient attributes");
                this._context.setLastErrorMessage(this._validator.getErrDesc());
                this.fail(node3);
            }
            this._nextNode = node3;
            if (node2 != null) {
                this.invokeEnter(node2);
            }
            node2 = node3;
        }
        this._nextNode = null;
        this.invokeEnter(node2);
    }

    private void invokeEnter(Node node) {
        if (node == null) {
            return;
        }
        this._invokeNodeStack.push(node);
        this._preEnter(node);
        this._enter(node);
        this._postEnter(node);
        this._invokeNodeStack.pop();
    }

    private Node _getInvokeNode(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this._invokeNodeStack.size()) {
            return null;
        }
        return (Node)this._invokeNodeStack.get(n);
    }

    private boolean _isInvokeNodeOf(String string, int n) {
        Node node = this._getInvokeNode(n);
        return string.equals(node.getNodeName());
    }

    private boolean _isUnderModuleDef() {
        return this._isInvokeNodeOf("FmoduleDefinition", 2);
    }

    private boolean _isUnderFstructType() {
        return this._isInvokeAncestorNodeOf("FstructDecl");
    }

    private boolean _isInvokeAncestorNodeOf(String string) {
        assert (string != null);
        Node node2 = null;
        for (Node node2 : this._invokeNodeStack) {
            if (!string.equals(node2.getNodeName())) continue;
            return true;
        }
        return false;
    }

    private void _preEnter(Node node) {
        if (this._context.isDebugMode()) {
            this._context.debugPrintLine(String.format("%100s", "").subSequence(0, (this._invokeNodeStack.size() - 1) * 2) + "<" + node.getNodeName() + ">");
        }
    }

    private void _postEnter(Node node) {
        if (this._context.isDebugMode()) {
            this._context.debugPrintLine(String.format("%100s", " ").subSequence(0, (this._invokeNodeStack.size() - 1) * 2) + "</" + node.getNodeName() + ">");
        }
    }

    private boolean _isConstantExpr(Node node) {
        String string;
        if (!node.getParentNode().getNodeName().equals("unaryMinusExpr") && node.getNodeName().equals("unaryMinusExpr")) {
            node = (Node)XmDomUtil.collectChildNodes((Node)node).get(0);
        }
        return (string = node.getNodeName()).equals("FintConstant") || string.equals("FlogicalConstant") || string.equals("FcharacterConstant") || string.equals("FrealConstant") || string.equals("FcomplexConstant") || string.equals("value");
    }

    private XfSymbol _makeSymbol(String string, String string2) {
        Object object;
        if (XfUtilForDom.isNullOrEmpty(string)) {
            return null;
        }
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        if (XfUtilForDom.isNullOrEmpty(string2)) {
            object = xfTypeManagerForDom.findSymbol(string);
            if (object == null) {
                return null;
            }
            string2 = XmDomUtil.getAttr((Node)object, (String)"type");
            if (XfUtilForDom.isNullOrEmpty(string2)) {
                return null;
            }
        }
        if (string.equals("**") || string.equals("*") || string.equals("/") || string.equals("+") || string.equals("-") || string.equals("//")) {
            string = "OPERATOR(" + string + ")";
        } else if (string.equals("=")) {
            string = "ASSIGNMENT(" + string + ")";
        } else if (string.startsWith(".") && string.endsWith(".")) {
            string = "OPERATOR(" + string + ")";
        }
        object = null;
        XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string2);
        object = xfType.isPrimitive() ? new XfSymbol(string, xfType) : new XfSymbol(string, xfType, string2);
        return object;
    }

    private XfSymbol _makeSymbol(Node node) {
        if (node == null) {
            return null;
        }
        String string = XmDomUtil.getContentText((Node)node);
        return this._makeSymbol(string, XmDomUtil.getAttr((Node)node, (String)"type"));
    }

    private void _writeLineDirective(Node node) {
        this._writeLineDirective(XmDomUtil.getAttr((Node)node, (String)"lineno"), XmDomUtil.getAttr((Node)node, (String)"file"));
    }

    private void _writeLineDirective(String string, String string2) {
        if (this._context.isOutputLineDirective() && string != null) {
            XmfWriter xmfWriter = this._context.getWriter();
            if (string2 == null) {
                xmfWriter.writeIsolatedLine(String.format("# %s", string));
            } else {
                xmfWriter.writeIsolatedLine(String.format("# %s \"%s\"", string, string2));
            }
        }
    }

    private void _writeSimplePrimitiveSymbolDecl(XfSymbol xfSymbol) {
        XmfWriter xmfWriter = this._context.getWriter();
        xmfWriter.writeToken(xfSymbol.getTypeId().fortranName());
        xmfWriter.writeToken(" :: ");
        xmfWriter.writeToken(xfSymbol.getSymbolName());
    }

    private void _writeCrayPointerDecl(XfSymbol xfSymbol, Node node) {
        Node node2 = XmDomUtil.getElement((Node)node, (String)"value");
        if (node2 == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        xmfWriter.writeToken("POINTER (");
        xmfWriter.writeToken(xfSymbol.getSymbolName());
        xmfWriter.writeToken(",");
        if (node2 != null) {
            this.invokeEnter(node2);
        }
        xmfWriter.writeToken(")");
    }

    private boolean _isCrayPointer(Node node, Node node2) {
        String string = node.getNodeName();
        if ("FbasicType".equals(string) && XmDomUtil.getAttrBool((Node)node, (String)"is_cray_pointer")) {
            return true;
        }
        String string2 = node2.getNodeName();
        return "FbasicType".equals(string2) && XmDomUtil.getAttrBool((Node)node2, (String)"is_cray_pointer");
    }

    private void _writeTypeParam(Node node, Node node2) {
        if (node == null && node2 == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        xmfWriter.writeToken("(");
        if (node2 != null) {
            xmfWriter.writeToken("LEN=");
            this.invokeEnter(node2);
        }
        if (node != null) {
            if (node2 != null) {
                xmfWriter.writeToken(", ");
            }
            xmfWriter.writeToken("KIND=");
            this.invokeEnter(node);
        }
        xmfWriter.writeToken(")");
    }

    private void _writeIndexRangeArray(ArrayList<Node> arrayList) {
        if (arrayList == null) {
            return;
        }
        XmfWriter xmfWriter = this._context.getWriter();
        xmfWriter.writeToken("(");
        int n = 0;
        for (Node node : arrayList) {
            String string;
            if (n > 0) {
                xmfWriter.writeToken(", ");
            }
            if ((string = node.getNodeName()).equals("indexRange") || string.equals("arrayIndex")) {
                this.invokeEnter(node);
            } else {
                this._context.debugPrintLine("Detected discontiguous 'indexRange' or 'arrayIndex' element.");
                this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, string));
                this.fail(node);
            }
            ++n;
        }
        xmfWriter.writeToken(")");
    }

    private void _writeUnaryExpr(Node node, String string, boolean bl) {
        XmfWriter xmfWriter = this._context.getWriter();
        if (bl) {
            xmfWriter.writeToken("(");
        }
        xmfWriter.writeToken(string);
        this.invokeEnter(node);
        if (bl) {
            xmfWriter.writeToken(")");
        }
    }

    private void _writeBinaryExpr(Node node, Node node2, String string, boolean bl) {
        XmfWriter xmfWriter = this._context.getWriter();
        int n = this.operator_priority(string);
        if (bl) {
            xmfWriter.writeToken("(");
        }
        boolean bl2 = false;
        if (n > this.operator_priority(node)) {
            bl2 = true;
        }
        if (bl2) {
            xmfWriter.writeToken("(");
        }
        this.invokeEnter(node);
        if (bl2) {
            xmfWriter.writeToken(")");
        }
        xmfWriter.writeToken(" ");
        xmfWriter.writeToken(string);
        xmfWriter.writeToken(" ");
        bl2 = false;
        if (n == 11 || n >= this.operator_priority(node2)) {
            bl2 = true;
        }
        if (bl2) {
            xmfWriter.writeToken("(");
        }
        this.invokeEnter(node2);
        if (bl2) {
            xmfWriter.writeToken(")");
        }
        if (bl) {
            xmfWriter.writeToken(")");
        }
    }

    int operator_priority(String string) {
        if (string.equals("=") || string.equals("=>")) {
            return 0;
        }
        if (string.equals("-") || string.equals("+")) {
            return 8;
        }
        if (string.equals("*") || string.equals("/")) {
            return 10;
        }
        if (string.equals("**")) {
            return 11;
        }
        if (string.equals("<") || string.equals(">") || string.equals("<=") || string.equals(">=") || string.equals("/=") || string.equals("==")) {
            return 6;
        }
        if (string.equals("//")) {
            return 7;
        }
        if (string.equals(".NOT.")) {
            return 5;
        }
        if (string.equals(".AND.")) {
            return 4;
        }
        if (string.equals(".OR.")) {
            return 3;
        }
        if (string.equals(".NEQV.") || string.equals(".EQV.")) {
            return 2;
        }
        if (string.startsWith(".") && string.endsWith(".")) {
            return 1;
        }
        return 13;
    }

    int operator_priority(Node node) {
        String string = node.getNodeName();
        if (string.equals("FassignStatement") || string.equals("FpointerAssignStatement")) {
            return 0;
        }
        if (string.equals("userBinaryExpr")) {
            return 1;
        }
        if (string.equals("plusExpr") || string.equals("minusExpr")) {
            return 8;
        }
        if (string.equals("unaryMinusExpr")) {
            return 9;
        }
        if (string.equals("divExpr") || string.equals("mulExpr")) {
            return 10;
        }
        if (string.equals("FpowerExpr")) {
            return 11;
        }
        if (string.equals("logLTExpr") || string.equals("logGTExpr") || string.equals("logLEExpr") || string.equals("logGEExpr") || string.equals("logEQExpr") || string.equals("logNEQExpr")) {
            return 6;
        }
        if (string.equals("FconcatExpr")) {
            return 7;
        }
        if (string.equals("logNotExpr")) {
            return 5;
        }
        if (string.equals("logAndExpr")) {
            return 4;
        }
        if (string.equals("logOrExpr")) {
            return 3;
        }
        if (string.equals("logEQVExpr") || string.equals("logNEQVExpr")) {
            return 2;
        }
        if (string.equals("userUnaryExpr")) {
            return 1;
        }
        return 13;
    }

    private boolean _checkBinaryExprRequireGrouping(Node node) {
        Node node2 = node.getParentNode();
        String string = node2.getNodeName();
        if (!(string.equals("unaryMinusExpr") || string.equals("userUnaryExpr") || string.equals("logNotExpr"))) {
            return false;
        }
        return this.operator_priority(node2) > this.operator_priority(node);
    }

    private void _writeBinaryExpr(ArrayList<Node> arrayList, int n, String string, boolean bl) {
        this._writeBinaryExpr(arrayList.get(n), arrayList.get(n + 1), string, bl);
    }

    private void _enter(Node node) {
        XcodeNodeVisitor xcodeNodeVisitor = this.visitorMap.getVisitor(node.getNodeName());
        if (xcodeNodeVisitor == null) {
            throw new XmTranslationException(node, "Unknown node");
        }
        xcodeNodeVisitor.enter(node);
    }

    private void fail(Node node) {
        throw new XmTranslationException(node, this._context.getLastErrorMessage(), (Throwable)this._context.getLastCause());
    }

    Node findFunctionType(Node node, Node node2) {
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        Node node3 = xfTypeManagerForDom.findType(node2);
        if (node3 == null) {
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node2, (String)"type")));
            this.fail(node);
        } else if (!"FfunctionType".equals(node3.getNodeName())) {
            this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", node3.getNodeName(), "FfunctionType"));
            this.fail(node);
        }
        return node3;
    }

    private Boolean _isNameDefinedWithUseStmt(String string) {
        ArrayList<String> arrayList = this._get_coarrayRuntimeLibNames__NEW__();
        for (String string2 : arrayList) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    ArrayList<String> _get_coarrayRuntimeLibNames__OLD__() {
        String[] stringArray = new String[]{"xmpf_image_index", "xmpf_cobound_generic", "xmpf_cobound_nodim", "xmpf_cobound_dim", "xmpf_num_images", "xmpf_this_image_generic", "xmpf_coarray_hello", "xmpf_sync_all_stat", "xmpf_sync_memory", "xmpf_sync_memory_nostat", "xmpf_sync_memory_stat_wrap", "xmpf_sync_images", "xmpf_sync_image_nostat", "xmpf_sync_images_nostat_wrap", "xmpf_sync_allimages_nostat_wrap", "xmpf_sync_image_stat_wrap", "xmpf_sync_images_stat_wrap", "xmpf_sync_allimages_stat_wrap", "xmpf_critical", "xmpf_end_critical", "xmpf_error_stop", "xmpf_atomic_define_generic", "xmpf_atomic_ref_generic", "xmpf_coarray_get_generic", "xmpf_coarray_put_generic", "xmpf_coarray_alloc_generic", "xmpf_coarray_dealloc_generic", "xmpf_co_broadcast_generic", "xmpf_co_sum_generic", "xmpf_co_max_generic", "xmpf_co_min_generic"};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        return arrayList;
    }

    ArrayList<String> _get_coarrayRuntimeLibNames__NEW__() {
        String[] stringArray = XfDecompileDomVisitor_coarrayLibs.EntryNameArray;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        return arrayList;
    }

    private void writeVolatileOrAsynchronousStatements(Node node) {
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        XmfWriter xmfWriter = this._context.getWriter();
        CollectDeclaredNameVisitor collectDeclaredNameVisitor = new CollectDeclaredNameVisitor();
        Set<String> set = collectDeclaredNameVisitor.collect(node);
        Set<String> set2 = xfTypeManagerForDom.findSymbolFromCurrentScope(new XfTypeManagerForDom.SymbolMatcher(){

            @Override
            public boolean match(Node node, Node node2) {
                return XmDomUtil.getAttrBool((Node)node2, (String)"is_volatile");
            }
        });
        for (String object2 : set2) {
            if (set.contains(object2)) continue;
            xmfWriter.writeToken("VOLATILE");
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(object2);
            xmfWriter.setupNewLine();
        }
        Set<String> set3 = xfTypeManagerForDom.findSymbolFromCurrentScope(new XfTypeManagerForDom.SymbolMatcher(){

            @Override
            public boolean match(Node node, Node node2) {
                return XmDomUtil.getAttrBool((Node)node2, (String)"is_asynchronous");
            }
        });
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string)) continue;
            xmfWriter.writeToken("ASYNCHRONOUS");
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
        }
    }

    private void writePublicOrPrivateStatements(Node node) {
        XfTypeManagerForDom xfTypeManagerForDom = this._context.getTypeManagerForDom();
        XmfWriter xmfWriter = this._context.getWriter();
        CollectDeclaredNameVisitor collectDeclaredNameVisitor = new CollectDeclaredNameVisitor();
        Set<String> set = collectDeclaredNameVisitor.collect(node);
        Set<String> set2 = xfTypeManagerForDom.findSymbolFromCurrentScope(new XfTypeManagerForDom.SymbolMatcher(){

            @Override
            public boolean match(Node node, Node node2) {
                return XmDomUtil.hasAttr((Node)node, (String)"declared_in");
            }
        });
        Set<String> set3 = xfTypeManagerForDom.findSymbolFromCurrentScope(new XfTypeManagerForDom.SymbolMatcher(){

            @Override
            public boolean match(Node node, Node node2) {
                return XmDomUtil.getAttrBool((Node)node2, (String)"is_public");
            }
        });
        for (String object2 : set3) {
            if (set.contains(object2) && !set2.contains(object2)) continue;
            xmfWriter.writeToken("PUBLIC");
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(object2);
            xmfWriter.setupNewLine();
        }
        Set<String> set4 = xfTypeManagerForDom.findSymbolFromCurrentScope(new XfTypeManagerForDom.SymbolMatcher(){

            @Override
            public boolean match(Node node, Node node2) {
                return XmDomUtil.getAttrBool((Node)node2, (String)"is_private");
            }
        });
        Iterator iterator = set4.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string) && !set2.contains(string)) continue;
            xmfWriter.writeToken("PRIVATE");
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
        }
    }

    static {
        String[] stringArray = new String[]{"FintConstant", "FrealConstant", "FcomplexConstant", "FcharacterConstant", "FlogicalConstant", "FarrayConstructor", "FstructConstructor", "Var", "FarrayRef", "FcharacterRef", "FmemberRef", "FcoArrayRef", "varRef", "functionCall", "plusExpr", "minusExpr", "mulExpr", "divExpr", "FpowerExpr", "FconcatExpr", "logEQExpr", "logNEQExpr", "logGEExpr", "logGTExpr", "logLEExpr", "logLTExpr", "logAndExpr", "logOrExpr", "logEQVExpr", "logNEQVExpr", "unaryMinusExpr", "logNotExpr", "userBinaryExpr", "userUnaryExpr", "FdoLoop"};
        exprModelSet = new HashSet<String>(Arrays.asList(stringArray));
    }

    class CollectDeclaredNameVisitor {
        private Set<String> _names;

        CollectDeclaredNameVisitor() {
        }

        public Set<String> collect(Node node) {
            this._names = new HashSet<String>();
            this.enter(node);
            return this._names;
        }

        private void enter(Node node) {
            String string = node.getNodeName();
            if ("name".equals(string)) {
                String string2 = node.getTextContent();
                if (string2 == null) {
                    return;
                }
                Node node2 = node.getParentNode();
                if (node2 == null) {
                    return;
                }
                if (!"varDecl".equals(node2.getNodeName())) {
                    return;
                }
                this._names.add(string2);
            } else {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if ("FinterfaceDecl".equals(node3.getNodeName())) continue;
                    this.enter(node3);
                }
            }
        }
    }

    class AssociateStatementVisitor
    extends XcodeNodeVisitor {
        AssociateStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(":");
            }
            xmfWriter.writeToken("ASSOCIATE");
            xmfWriter.writeToken("(");
            xmfWriter.incrementIndentLevel();
            Node node2 = XmDomUtil.getElement((Node)node, (String)"symbols");
            Boolean bl = true;
            for (Node node3 : XmDomUtil.collectElements((Node)node2, (String[])new String[]{"id"})) {
                if (!bl.booleanValue()) {
                    xmfWriter.writeToken(",");
                }
                bl = false;
                xfTypeManagerForDom.addSymbol(node3);
                Node node4 = XmDomUtil.getElement((Node)node3, (String)"name");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node4));
                xmfWriter.writeToken("=>");
                Node node5 = XmDomUtil.getElement((Node)node3, (String)"value");
                XfDecompileDomVisitor.this.invokeEnter(node5);
            }
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("ASSOCIATE");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FenumDeclVisitor
    extends XcodeNodeVisitor {
        FenumDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(":");
            }
            xmfWriter.writeToken("ENUM");
            xmfWriter.writeToken(",");
            xmfWriter.writeToken("BIND");
            xmfWriter.writeToken("(");
            xmfWriter.writeToken("C");
            xmfWriter.writeToken(")");
            xmfWriter.incrementIndentLevel();
            String string2 = XmDomUtil.getAttr((Node)node, (String)"type");
            if (XfUtilForDom.isNullOrEmpty(string2)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if ((node2 = xfTypeManagerForDom.findType(string2)) == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, string2));
                XfDecompileDomVisitor.this.fail(node);
            }
            Node node3 = XmDomUtil.getElement((Node)node2, (String)"symbols");
            NodeList nodeList = node3.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string3;
                Node node4 = nodeList.item(i);
                if (node4.getNodeType() != 1 || (string3 = node4.getNodeName()) == null || !string3.equals("id")) continue;
                Node node5 = XmDomUtil.getElement((Node)node4, (String)"name");
                if (node5 == null) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node4, XfError.XCODEML_SEMANTICS, "id"));
                    XfDecompileDomVisitor.this.fail(node4);
                }
                xmfWriter.setupNewLine();
                xmfWriter.writeToken("ENUMERATOR");
                xmfWriter.writeToken("::");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node5));
                Node node6 = XmDomUtil.getElement((Node)node4, (String)"value");
                if (node6 == null) continue;
                xmfWriter.writeToken("=");
                XfDecompileDomVisitor.this.invokeEnter(node6);
            }
            xmfWriter.setupNewLine();
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("ENUM");
            xmfWriter.setupNewLine();
        }
    }

    class ForallStatementVisitor
    extends ForallLikeTagVisitor {
        ForallStatementVisitor() {
        }

        @Override
        public void startConstruct() {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("FORALL");
        }

        @Override
        public void endConstruct() {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("FORALL");
        }
    }

    abstract class ForallLikeTagVisitor
    extends XcodeNodeVisitor {
        ForallLikeTagVisitor() {
        }

        public abstract void startConstruct();

        public abstract void endConstruct();

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(":");
            }
            this.startConstruct();
            xmfWriter.writeToken("(");
            Boolean bl = true;
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                if ("Var".equals(nodeList.item(i).getNodeName())) {
                    if (!bl.booleanValue()) {
                        xmfWriter.writeToken(",");
                    }
                    bl = false;
                    Node node2 = nodeList.item(i);
                    XfDecompileDomVisitor.this.invokeEnter(node2);
                    xmfWriter.writeToken("=");
                    continue;
                }
                if (!"indexRange".equals(nodeList.item(i).getNodeName())) continue;
                XfDecompileDomVisitor.this.invokeEnter(nodeList.item(i));
            }
            Node node3 = XmDomUtil.getElement((Node)node, (String)"condition");
            if (node3 != null) {
                xmfWriter.writeToken(",");
                XfDecompileDomVisitor.this._invokeChildEnter(node3);
            }
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            this.endConstruct();
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class BlockStatementVisitor
    extends XcodeNodeVisitor {
        BlockStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(":");
            }
            xmfWriter.writeToken("BLOCK");
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            xfTypeManagerForDom.enterScope();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            Node node2 = XmDomUtil.getElement((Node)node, (String)"declarations");
            XfDecompileDomVisitor.this.invokeEnter(node2);
            XfDecompileDomVisitor.this.writeVolatileOrAsynchronousStatements(node2);
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xfTypeManagerForDom.leaveScope();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("BLOCK");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FimportDeclVisitor
    extends XcodeNodeVisitor {
        FimportDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("IMPORT");
            int n = 0;
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"name"});
            if (arrayList.size() > 0) {
                xmfWriter.writeToken("::");
            }
            for (Node node2 : arrayList) {
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                ++n;
            }
            xmfWriter.setupNewLine();
        }
    }

    class CriticalStatementVisitor
    extends XcodeNodeVisitor {
        CriticalStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(":");
            }
            xmfWriter.writeToken("CRITICAL");
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.writeToken("END CRITICAL");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class SyncStatVisitor
    extends XcodeNodeVisitor {
        SyncStatVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2;
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"kind");
            if (!XfUtilForDom.isNullOrEmpty(string) && (node2 = XmDomUtil.getElement((Node)node, (String)"Var")) != null) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken("=");
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
        }
    }

    class UnlockStatementVisitor
    extends XcodeNodeVisitor {
        UnlockStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("UNLOCK");
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class LockStatementVisitor
    extends XcodeNodeVisitor {
        LockStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("LOCK");
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class SyncMemoryStatementVisitor
    extends XcodeNodeVisitor {
        SyncMemoryStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("SYNC");
            xmfWriter.writeToken("MEMORY");
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class SyncImagesStatementVisitor
    extends XcodeNodeVisitor {
        SyncImagesStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            Node node2 = null;
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (!exprModelSet.contains(node3.getNodeName())) continue;
                node2 = node3;
            }
            xmfWriter.writeToken("SYNC");
            xmfWriter.writeToken("IMAGES");
            xmfWriter.writeToken("(");
            if (node2 == null) {
                xmfWriter.writeToken("*");
                if (n > 1) {
                    xmfWriter.writeToken(",");
                }
            }
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class SyncAllStatementVisitor
    extends XcodeNodeVisitor {
        SyncAllStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("SYNC");
            xmfWriter.writeToken("ALL");
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class VarRefVisitor
    extends XcodeNodeVisitor {
        VarRefVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class VarListVisitor
    extends XcodeNodeVisitor {
        VarListVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            if (XfDecompileDomVisitor.this._isInvokeNodeOf("FcommonDecl", 1)) {
                xmfWriter.writeToken("/");
                if (!XfUtilForDom.isNullOrEmpty(string)) {
                    xmfWriter.writeToken(string);
                }
                xmfWriter.writeToken("/ ");
            } else if (XfDecompileDomVisitor.this._isInvokeNodeOf("FnamelistDecl", 1)) {
                if (XfUtilForDom.isNullOrEmpty(string)) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName()));
                    XfDecompileDomVisitor.this.fail(node);
                }
                xmfWriter.writeToken("/");
                xmfWriter.writeToken(string);
                xmfWriter.writeToken("/ ");
            } else if (!XfDecompileDomVisitor.this._isInvokeNodeOf("FdataDecl", 1) && !XfDecompileDomVisitor.this._isInvokeNodeOf("FequivalenceDecl", 1)) assert (false);
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
        }
    }

    class VarDeclVisitor
    extends XcodeNodeVisitor {
        VarDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            XfSymbol xfSymbol = XfDecompileDomVisitor.this._makeSymbol(node2);
            if (xfSymbol == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node2, XfError.XCODEML_NAME_NOT_FOUND, XmDomUtil.getContentText((Node)node2)));
                XfDecompileDomVisitor.this.fail(node2);
            }
            String string = null;
            Node node3 = XfDecompileDomVisitor.this._context.getTypeManagerForDom().findSymbol(xfSymbol.getSymbolName());
            if (node3 != null) {
                string = XmDomUtil.getAttr((Node)node3, (String)"declared_in");
            }
            if (string != null) {
                return;
            }
            XfDecompileDomVisitor.this._writeLineDirective(node);
            Boolean bl = false;
            if (!XfDecompileDomVisitor.this._isNameDefinedWithUseStmt(xfSymbol.getSymbolName()).booleanValue()) {
                bl = XfDecompileDomVisitor.this._writeSymbolDecl(xfSymbol, node);
            }
            Node node4 = XmDomUtil.getElement((Node)node, (String)"value");
            if (bl.booleanValue() && node4 != null) {
                String string2;
                XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
                XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                Node node5 = xfTypeManagerForDom.findType(string2 = XmDomUtil.getAttr((Node)node2, (String)"type"));
                if (node5 != null && XmDomUtil.getAttrBool((Node)node5, (String)"is_pointer")) {
                    xmfWriter.writeToken(" => ");
                } else {
                    xmfWriter.writeToken(" = ");
                }
                XfDecompileDomVisitor.this.invokeEnter(node4);
            }
            XfDecompileDomVisitor.this._context.getWriter().setupNewLine();
        }
    }

    class VarVisitor
    extends XcodeNodeVisitor {
        VarVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken(XmDomUtil.getContentText((Node)node));
        }
    }

    class FfunctionVisitor
    extends XcodeNodeVisitor {
        FfunctionVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken(XmDomUtil.getContentText((Node)node));
        }
    }

    class ValueListVisitor
    extends XcodeNodeVisitor {
        ValueListVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
        }
    }

    class RepeatCountVisitor
    extends XcodeNodeVisitor {
        RepeatCountVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class ValueVisitor
    extends XcodeNodeVisitor {
        ValueVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Node node2 = XmDomUtil.getElement((Node)node, (String)"repeat_count");
            if (node2 != null) {
                object = XfDecompileDomVisitor.this._context.getWriter();
                XfDecompileDomVisitor.this.invokeEnter(node2);
                ((XmfWriter)object).writeToken("*");
            }
            if (!((ArrayList)(object = XmDomUtil.collectElementsExclude((Node)node, (String[])new String[]{"repeat_count"}))).isEmpty()) {
                assert (((ArrayList)object).size() == 1);
                XfDecompileDomVisitor.this.invokeEnter((Node)((ArrayList)object).get(0));
            }
        }
    }

    class UserUnaryExprVisitor
    extends XcodeNodeVisitor {
        UserUnaryExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            if (XfUtilForDom.isNullOrEmpty(string)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            XfDecompileDomVisitor.this._writeUnaryExpr(XmDomUtil.getContent((Node)node), string, true);
        }
    }

    class UserBinaryExprVisitor
    extends XcodeNodeVisitor {
        UserBinaryExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            if (XfUtilForDom.isNullOrEmpty(string)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "name", node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, string, XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class UpperBoundVisitor
    extends XcodeNodeVisitor {
        UpperBoundVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class UnaryMinusExprVisitor
    extends XcodeNodeVisitor {
        UnaryMinusExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2 = XmDomUtil.getContent((Node)node);
            boolean bl = true;
            if (XfDecompileDomVisitor.this._isConstantExpr(node.getParentNode()) && XfDecompileDomVisitor.this._isConstantExpr(node2)) {
                bl = false;
            }
            XfDecompileDomVisitor.this._writeUnaryExpr(node2, "-", bl);
        }
    }

    class ThenVisitor
    extends XcodeNodeVisitor {
        ThenVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
        }
    }

    class SymbolsVisitor
    extends XcodeNodeVisitor {
        SymbolsVisitor() {
        }

        @Override
        public void enter(Node node) {
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"id"});
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            if (!XfDecompileDomVisitor.this._isInvokeAncestorNodeOf("FstructDecl")) {
                XfDecompileDomVisitor.this._context.debugPrintLine("Add to symbol table.");
                for (Node node2 : arrayList) {
                    xfTypeManagerForDom.addSymbol(node2);
                }
            } else {
                XfDecompileDomVisitor.this._context.debugPrintLine("Write symbol.");
                for (Node node3 : arrayList) {
                    String string;
                    XfSymbol xfSymbol;
                    String string2 = XmDomUtil.getAttr((Node)node3, (String)"type");
                    Node node4 = XmDomUtil.getElement((Node)node3, (String)"name");
                    if (string2 == null && (string2 = XmDomUtil.getAttr((Node)node4, (String)"type")) == null) {
                        XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node3, XfError.XCODEML_NEED_ATTR, "type", node.getNodeName()));
                        XfDecompileDomVisitor.this.fail(node);
                    }
                    if ((xfSymbol = XfDecompileDomVisitor.this._makeSymbol(string = XmDomUtil.getContentText((Node)node4), string2)) == null) {
                        XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node3, XfError.XCODEML_TYPE_NOT_FOUND, string2));
                        XfDecompileDomVisitor.this.fail(node);
                    }
                    Boolean bl = false;
                    if (!XfDecompileDomVisitor.this._isNameDefinedWithUseStmt(xfSymbol.getSymbolName()).booleanValue()) {
                        bl = XfDecompileDomVisitor.this._writeSymbolDecl(xfSymbol, node);
                    }
                    Node node5 = XmDomUtil.getElement((Node)node3, (String)"value");
                    if (bl.booleanValue() && node5 != null) {
                        XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
                        Node node6 = xfTypeManagerForDom.findType(string2);
                        if (XmDomUtil.getAttrBool((Node)node6, (String)"is_pointer")) {
                            xmfWriter.writeToken(" => ");
                        } else {
                            xmfWriter.writeToken(" = ");
                        }
                        XfDecompileDomVisitor.this.invokeEnter(node5);
                    }
                    XfDecompileDomVisitor.this._context.getWriter().setupNewLine();
                }
            }
        }
    }

    class StepVisitor
    extends XcodeNodeVisitor {
        StepVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class StatementLabelVisitor
    extends XcodeNodeVisitor {
        StatementLabelVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"label_name"));
            xmfWriter.incrementIndentLevel();
            if (XfDecompileDomVisitor.this._nextNode != null && "statementLabel".equals(XfDecompileDomVisitor.this._nextNode.getNodeName())) {
                xmfWriter.writeToken(" CONTINUE");
                xmfWriter.setupNewLine();
            } else {
                xmfWriter.writeToken(" ");
                xmfWriter.setupContiguousNewLine();
            }
        }
    }

    class PlusExprVisitor
    extends XcodeNodeVisitor {
        PlusExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "+", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class ParamsVisitor
    extends XcodeNodeVisitor {
        ParamsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            int n = 0;
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"name"});
            for (Node node2 : arrayList) {
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                ++n;
            }
        }
    }

    class NamedValueListVisitor
    extends XcodeNodeVisitor {
        NamedValueListVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
            xmfWriter.writeToken(")");
        }
    }

    class NamedValueVisitor
    extends XcodeNodeVisitor {
        NamedValueVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"name"));
            xmfWriter.writeToken("=");
            Node node2 = XmDomUtil.getContent((Node)node);
            if (node2 == null) {
                xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"value"));
            } else {
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
        }
    }

    class NameVisitor
    extends XcodeNodeVisitor {
        NameVisitor() {
        }

        @Override
        public void enter(Node node) {
            assert (false);
        }
    }

    class MulExprVisitor
    extends XcodeNodeVisitor {
        MulExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "*", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class MinusExprVisitor
    extends XcodeNodeVisitor {
        MinusExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "-", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LowerBoundVisitor
    extends XcodeNodeVisitor {
        LowerBoundVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class LogOrExprVisitor
    extends XcodeNodeVisitor {
        LogOrExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ".OR.", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogNotExprVisitor
    extends XcodeNodeVisitor {
        LogNotExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeUnaryExpr(XmDomUtil.getContent((Node)node), ".NOT.", true);
        }
    }

    class LogNEQVExprVisitor
    extends XcodeNodeVisitor {
        LogNEQVExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ".NEQV.", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogNEQExprVisitor
    extends XcodeNodeVisitor {
        LogNEQExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "/=", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogLTExprVisitor
    extends XcodeNodeVisitor {
        LogLTExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "<", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogLEExprVisitor
    extends XcodeNodeVisitor {
        LogLEExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "<=", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogGTExprVisitor
    extends XcodeNodeVisitor {
        LogGTExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ">", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogGEExprVisitor
    extends XcodeNodeVisitor {
        LogGEExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ">=", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogEQVExprVisitor
    extends XcodeNodeVisitor {
        LogEQVExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ".EQV.", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogEQExprVisitor
    extends XcodeNodeVisitor {
        LogEQExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "==", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LogAndExprVisitor
    extends XcodeNodeVisitor {
        LogAndExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, ".AND.", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class LenVisitor
    extends XcodeNodeVisitor {
        LenVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2 = XmDomUtil.getContent((Node)node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_shape")) {
                xmfWriter.writeToken(":");
            } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_size")) {
                xmfWriter.writeToken("*");
            } else if (node2 == null) {
                xmfWriter.writeToken("*");
            } else {
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
        }
    }

    class KindVisitor
    extends XcodeNodeVisitor {
        KindVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class IndexRangeVisitor
    extends XcodeNodeVisitor {
        IndexRangeVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XfDecompileDomVisitor.this._isInvokeNodeOf("FdoLoop", 1) ? ", " : (XfDecompileDomVisitor.this._isInvokeNodeOf("FdoStatement", 1) ? ", " : ":");
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_shape") && XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_size")) {
                XfDecompileDomVisitor.this._context.debugPrintLine("'is_assumed_shape' and 'is_assumed_size' are logically exclusize attributes.");
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_shape")) {
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"lowerBound"));
                xmfWriter.writeToken(":");
                return;
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_assumed_size")) {
                Node node2 = XmDomUtil.getElement((Node)node, (String)"lowerBound");
                if (node2 != null) {
                    XfDecompileDomVisitor.this.invokeEnter(node2);
                    xmfWriter.writeToken(":");
                }
                xmfWriter.writeToken("*");
                return;
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"lowerBound"));
            xmfWriter.writeToken(string);
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"upperBound"));
            Node node3 = XmDomUtil.getElement((Node)node, (String)"step");
            if (node3 != null) {
                xmfWriter.writeToken(string);
                XfDecompileDomVisitor.this.invokeEnter(node3);
            }
        }
    }

    class IdVisitor
    extends XcodeNodeVisitor {
        IdVisitor() {
        }

        @Override
        public void enter(Node node) {
            assert (false);
        }
    }

    class GotoStatementVisitor
    extends XcodeNodeVisitor {
        GotoStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("GOTO ");
            String string = XmDomUtil.getAttr((Node)node, (String)"label_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            } else {
                ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    if (!"params".equals(node2.getNodeName())) {
                        throw new XmTranslationException(node, "Invalid contents");
                    }
                    if (!iterator.hasNext()) {
                        throw new XmTranslationException(node, "Invalid contents");
                    }
                    Node node3 = (Node)iterator.next();
                    if (!"value".equals(node3.getNodeName())) {
                        throw new XmTranslationException(node, "Invalid contents");
                    }
                    xmfWriter.writeToken("(");
                    XfDecompileDomVisitor.this.invokeEnter(node2);
                    xmfWriter.writeToken("), ");
                    XfDecompileDomVisitor.this.invokeEnter(node3);
                }
            }
            xmfWriter.setupNewLine();
        }
    }

    class FwriteStatementVisitor
    extends XcodeNodeVisitor {
        FwriteStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("WRITE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.writeToken(" ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"valueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FwhereStatementVisitor
    extends XcodeNodeVisitor {
        FwhereStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("WHERE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"condition"));
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"then"));
            Node node2 = XmDomUtil.getElement((Node)node, (String)"else");
            if (node2 != null) {
                xmfWriter.writeToken("ELSEWHERE");
                xmfWriter.setupNewLine();
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
            xmfWriter.writeToken("END WHERE");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FuseOnlyDeclVisitor
    extends XcodeNodeVisitor {
        FuseOnlyDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("USE ");
            if (XmDomUtil.getAttrBool((Node)node, (String)"intrinsic")) {
                xmfWriter.writeToken(", INTRINSIC :: ");
            }
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"name"));
            xmfWriter.writeToken(", ONLY: ");
            int n = 0;
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"renamable"});
            for (Node node2 : arrayList) {
                if (!XfDecompileDomVisitor.this._validator.validateAttr(node2)) {
                    XfDecompileDomVisitor.this._context.debugPrintLine("Detected insufficient attributes");
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfDecompileDomVisitor.this._validator.getErrDesc());
                    XfDecompileDomVisitor.this.fail(node);
                }
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                boolean bl = XmDomUtil.getAttrBool((Node)node2, (String)"is_operator");
                String string = XmDomUtil.getAttr((Node)node2, (String)"local_name");
                String string2 = XmDomUtil.getAttr((Node)node2, (String)"use_name");
                if (!XfUtilForDom.isNullOrEmpty(string)) {
                    if (bl) {
                        if (string.equals("=")) {
                            xmfWriter.writeToken("ASSIGNMENT");
                        } else {
                            xmfWriter.writeToken("OPERATOR");
                        }
                        xmfWriter.writeToken("(");
                        xmfWriter.writeToken(string);
                        xmfWriter.writeToken(")");
                    } else {
                        xmfWriter.writeToken(string);
                    }
                    xmfWriter.writeToken(" => ");
                }
                if (!XfUtilForDom.isNullOrEmpty(string2)) {
                    if (bl) {
                        if (string2.equals("=")) {
                            xmfWriter.writeToken("ASSIGNMENT");
                        } else {
                            xmfWriter.writeToken("OPERATOR");
                        }
                        xmfWriter.writeToken("(");
                        xmfWriter.writeToken(string2);
                        xmfWriter.writeToken(")");
                    } else {
                        xmfWriter.writeToken(string2);
                    }
                }
                ++n;
            }
            xmfWriter.setupNewLine();
        }
    }

    class FuseDeclVisitor
    extends XcodeNodeVisitor {
        FuseDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("USE ");
            if (XmDomUtil.getAttrBool((Node)node, (String)"intrinsic")) {
                xmfWriter.writeToken(", INTRINSIC :: ");
            }
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"name"));
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"rename"});
            for (Node node2 : arrayList) {
                if (!XfDecompileDomVisitor.this._validator.validateAttr(node2)) {
                    XfDecompileDomVisitor.this._context.debugPrintLine("Detected insufficient attributes");
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfDecompileDomVisitor.this._validator.getErrDesc());
                    XfDecompileDomVisitor.this.fail(node);
                }
                boolean bl = XmDomUtil.getAttrBool((Node)node2, (String)"is_operator");
                String string = XmDomUtil.getAttr((Node)node2, (String)"local_name");
                String string2 = XmDomUtil.getAttr((Node)node2, (String)"use_name");
                xmfWriter.writeToken(", ");
                if (!XfUtilForDom.isNullOrEmpty(string)) {
                    if (bl) {
                        xmfWriter.writeToken("OPERATOR");
                        xmfWriter.writeToken("(");
                        xmfWriter.writeToken(string);
                        xmfWriter.writeToken(")");
                    } else {
                        xmfWriter.writeToken(string);
                    }
                    xmfWriter.writeToken(" => ");
                }
                if (XfUtilForDom.isNullOrEmpty(string2)) continue;
                if (bl) {
                    xmfWriter.writeToken("OPERATOR");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken(string2);
                    xmfWriter.writeToken(")");
                    continue;
                }
                xmfWriter.writeToken(string2);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FunctionCallVisitor
    extends XcodeNodeVisitor {
        FunctionCallVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Object object2;
            Object object3;
            String string = null;
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            Node node3 = XmDomUtil.getElement((Node)node, (String)"FmemberRef");
            if (node2 == null && node3 == null) {
                XfDecompileDomVisitor.this._context.debugPrintLine("Detected a function call with neither the name element nor the memberRef element.");
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (node2 != null && node3 != null) {
                XfDecompileDomVisitor.this._context.debugPrintLine("Detected a function call with either the name element and the memberRef element.");
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (node2 != null) {
                string = XmDomUtil.getContentText((Node)node2);
                if (XfUtilForDom.isNullOrEmpty(string)) {
                    XfDecompileDomVisitor.this._context.debugPrintLine("Function name is empty.");
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node2, XfError.XCODEML_SEMANTICS, node2.getNodeName()));
                    XfDecompileDomVisitor.this.fail(node2);
                }
                if (!XmDomUtil.getAttrBool((Node)node, (String)"is_intrinsic") && !XfDecompileDomVisitor.this._isNameDefinedWithUseStmt(string).booleanValue()) {
                    object3 = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                    object2 = ((XfTypeManagerForDom)object3).findType(node2);
                    if (object2 == null) {
                        XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node2, (String)"type")));
                        XfDecompileDomVisitor.this.fail(node);
                    } else if (!this._isFunctionType((Node)object2)) {
                        XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", object2.getNodeName(), "FfunctionType"));
                        XfDecompileDomVisitor.this.fail(node);
                    }
                    object = object2;
                    if (XmDomUtil.getAttrBool((Node)object, (String)"is_program")) {
                        XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", "PROGRAM", "FUNCTION or SUBROUTINE"));
                        XfDecompileDomVisitor.this.fail(node);
                    }
                }
            }
            object3 = XfDecompileDomVisitor.this._context.getWriter();
            object2 = XmDomUtil.getAttr((Node)node, (String)"type");
            object = XfType.getTypeIdFromXcodemlTypeName((String)object2);
            if (object == XfType.VOID) {
                ((XmfWriter)object3).writeToken("CALL ");
            }
            if (string != null) {
                ((XmfWriter)object3).writeToken(string);
            } else {
                XfDecompileDomVisitor.this.invokeEnter(node3);
            }
            ((XmfWriter)object3).writeToken("(");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"arguments"));
            ((XmfWriter)object3).writeToken(")");
        }

        public boolean _isFunctionType(Node node) {
            if ("FfunctionType".equals(node.getNodeName()) || XmDomUtil.getAttrBool((Node)node, (String)"is_procedure")) {
                return true;
            }
            XfTypeManagerForDom.TypeList typeList = XfDecompileDomVisitor.this.getTypeList(XmDomUtil.getAttr((Node)node, (String)"type"));
            for (Node node2 : typeList) {
                if (!"FfunctionType".equals(node2.getNodeName())) continue;
                return true;
            }
            return false;
        }
    }

    class FstructDeclVisitor
    extends XcodeNodeVisitor {
        FstructDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string;
            String string2;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            if (!XfDecompileDomVisitor.this._validator.validateAttr(node2)) {
                XfDecompileDomVisitor.this._context.debugPrintLine("Detected insufficient attributes");
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfDecompileDomVisitor.this._validator.getErrDesc());
                XfDecompileDomVisitor.this.fail(node);
            }
            String string3 = XmDomUtil.getAttr((Node)node2, (String)"type");
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            Node node3 = xfTypeManagerForDom.findType(string3);
            if (node3 == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node2, (String)"type")));
                XfDecompileDomVisitor.this.fail(node);
            } else if (!"FstructType".equals(node3.getNodeName())) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "struct definition", node3.getNodeName(), "FstructType"));
                XfDecompileDomVisitor.this.fail(node);
            }
            Node node4 = node3;
            String string4 = XmDomUtil.getContentText((Node)node2);
            xfTypeManagerForDom.putAliasTypeName(string3, string4);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("TYPE");
            if (XmDomUtil.getAttrBool((Node)node4, (String)"is_abstract")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("ABSTRACT");
            }
            if ((string2 = XmDomUtil.getAttr((Node)node4, (String)"extends")) != null) {
                string = xfTypeManagerForDom.getAliasTypeName(string2);
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("EXTENDS");
                xmfWriter.writeToken("(");
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(")");
            }
            if (XfDecompileDomVisitor.this._isUnderModuleDef()) {
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_private")) {
                    xmfWriter.writeToken(", PRIVATE");
                } else if (XmDomUtil.getAttrBool((Node)node4, (String)"is_public")) {
                    xmfWriter.writeToken(", PUBLIC");
                } else if (XmDomUtil.getAttrBool((Node)node4, (String)"is_protected")) {
                    xmfWriter.writeToken(", PROTECTED");
                }
            }
            if (!XfUtilForDom.isNullOrEmpty(string = XmDomUtil.getAttr((Node)node4, (String)"bind"))) {
                xmfWriter.writeToken(", ");
                xmfWriter.writeToken("BIND( " + string.toUpperCase() + " )");
            }
            xmfWriter.writeToken(" :: ");
            xmfWriter.writeToken(string4);
            Node node5 = XmDomUtil.getElement((Node)node4, (String)"typeParams");
            if (node5 != null) {
                xmfWriter.writeToken("(");
                ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node5);
                for (Node node6 : arrayList) {
                    if (node6 != arrayList.get(0)) {
                        xmfWriter.writeToken(",");
                    }
                    xmfWriter.writeToken(XmDomUtil.getContentText((Node)XmDomUtil.getElement((Node)node6, (String)"name")));
                }
                xmfWriter.writeToken(")");
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            if (XfDecompileDomVisitor.this._isUnderModuleDef() && XmDomUtil.getAttrBool((Node)node4, (String)"is_internal_private")) {
                xmfWriter.writeToken("PRIVATE");
                xmfWriter.setupNewLine();
            }
            if (XmDomUtil.getAttrBool((Node)node4, (String)"is_sequence")) {
                xmfWriter.writeToken("SEQUENCE");
                xmfWriter.setupNewLine();
            }
            XfDecompileDomVisitor.this.invokeEnter(node4);
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END TYPE");
            xmfWriter.writeToken(" ");
            xmfWriter.writeToken(string4);
            xmfWriter.setupNewLine();
        }
    }

    class FstructConstructorVisitor
    extends XcodeNodeVisitor {
        FstructConstructorVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2;
            Node node3;
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XfTypeManagerForDom.TypeList typeList = XfDecompileDomVisitor.this.getTypeList(XmDomUtil.getAttr((Node)node, (String)"type"));
            if (typeList == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node, (String)"type")));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (!"FstructType".equals((node3 = "FbasicType".equals((node2 = (Node)typeList.getFirst()).getNodeName()) ? xfTypeManagerForDom.findType(XmDomUtil.getAttr((Node)node, (String)"ref")) : node2).getNodeName())) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "struct definition", node.getNodeName(), "FstructType"));
                XfDecompileDomVisitor.this.fail(node);
            }
            String string = xfTypeManagerForDom.getAliasTypeName(XmDomUtil.getAttr((Node)node3, (String)"type"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken(string);
            Node node4 = XmDomUtil.getElement((Node)node, (String)"typeParamValues");
            if (node4 != null) {
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node4, ", ");
                xmfWriter.writeToken(")");
            }
            ArrayList arrayList = XmDomUtil.collectElementsExclude((Node)node, (String[])new String[]{"typeParamValues"});
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ", ");
            xmfWriter.writeToken(")");
        }
    }

    class FpauseStatementVisitor
    extends XcodeNodeVisitor {
        FpauseStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("PAUSE ");
            String string = XmDomUtil.getAttr((Node)node, (String)"code");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"message");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            } else if (!XfUtilForDom.isNullOrEmpty(string2)) {
                xmfWriter.writeLiteralString(string2);
            } else {
                xmfWriter.writeToken("0");
            }
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            xmfWriter.setupNewLine();
        }
    }

    class FerrorStopStatementVisitor
    extends XcodeNodeVisitor {
        FerrorStopStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("ERROR");
            xmfWriter.writeToken("STOP");
            String string = XmDomUtil.getAttr((Node)node, (String)"code");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"message");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            } else if (!XfUtilForDom.isNullOrEmpty(string2)) {
                xmfWriter.writeLiteralString(string2);
            }
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            xmfWriter.setupNewLine();
        }
    }

    class FstopStatementVisitor
    extends XcodeNodeVisitor {
        FstopStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("STOP");
            String string = XmDomUtil.getAttr((Node)node, (String)"code");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"message");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
            } else if (!XfUtilForDom.isNullOrEmpty(string2)) {
                xmfWriter.writeLiteralString(string2);
            }
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            xmfWriter.setupNewLine();
        }
    }

    class SelectTypeStatementVisitor
    extends XcodeNodeVisitor {
        SelectTypeStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("SELECT TYPE (");
            Node node2 = XmDomUtil.getElement((Node)node, (String)"id");
            Node node3 = XmDomUtil.getElement((Node)node2, (String)"name");
            if (!node3.getTextContent().equals("")) {
                xmfWriter.writeToken(node3.getTextContent());
                xmfWriter.writeToken("=>");
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node2, (String)"value"));
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"typeGuard"});
            XfDecompileDomVisitor.this._invokeEnter(arrayList);
            xmfWriter.writeToken("END SELECT");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FselectCaseStatementVisitor
    extends XcodeNodeVisitor {
        FselectCaseStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("SELECT CASE (");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"value"));
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"FcaseLabel"});
            XfDecompileDomVisitor.this._invokeEnter(arrayList);
            xmfWriter.writeToken("END SELECT");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FrewindStatementVisitor
    extends XcodeNodeVisitor {
        FrewindStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("REWIND ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FreturnStatementVisitor
    extends XcodeNodeVisitor {
        FreturnStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("RETURN");
            xmfWriter.setupNewLine();
        }
    }

    class FrealConstantVisitor
    extends XcodeNodeVisitor {
        FrealConstantVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string;
            Object object;
            String string2;
            String string3 = XmDomUtil.getContentText((Node)node);
            if (XfUtilForDom.isNullOrEmpty(string3)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (!XfUtilForDom.isNullOrEmpty(string2 = XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfType xfType;
                object = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                string = ((XfTypeManagerForDom)object).getBottomTypeName(string2);
                if (string == null) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, node.getNodeName(), string2));
                    XfDecompileDomVisitor.this.fail(node);
                }
                if ((xfType = XfType.getTypeIdFromXcodemlTypeName(string)) != XfType.DERIVED && xfType != XfType.REAL) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, node.getNodeName(), string2, "Fint"));
                    XfDecompileDomVisitor.this.fail(node);
                }
            }
            object = XfDecompileDomVisitor.this._context.getWriter();
            string = XmDomUtil.getAttr((Node)node, (String)"kind");
            if (!XfUtilForDom.isNullOrEmpty(string) && string3.toLowerCase().indexOf("d") < 0 && string3.toLowerCase().indexOf("q") < 0) {
                ((XmfWriter)object).writeToken(string3 + "_" + string);
            } else {
                ((XmfWriter)object).writeToken(string3);
            }
        }
    }

    class FreadStatementVisitor
    extends XcodeNodeVisitor {
        FreadStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("READ ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.writeToken(" ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"valueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FprintStatementVisitor
    extends XcodeNodeVisitor {
        FprintStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("PRINT ");
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"format"));
            Node node2 = XmDomUtil.getElement((Node)node, (String)"valueList");
            if (node2 != null && XmDomUtil.collectChildNodes((Node)node2).size() > 0) {
                xmfWriter.writeToken(", ");
            }
            XfDecompileDomVisitor.this.invokeEnter(node2);
            xmfWriter.setupNewLine();
        }
    }

    class ACCPragmaVisitor
    extends XcodeNodeVisitor {
        ACCPragmaVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2;
            int n;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            NodeList nodeList = node.getChildNodes();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            XmfWriter.StatementMode statementMode = xmfWriter.getStatementMode();
            xmfWriter.setStatementMode(XmfWriter.StatementMode.ACC);
            Node node3 = nodeList.item(0);
            String string = XmDomUtil.getContentText((Node)node3);
            if (string.equals("PARALLEL_LOOP")) {
                string = "PARALLEL LOOP";
            } else if (string.equals("KERNELS_LOOP")) {
                string = "KERNELS LOOP";
            } else if (string.equals("ENTER_DATA")) {
                string = "ENTER DATA";
            } else if (string.equals("EXIT_DATA")) {
                string = "EXIT DATA";
            }
            xmfWriter.writeToken("!$ACC " + string);
            Node node4 = nodeList.item(1);
            NodeList nodeList2 = node4.getChildNodes();
            int n2 = nodeList2.getLength();
            int n3 = -1;
            if (string.equals("WAIT") || string.equals("CACHE") || string.equals("ROUTINE")) {
                for (n = 0; n < n2; ++n) {
                    node2 = nodeList2.item(n);
                    if (!this.getClauseName(node2).equals(string)) continue;
                    this.enterClause(string, node2);
                    n3 = n;
                    break;
                }
            }
            for (n = 0; n < n2; ++n) {
                node2 = nodeList2.item(n);
                if (n == n3) continue;
                this.enterClause(string, node2);
            }
            xmfWriter.setStatementMode(statementMode);
            xmfWriter.setupNewLine();
            Node node5 = nodeList.item(2);
            this.enterBody(node5);
            if (string.equals("PARALLEL") || string.equals("KERNELS") || string.equals("DATA") || string.equals("HOST_DATA") || string.equals("ATOMIC")) {
                xmfWriter.writeToken("!$ACC END " + string);
                xmfWriter.setupNewLine();
            }
        }

        private void enterClause(String string, Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            NodeList nodeList = node.getChildNodes();
            String string2 = this.getClauseName(node);
            Node node2 = nodeList.item(1);
            if (string2.equals("ASTERISK")) {
                xmfWriter.writeToken("*");
                return;
            }
            if (string2.equals("COMMONBLOCK")) {
                xmfWriter.writeToken("/");
                this.enterClauseArg(string, node2);
                xmfWriter.writeToken("/");
                return;
            }
            if (string2.equals("STATIC")) {
                xmfWriter.writeToken(string2 + ":");
                this.enterClauseArg(string, node2);
                return;
            }
            String string3 = "";
            if (string2.equals("REDUCTION_PLUS")) {
                string2 = "REDUCTION";
                string3 = "+";
            } else if (string2.equals("REDUCTION_MUL")) {
                string2 = "REDUCTION";
                string3 = "*";
            } else if (string2.equals("REDUCTION_MAX")) {
                string2 = "REDUCTION";
                string3 = "MAX";
            } else if (string2.equals("REDUCTION_MIN")) {
                string2 = "REDUCTION";
                string3 = "MIN";
            } else if (string2.equals("REDUCTION_BITAND")) {
                string2 = "REDUCTION";
                string3 = "IAND";
            } else if (string2.equals("REDUCTION_BITOR")) {
                string2 = "REDUCTION";
                string3 = "IOR";
            } else if (string2.equals("REDUCTION_BITXOR")) {
                string2 = "REDUCTION";
                string3 = "IEOR";
            } else if (string2.equals("REDUCTION_LOGAND")) {
                string2 = "REDUCTION";
                string3 = ".AND.";
            } else if (string2.equals("REDUCTION_LOGOR")) {
                string2 = "REDUCTION";
                string3 = ".OR.";
            } else if (string2.equals("REDUCTION_EQV")) {
                string2 = "REDUCTION";
                string3 = ".EQV.";
            } else if (string2.equals("REDUCTION_NEQV")) {
                string2 = "REDUCTION";
                string3 = ".NEQV.";
            }
            if (!string2.equals(string)) {
                xmfWriter.writeToken(string2);
            }
            if (node2 == null) {
                return;
            }
            xmfWriter.writeToken("(");
            if (string2.equals("REDUCTION")) {
                xmfWriter.writeToken(string3 + ":");
            }
            if (node2.getNodeName().equals("list") && !this.isClauseNode(node2)) {
                NodeList nodeList2 = node2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (i != 0) {
                        xmfWriter.writeToken(",");
                    }
                    this.enterClauseArg(string, nodeList2.item(i));
                }
            } else {
                this.enterClauseArg(string, node2);
            }
            xmfWriter.writeToken(")");
        }

        private void enterClauseArg(String string, Node node) {
            if (node == null) {
                return;
            }
            if (this.isClauseNode(node)) {
                this.enterClause(string, node);
                return;
            }
            XfDecompileDomVisitor.this.invokeEnter(node);
        }

        private boolean isClauseNode(Node node) {
            if (!node.getNodeName().equals("list")) {
                return false;
            }
            return node.getFirstChild().getNodeName().equals("string");
        }

        private String getClauseName(Node node) {
            if (!this.isClauseNode(node)) {
                return null;
            }
            Node node2 = node.getFirstChild();
            return XmDomUtil.getContentText((Node)node2);
        }

        private void enterBody(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.incrementIndentLevel();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
            xmfWriter.decrementIndentLevel();
        }
    }

    class OMPPragmaVisitor
    extends XcodeNodeVisitor {
        OMPPragmaVisitor() {
        }

        @Override
        public void enter(Node node) {
            Node node2;
            Object object;
            Object object2;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            boolean bl = false;
            boolean bl2 = false;
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            XmfWriter.StatementMode statementMode = xmfWriter.getStatementMode();
            xmfWriter.setStatementMode(XmfWriter.StatementMode.OMP);
            Node node3 = node.getFirstChild();
            while (node3.getNodeType() != 1) {
                node3 = node3.getNextSibling();
            }
            String string = XmDomUtil.getContentText((Node)node3);
            if (string.equals("FOR")) {
                string = "DO";
            }
            xmfWriter.writeToken("!$OMP " + string);
            if (string.equals("THREADPRIVATE") || string.equals("FLUSH")) {
                xmfWriter.writeToken("(");
                node3 = node3.getNextSibling();
                while (node3.getNodeType() != 1) {
                    node3 = node3.getNextSibling();
                }
                NodeList nodeList = node3.getChildNodes();
                int n = 0;
                while (nodeList.item(n).getNodeType() != 1) {
                    ++n;
                }
                XfDecompileDomVisitor.this.invokeEnter(nodeList.item(n));
                ++n;
                while (n < nodeList.getLength()) {
                    Node node4 = nodeList.item(n);
                    if (node4.getNodeType() == 1) {
                        xmfWriter.writeToken(",");
                        XfDecompileDomVisitor.this.invokeEnter(node4);
                    }
                    ++n;
                }
                xmfWriter.writeToken(")");
                xmfWriter.setStatementMode(statementMode);
                xmfWriter.setupNewLine();
                return;
            }
            if (string.equals("BARRIER")) {
                xmfWriter.setStatementMode(statementMode);
                xmfWriter.setupNewLine();
                return;
            }
            Node node5 = node3.getNextSibling();
            while (node5.getNodeType() != 1) {
                node5 = node5.getNextSibling();
            }
            Node node6 = null;
            NodeList nodeList = node5.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object3;
                object2 = nodeList.item(i);
                if (object2.getNodeType() != 1) continue;
                String string2 = XmDomUtil.getContentText((Node)object2);
                object = "";
                if (string2.equals("DATA_DEFAULT")) {
                    string2 = "DEFAULT";
                } else if (string2.equals("DATA_PRIVATE")) {
                    string2 = "PRIVATE";
                } else if (string2.equals("DATA_SHARED")) {
                    string2 = "SHARED";
                } else if (string2.equals("DATA_FIRSTPRIVATE")) {
                    string2 = "FIRSTPRIVATE";
                } else if (string2.equals("DATA_LASTPRIVATE")) {
                    string2 = "LASTPRIVATE";
                } else if (string2.equals("DATA_COPYIN")) {
                    string2 = "COPYIN";
                } else if (string2.equals("DATA_REDUCTION_PLUS")) {
                    string2 = "REDUCTION";
                    object = "+";
                } else if (string2.equals("DATA_REDUCTION_MINUS")) {
                    string2 = "REDUCTION";
                    object = "-";
                } else if (string2.equals("DATA_REDUCTION_MUL")) {
                    string2 = "REDUCTION";
                    object = "*";
                } else if (string2.equals("DATA_REDUCTION_BITAND")) {
                    string2 = "REDUCTION";
                    object = "iand";
                } else if (string2.equals("DATA_REDUCTION_BITOR")) {
                    string2 = "REDUCTION";
                    object = "ior";
                } else if (string2.equals("DATA_REDUCTION_BITXOR")) {
                    string2 = "REDUCTION";
                    object = "ieor";
                } else if (string2.equals("DATA_REDUCTION_LOGAND")) {
                    string2 = "REDUCTION";
                    object = ".and.";
                } else if (string2.equals("DATA_REDUCTION_LOGOR")) {
                    string2 = "REDUCTION";
                    object = ".or.";
                } else if (string2.equals("DATA_REDUCTION_MIN")) {
                    string2 = "REDUCTION";
                    object = "min";
                } else if (string2.equals("DATA_REDUCTION_MAX")) {
                    string2 = "REDUCTION";
                    object = "max";
                } else if (string2.equals("DATA_REDUCTION_EQV")) {
                    string2 = "REDUCTION";
                    object = ".eqv.";
                } else if (string2.equals("DATA_REDUCTION_NEQV")) {
                    string2 = "REDUCTION";
                    object = ".neqv.";
                } else if (string2.equals("DATA_COPYPRIVATE")) {
                    string2 = "COPYPRIVATE";
                    bl2 = true;
                    node6 = object2.getFirstChild().getNextSibling();
                    while (node6.getNodeType() != 1) {
                        node6 = node6.getNextSibling();
                    }
                } else if (string2.equals("DIR_ORDERED")) {
                    string2 = "ORDERED";
                } else if (string2.equals("DIR_IF")) {
                    string2 = "IF";
                } else if (string2.equals("DIR_NOWAIT")) {
                    string2 = "NOWAIT";
                    bl = true;
                } else if (string2.equals("DIR_SCHEDULE")) {
                    string2 = "SCHEDULE";
                }
                if (string2.equals("NOWAIT") || string2.equals("COPYPRIVATE")) continue;
                xmfWriter.writeToken(string2);
                node2 = object2.getFirstChild().getNextSibling();
                while (node2.getNodeType() != 1) {
                    node2 = node2.getNextSibling();
                }
                if (node2 == null) continue;
                xmfWriter.writeToken("(");
                if (object != "") {
                    xmfWriter.writeToken((String)object + " :");
                }
                NodeList nodeList2 = node2.getChildNodes();
                int n = 0;
                while (nodeList2.item(n).getNodeType() != 1) {
                    ++n;
                }
                if (string2.equals("SCHEDULE")) {
                    object3 = XmDomUtil.getContentText((Node)nodeList2.item(n));
                    if (((String)object3).equals("0")) {
                        object3 = "";
                    } else if (((String)object3).equals("1")) {
                        object3 = "STATIC";
                    } else if (((String)object3).equals("2")) {
                        object3 = "DYNAMIC";
                    } else if (((String)object3).equals("3")) {
                        object3 = "GUIDED";
                    } else if (((String)object3).equals("4")) {
                        object3 = "RUNTIME";
                    } else if (((String)object3).equals("5")) {
                        object3 = "AFFINITY";
                    }
                    xmfWriter.writeToken((String)object3);
                } else if (string2.equals("DEFAULT")) {
                    object3 = XmDomUtil.getContentText((Node)nodeList2.item(n));
                    if (((String)object3).equals("0")) {
                        object3 = "SHARED";
                    } else if (((String)object3).equals("1")) {
                        object3 = "";
                    } else if (((String)object3).equals("2")) {
                        object3 = "PRIVATE";
                    }
                    xmfWriter.writeToken((String)object3);
                } else {
                    XfDecompileDomVisitor.this.invokeEnter(nodeList2.item(n));
                }
                ++n;
                while (n < nodeList2.getLength()) {
                    object3 = nodeList2.item(n);
                    if (object3.getNodeType() == 1) {
                        xmfWriter.writeToken(",");
                        XfDecompileDomVisitor.this.invokeEnter((Node)object3);
                    }
                    ++n;
                }
                xmfWriter.writeToken(")");
            }
            xmfWriter.setStatementMode(statementMode);
            xmfWriter.setupNewLine();
            Node node7 = node5.getNextSibling();
            while (node7.getNodeType() != 1) {
                node7 = node7.getNextSibling();
            }
            xmfWriter.incrementIndentLevel();
            object2 = node7.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                if (object.getNodeType() != 1) continue;
                XfDecompileDomVisitor.this.invokeEnter((Node)object);
            }
            xmfWriter.decrementIndentLevel();
            if (!string.equals("ATOMIC")) {
                xmfWriter.writeToken("!$OMP END " + string);
                if (bl) {
                    xmfWriter.writeToken("NOWAIT");
                }
                if (bl2) {
                    xmfWriter.writeToken("COPYPRIVATE (");
                    NodeList nodeList3 = node6.getChildNodes();
                    int n = 0;
                    while (nodeList3.item(n).getNodeType() != 1) {
                        ++n;
                    }
                    XfDecompileDomVisitor.this.invokeEnter(nodeList3.item(n));
                    ++n;
                    while (n < nodeList3.getLength()) {
                        node2 = nodeList3.item(n);
                        if (node2.getNodeType() == 1) {
                            xmfWriter.writeToken(",");
                            XfDecompileDomVisitor.this.invokeEnter(node2);
                        }
                        ++n;
                    }
                    xmfWriter.writeToken(")");
                }
                xmfWriter.setupNewLine();
            }
        }
    }

    class FcommentLineVisitor
    extends XcodeNodeVisitor {
        FcommentLineVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            String string = XmDomUtil.getContentText((Node)node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeIsolatedLine(string);
        }
    }

    class FpragmaStatementVisitor
    extends XcodeNodeVisitor {
        FpragmaStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            String string = XmDomUtil.getContentText((Node)node);
            if (string.startsWith("cdir") || string.startsWith("ocl")) {
                string = "!" + string;
            } else if (!string.startsWith("!$")) {
                string = "!$" + string;
            }
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeIsolatedLine(string);
        }
    }

    class FpowerExprVisitor
    extends XcodeNodeVisitor {
        FpowerExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "**", false);
        }
    }

    class FpointerAssignStatementVisitor
    extends XcodeNodeVisitor {
        FpointerAssignStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "=>", false);
            xmfWriter.setupNewLine();
        }
    }

    class FwaitStatementVisitor
    extends XcodeNodeVisitor {
        FwaitStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("WAIT ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FopenStatementVisitor
    extends XcodeNodeVisitor {
        FopenStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("OPEN ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FnullifyStatementVisitor
    extends XcodeNodeVisitor {
        FnullifyStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("NULLIFY (");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class FnamelistDeclVisitor
    extends XcodeNodeVisitor {
        FnamelistDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("NAMELIST ");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
            xmfWriter.setupNewLine();
        }
    }

    class FblockDataDefinitionVisitor
    extends XcodeNodeVisitor {
        FblockDataDefinitionVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            xmfWriter.writeToken("BLOCK DATA");
            xmfWriter.writeToken(" ");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            xfTypeManagerForDom.enterScope();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"declarations"));
            xmfWriter.decrementIndentLevel();
            xfTypeManagerForDom.leaveScope();
            xmfWriter.writeToken("END BLOCK DATA");
            xmfWriter.writeToken(" ");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
            xmfWriter.setupNewLine();
        }
    }

    class FmoduleProcedureDeclVisitor
    extends XcodeNodeVisitor {
        FmoduleProcedureDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_module_specified")) {
                xmfWriter.writeToken("MODULE ");
            }
            xmfWriter.writeToken("PROCEDURE ");
            int n = 0;
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"name"});
            for (Node node2 : arrayList) {
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                ++n;
            }
            xmfWriter.setupNewLine();
        }
    }

    class FmoduleDefinitionVisitor
    extends XcodeNodeVisitor {
        FmoduleDefinitionVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            boolean bl = XmDomUtil.getAttrBool((Node)node, (String)"is_sub");
            if (bl) {
                xmfWriter.writeToken("SUBMODULE");
                xmfWriter.writeToken("(");
                object = XmDomUtil.getAttr((Node)node, (String)"parent_name");
                xmfWriter.writeToken((String)object);
                xmfWriter.writeToken(")");
            } else {
                xmfWriter.writeToken("MODULE");
            }
            xmfWriter.writeToken(" ");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            xfTypeManagerForDom.enterScope();
            if (!XmOption.coarrayNoUseStatement()) {
                xmfWriter.writeToken("use xmpf_coarray_decl");
                xmfWriter.setupNewLine();
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            object = XmDomUtil.getElement((Node)node, (String)"declarations");
            XfDecompileDomVisitor.this.invokeEnter((Node)object);
            XfDecompileDomVisitor.this.writePublicOrPrivateStatements((Node)object);
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"FcontainsStatement"));
            xmfWriter.decrementIndentLevel();
            xfTypeManagerForDom.leaveScope();
            if (bl) {
                xmfWriter.writeToken("END SUBMODULE");
            } else {
                xmfWriter.writeToken("END MODULE");
            }
            xmfWriter.writeToken(" ");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
            xmfWriter.setupNewLine();
        }
    }

    class FmemberRefVisitor
    extends XcodeNodeVisitor {
        FmemberRefVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"varRef"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("%");
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"member"));
        }
    }

    class FlogicalConstantVisitor
    extends XcodeNodeVisitor {
        FlogicalConstantVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string;
            Object object;
            String string2;
            String string3 = XmDomUtil.getContentText((Node)node);
            if (XfUtilForDom.isNullOrEmpty(string3)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (!XfUtilForDom.isNullOrEmpty(string2 = XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfType xfType;
                object = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                string = ((XfTypeManagerForDom)object).getBottomTypeName(string2);
                if (string == null) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, node.getNodeName(), string2));
                    XfDecompileDomVisitor.this.fail(node);
                }
                if ((xfType = XfType.getTypeIdFromXcodemlTypeName(string)) != XfType.DERIVED && xfType != XfType.LOGICAL) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, node.getNodeName(), string2, "Fint"));
                    XfDecompileDomVisitor.this.fail(node);
                }
            }
            object = XfDecompileDomVisitor.this._context.getWriter();
            string = XmDomUtil.getAttr((Node)node, (String)"kind");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                ((XmfWriter)object).writeToken(string3 + "_" + string);
            } else {
                ((XmfWriter)object).writeToken(string3);
            }
        }
    }

    class FinterfaceDeclVisitor
    extends XcodeNodeVisitor {
        FinterfaceDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"is_defined_io");
            boolean bl = XmDomUtil.getAttrBool((Node)node, (String)"is_abstract");
            if (bl) {
                xmfWriter.writeToken("ABSTRACT");
            }
            xmfWriter.writeToken("INTERFACE");
            if (!XfUtilForDom.isNullOrEmpty(string2)) {
                if ((string2 = string2.toUpperCase()).equals("WRITE(FORMATTED)")) {
                    xmfWriter.writeToken("WRITE");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken("FORMATTED");
                    xmfWriter.writeToken(")");
                } else if (string2.equals("WRITE(UNFORMATTED)")) {
                    xmfWriter.writeToken("WRITE");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken("UNFORMATTED");
                    xmfWriter.writeToken(")");
                } else if (string2.equals("READ(FORMATTED)")) {
                    xmfWriter.writeToken("READ");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken("FORMATTED");
                    xmfWriter.writeToken(")");
                } else if (string2.equals("READ(UNFORMATTED)")) {
                    xmfWriter.writeToken("READ");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken("UNFORMATTED");
                    xmfWriter.writeToken(")");
                } else {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName(), string2));
                    XfDecompileDomVisitor.this.fail(node);
                }
            } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_assignment")) {
                xmfWriter.writeToken(" ASSIGNMENT(=)");
            } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_operator")) {
                xmfWriter.writeToken(" OPERATOR(");
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(")");
            } else if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END INTERFACE");
            xmfWriter.setupNewLine();
        }
    }

    class FintConstantVisitor
    extends XcodeNodeVisitor {
        FintConstantVisitor() {
        }

        @Override
        public void enter(Node node) {
            String string;
            Object object;
            String string2;
            String string3 = XmDomUtil.getContentText((Node)node);
            if (XfUtilForDom.isNullOrEmpty(string3)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (!XfUtilForDom.isNullOrEmpty(string2 = XmDomUtil.getAttr((Node)node, (String)"type"))) {
                XfType xfType;
                object = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                string = ((XfTypeManagerForDom)object).getBottomTypeName(string2);
                if (string == null) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, node.getNodeName(), string2));
                    XfDecompileDomVisitor.this.fail(node);
                }
                if ((xfType = XfType.getTypeIdFromXcodemlTypeName(string)) != XfType.DERIVED && xfType != XfType.INT) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, node.getNodeName(), string2, "Fint"));
                    XfDecompileDomVisitor.this.fail(node);
                }
            }
            object = XfDecompileDomVisitor.this._context.getWriter();
            string = XmDomUtil.getAttr((Node)node, (String)"kind");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                ((XmfWriter)object).writeToken(string3 + "_" + string);
            } else {
                if (new Long(string3) < 0L) {
                    string3 = "(" + string3 + ")";
                }
                ((XmfWriter)object).writeToken(string3);
            }
        }
    }

    class FinquireStatementVisitor
    extends XcodeNodeVisitor {
        FinquireStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("INQUIRE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.writeToken(" ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"valueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FifStatementVisitor
    extends XcodeNodeVisitor {
        FifStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("IF ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"condition"));
            xmfWriter.writeToken(" THEN");
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"then"));
            Node node2 = XmDomUtil.getElement((Node)node, (String)"else");
            if (node2 != null) {
                xmfWriter.writeToken("ELSE");
                if (!XfUtilForDom.isNullOrEmpty(string)) {
                    xmfWriter.writeToken(" ");
                    xmfWriter.writeToken(string);
                }
                xmfWriter.setupNewLine();
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
            xmfWriter.writeToken("END IF");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FmoduleProcedureDefinitionVisitor
    extends XcodeNodeVisitor {
        FmoduleProcedureDefinitionVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            Node node3 = XfDecompileDomVisitor.this.findFunctionType(node, node2);
            String string = XmDomUtil.getAttr((Node)node3, (String)"is_module");
            if (XfUtilForDom.isNullOrEmpty(string)) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_NEED_ATTR, "is_module", node3.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            xmfWriter.writeToken("MODULE");
            xmfWriter.writeToken("PROCEDURE");
            xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            xfTypeManagerForDom.enterScope();
            if (!XmOption.coarrayNoUseStatement()) {
                xmfWriter.writeToken("use xmpf_coarray_decl");
                xmfWriter.setupNewLine();
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            Node node4 = XmDomUtil.getElement((Node)node, (String)"declarations");
            XfDecompileDomVisitor.this.invokeEnter(node4);
            XfDecompileDomVisitor.this.writeVolatileOrAsynchronousStatements(node4);
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xfTypeManagerForDom.leaveScope();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("PROCEDURE");
            xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            xmfWriter.setupNewLine();
        }
    }

    class FfunctionDefinitionVisitor
    extends XcodeNodeVisitor {
        FfunctionDefinitionVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            Node node3 = XfDecompileDomVisitor.this.findFunctionType(node, node2);
            String string = XmDomUtil.getAttr((Node)node3, (String)"return_type");
            XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
            if (XmDomUtil.getAttrBool((Node)node3, (String)"is_program")) {
                xmfWriter.writeToken("PROGRAM");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            } else if (xfType == XfType.VOID) {
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_recursive")) {
                    xmfWriter.writeToken("RECURSIVE");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.hasAttr((Node)node3, (String)"is_pure")) {
                    if (XmDomUtil.getAttrBool((Node)node3, (String)"is_pure")) {
                        xmfWriter.writeToken("PURE");
                    } else {
                        xmfWriter.writeToken("IMPURE");
                    }
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_elemental")) {
                    xmfWriter.writeToken("ELEMENTAL");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_module")) {
                    xmfWriter.writeToken("MODULE");
                    xmfWriter.writeToken(" ");
                }
                xmfWriter.writeToken("SUBROUTINE");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node3, (String)"params"));
                xmfWriter.writeToken(")");
                object = XmDomUtil.getAttr((Node)node3, (String)"bind");
                if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                    xmfWriter.writeToken(" ");
                    xmfWriter.writeToken("BIND( " + ((String)object).toUpperCase());
                    String string2 = XmDomUtil.getAttr((Node)node3, (String)"bind_name");
                    if (!XfUtilForDom.isNullOrEmpty(string2)) {
                        xmfWriter.writeToken(", NAME = \"" + string2 + "\"");
                    }
                    xmfWriter.writeToken(")");
                }
            } else {
                String string3;
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_recursive")) {
                    xmfWriter.writeToken("RECURSIVE");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.hasAttr((Node)node3, (String)"is_pure")) {
                    if (XmDomUtil.getAttrBool((Node)node3, (String)"is_pure")) {
                        xmfWriter.writeToken("PURE");
                    } else {
                        xmfWriter.writeToken("IMPURE");
                    }
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_elemental")) {
                    xmfWriter.writeToken("ELEMENTAL");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node3, (String)"is_module")) {
                    xmfWriter.writeToken("MODULE");
                    xmfWriter.writeToken(" ");
                }
                xmfWriter.writeToken("FUNCTION");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node3, (String)"params"));
                xmfWriter.writeToken(")");
                object = XmDomUtil.getAttr((Node)node3, (String)"result_name");
                if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                    xmfWriter.writeToken(" RESULT(" + (String)object + ")");
                }
                if (!XfUtilForDom.isNullOrEmpty(string3 = XmDomUtil.getAttr((Node)node3, (String)"bind"))) {
                    xmfWriter.writeToken(" ");
                    xmfWriter.writeToken("BIND( " + string3.toUpperCase());
                    String string4 = XmDomUtil.getAttr((Node)node3, (String)"bind_name");
                    if (!XfUtilForDom.isNullOrEmpty(string4)) {
                        xmfWriter.writeToken(", NAME = \"" + string4 + "\"");
                    }
                    xmfWriter.writeToken(")");
                }
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            xfTypeManagerForDom.enterScope();
            if (!XmOption.coarrayNoUseStatement()) {
                xmfWriter.writeToken("use xmpf_coarray_decl");
                xmfWriter.setupNewLine();
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            object = XmDomUtil.getElement((Node)node, (String)"declarations");
            XfDecompileDomVisitor.this.invokeEnter((Node)object);
            XfDecompileDomVisitor.this.writeVolatileOrAsynchronousStatements((Node)object);
            xmfWriter.setupNewLine();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xfTypeManagerForDom.leaveScope();
            if (XmDomUtil.getAttrBool((Node)node3, (String)"is_program")) {
                xmfWriter.writeToken("END PROGRAM");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            } else if (xfType == XfType.VOID) {
                xmfWriter.writeToken("END SUBROUTINE");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            } else {
                xmfWriter.writeToken("END FUNCTION");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            }
            xmfWriter.setupNewLine();
            xmfWriter.setupNewLine();
        }
    }

    class FfunctionDeclVisitor
    extends XcodeNodeVisitor {
        FfunctionDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            Node node3 = xfTypeManagerForDom.findType(node2);
            if (node3 == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node2, (String)"type")));
                XfDecompileDomVisitor.this.fail(node);
            } else if (!"FfunctionType".equals(node3.getNodeName())) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", node3.getNodeName(), "FfunctionType"));
                XfDecompileDomVisitor.this.fail(node);
            }
            Node node4 = node3;
            String string = XmDomUtil.getAttr((Node)node4, (String)"return_type");
            XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
            if (XmDomUtil.getAttrBool((Node)node4, (String)"is_program")) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", "PROGRAM", "FUNCTION or SUBROUTINE"));
                XfDecompileDomVisitor.this.fail(node);
            } else if (xfType == XfType.VOID) {
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_recursive")) {
                    xmfWriter.writeToken("RECURSIVE");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.hasAttr((Node)node4, (String)"is_pure")) {
                    if (XmDomUtil.getAttrBool((Node)node4, (String)"is_pure")) {
                        xmfWriter.writeToken("PURE");
                    } else {
                        xmfWriter.writeToken("IMPURE");
                    }
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_elemental")) {
                    xmfWriter.writeToken("ELEMENTAL");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_module")) {
                    xmfWriter.writeToken("MODULE");
                    xmfWriter.writeToken(" ");
                }
                xmfWriter.writeToken("SUBROUTINE");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node4, (String)"params"));
                xmfWriter.writeToken(")");
                object = XmDomUtil.getAttr((Node)node4, (String)"bind");
                if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                    xmfWriter.writeToken("BIND(" + ((String)object).toUpperCase());
                    String string2 = XmDomUtil.getAttr((Node)node4, (String)"bind_name");
                    if (!XfUtilForDom.isNullOrEmpty(string2)) {
                        xmfWriter.writeToken(", NAME = \"" + string2 + "\"");
                    }
                    xmfWriter.writeToken(")");
                }
            } else {
                String string3;
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_recursive")) {
                    xmfWriter.writeToken("RECURSIVE");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.hasAttr((Node)node4, (String)"is_pure")) {
                    if (XmDomUtil.getAttrBool((Node)node4, (String)"is_pure")) {
                        xmfWriter.writeToken("PURE");
                    } else {
                        xmfWriter.writeToken("IMPURE");
                    }
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_elemental")) {
                    xmfWriter.writeToken("ELEMENTAL");
                    xmfWriter.writeToken(" ");
                }
                if (XmDomUtil.getAttrBool((Node)node4, (String)"is_module")) {
                    xmfWriter.writeToken("MODULE");
                    xmfWriter.writeToken(" ");
                }
                xmfWriter.writeToken("FUNCTION");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node4, (String)"params"));
                xmfWriter.writeToken(")");
                object = XmDomUtil.getAttr((Node)node4, (String)"result_name");
                if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                    xmfWriter.writeToken(" RESULT(" + (String)object + ")");
                }
                if (!XfUtilForDom.isNullOrEmpty(string3 = XmDomUtil.getAttr((Node)node4, (String)"bind"))) {
                    xmfWriter.writeToken(" ");
                    xmfWriter.writeToken("BIND( " + string3.toUpperCase());
                    String string4 = XmDomUtil.getAttr((Node)node4, (String)"bind_name");
                    if (!XfUtilForDom.isNullOrEmpty(string4)) {
                        xmfWriter.writeToken(", NAME = \"" + string4 + "\"");
                    }
                    xmfWriter.writeToken(")");
                }
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
            object = XmDomUtil.getElement((Node)node, (String)"declarations");
            XfDecompileDomVisitor.this.invokeEnter((Node)object);
            XfDecompileDomVisitor.this.writeVolatileOrAsynchronousStatements((Node)object);
            xmfWriter.decrementIndentLevel();
            assert (XmDomUtil.getAttrBool((Node)node4, (String)"is_program"));
            if (xfType == XfType.VOID) {
                xmfWriter.writeToken("END SUBROUTINE");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            } else {
                xmfWriter.writeToken("END FUNCTION");
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
            }
            xmfWriter.setupNewLine();
        }
    }

    class FformatDeclVisitor
    extends XcodeNodeVisitor {
        FformatDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("FORMAT ");
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"format"));
            xmfWriter.setupNewLine();
        }
    }

    class FflushStatementVisitor
    extends XcodeNodeVisitor {
        FflushStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("FLUSH");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FexitStatementVisitor
    extends XcodeNodeVisitor {
        FexitStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("EXIT");
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FequivalenceDeclVisitor
    extends XcodeNodeVisitor {
        FequivalenceDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("EQUIVALENCE ");
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                xmfWriter.writeToken("(");
                Node node2 = (Node)iterator.next();
                if (!"varRef".equals(node2.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                if (!iterator.hasNext()) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                Node node3 = (Node)iterator.next();
                if (!"varList".equals(node3.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                XfDecompileDomVisitor.this.invokeEnter(node2);
                xmfWriter.writeToken(", ");
                XfDecompileDomVisitor.this.invokeEnter(node3);
                xmfWriter.writeToken(")");
            }
            xmfWriter.setupNewLine();
        }
    }

    class FentryDeclVisitor
    extends XcodeNodeVisitor {
        FentryDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            Node node3 = xfTypeManagerForDom.findType(node2);
            if (node3 == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, XmDomUtil.getAttr((Node)node2, (String)"type")));
                XfDecompileDomVisitor.this.fail(node);
            } else if (!"FfunctionType".equals(node3.getNodeName())) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", node3.getNodeName(), "FfunctionType"));
                XfDecompileDomVisitor.this.fail(node);
            }
            Node node4 = node3;
            String string = XmDomUtil.getAttr((Node)node4, (String)"return_type");
            XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
            if (XmDomUtil.getAttrBool((Node)node4, (String)"is_program")) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, "function definition", "PROGRAM", "FUNCTION or SUBROUTINE"));
                XfDecompileDomVisitor.this.fail(node);
            } else {
                String string2;
                xmfWriter.decrementIndentLevel();
                xmfWriter.writeToken("ENTRY");
                xmfWriter.incrementIndentLevel();
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node2));
                xmfWriter.writeToken("(");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node4, (String)"params"));
                xmfWriter.writeToken(")");
                if (xfType != XfType.VOID && !XfUtilForDom.isNullOrEmpty(string2 = XmDomUtil.getAttr((Node)node4, (String)"result_name"))) {
                    xmfWriter.writeToken(" RESULT(" + string2 + ")");
                }
            }
            xmfWriter.setupNewLine();
        }
    }

    class FendFileStatementVisitor
    extends XcodeNodeVisitor {
        FendFileStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("ENDFILE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FdoWhileStatementVisitor
    extends XcodeNodeVisitor {
        FdoWhileStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("DO, WHILE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"condition"));
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END DO");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FdoStatementVisitor
    extends XcodeNodeVisitor {
        FdoStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string);
                xmfWriter.writeToken(": ");
            }
            xmfWriter.writeToken("DO");
            Node node2 = XmDomUtil.getElement((Node)node, (String)"Var");
            if (node2 != null) {
                xmfWriter.writeToken(" ");
                XfDecompileDomVisitor.this.invokeEnter(node2);
                xmfWriter.writeToken(" = ");
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"indexRange"));
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("END DO");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FdoConcurrentStatementVisitor
    extends ForallLikeTagVisitor {
        FdoConcurrentStatementVisitor() {
        }

        @Override
        public void startConstruct() {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("DO");
            xmfWriter.writeToken("CONCURRENT");
        }

        @Override
        public void endConstruct() {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("END");
            xmfWriter.writeToken("DO");
        }
    }

    class FdoLoopVisitor
    extends XcodeNodeVisitor {
        FdoLoopVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(");
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"value"});
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ", ");
            if (arrayList.size() > 0) {
                xmfWriter.writeToken(", ");
            }
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"Var"));
            xmfWriter.writeToken(" = ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"indexRange"));
            xmfWriter.writeToken(")");
        }
    }

    class FdeallocateStatementVisitor
    extends XcodeNodeVisitor {
        FdeallocateStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("DEALLOCATE (");
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"alloc", "allocOpt"});
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ",");
            String string = XmDomUtil.getAttr((Node)node, (String)"stat_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("STAT = ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class FdataStatementVisitor
    extends XcodeNodeVisitor {
        FdataStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("DATA ");
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!"varList".equals(node2.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                if (!iterator.hasNext()) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                Node node3 = (Node)iterator.next();
                if (!"valueList".equals(node3.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                XfDecompileDomVisitor.this.invokeEnter(node2);
                xmfWriter.writeToken(" /");
                XfDecompileDomVisitor.this.invokeEnter(node3);
                xmfWriter.writeToken("/");
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                ++n;
            }
            xmfWriter.setupNewLine();
        }
    }

    class FdataDeclVisitor
    extends XcodeNodeVisitor {
        FdataDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("DATA ");
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!"varList".equals(node2.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                if (!iterator.hasNext()) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                Node node3 = (Node)iterator.next();
                if (!"valueList".equals(node3.getNodeName())) {
                    throw new XmTranslationException(node, "Invalid contents");
                }
                XfDecompileDomVisitor.this.invokeEnter(node2);
                xmfWriter.writeToken(" /");
                XfDecompileDomVisitor.this.invokeEnter(node3);
                xmfWriter.writeToken("/");
                if (n > 0) {
                    xmfWriter.writeToken(", ");
                }
                ++n;
            }
            xmfWriter.setupNewLine();
        }
    }

    class FcycleStatementVisitor
    extends XcodeNodeVisitor {
        FcycleStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("CYCLE");
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
        }
    }

    class FcontainsStatementVisitor
    extends XcodeNodeVisitor {
        FcontainsStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.decrementIndentLevel();
            xmfWriter.setupNewLine();
            xmfWriter.writeToken("CONTAINS");
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this._invokeEnter(XmDomUtil.collectChildNodes((Node)node));
        }
    }

    class FconcatExprVisitor
    extends XcodeNodeVisitor {
        FconcatExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "//", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class FcomplexPartRefVisitor
    extends XcodeNodeVisitor {
        FcomplexPartRefVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"varRef"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("%");
            xmfWriter.writeToken(XmDomUtil.getAttr((Node)node, (String)"part"));
        }
    }

    class FcomplexConstantVisitor
    extends XcodeNodeVisitor {
        FcomplexConstantVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Object object2;
            Object object3;
            String string;
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            if (arrayList.size() < 2) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName()));
                XfDecompileDomVisitor.this.fail(node);
            }
            if (!XfUtilForDom.isNullOrEmpty(string = XmDomUtil.getAttr((Node)node, (String)"type"))) {
                object3 = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                object2 = ((XfTypeManagerForDom)object3).getBottomTypeName(string);
                if (object2 == null) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_NOT_FOUND, node.getNodeName(), string));
                    XfDecompileDomVisitor.this.fail(node);
                }
                if ((object = XfType.getTypeIdFromXcodemlTypeName((String)object2)) != XfType.DERIVED && object != XfType.COMPLEX) {
                    XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_TYPE_MISMATCH, node.getNodeName(), string, "Fcomplex"));
                    XfDecompileDomVisitor.this.fail(node);
                }
            }
            object3 = XfDecompileDomVisitor.this._context.getWriter();
            object2 = (Node)arrayList.get(0);
            object = (Node)arrayList.get(1);
            if (!XfDecompileDomVisitor.this._isConstantExpr((Node)object2) || !XfDecompileDomVisitor.this._isConstantExpr((Node)object)) {
                ((XmfWriter)object3).writeToken("CMPLX");
            }
            ((XmfWriter)object3).writeToken("(");
            XfDecompileDomVisitor.this.invokeEnter((Node)object2);
            ((XmfWriter)object3).writeToken(", ");
            XfDecompileDomVisitor.this.invokeEnter((Node)object);
            ((XmfWriter)object3).writeToken(")");
        }
    }

    class FcommonDeclVisitor
    extends XcodeNodeVisitor {
        FcommonDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("COMMON");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.setupNewLine();
            String string = XmDomUtil.getAttr((Node)node, (String)"bind");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken("BIND( " + string.toUpperCase());
                String string2 = XmDomUtil.getAttr((Node)node, (String)"bind_name");
                if (!XfUtilForDom.isNullOrEmpty(string2)) {
                    xmfWriter.writeToken(", NAME = \"" + string2 + "\"");
                }
                xmfWriter.writeToken(")");
                xmfWriter.writeToken("::");
                ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
                Node node2 = (Node)arrayList.get(0);
                String string3 = XmDomUtil.getAttr((Node)node2, (String)"name");
                if (!XfUtilForDom.isNullOrEmpty(string3)) {
                    xmfWriter.writeToken("/");
                    xmfWriter.writeToken(string3);
                    xmfWriter.writeToken("/ ");
                }
                xmfWriter.setupNewLine();
            }
        }
    }

    class FcloseStatementVisitor
    extends XcodeNodeVisitor {
        FcloseStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("CLOSE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FcharacterRef
    extends XcodeNodeVisitor {
        FcharacterRef() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"varRef"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"indexRange"));
            xmfWriter.writeToken(")");
        }
    }

    class FcharacterConstant
    extends XcodeNodeVisitor {
        FcharacterConstant() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"kind");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(string + "_");
            }
            xmfWriter.skipSeparator();
            xmfWriter.writeLiteralString(XmDomUtil.getContentText((Node)node));
        }
    }

    class TypeGuardVisitor
    extends XcodeNodeVisitor {
        TypeGuardVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            String string = XmDomUtil.getAttr((Node)node, (String)"kind");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"type");
            if (string.equals("CLASS_DEFAULT")) {
                xmfWriter.writeToken("CLASS DEFAULT");
            } else {
                if (string.equals("CLASS_IS")) {
                    xmfWriter.writeToken("CLASS IS");
                } else if (string.equals("TYPE_IS")) {
                    xmfWriter.writeToken("TYPE IS");
                }
                xmfWriter.writeToken(" ( ");
                object = XfType.getTypeIdFromXcodemlTypeName(string2);
                if (((XfType)((Object)object)).isPrimitive()) {
                    xmfWriter.writeToken(((XfType)((Object)object)).fortranName());
                } else {
                    XfTypeManagerForDom.TypeList typeList = XfDecompileDomVisitor.this.getTypeList(string2);
                    XfDecompileDomVisitor.this._writeTopType(typeList, false);
                }
                xmfWriter.writeToken(" ) ");
            }
            object = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken((String)object);
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
        }
    }

    class FcaseLabelVisitor
    extends XcodeNodeVisitor {
        FcaseLabelVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("CASE");
            ArrayList arrayList = XmDomUtil.collectElementsExclude((Node)node, (String[])new String[]{"body"});
            if (arrayList != null && arrayList.size() > 0) {
                xmfWriter.writeToken(" (");
                XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ", ");
                xmfWriter.writeToken(")");
            } else {
                xmfWriter.writeToken(" DEFAULT");
            }
            String string = XmDomUtil.getAttr((Node)node, (String)"construct_name");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                xmfWriter.writeToken(" ");
                xmfWriter.writeToken(string);
            }
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
        }
    }

    class FbackspaceStatement
    extends XcodeNodeVisitor {
        FbackspaceStatement() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("BACKSPACE ");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"namedValueList"));
            xmfWriter.setupNewLine();
        }
    }

    class FcoArrayRefVisitor
    extends XcodeNodeVisitor {
        FcoArrayRefVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"varRef"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("[");
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"arrayIndex"});
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ", ");
            xmfWriter.writeToken("]");
        }
    }

    class FarrayRefVisitor
    extends XcodeNodeVisitor {
        FarrayRefVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"varRef"));
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(");
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"indexRange", "arrayIndex", "FarrayConstructor", "FarrayRef"});
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim(arrayList, ", ");
            xmfWriter.writeToken(")");
        }
    }

    class FarrayConstructor
    extends XcodeNodeVisitor {
        FarrayConstructor() {
        }

        @Override
        public void enter(Node node) {
            String string = XmDomUtil.getAttr((Node)node, (String)"element_type");
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(/");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                XfType xfType = XfType.getTypeIdFromXcodemlTypeName(string);
                if (xfType.isPrimitive()) {
                    xmfWriter.writeToken(xfType.fortranName());
                } else {
                    XfTypeManagerForDom.TypeList typeList = XfDecompileDomVisitor.this.getTypeList(string);
                    XfDecompileDomVisitor.this._writeTopType(typeList, false);
                }
                xmfWriter.writeToken("::");
            }
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ",");
            xmfWriter.writeToken("/)");
        }
    }

    class FallocOpt
    extends XcodeNodeVisitor {
        FallocOpt() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"kind");
            xmfWriter.writeToken(string.toUpperCase());
            xmfWriter.writeToken("=");
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class FallocateStatement
    extends XcodeNodeVisitor {
        FallocateStatement() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Object object2;
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getAttr((Node)node, (String)"type");
            xmfWriter.writeToken("ALLOCATE");
            xmfWriter.writeToken("(");
            if (!XfUtilForDom.isNullOrEmpty(string)) {
                object2 = XfType.getTypeIdFromXcodemlTypeName(string);
                if (object2.isPrimitive()) {
                    xmfWriter.writeToken(object2.fortranName());
                } else {
                    object = XfDecompileDomVisitor.this.getTypeList(string);
                    XfDecompileDomVisitor.this._writeTopType((XfTypeManagerForDom.TypeList)object, false);
                }
                xmfWriter.writeToken("::");
            }
            object2 = XmDomUtil.collectElements((Node)node, (String[])new String[]{"alloc", "allocOpt"});
            XfDecompileDomVisitor.this._invokeEnterAndWriteDelim((ArrayList)object2, ",");
            object = XmDomUtil.getAttr((Node)node, (String)"stat_name");
            if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("STAT = ");
                xmfWriter.writeToken((String)object);
            }
            xmfWriter.writeToken(")");
            xmfWriter.setupNewLine();
        }
    }

    class ExternDeclVisitor
    extends XcodeNodeVisitor {
        ExternDeclVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            String string = XmDomUtil.getContentText((Node)node2);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("EXTERNAL ");
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
        }
    }

    class ExprStatementVisitor
    extends XcodeNodeVisitor {
        ExprStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.setupNewLine();
        }
    }

    class ElseVisitor
    extends XcodeNodeVisitor {
        ElseVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"body"));
            xmfWriter.decrementIndentLevel();
        }
    }

    class DivExprVisitor
    extends XcodeNodeVisitor {
        DivExprVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "/", XfDecompileDomVisitor.this._checkBinaryExprRequireGrouping(node));
        }
    }

    class DeclarationsVisitor
    extends XcodeNodeVisitor {
        DeclarationsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class ContinueStatement
    extends XcodeNodeVisitor {
        ContinueStatement() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken(" CONTINUE");
            xmfWriter.setupNewLine();
        }
    }

    class ConditionVisitor
    extends XcodeNodeVisitor {
        ConditionVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("(");
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
            xmfWriter.writeToken(")");
        }
    }

    class BodyVisitor
    extends XcodeNodeVisitor {
        BodyVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class FassignStatementVisitor
    extends XcodeNodeVisitor {
        FassignStatementVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            XfDecompileDomVisitor.this._writeLineDirective(node);
            XfDecompileDomVisitor.this._writeBinaryExpr(XmDomUtil.collectChildNodes((Node)node), 0, "=", false);
            xmfWriter.setupNewLine();
        }
    }

    class ArrayIndexVisitor
    extends XcodeNodeVisitor {
        ArrayIndexVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getContent((Node)node));
        }
    }

    class ArgumentsVisitor
    extends XcodeNodeVisitor {
        ArgumentsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
        }
    }

    class AllocVisitor
    extends XcodeNodeVisitor {
        AllocVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Node node2 = XmDomUtil.getElement((Node)node, (String)"Var");
            if (node2 != null) {
                XfDecompileDomVisitor.this.invokeEnter(node2);
            } else {
                node2 = XmDomUtil.getElement((Node)node, (String)"FmemberRef");
                if (node2 != null) {
                    XfDecompileDomVisitor.this.invokeEnter(node2);
                } else {
                    throw new XmTranslationException(node, "Invalid `alloc' content.");
                }
            }
            if (XfDecompileDomVisitor.this._isInvokeNodeOf("FallocateStatement", 1) && (object = XmDomUtil.collectElements((Node)node, (String[])new String[]{"indexRange", "arrayIndex"})) != null && ((ArrayList)object).size() > 0) {
                XfDecompileDomVisitor.this._writeIndexRangeArray((ArrayList)object);
            }
            if ((object = XmDomUtil.getElement((Node)node, (String)"coShape")) != null) {
                XfDecompileDomVisitor.this.invokeEnter((Node)object);
            }
        }
    }

    class GlobalDeclarationsVisitor
    extends XcodeNodeVisitor {
        GlobalDeclarationsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class GlobalSymbolsVisitor
    extends XcodeNodeVisitor {
        GlobalSymbolsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            for (Node node2 : XmDomUtil.collectElements((Node)node, (String[])new String[]{"id"})) {
                xfTypeManagerForDom.addSymbol(node2);
            }
        }
    }

    class FinalProcedureVisitor
    extends XcodeNodeVisitor {
        FinalProcedureVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("FINAL");
            xmfWriter.writeToken("::");
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            String string = XmDomUtil.getContentText((Node)node2);
            xmfWriter.writeToken(string);
            xmfWriter.setupNewLine();
        }
    }

    class TypeBoundGenericProcedureVisitor
    extends XcodeNodeVisitor {
        TypeBoundGenericProcedureVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Node node2;
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("GENERIC");
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_public")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("PUBLIC");
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_private")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("PRIVATE");
            }
            xmfWriter.writeToken("::");
            String string = XmDomUtil.getAttr((Node)node, (String)"is_defined_io");
            if (XfUtilForDom.isNullOrEmpty(string)) {
                node2 = XmDomUtil.getElement((Node)node, (String)"name");
                object = XmDomUtil.getContentText((Node)node2);
                if (XmDomUtil.getAttrBool((Node)node, (String)"is_operator")) {
                    xmfWriter.writeToken("OPERATOR");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken((String)object);
                    xmfWriter.writeToken(")");
                } else if (XmDomUtil.getAttrBool((Node)node, (String)"is_assignment")) {
                    xmfWriter.writeToken("ASSIGNMENT");
                    xmfWriter.writeToken("(");
                    xmfWriter.writeToken("=");
                    xmfWriter.writeToken(")");
                } else {
                    xmfWriter.writeToken((String)object);
                }
            } else if ((string = string.toUpperCase()).equals("WRITE(FORMATTED)")) {
                xmfWriter.writeToken("WRITE");
                xmfWriter.writeToken("(");
                xmfWriter.writeToken("FORMATTED");
                xmfWriter.writeToken(")");
            } else if (string.equals("WRITE(UNFORMATTED)")) {
                xmfWriter.writeToken("WRITE");
                xmfWriter.writeToken("(");
                xmfWriter.writeToken("UNFORMATTED");
                xmfWriter.writeToken(")");
            } else if (string.equals("READ(FORMATTED)")) {
                xmfWriter.writeToken("READ");
                xmfWriter.writeToken("(");
                xmfWriter.writeToken("FORMATTED");
                xmfWriter.writeToken(")");
            } else if (string.equals("READ(UNFORMATTED)")) {
                xmfWriter.writeToken("READ");
                xmfWriter.writeToken("(");
                xmfWriter.writeToken("UNFORMATTED");
                xmfWriter.writeToken(")");
            } else {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_SEMANTICS, node.getNodeName(), string));
                XfDecompileDomVisitor.this.fail(node);
            }
            xmfWriter.writeToken("=>");
            node2 = XmDomUtil.getElement((Node)node, (String)"binding");
            if (node2 == null) {
                XfDecompileDomVisitor.this._context.setLastErrorMessage(XfUtilForDom.formatError(node, XfError.XCODEML_NODE_MISSING, node.getNodeName(), "binding"));
                XfDecompileDomVisitor.this.fail(node);
            }
            object = XmDomUtil.collectChildNodes((Node)node2);
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Node node3 = (Node)iterator.next();
                if (node3 != ((ArrayList)object).get(0)) {
                    xmfWriter.writeToken(",");
                }
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)node3));
            }
            xmfWriter.setupNewLine();
        }
    }

    class TypeBoundProcedureVisitor
    extends XcodeNodeVisitor {
        TypeBoundProcedureVisitor() {
        }

        @Override
        public void enter(Node node) {
            Object object;
            Object object2;
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("PROCEDURE");
            boolean bl = XmDomUtil.getAttrBool((Node)node, (String)"is_deferred");
            Node node2 = XmDomUtil.getElement((Node)node, (String)"binding");
            if (bl) {
                object2 = XmDomUtil.collectChildNodes((Node)node2);
                if (((ArrayList)object2).size() != 1) {
                    throw new XmTranslationException(node, "Invalid `binding' length.");
                }
                xmfWriter.writeToken("(");
                xmfWriter.writeToken(XmDomUtil.getContentText((Node)((Node)((ArrayList)object2).get(0))));
                xmfWriter.writeToken(")");
            }
            if (!XfUtilForDom.isNullOrEmpty((String)(object2 = XmDomUtil.getAttr((Node)node, (String)"pass")))) {
                if (((String)object2).equals("pass")) {
                    xmfWriter.writeToken(",");
                    xmfWriter.writeToken("PASS");
                    object = XmDomUtil.getAttr((Node)node, (String)"pass_arg_name");
                    if (!XfUtilForDom.isNullOrEmpty((String)object)) {
                        xmfWriter.writeToken("(");
                        xmfWriter.writeToken((String)object);
                        xmfWriter.writeToken(")");
                    }
                } else if (((String)object2).equals("nopass")) {
                    xmfWriter.writeToken(",");
                    xmfWriter.writeToken("NOPASS");
                }
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_non_overridable")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("NON_OVERRIDABLE");
            }
            if (bl) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("DEFERRED");
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_public")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("PUBLIC");
            }
            if (XmDomUtil.getAttrBool((Node)node, (String)"is_private")) {
                xmfWriter.writeToken(",");
                xmfWriter.writeToken("PRIVATE");
            }
            xmfWriter.writeToken("::");
            object = XmDomUtil.getElement((Node)node, (String)"name");
            String string = XmDomUtil.getContentText((Node)object);
            xmfWriter.writeToken(string);
            if (!bl) {
                xmfWriter.writeToken("=>");
                if (node2 != null) {
                    ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node2);
                    for (Node node3 : arrayList) {
                        if (node3 != arrayList.get(0)) {
                            xmfWriter.writeToken(",");
                        }
                        xmfWriter.writeToken(XmDomUtil.getContentText((Node)node3));
                    }
                }
            }
            xmfWriter.setupNewLine();
        }
    }

    class TypeBoundProceduresVisitor
    extends XcodeNodeVisitor {
        TypeBoundProceduresVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.decrementIndentLevel();
            xmfWriter.writeToken("CONTAINS");
            xmfWriter.setupNewLine();
            xmfWriter.incrementIndentLevel();
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class TypeParamVisitor
    extends XcodeNodeVisitor {
        TypeParamVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            String string = XmDomUtil.getContentText((Node)XmDomUtil.getContent((Node)node));
            String string2 = XmDomUtil.getAttr((Node)node, (String)"attr");
            xmfWriter.writeToken("INTEGER");
            xmfWriter.writeToken(",");
            if (string2.compareToIgnoreCase("length") == 0) {
                xmfWriter.writeToken("LEN");
            } else if (string2.compareToIgnoreCase("len") == 0) {
                xmfWriter.writeToken("LEN");
            } else if (string2.compareToIgnoreCase("kind") == 0) {
                xmfWriter.writeToken("KIND");
            }
            xmfWriter.writeToken("::");
            xmfWriter.writeToken(string);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"value");
            if (node2 != null) {
                xmfWriter.writeToken("=");
                XfDecompileDomVisitor.this.invokeEnter(node2);
            }
            xmfWriter.setupNewLine();
        }
    }

    class TypeParamsVisitor
    extends XcodeNodeVisitor {
        TypeParamsVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class FstructTypeVisitor
    extends XcodeNodeVisitor {
        FstructTypeVisitor() {
        }

        @Override
        public void enter(Node node) {
            if (XfDecompileDomVisitor.this._isInvokeAncestorNodeOf("typeTable")) {
                XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                xfTypeManagerForDom.addType(node);
            } else {
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"typeParams"));
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"symbols"));
                XfDecompileDomVisitor.this.invokeEnter(XmDomUtil.getElement((Node)node, (String)"typeBoundProcedures"));
            }
        }
    }

    class FenumTypeVisitor
    extends XcodeNodeVisitor {
        FenumTypeVisitor() {
        }

        @Override
        public void enter(Node node) {
            if (XfDecompileDomVisitor.this._isInvokeAncestorNodeOf("typeTable")) {
                XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                xfTypeManagerForDom.addType(node);
            } else assert (false);
        }
    }

    class FfunctionTypeVisitor
    extends XcodeNodeVisitor {
        FfunctionTypeVisitor() {
        }

        @Override
        public void enter(Node node) {
            if (XfDecompileDomVisitor.this._isInvokeAncestorNodeOf("typeTable")) {
                XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
                xfTypeManagerForDom.addType(node);
            } else assert (false);
        }
    }

    class CoShapeVisitor
    extends XcodeNodeVisitor {
        CoShapeVisitor() {
        }

        @Override
        public void enter(Node node) {
            XmfWriter xmfWriter = XfDecompileDomVisitor.this._context.getWriter();
            xmfWriter.writeToken("[");
            XfDecompileDomVisitor.this._invokeChildEnterAndWriteDelim(node, ", ");
            xmfWriter.writeToken("]");
        }
    }

    class BasicTypeVisitor
    extends XcodeNodeVisitor {
        BasicTypeVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            xfTypeManagerForDom.addType(node);
        }
    }

    class TypeTableVisitor
    extends XcodeNodeVisitor {
        TypeTableVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    class XcodeProgramVisitor
    extends XcodeNodeVisitor {
        XcodeProgramVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfTypeManagerForDom xfTypeManagerForDom = XfDecompileDomVisitor.this._context.getTypeManagerForDom();
            xfTypeManagerForDom.enterScope();
            XfDecompileDomVisitor.this._invokeChildEnter(node);
            xfTypeManagerForDom.leaveScope();
        }
    }

    class PassThroughVisitor
    extends XcodeNodeVisitor {
        PassThroughVisitor() {
        }

        @Override
        public void enter(Node node) {
            XfDecompileDomVisitor.this._invokeChildEnter(node);
        }
    }

    abstract class XcodeNodeVisitor {
        XcodeNodeVisitor() {
        }

        public abstract void enter(Node var1);
    }

    private class InvokeNodeStack
    extends LinkedList<Node> {
        private InvokeNodeStack() {
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[Invoke Node Stack]\n");
            for (Node node : this.toArray(new Node[0])) {
                stringBuilder.append(node.getNodeName());
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }
}

